<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RenderEmailTemplateResult StructType
 * @subpackage Structs
 */
class RenderEmailTemplateResult extends AbstractStructBase
{
    /**
     * The bodyResults
     * Meta informations extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \NexusDigital/MiratelForce\StructType\RenderEmailTemplateBodyResult[]
     */
    public $bodyResults;
    /**
     * The errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \NexusDigital/MiratelForce\StructType\Error[]
     */
    public $errors;
    /**
     * The success
     * @var bool
     */
    public $success;
    /**
     * Constructor method for RenderEmailTemplateResult
     * @uses RenderEmailTemplateResult::setBodyResults()
     * @uses RenderEmailTemplateResult::setErrors()
     * @uses RenderEmailTemplateResult::setSuccess()
     * @param \NexusDigital/MiratelForce\StructType\RenderEmailTemplateBodyResult[] $bodyResults
     * @param \NexusDigital/MiratelForce\StructType\Error[] $errors
     * @param bool $success
     */
    public function __construct(array $bodyResults = array(), array $errors = array(), $success = null)
    {
        $this
            ->setBodyResults($bodyResults)
            ->setErrors($errors)
            ->setSuccess($success);
    }
    /**
     * Get bodyResults value
     * @return \NexusDigital/MiratelForce\StructType\RenderEmailTemplateBodyResult[]|null
     */
    public function getBodyResults()
    {
        return $this->bodyResults;
    }
    /**
     * This method is responsible for validating the values passed to the setBodyResults method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBodyResults method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBodyResultsForArrayConstraintsFromSetBodyResults(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $renderEmailTemplateResultBodyResultsItem) {
            // validation for constraint: itemType
            if (!$renderEmailTemplateResultBodyResultsItem instanceof \NexusDigital/MiratelForce\StructType\RenderEmailTemplateBodyResult) {
                $invalidValues[] = is_object($renderEmailTemplateResultBodyResultsItem) ? get_class($renderEmailTemplateResultBodyResultsItem) : sprintf('%s(%s)', gettype($renderEmailTemplateResultBodyResultsItem), var_export($renderEmailTemplateResultBodyResultsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bodyResults property can only contain items of type \NexusDigital/MiratelForce\StructType\RenderEmailTemplateBodyResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bodyResults value
     * @throws \InvalidArgumentException
     * @param \NexusDigital/MiratelForce\StructType\RenderEmailTemplateBodyResult[] $bodyResults
     * @return \NexusDigital/MiratelForce\StructType\RenderEmailTemplateResult
     */
    public function setBodyResults(array $bodyResults = array())
    {
        // validation for constraint: array
        if ('' !== ($bodyResultsArrayErrorMessage = self::validateBodyResultsForArrayConstraintsFromSetBodyResults($bodyResults))) {
            throw new \InvalidArgumentException($bodyResultsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($bodyResults) && count($bodyResults) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($bodyResults)), __LINE__);
        }
        $this->bodyResults = $bodyResults;
        return $this;
    }
    /**
     * Add item to bodyResults value
     * @throws \InvalidArgumentException
     * @param \NexusDigital/MiratelForce\StructType\RenderEmailTemplateBodyResult $item
     * @return \NexusDigital/MiratelForce\StructType\RenderEmailTemplateResult
     */
    public function addToBodyResults(\NexusDigital/MiratelForce\StructType\RenderEmailTemplateBodyResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \NexusDigital/MiratelForce\StructType\RenderEmailTemplateBodyResult) {
            throw new \InvalidArgumentException(sprintf('The bodyResults property can only contain items of type \NexusDigital/MiratelForce\StructType\RenderEmailTemplateBodyResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->bodyResults) && count($this->bodyResults) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->bodyResults)), __LINE__);
        }
        $this->bodyResults[] = $item;
        return $this;
    }
    /**
     * Get errors value
     * @return \NexusDigital/MiratelForce\StructType\Error[]|null
     */
    public function getErrors()
    {
        return $this->errors;
    }
    /**
     * This method is responsible for validating the values passed to the setErrors method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErrors method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErrorsForArrayConstraintsFromSetErrors(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $renderEmailTemplateResultErrorsItem) {
            // validation for constraint: itemType
            if (!$renderEmailTemplateResultErrorsItem instanceof \NexusDigital/MiratelForce\StructType\Error) {
                $invalidValues[] = is_object($renderEmailTemplateResultErrorsItem) ? get_class($renderEmailTemplateResultErrorsItem) : sprintf('%s(%s)', gettype($renderEmailTemplateResultErrorsItem), var_export($renderEmailTemplateResultErrorsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The errors property can only contain items of type \NexusDigital/MiratelForce\StructType\Error, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set errors value
     * @throws \InvalidArgumentException
     * @param \NexusDigital/MiratelForce\StructType\Error[] $errors
     * @return \NexusDigital/MiratelForce\StructType\RenderEmailTemplateResult
     */
    public function setErrors(array $errors = array())
    {
        // validation for constraint: array
        if ('' !== ($errorsArrayErrorMessage = self::validateErrorsForArrayConstraintsFromSetErrors($errors))) {
            throw new \InvalidArgumentException($errorsArrayErrorMessage, __LINE__);
        }
        $this->errors = $errors;
        return $this;
    }
    /**
     * Add item to errors value
     * @throws \InvalidArgumentException
     * @param \NexusDigital/MiratelForce\StructType\Error $item
     * @return \NexusDigital/MiratelForce\StructType\RenderEmailTemplateResult
     */
    public function addToErrors(\NexusDigital/MiratelForce\StructType\Error $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \NexusDigital/MiratelForce\StructType\Error) {
            throw new \InvalidArgumentException(sprintf('The errors property can only contain items of type \NexusDigital/MiratelForce\StructType\Error, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->errors[] = $item;
        return $this;
    }
    /**
     * Get success value
     * @return bool|null
     */
    public function getSuccess()
    {
        return $this->success;
    }
    /**
     * Set success value
     * @param bool $success
     * @return \NexusDigital/MiratelForce\StructType\RenderEmailTemplateResult
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->success = $success;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\RenderEmailTemplateResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
