<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Publisher StructType
 * @subpackage Structs
 */
class Publisher extends SObject
{
    /**
     * The DurableId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DurableId;
    /**
     * The InstalledEntityDefinitions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $InstalledEntityDefinitions;
    /**
     * The InstalledFieldDefinitions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $InstalledFieldDefinitions;
    /**
     * The IsSalesforce
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSalesforce;
    /**
     * The MajorVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MajorVersion;
    /**
     * The MinorVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinorVersion;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NamespacePrefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NamespacePrefix;
    /**
     * Constructor method for Publisher
     * @uses Publisher::setDurableId()
     * @uses Publisher::setInstalledEntityDefinitions()
     * @uses Publisher::setInstalledFieldDefinitions()
     * @uses Publisher::setIsSalesforce()
     * @uses Publisher::setMajorVersion()
     * @uses Publisher::setMinorVersion()
     * @uses Publisher::setName()
     * @uses Publisher::setNamespacePrefix()
     * @param string $durableId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $installedEntityDefinitions
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $installedFieldDefinitions
     * @param bool $isSalesforce
     * @param int $majorVersion
     * @param int $minorVersion
     * @param string $name
     * @param string $namespacePrefix
     */
    public function __construct($durableId = null, \NexusDigital/MiratelForce\StructType\QueryResult $installedEntityDefinitions = null, \NexusDigital/MiratelForce\StructType\QueryResult $installedFieldDefinitions = null, $isSalesforce = null, $majorVersion = null, $minorVersion = null, $name = null, $namespacePrefix = null)
    {
        $this
            ->setDurableId($durableId)
            ->setInstalledEntityDefinitions($installedEntityDefinitions)
            ->setInstalledFieldDefinitions($installedFieldDefinitions)
            ->setIsSalesforce($isSalesforce)
            ->setMajorVersion($majorVersion)
            ->setMinorVersion($minorVersion)
            ->setName($name)
            ->setNamespacePrefix($namespacePrefix);
    }
    /**
     * Get DurableId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDurableId()
    {
        return isset($this->DurableId) ? $this->DurableId : null;
    }
    /**
     * Set DurableId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $durableId
     * @return \NexusDigital/MiratelForce\StructType\Publisher
     */
    public function setDurableId($durableId = null)
    {
        // validation for constraint: string
        if (!is_null($durableId) && !is_string($durableId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($durableId, true), gettype($durableId)), __LINE__);
        }
        if (is_null($durableId) || (is_array($durableId) && empty($durableId))) {
            unset($this->DurableId);
        } else {
            $this->DurableId = $durableId;
        }
        return $this;
    }
    /**
     * Get InstalledEntityDefinitions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getInstalledEntityDefinitions()
    {
        return isset($this->InstalledEntityDefinitions) ? $this->InstalledEntityDefinitions : null;
    }
    /**
     * Set InstalledEntityDefinitions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $installedEntityDefinitions
     * @return \NexusDigital/MiratelForce\StructType\Publisher
     */
    public function setInstalledEntityDefinitions(\NexusDigital/MiratelForce\StructType\QueryResult $installedEntityDefinitions = null)
    {
        if (is_null($installedEntityDefinitions) || (is_array($installedEntityDefinitions) && empty($installedEntityDefinitions))) {
            unset($this->InstalledEntityDefinitions);
        } else {
            $this->InstalledEntityDefinitions = $installedEntityDefinitions;
        }
        return $this;
    }
    /**
     * Get InstalledFieldDefinitions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getInstalledFieldDefinitions()
    {
        return isset($this->InstalledFieldDefinitions) ? $this->InstalledFieldDefinitions : null;
    }
    /**
     * Set InstalledFieldDefinitions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $installedFieldDefinitions
     * @return \NexusDigital/MiratelForce\StructType\Publisher
     */
    public function setInstalledFieldDefinitions(\NexusDigital/MiratelForce\StructType\QueryResult $installedFieldDefinitions = null)
    {
        if (is_null($installedFieldDefinitions) || (is_array($installedFieldDefinitions) && empty($installedFieldDefinitions))) {
            unset($this->InstalledFieldDefinitions);
        } else {
            $this->InstalledFieldDefinitions = $installedFieldDefinitions;
        }
        return $this;
    }
    /**
     * Get IsSalesforce value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSalesforce()
    {
        return isset($this->IsSalesforce) ? $this->IsSalesforce : null;
    }
    /**
     * Set IsSalesforce value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSalesforce
     * @return \NexusDigital/MiratelForce\StructType\Publisher
     */
    public function setIsSalesforce($isSalesforce = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSalesforce) && !is_bool($isSalesforce)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSalesforce, true), gettype($isSalesforce)), __LINE__);
        }
        if (is_null($isSalesforce) || (is_array($isSalesforce) && empty($isSalesforce))) {
            unset($this->IsSalesforce);
        } else {
            $this->IsSalesforce = $isSalesforce;
        }
        return $this;
    }
    /**
     * Get MajorVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMajorVersion()
    {
        return isset($this->MajorVersion) ? $this->MajorVersion : null;
    }
    /**
     * Set MajorVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $majorVersion
     * @return \NexusDigital/MiratelForce\StructType\Publisher
     */
    public function setMajorVersion($majorVersion = null)
    {
        // validation for constraint: int
        if (!is_null($majorVersion) && !(is_int($majorVersion) || ctype_digit($majorVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($majorVersion, true), gettype($majorVersion)), __LINE__);
        }
        if (is_null($majorVersion) || (is_array($majorVersion) && empty($majorVersion))) {
            unset($this->MajorVersion);
        } else {
            $this->MajorVersion = $majorVersion;
        }
        return $this;
    }
    /**
     * Get MinorVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinorVersion()
    {
        return isset($this->MinorVersion) ? $this->MinorVersion : null;
    }
    /**
     * Set MinorVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minorVersion
     * @return \NexusDigital/MiratelForce\StructType\Publisher
     */
    public function setMinorVersion($minorVersion = null)
    {
        // validation for constraint: int
        if (!is_null($minorVersion) && !(is_int($minorVersion) || ctype_digit($minorVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minorVersion, true), gettype($minorVersion)), __LINE__);
        }
        if (is_null($minorVersion) || (is_array($minorVersion) && empty($minorVersion))) {
            unset($this->MinorVersion);
        } else {
            $this->MinorVersion = $minorVersion;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\Publisher
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NamespacePrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNamespacePrefix()
    {
        return isset($this->NamespacePrefix) ? $this->NamespacePrefix : null;
    }
    /**
     * Set NamespacePrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $namespacePrefix
     * @return \NexusDigital/MiratelForce\StructType\Publisher
     */
    public function setNamespacePrefix($namespacePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($namespacePrefix) && !is_string($namespacePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($namespacePrefix, true), gettype($namespacePrefix)), __LINE__);
        }
        if (is_null($namespacePrefix) || (is_array($namespacePrefix) && empty($namespacePrefix))) {
            unset($this->NamespacePrefix);
        } else {
            $this->NamespacePrefix = $namespacePrefix;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\Publisher
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
