<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PromptVersion StructType
 * @subpackage Structs
 */
class PromptVersion extends SObject
{
    /**
     * The ActionButtonLabel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActionButtonLabel;
    /**
     * The ActionButtonLink
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActionButtonLink;
    /**
     * The Body
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Body;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The DelayDays
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DelayDays;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The DismissButtonLabel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DismissButtonLabel;
    /**
     * The DisplayPosition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayPosition;
    /**
     * The DisplayType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayType;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The Header
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Header;
    /**
     * The IndexWithIsPublished
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IndexWithIsPublished;
    /**
     * The IndexWithoutIsPublished
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IndexWithoutIsPublished;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsPublished
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPublished;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The MasterLabel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MasterLabel;
    /**
     * The Parent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Prompt
     */
    public $Parent;
    /**
     * The ParentId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ParentId;
    /**
     * The PublishedByUser
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $PublishedByUser;
    /**
     * The PublishedByUserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $PublishedByUserId;
    /**
     * The PublishedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PublishedDate;
    /**
     * The ShouldDisplayActionButton
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShouldDisplayActionButton;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The TargetAppDeveloperName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetAppDeveloperName;
    /**
     * The TargetAppNamespacePrefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetAppNamespacePrefix;
    /**
     * The TargetPageKey1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetPageKey1;
    /**
     * The TargetPageKey2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetPageKey2;
    /**
     * The TargetPageType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetPageType;
    /**
     * The TimesToDisplay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TimesToDisplay;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Title;
    /**
     * The UserAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserAccess;
    /**
     * The VersionNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $VersionNumber;
    /**
     * Constructor method for PromptVersion
     * @uses PromptVersion::setActionButtonLabel()
     * @uses PromptVersion::setActionButtonLink()
     * @uses PromptVersion::setBody()
     * @uses PromptVersion::setCreatedBy()
     * @uses PromptVersion::setCreatedById()
     * @uses PromptVersion::setCreatedDate()
     * @uses PromptVersion::setDelayDays()
     * @uses PromptVersion::setDescription()
     * @uses PromptVersion::setDismissButtonLabel()
     * @uses PromptVersion::setDisplayPosition()
     * @uses PromptVersion::setDisplayType()
     * @uses PromptVersion::setEndDate()
     * @uses PromptVersion::setHeader()
     * @uses PromptVersion::setIndexWithIsPublished()
     * @uses PromptVersion::setIndexWithoutIsPublished()
     * @uses PromptVersion::setIsDeleted()
     * @uses PromptVersion::setIsPublished()
     * @uses PromptVersion::setLastModifiedBy()
     * @uses PromptVersion::setLastModifiedById()
     * @uses PromptVersion::setLastModifiedDate()
     * @uses PromptVersion::setMasterLabel()
     * @uses PromptVersion::setParent()
     * @uses PromptVersion::setParentId()
     * @uses PromptVersion::setPublishedByUser()
     * @uses PromptVersion::setPublishedByUserId()
     * @uses PromptVersion::setPublishedDate()
     * @uses PromptVersion::setShouldDisplayActionButton()
     * @uses PromptVersion::setStartDate()
     * @uses PromptVersion::setSystemModstamp()
     * @uses PromptVersion::setTargetAppDeveloperName()
     * @uses PromptVersion::setTargetAppNamespacePrefix()
     * @uses PromptVersion::setTargetPageKey1()
     * @uses PromptVersion::setTargetPageKey2()
     * @uses PromptVersion::setTargetPageType()
     * @uses PromptVersion::setTimesToDisplay()
     * @uses PromptVersion::setTitle()
     * @uses PromptVersion::setUserAccess()
     * @uses PromptVersion::setVersionNumber()
     * @param string $actionButtonLabel
     * @param string $actionButtonLink
     * @param string $body
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param int $delayDays
     * @param string $description
     * @param string $dismissButtonLabel
     * @param string $displayPosition
     * @param string $displayType
     * @param string $endDate
     * @param string $header
     * @param string $indexWithIsPublished
     * @param string $indexWithoutIsPublished
     * @param bool $isDeleted
     * @param bool $isPublished
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $masterLabel
     * @param \NexusDigital/MiratelForce\StructType\Prompt $parent
     * @param string $parentId
     * @param \NexusDigital/MiratelForce\StructType\User $publishedByUser
     * @param string $publishedByUserId
     * @param string $publishedDate
     * @param bool $shouldDisplayActionButton
     * @param string $startDate
     * @param string $systemModstamp
     * @param string $targetAppDeveloperName
     * @param string $targetAppNamespacePrefix
     * @param string $targetPageKey1
     * @param string $targetPageKey2
     * @param string $targetPageType
     * @param int $timesToDisplay
     * @param string $title
     * @param string $userAccess
     * @param int $versionNumber
     */
    public function __construct($actionButtonLabel = null, $actionButtonLink = null, $body = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $delayDays = null, $description = null, $dismissButtonLabel = null, $displayPosition = null, $displayType = null, $endDate = null, $header = null, $indexWithIsPublished = null, $indexWithoutIsPublished = null, $isDeleted = null, $isPublished = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $masterLabel = null, \NexusDigital/MiratelForce\StructType\Prompt $parent = null, $parentId = null, \NexusDigital/MiratelForce\StructType\User $publishedByUser = null, $publishedByUserId = null, $publishedDate = null, $shouldDisplayActionButton = null, $startDate = null, $systemModstamp = null, $targetAppDeveloperName = null, $targetAppNamespacePrefix = null, $targetPageKey1 = null, $targetPageKey2 = null, $targetPageType = null, $timesToDisplay = null, $title = null, $userAccess = null, $versionNumber = null)
    {
        $this
            ->setActionButtonLabel($actionButtonLabel)
            ->setActionButtonLink($actionButtonLink)
            ->setBody($body)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDelayDays($delayDays)
            ->setDescription($description)
            ->setDismissButtonLabel($dismissButtonLabel)
            ->setDisplayPosition($displayPosition)
            ->setDisplayType($displayType)
            ->setEndDate($endDate)
            ->setHeader($header)
            ->setIndexWithIsPublished($indexWithIsPublished)
            ->setIndexWithoutIsPublished($indexWithoutIsPublished)
            ->setIsDeleted($isDeleted)
            ->setIsPublished($isPublished)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setMasterLabel($masterLabel)
            ->setParent($parent)
            ->setParentId($parentId)
            ->setPublishedByUser($publishedByUser)
            ->setPublishedByUserId($publishedByUserId)
            ->setPublishedDate($publishedDate)
            ->setShouldDisplayActionButton($shouldDisplayActionButton)
            ->setStartDate($startDate)
            ->setSystemModstamp($systemModstamp)
            ->setTargetAppDeveloperName($targetAppDeveloperName)
            ->setTargetAppNamespacePrefix($targetAppNamespacePrefix)
            ->setTargetPageKey1($targetPageKey1)
            ->setTargetPageKey2($targetPageKey2)
            ->setTargetPageType($targetPageType)
            ->setTimesToDisplay($timesToDisplay)
            ->setTitle($title)
            ->setUserAccess($userAccess)
            ->setVersionNumber($versionNumber);
    }
    /**
     * Get ActionButtonLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionButtonLabel()
    {
        return isset($this->ActionButtonLabel) ? $this->ActionButtonLabel : null;
    }
    /**
     * Set ActionButtonLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actionButtonLabel
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setActionButtonLabel($actionButtonLabel = null)
    {
        // validation for constraint: string
        if (!is_null($actionButtonLabel) && !is_string($actionButtonLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionButtonLabel, true), gettype($actionButtonLabel)), __LINE__);
        }
        if (is_null($actionButtonLabel) || (is_array($actionButtonLabel) && empty($actionButtonLabel))) {
            unset($this->ActionButtonLabel);
        } else {
            $this->ActionButtonLabel = $actionButtonLabel;
        }
        return $this;
    }
    /**
     * Get ActionButtonLink value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionButtonLink()
    {
        return isset($this->ActionButtonLink) ? $this->ActionButtonLink : null;
    }
    /**
     * Set ActionButtonLink value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actionButtonLink
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setActionButtonLink($actionButtonLink = null)
    {
        // validation for constraint: string
        if (!is_null($actionButtonLink) && !is_string($actionButtonLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionButtonLink, true), gettype($actionButtonLink)), __LINE__);
        }
        if (is_null($actionButtonLink) || (is_array($actionButtonLink) && empty($actionButtonLink))) {
            unset($this->ActionButtonLink);
        } else {
            $this->ActionButtonLink = $actionButtonLink;
        }
        return $this;
    }
    /**
     * Get Body value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBody()
    {
        return isset($this->Body) ? $this->Body : null;
    }
    /**
     * Set Body value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $body
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setBody($body = null)
    {
        // validation for constraint: string
        if (!is_null($body) && !is_string($body)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($body, true), gettype($body)), __LINE__);
        }
        if (is_null($body) || (is_array($body) && empty($body))) {
            unset($this->Body);
        } else {
            $this->Body = $body;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get DelayDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDelayDays()
    {
        return isset($this->DelayDays) ? $this->DelayDays : null;
    }
    /**
     * Set DelayDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $delayDays
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setDelayDays($delayDays = null)
    {
        // validation for constraint: int
        if (!is_null($delayDays) && !(is_int($delayDays) || ctype_digit($delayDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($delayDays, true), gettype($delayDays)), __LINE__);
        }
        if (is_null($delayDays) || (is_array($delayDays) && empty($delayDays))) {
            unset($this->DelayDays);
        } else {
            $this->DelayDays = $delayDays;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DismissButtonLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDismissButtonLabel()
    {
        return isset($this->DismissButtonLabel) ? $this->DismissButtonLabel : null;
    }
    /**
     * Set DismissButtonLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dismissButtonLabel
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setDismissButtonLabel($dismissButtonLabel = null)
    {
        // validation for constraint: string
        if (!is_null($dismissButtonLabel) && !is_string($dismissButtonLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dismissButtonLabel, true), gettype($dismissButtonLabel)), __LINE__);
        }
        if (is_null($dismissButtonLabel) || (is_array($dismissButtonLabel) && empty($dismissButtonLabel))) {
            unset($this->DismissButtonLabel);
        } else {
            $this->DismissButtonLabel = $dismissButtonLabel;
        }
        return $this;
    }
    /**
     * Get DisplayPosition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayPosition()
    {
        return isset($this->DisplayPosition) ? $this->DisplayPosition : null;
    }
    /**
     * Set DisplayPosition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayPosition
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setDisplayPosition($displayPosition = null)
    {
        // validation for constraint: string
        if (!is_null($displayPosition) && !is_string($displayPosition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayPosition, true), gettype($displayPosition)), __LINE__);
        }
        if (is_null($displayPosition) || (is_array($displayPosition) && empty($displayPosition))) {
            unset($this->DisplayPosition);
        } else {
            $this->DisplayPosition = $displayPosition;
        }
        return $this;
    }
    /**
     * Get DisplayType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayType()
    {
        return isset($this->DisplayType) ? $this->DisplayType : null;
    }
    /**
     * Set DisplayType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayType
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setDisplayType($displayType = null)
    {
        // validation for constraint: string
        if (!is_null($displayType) && !is_string($displayType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayType, true), gettype($displayType)), __LINE__);
        }
        if (is_null($displayType) || (is_array($displayType) && empty($displayType))) {
            unset($this->DisplayType);
        } else {
            $this->DisplayType = $displayType;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get Header value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHeader()
    {
        return isset($this->Header) ? $this->Header : null;
    }
    /**
     * Set Header value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $header
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setHeader($header = null)
    {
        // validation for constraint: string
        if (!is_null($header) && !is_string($header)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($header, true), gettype($header)), __LINE__);
        }
        if (is_null($header) || (is_array($header) && empty($header))) {
            unset($this->Header);
        } else {
            $this->Header = $header;
        }
        return $this;
    }
    /**
     * Get IndexWithIsPublished value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIndexWithIsPublished()
    {
        return isset($this->IndexWithIsPublished) ? $this->IndexWithIsPublished : null;
    }
    /**
     * Set IndexWithIsPublished value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $indexWithIsPublished
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setIndexWithIsPublished($indexWithIsPublished = null)
    {
        // validation for constraint: string
        if (!is_null($indexWithIsPublished) && !is_string($indexWithIsPublished)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indexWithIsPublished, true), gettype($indexWithIsPublished)), __LINE__);
        }
        if (is_null($indexWithIsPublished) || (is_array($indexWithIsPublished) && empty($indexWithIsPublished))) {
            unset($this->IndexWithIsPublished);
        } else {
            $this->IndexWithIsPublished = $indexWithIsPublished;
        }
        return $this;
    }
    /**
     * Get IndexWithoutIsPublished value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIndexWithoutIsPublished()
    {
        return isset($this->IndexWithoutIsPublished) ? $this->IndexWithoutIsPublished : null;
    }
    /**
     * Set IndexWithoutIsPublished value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $indexWithoutIsPublished
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setIndexWithoutIsPublished($indexWithoutIsPublished = null)
    {
        // validation for constraint: string
        if (!is_null($indexWithoutIsPublished) && !is_string($indexWithoutIsPublished)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indexWithoutIsPublished, true), gettype($indexWithoutIsPublished)), __LINE__);
        }
        if (is_null($indexWithoutIsPublished) || (is_array($indexWithoutIsPublished) && empty($indexWithoutIsPublished))) {
            unset($this->IndexWithoutIsPublished);
        } else {
            $this->IndexWithoutIsPublished = $indexWithoutIsPublished;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get IsPublished value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPublished()
    {
        return isset($this->IsPublished) ? $this->IsPublished : null;
    }
    /**
     * Set IsPublished value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPublished
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setIsPublished($isPublished = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPublished) && !is_bool($isPublished)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPublished, true), gettype($isPublished)), __LINE__);
        }
        if (is_null($isPublished) || (is_array($isPublished) && empty($isPublished))) {
            unset($this->IsPublished);
        } else {
            $this->IsPublished = $isPublished;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get MasterLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterLabel()
    {
        return isset($this->MasterLabel) ? $this->MasterLabel : null;
    }
    /**
     * Set MasterLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterLabel
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setMasterLabel($masterLabel = null)
    {
        // validation for constraint: string
        if (!is_null($masterLabel) && !is_string($masterLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterLabel, true), gettype($masterLabel)), __LINE__);
        }
        if (is_null($masterLabel) || (is_array($masterLabel) && empty($masterLabel))) {
            unset($this->MasterLabel);
        } else {
            $this->MasterLabel = $masterLabel;
        }
        return $this;
    }
    /**
     * Get Parent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Prompt|null
     */
    public function getParent()
    {
        return isset($this->Parent) ? $this->Parent : null;
    }
    /**
     * Set Parent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Prompt $parent
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setParent(\NexusDigital/MiratelForce\StructType\Prompt $parent = null)
    {
        if (is_null($parent) || (is_array($parent) && empty($parent))) {
            unset($this->Parent);
        } else {
            $this->Parent = $parent;
        }
        return $this;
    }
    /**
     * Get ParentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentId()
    {
        return isset($this->ParentId) ? $this->ParentId : null;
    }
    /**
     * Set ParentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentId
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: string
        if (!is_null($parentId) && !is_string($parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentId, true), gettype($parentId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($parentId) && mb_strlen($parentId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($parentId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($parentId) && !preg_match('/[a-zA-Z0-9]{18}/', $parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($parentId, true)), __LINE__);
        }
        if (is_null($parentId) || (is_array($parentId) && empty($parentId))) {
            unset($this->ParentId);
        } else {
            $this->ParentId = $parentId;
        }
        return $this;
    }
    /**
     * Get PublishedByUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getPublishedByUser()
    {
        return isset($this->PublishedByUser) ? $this->PublishedByUser : null;
    }
    /**
     * Set PublishedByUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $publishedByUser
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setPublishedByUser(\NexusDigital/MiratelForce\StructType\User $publishedByUser = null)
    {
        if (is_null($publishedByUser) || (is_array($publishedByUser) && empty($publishedByUser))) {
            unset($this->PublishedByUser);
        } else {
            $this->PublishedByUser = $publishedByUser;
        }
        return $this;
    }
    /**
     * Get PublishedByUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPublishedByUserId()
    {
        return isset($this->PublishedByUserId) ? $this->PublishedByUserId : null;
    }
    /**
     * Set PublishedByUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $publishedByUserId
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setPublishedByUserId($publishedByUserId = null)
    {
        // validation for constraint: string
        if (!is_null($publishedByUserId) && !is_string($publishedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publishedByUserId, true), gettype($publishedByUserId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($publishedByUserId) && mb_strlen($publishedByUserId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($publishedByUserId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($publishedByUserId) && !preg_match('/[a-zA-Z0-9]{18}/', $publishedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($publishedByUserId, true)), __LINE__);
        }
        if (is_null($publishedByUserId) || (is_array($publishedByUserId) && empty($publishedByUserId))) {
            unset($this->PublishedByUserId);
        } else {
            $this->PublishedByUserId = $publishedByUserId;
        }
        return $this;
    }
    /**
     * Get PublishedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPublishedDate()
    {
        return isset($this->PublishedDate) ? $this->PublishedDate : null;
    }
    /**
     * Set PublishedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $publishedDate
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setPublishedDate($publishedDate = null)
    {
        // validation for constraint: string
        if (!is_null($publishedDate) && !is_string($publishedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publishedDate, true), gettype($publishedDate)), __LINE__);
        }
        if (is_null($publishedDate) || (is_array($publishedDate) && empty($publishedDate))) {
            unset($this->PublishedDate);
        } else {
            $this->PublishedDate = $publishedDate;
        }
        return $this;
    }
    /**
     * Get ShouldDisplayActionButton value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShouldDisplayActionButton()
    {
        return isset($this->ShouldDisplayActionButton) ? $this->ShouldDisplayActionButton : null;
    }
    /**
     * Set ShouldDisplayActionButton value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $shouldDisplayActionButton
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setShouldDisplayActionButton($shouldDisplayActionButton = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldDisplayActionButton) && !is_bool($shouldDisplayActionButton)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldDisplayActionButton, true), gettype($shouldDisplayActionButton)), __LINE__);
        }
        if (is_null($shouldDisplayActionButton) || (is_array($shouldDisplayActionButton) && empty($shouldDisplayActionButton))) {
            unset($this->ShouldDisplayActionButton);
        } else {
            $this->ShouldDisplayActionButton = $shouldDisplayActionButton;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get TargetAppDeveloperName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetAppDeveloperName()
    {
        return isset($this->TargetAppDeveloperName) ? $this->TargetAppDeveloperName : null;
    }
    /**
     * Set TargetAppDeveloperName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetAppDeveloperName
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setTargetAppDeveloperName($targetAppDeveloperName = null)
    {
        // validation for constraint: string
        if (!is_null($targetAppDeveloperName) && !is_string($targetAppDeveloperName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetAppDeveloperName, true), gettype($targetAppDeveloperName)), __LINE__);
        }
        if (is_null($targetAppDeveloperName) || (is_array($targetAppDeveloperName) && empty($targetAppDeveloperName))) {
            unset($this->TargetAppDeveloperName);
        } else {
            $this->TargetAppDeveloperName = $targetAppDeveloperName;
        }
        return $this;
    }
    /**
     * Get TargetAppNamespacePrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetAppNamespacePrefix()
    {
        return isset($this->TargetAppNamespacePrefix) ? $this->TargetAppNamespacePrefix : null;
    }
    /**
     * Set TargetAppNamespacePrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetAppNamespacePrefix
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setTargetAppNamespacePrefix($targetAppNamespacePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($targetAppNamespacePrefix) && !is_string($targetAppNamespacePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetAppNamespacePrefix, true), gettype($targetAppNamespacePrefix)), __LINE__);
        }
        if (is_null($targetAppNamespacePrefix) || (is_array($targetAppNamespacePrefix) && empty($targetAppNamespacePrefix))) {
            unset($this->TargetAppNamespacePrefix);
        } else {
            $this->TargetAppNamespacePrefix = $targetAppNamespacePrefix;
        }
        return $this;
    }
    /**
     * Get TargetPageKey1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPageKey1()
    {
        return isset($this->TargetPageKey1) ? $this->TargetPageKey1 : null;
    }
    /**
     * Set TargetPageKey1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPageKey1
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setTargetPageKey1($targetPageKey1 = null)
    {
        // validation for constraint: string
        if (!is_null($targetPageKey1) && !is_string($targetPageKey1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPageKey1, true), gettype($targetPageKey1)), __LINE__);
        }
        if (is_null($targetPageKey1) || (is_array($targetPageKey1) && empty($targetPageKey1))) {
            unset($this->TargetPageKey1);
        } else {
            $this->TargetPageKey1 = $targetPageKey1;
        }
        return $this;
    }
    /**
     * Get TargetPageKey2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPageKey2()
    {
        return isset($this->TargetPageKey2) ? $this->TargetPageKey2 : null;
    }
    /**
     * Set TargetPageKey2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPageKey2
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setTargetPageKey2($targetPageKey2 = null)
    {
        // validation for constraint: string
        if (!is_null($targetPageKey2) && !is_string($targetPageKey2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPageKey2, true), gettype($targetPageKey2)), __LINE__);
        }
        if (is_null($targetPageKey2) || (is_array($targetPageKey2) && empty($targetPageKey2))) {
            unset($this->TargetPageKey2);
        } else {
            $this->TargetPageKey2 = $targetPageKey2;
        }
        return $this;
    }
    /**
     * Get TargetPageType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPageType()
    {
        return isset($this->TargetPageType) ? $this->TargetPageType : null;
    }
    /**
     * Set TargetPageType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPageType
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setTargetPageType($targetPageType = null)
    {
        // validation for constraint: string
        if (!is_null($targetPageType) && !is_string($targetPageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPageType, true), gettype($targetPageType)), __LINE__);
        }
        if (is_null($targetPageType) || (is_array($targetPageType) && empty($targetPageType))) {
            unset($this->TargetPageType);
        } else {
            $this->TargetPageType = $targetPageType;
        }
        return $this;
    }
    /**
     * Get TimesToDisplay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTimesToDisplay()
    {
        return isset($this->TimesToDisplay) ? $this->TimesToDisplay : null;
    }
    /**
     * Set TimesToDisplay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $timesToDisplay
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setTimesToDisplay($timesToDisplay = null)
    {
        // validation for constraint: int
        if (!is_null($timesToDisplay) && !(is_int($timesToDisplay) || ctype_digit($timesToDisplay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timesToDisplay, true), gettype($timesToDisplay)), __LINE__);
        }
        if (is_null($timesToDisplay) || (is_array($timesToDisplay) && empty($timesToDisplay))) {
            unset($this->TimesToDisplay);
        } else {
            $this->TimesToDisplay = $timesToDisplay;
        }
        return $this;
    }
    /**
     * Get Title value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitle()
    {
        return isset($this->Title) ? $this->Title : null;
    }
    /**
     * Set Title value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $title
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        if (is_null($title) || (is_array($title) && empty($title))) {
            unset($this->Title);
        } else {
            $this->Title = $title;
        }
        return $this;
    }
    /**
     * Get UserAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserAccess()
    {
        return isset($this->UserAccess) ? $this->UserAccess : null;
    }
    /**
     * Set UserAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userAccess
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setUserAccess($userAccess = null)
    {
        // validation for constraint: string
        if (!is_null($userAccess) && !is_string($userAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userAccess, true), gettype($userAccess)), __LINE__);
        }
        if (is_null($userAccess) || (is_array($userAccess) && empty($userAccess))) {
            unset($this->UserAccess);
        } else {
            $this->UserAccess = $userAccess;
        }
        return $this;
    }
    /**
     * Get VersionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVersionNumber()
    {
        return isset($this->VersionNumber) ? $this->VersionNumber : null;
    }
    /**
     * Set VersionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $versionNumber
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public function setVersionNumber($versionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($versionNumber) && !(is_int($versionNumber) || ctype_digit($versionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($versionNumber, true), gettype($versionNumber)), __LINE__);
        }
        if (is_null($versionNumber) || (is_array($versionNumber) && empty($versionNumber))) {
            unset($this->VersionNumber);
        } else {
            $this->VersionNumber = $versionNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\PromptVersion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
