<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessInstanceWorkitem StructType
 * @subpackage Structs
 */
class ProcessInstanceWorkitem extends SObject
{
    /**
     * The Actor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $Actor;
    /**
     * The ActorId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ActorId;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The ElapsedTimeInDays
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ElapsedTimeInDays;
    /**
     * The ElapsedTimeInHours
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ElapsedTimeInHours;
    /**
     * The ElapsedTimeInMinutes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ElapsedTimeInMinutes;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The OriginalActor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $OriginalActor;
    /**
     * The OriginalActorId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $OriginalActorId;
    /**
     * The ProcessInstance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public $ProcessInstance;
    /**
     * The ProcessInstanceId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ProcessInstanceId;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * Constructor method for ProcessInstanceWorkitem
     * @uses ProcessInstanceWorkitem::setActor()
     * @uses ProcessInstanceWorkitem::setActorId()
     * @uses ProcessInstanceWorkitem::setCreatedBy()
     * @uses ProcessInstanceWorkitem::setCreatedById()
     * @uses ProcessInstanceWorkitem::setCreatedDate()
     * @uses ProcessInstanceWorkitem::setElapsedTimeInDays()
     * @uses ProcessInstanceWorkitem::setElapsedTimeInHours()
     * @uses ProcessInstanceWorkitem::setElapsedTimeInMinutes()
     * @uses ProcessInstanceWorkitem::setIsDeleted()
     * @uses ProcessInstanceWorkitem::setOriginalActor()
     * @uses ProcessInstanceWorkitem::setOriginalActorId()
     * @uses ProcessInstanceWorkitem::setProcessInstance()
     * @uses ProcessInstanceWorkitem::setProcessInstanceId()
     * @uses ProcessInstanceWorkitem::setSystemModstamp()
     * @param \NexusDigital/MiratelForce\StructType\SObject $actor
     * @param string $actorId
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param float $elapsedTimeInDays
     * @param float $elapsedTimeInHours
     * @param float $elapsedTimeInMinutes
     * @param bool $isDeleted
     * @param \NexusDigital/MiratelForce\StructType\SObject $originalActor
     * @param string $originalActorId
     * @param \NexusDigital/MiratelForce\StructType\ProcessInstance $processInstance
     * @param string $processInstanceId
     * @param string $systemModstamp
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\SObject $actor = null, $actorId = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $elapsedTimeInDays = null, $elapsedTimeInHours = null, $elapsedTimeInMinutes = null, $isDeleted = null, \NexusDigital/MiratelForce\StructType\SObject $originalActor = null, $originalActorId = null, \NexusDigital/MiratelForce\StructType\ProcessInstance $processInstance = null, $processInstanceId = null, $systemModstamp = null)
    {
        $this
            ->setActor($actor)
            ->setActorId($actorId)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setElapsedTimeInDays($elapsedTimeInDays)
            ->setElapsedTimeInHours($elapsedTimeInHours)
            ->setElapsedTimeInMinutes($elapsedTimeInMinutes)
            ->setIsDeleted($isDeleted)
            ->setOriginalActor($originalActor)
            ->setOriginalActorId($originalActorId)
            ->setProcessInstance($processInstance)
            ->setProcessInstanceId($processInstanceId)
            ->setSystemModstamp($systemModstamp);
    }
    /**
     * Get Actor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getActor()
    {
        return isset($this->Actor) ? $this->Actor : null;
    }
    /**
     * Set Actor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $actor
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceWorkitem
     */
    public function setActor(\NexusDigital/MiratelForce\StructType\SObject $actor = null)
    {
        if (is_null($actor) || (is_array($actor) && empty($actor))) {
            unset($this->Actor);
        } else {
            $this->Actor = $actor;
        }
        return $this;
    }
    /**
     * Get ActorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActorId()
    {
        return isset($this->ActorId) ? $this->ActorId : null;
    }
    /**
     * Set ActorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actorId
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceWorkitem
     */
    public function setActorId($actorId = null)
    {
        // validation for constraint: string
        if (!is_null($actorId) && !is_string($actorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actorId, true), gettype($actorId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($actorId) && mb_strlen($actorId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($actorId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($actorId) && !preg_match('/[a-zA-Z0-9]{18}/', $actorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($actorId, true)), __LINE__);
        }
        if (is_null($actorId) || (is_array($actorId) && empty($actorId))) {
            unset($this->ActorId);
        } else {
            $this->ActorId = $actorId;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceWorkitem
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceWorkitem
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceWorkitem
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get ElapsedTimeInDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getElapsedTimeInDays()
    {
        return isset($this->ElapsedTimeInDays) ? $this->ElapsedTimeInDays : null;
    }
    /**
     * Set ElapsedTimeInDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $elapsedTimeInDays
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceWorkitem
     */
    public function setElapsedTimeInDays($elapsedTimeInDays = null)
    {
        // validation for constraint: float
        if (!is_null($elapsedTimeInDays) && !(is_float($elapsedTimeInDays) || is_numeric($elapsedTimeInDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($elapsedTimeInDays, true), gettype($elapsedTimeInDays)), __LINE__);
        }
        if (is_null($elapsedTimeInDays) || (is_array($elapsedTimeInDays) && empty($elapsedTimeInDays))) {
            unset($this->ElapsedTimeInDays);
        } else {
            $this->ElapsedTimeInDays = $elapsedTimeInDays;
        }
        return $this;
    }
    /**
     * Get ElapsedTimeInHours value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getElapsedTimeInHours()
    {
        return isset($this->ElapsedTimeInHours) ? $this->ElapsedTimeInHours : null;
    }
    /**
     * Set ElapsedTimeInHours value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $elapsedTimeInHours
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceWorkitem
     */
    public function setElapsedTimeInHours($elapsedTimeInHours = null)
    {
        // validation for constraint: float
        if (!is_null($elapsedTimeInHours) && !(is_float($elapsedTimeInHours) || is_numeric($elapsedTimeInHours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($elapsedTimeInHours, true), gettype($elapsedTimeInHours)), __LINE__);
        }
        if (is_null($elapsedTimeInHours) || (is_array($elapsedTimeInHours) && empty($elapsedTimeInHours))) {
            unset($this->ElapsedTimeInHours);
        } else {
            $this->ElapsedTimeInHours = $elapsedTimeInHours;
        }
        return $this;
    }
    /**
     * Get ElapsedTimeInMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getElapsedTimeInMinutes()
    {
        return isset($this->ElapsedTimeInMinutes) ? $this->ElapsedTimeInMinutes : null;
    }
    /**
     * Set ElapsedTimeInMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $elapsedTimeInMinutes
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceWorkitem
     */
    public function setElapsedTimeInMinutes($elapsedTimeInMinutes = null)
    {
        // validation for constraint: float
        if (!is_null($elapsedTimeInMinutes) && !(is_float($elapsedTimeInMinutes) || is_numeric($elapsedTimeInMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($elapsedTimeInMinutes, true), gettype($elapsedTimeInMinutes)), __LINE__);
        }
        if (is_null($elapsedTimeInMinutes) || (is_array($elapsedTimeInMinutes) && empty($elapsedTimeInMinutes))) {
            unset($this->ElapsedTimeInMinutes);
        } else {
            $this->ElapsedTimeInMinutes = $elapsedTimeInMinutes;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceWorkitem
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get OriginalActor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getOriginalActor()
    {
        return isset($this->OriginalActor) ? $this->OriginalActor : null;
    }
    /**
     * Set OriginalActor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $originalActor
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceWorkitem
     */
    public function setOriginalActor(\NexusDigital/MiratelForce\StructType\SObject $originalActor = null)
    {
        if (is_null($originalActor) || (is_array($originalActor) && empty($originalActor))) {
            unset($this->OriginalActor);
        } else {
            $this->OriginalActor = $originalActor;
        }
        return $this;
    }
    /**
     * Get OriginalActorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalActorId()
    {
        return isset($this->OriginalActorId) ? $this->OriginalActorId : null;
    }
    /**
     * Set OriginalActorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalActorId
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceWorkitem
     */
    public function setOriginalActorId($originalActorId = null)
    {
        // validation for constraint: string
        if (!is_null($originalActorId) && !is_string($originalActorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalActorId, true), gettype($originalActorId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($originalActorId) && mb_strlen($originalActorId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($originalActorId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($originalActorId) && !preg_match('/[a-zA-Z0-9]{18}/', $originalActorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($originalActorId, true)), __LINE__);
        }
        if (is_null($originalActorId) || (is_array($originalActorId) && empty($originalActorId))) {
            unset($this->OriginalActorId);
        } else {
            $this->OriginalActorId = $originalActorId;
        }
        return $this;
    }
    /**
     * Get ProcessInstance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance|null
     */
    public function getProcessInstance()
    {
        return isset($this->ProcessInstance) ? $this->ProcessInstance : null;
    }
    /**
     * Set ProcessInstance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ProcessInstance $processInstance
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceWorkitem
     */
    public function setProcessInstance(\NexusDigital/MiratelForce\StructType\ProcessInstance $processInstance = null)
    {
        if (is_null($processInstance) || (is_array($processInstance) && empty($processInstance))) {
            unset($this->ProcessInstance);
        } else {
            $this->ProcessInstance = $processInstance;
        }
        return $this;
    }
    /**
     * Get ProcessInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessInstanceId()
    {
        return isset($this->ProcessInstanceId) ? $this->ProcessInstanceId : null;
    }
    /**
     * Set ProcessInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processInstanceId
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceWorkitem
     */
    public function setProcessInstanceId($processInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($processInstanceId) && !is_string($processInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processInstanceId, true), gettype($processInstanceId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($processInstanceId) && mb_strlen($processInstanceId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($processInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($processInstanceId) && !preg_match('/[a-zA-Z0-9]{18}/', $processInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($processInstanceId, true)), __LINE__);
        }
        if (is_null($processInstanceId) || (is_array($processInstanceId) && empty($processInstanceId))) {
            unset($this->ProcessInstanceId);
        } else {
            $this->ProcessInstanceId = $processInstanceId;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceWorkitem
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstanceWorkitem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
