<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessInstance StructType
 * @subpackage Structs
 */
class ProcessInstance extends SObject
{
    /**
     * The CompletedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompletedDate;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The ElapsedTimeInDays
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ElapsedTimeInDays;
    /**
     * The ElapsedTimeInHours
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ElapsedTimeInHours;
    /**
     * The ElapsedTimeInMinutes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ElapsedTimeInMinutes;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The LastActor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastActor;
    /**
     * The LastActorId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastActorId;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The Nodes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Nodes;
    /**
     * The ProcessDefinition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ProcessDefinition
     */
    public $ProcessDefinition;
    /**
     * The ProcessDefinitionId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ProcessDefinitionId;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The Steps
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Steps;
    /**
     * The StepsAndWorkitems
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $StepsAndWorkitems;
    /**
     * The SubmittedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $SubmittedBy;
    /**
     * The SubmittedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $SubmittedById;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The TargetObject
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $TargetObject;
    /**
     * The TargetObjectId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $TargetObjectId;
    /**
     * The Workitems
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Workitems;
    /**
     * Constructor method for ProcessInstance
     * @uses ProcessInstance::setCompletedDate()
     * @uses ProcessInstance::setCreatedBy()
     * @uses ProcessInstance::setCreatedById()
     * @uses ProcessInstance::setCreatedDate()
     * @uses ProcessInstance::setElapsedTimeInDays()
     * @uses ProcessInstance::setElapsedTimeInHours()
     * @uses ProcessInstance::setElapsedTimeInMinutes()
     * @uses ProcessInstance::setIsDeleted()
     * @uses ProcessInstance::setLastActor()
     * @uses ProcessInstance::setLastActorId()
     * @uses ProcessInstance::setLastModifiedBy()
     * @uses ProcessInstance::setLastModifiedById()
     * @uses ProcessInstance::setLastModifiedDate()
     * @uses ProcessInstance::setNodes()
     * @uses ProcessInstance::setProcessDefinition()
     * @uses ProcessInstance::setProcessDefinitionId()
     * @uses ProcessInstance::setStatus()
     * @uses ProcessInstance::setSteps()
     * @uses ProcessInstance::setStepsAndWorkitems()
     * @uses ProcessInstance::setSubmittedBy()
     * @uses ProcessInstance::setSubmittedById()
     * @uses ProcessInstance::setSystemModstamp()
     * @uses ProcessInstance::setTargetObject()
     * @uses ProcessInstance::setTargetObjectId()
     * @uses ProcessInstance::setWorkitems()
     * @param string $completedDate
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param float $elapsedTimeInDays
     * @param float $elapsedTimeInHours
     * @param float $elapsedTimeInMinutes
     * @param bool $isDeleted
     * @param \NexusDigital/MiratelForce\StructType\User $lastActor
     * @param string $lastActorId
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $nodes
     * @param \NexusDigital/MiratelForce\StructType\ProcessDefinition $processDefinition
     * @param string $processDefinitionId
     * @param string $status
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $steps
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $stepsAndWorkitems
     * @param \NexusDigital/MiratelForce\StructType\User $submittedBy
     * @param string $submittedById
     * @param string $systemModstamp
     * @param \NexusDigital/MiratelForce\StructType\SObject $targetObject
     * @param string $targetObjectId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $workitems
     */
    public function __construct($completedDate = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $elapsedTimeInDays = null, $elapsedTimeInHours = null, $elapsedTimeInMinutes = null, $isDeleted = null, \NexusDigital/MiratelForce\StructType\User $lastActor = null, $lastActorId = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, \NexusDigital/MiratelForce\StructType\QueryResult $nodes = null, \NexusDigital/MiratelForce\StructType\ProcessDefinition $processDefinition = null, $processDefinitionId = null, $status = null, \NexusDigital/MiratelForce\StructType\QueryResult $steps = null, \NexusDigital/MiratelForce\StructType\QueryResult $stepsAndWorkitems = null, \NexusDigital/MiratelForce\StructType\User $submittedBy = null, $submittedById = null, $systemModstamp = null, \NexusDigital/MiratelForce\StructType\SObject $targetObject = null, $targetObjectId = null, \NexusDigital/MiratelForce\StructType\QueryResult $workitems = null)
    {
        $this
            ->setCompletedDate($completedDate)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setElapsedTimeInDays($elapsedTimeInDays)
            ->setElapsedTimeInHours($elapsedTimeInHours)
            ->setElapsedTimeInMinutes($elapsedTimeInMinutes)
            ->setIsDeleted($isDeleted)
            ->setLastActor($lastActor)
            ->setLastActorId($lastActorId)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setNodes($nodes)
            ->setProcessDefinition($processDefinition)
            ->setProcessDefinitionId($processDefinitionId)
            ->setStatus($status)
            ->setSteps($steps)
            ->setStepsAndWorkitems($stepsAndWorkitems)
            ->setSubmittedBy($submittedBy)
            ->setSubmittedById($submittedById)
            ->setSystemModstamp($systemModstamp)
            ->setTargetObject($targetObject)
            ->setTargetObjectId($targetObjectId)
            ->setWorkitems($workitems);
    }
    /**
     * Get CompletedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompletedDate()
    {
        return isset($this->CompletedDate) ? $this->CompletedDate : null;
    }
    /**
     * Set CompletedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $completedDate
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setCompletedDate($completedDate = null)
    {
        // validation for constraint: string
        if (!is_null($completedDate) && !is_string($completedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($completedDate, true), gettype($completedDate)), __LINE__);
        }
        if (is_null($completedDate) || (is_array($completedDate) && empty($completedDate))) {
            unset($this->CompletedDate);
        } else {
            $this->CompletedDate = $completedDate;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get ElapsedTimeInDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getElapsedTimeInDays()
    {
        return isset($this->ElapsedTimeInDays) ? $this->ElapsedTimeInDays : null;
    }
    /**
     * Set ElapsedTimeInDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $elapsedTimeInDays
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setElapsedTimeInDays($elapsedTimeInDays = null)
    {
        // validation for constraint: float
        if (!is_null($elapsedTimeInDays) && !(is_float($elapsedTimeInDays) || is_numeric($elapsedTimeInDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($elapsedTimeInDays, true), gettype($elapsedTimeInDays)), __LINE__);
        }
        if (is_null($elapsedTimeInDays) || (is_array($elapsedTimeInDays) && empty($elapsedTimeInDays))) {
            unset($this->ElapsedTimeInDays);
        } else {
            $this->ElapsedTimeInDays = $elapsedTimeInDays;
        }
        return $this;
    }
    /**
     * Get ElapsedTimeInHours value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getElapsedTimeInHours()
    {
        return isset($this->ElapsedTimeInHours) ? $this->ElapsedTimeInHours : null;
    }
    /**
     * Set ElapsedTimeInHours value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $elapsedTimeInHours
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setElapsedTimeInHours($elapsedTimeInHours = null)
    {
        // validation for constraint: float
        if (!is_null($elapsedTimeInHours) && !(is_float($elapsedTimeInHours) || is_numeric($elapsedTimeInHours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($elapsedTimeInHours, true), gettype($elapsedTimeInHours)), __LINE__);
        }
        if (is_null($elapsedTimeInHours) || (is_array($elapsedTimeInHours) && empty($elapsedTimeInHours))) {
            unset($this->ElapsedTimeInHours);
        } else {
            $this->ElapsedTimeInHours = $elapsedTimeInHours;
        }
        return $this;
    }
    /**
     * Get ElapsedTimeInMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getElapsedTimeInMinutes()
    {
        return isset($this->ElapsedTimeInMinutes) ? $this->ElapsedTimeInMinutes : null;
    }
    /**
     * Set ElapsedTimeInMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $elapsedTimeInMinutes
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setElapsedTimeInMinutes($elapsedTimeInMinutes = null)
    {
        // validation for constraint: float
        if (!is_null($elapsedTimeInMinutes) && !(is_float($elapsedTimeInMinutes) || is_numeric($elapsedTimeInMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($elapsedTimeInMinutes, true), gettype($elapsedTimeInMinutes)), __LINE__);
        }
        if (is_null($elapsedTimeInMinutes) || (is_array($elapsedTimeInMinutes) && empty($elapsedTimeInMinutes))) {
            unset($this->ElapsedTimeInMinutes);
        } else {
            $this->ElapsedTimeInMinutes = $elapsedTimeInMinutes;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get LastActor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastActor()
    {
        return isset($this->LastActor) ? $this->LastActor : null;
    }
    /**
     * Set LastActor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastActor
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setLastActor(\NexusDigital/MiratelForce\StructType\User $lastActor = null)
    {
        if (is_null($lastActor) || (is_array($lastActor) && empty($lastActor))) {
            unset($this->LastActor);
        } else {
            $this->LastActor = $lastActor;
        }
        return $this;
    }
    /**
     * Get LastActorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastActorId()
    {
        return isset($this->LastActorId) ? $this->LastActorId : null;
    }
    /**
     * Set LastActorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastActorId
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setLastActorId($lastActorId = null)
    {
        // validation for constraint: string
        if (!is_null($lastActorId) && !is_string($lastActorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastActorId, true), gettype($lastActorId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastActorId) && mb_strlen($lastActorId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastActorId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastActorId) && !preg_match('/[a-zA-Z0-9]{18}/', $lastActorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastActorId, true)), __LINE__);
        }
        if (is_null($lastActorId) || (is_array($lastActorId) && empty($lastActorId))) {
            unset($this->LastActorId);
        } else {
            $this->LastActorId = $lastActorId;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get Nodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getNodes()
    {
        return isset($this->Nodes) ? $this->Nodes : null;
    }
    /**
     * Set Nodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $nodes
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setNodes(\NexusDigital/MiratelForce\StructType\QueryResult $nodes = null)
    {
        if (is_null($nodes) || (is_array($nodes) && empty($nodes))) {
            unset($this->Nodes);
        } else {
            $this->Nodes = $nodes;
        }
        return $this;
    }
    /**
     * Get ProcessDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ProcessDefinition|null
     */
    public function getProcessDefinition()
    {
        return isset($this->ProcessDefinition) ? $this->ProcessDefinition : null;
    }
    /**
     * Set ProcessDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ProcessDefinition $processDefinition
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setProcessDefinition(\NexusDigital/MiratelForce\StructType\ProcessDefinition $processDefinition = null)
    {
        if (is_null($processDefinition) || (is_array($processDefinition) && empty($processDefinition))) {
            unset($this->ProcessDefinition);
        } else {
            $this->ProcessDefinition = $processDefinition;
        }
        return $this;
    }
    /**
     * Get ProcessDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessDefinitionId()
    {
        return isset($this->ProcessDefinitionId) ? $this->ProcessDefinitionId : null;
    }
    /**
     * Set ProcessDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processDefinitionId
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setProcessDefinitionId($processDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($processDefinitionId) && !is_string($processDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processDefinitionId, true), gettype($processDefinitionId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($processDefinitionId) && mb_strlen($processDefinitionId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($processDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($processDefinitionId) && !preg_match('/[a-zA-Z0-9]{18}/', $processDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($processDefinitionId, true)), __LINE__);
        }
        if (is_null($processDefinitionId) || (is_array($processDefinitionId) && empty($processDefinitionId))) {
            unset($this->ProcessDefinitionId);
        } else {
            $this->ProcessDefinitionId = $processDefinitionId;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Steps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getSteps()
    {
        return isset($this->Steps) ? $this->Steps : null;
    }
    /**
     * Set Steps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $steps
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setSteps(\NexusDigital/MiratelForce\StructType\QueryResult $steps = null)
    {
        if (is_null($steps) || (is_array($steps) && empty($steps))) {
            unset($this->Steps);
        } else {
            $this->Steps = $steps;
        }
        return $this;
    }
    /**
     * Get StepsAndWorkitems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getStepsAndWorkitems()
    {
        return isset($this->StepsAndWorkitems) ? $this->StepsAndWorkitems : null;
    }
    /**
     * Set StepsAndWorkitems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $stepsAndWorkitems
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setStepsAndWorkitems(\NexusDigital/MiratelForce\StructType\QueryResult $stepsAndWorkitems = null)
    {
        if (is_null($stepsAndWorkitems) || (is_array($stepsAndWorkitems) && empty($stepsAndWorkitems))) {
            unset($this->StepsAndWorkitems);
        } else {
            $this->StepsAndWorkitems = $stepsAndWorkitems;
        }
        return $this;
    }
    /**
     * Get SubmittedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getSubmittedBy()
    {
        return isset($this->SubmittedBy) ? $this->SubmittedBy : null;
    }
    /**
     * Set SubmittedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $submittedBy
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setSubmittedBy(\NexusDigital/MiratelForce\StructType\User $submittedBy = null)
    {
        if (is_null($submittedBy) || (is_array($submittedBy) && empty($submittedBy))) {
            unset($this->SubmittedBy);
        } else {
            $this->SubmittedBy = $submittedBy;
        }
        return $this;
    }
    /**
     * Get SubmittedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubmittedById()
    {
        return isset($this->SubmittedById) ? $this->SubmittedById : null;
    }
    /**
     * Set SubmittedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $submittedById
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setSubmittedById($submittedById = null)
    {
        // validation for constraint: string
        if (!is_null($submittedById) && !is_string($submittedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($submittedById, true), gettype($submittedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($submittedById) && mb_strlen($submittedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($submittedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($submittedById) && !preg_match('/[a-zA-Z0-9]{18}/', $submittedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($submittedById, true)), __LINE__);
        }
        if (is_null($submittedById) || (is_array($submittedById) && empty($submittedById))) {
            unset($this->SubmittedById);
        } else {
            $this->SubmittedById = $submittedById;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get TargetObject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getTargetObject()
    {
        return isset($this->TargetObject) ? $this->TargetObject : null;
    }
    /**
     * Set TargetObject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $targetObject
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setTargetObject(\NexusDigital/MiratelForce\StructType\SObject $targetObject = null)
    {
        if (is_null($targetObject) || (is_array($targetObject) && empty($targetObject))) {
            unset($this->TargetObject);
        } else {
            $this->TargetObject = $targetObject;
        }
        return $this;
    }
    /**
     * Get TargetObjectId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetObjectId()
    {
        return isset($this->TargetObjectId) ? $this->TargetObjectId : null;
    }
    /**
     * Set TargetObjectId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetObjectId
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setTargetObjectId($targetObjectId = null)
    {
        // validation for constraint: string
        if (!is_null($targetObjectId) && !is_string($targetObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetObjectId, true), gettype($targetObjectId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($targetObjectId) && mb_strlen($targetObjectId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($targetObjectId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($targetObjectId) && !preg_match('/[a-zA-Z0-9]{18}/', $targetObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($targetObjectId, true)), __LINE__);
        }
        if (is_null($targetObjectId) || (is_array($targetObjectId) && empty($targetObjectId))) {
            unset($this->TargetObjectId);
        } else {
            $this->TargetObjectId = $targetObjectId;
        }
        return $this;
    }
    /**
     * Get Workitems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getWorkitems()
    {
        return isset($this->Workitems) ? $this->Workitems : null;
    }
    /**
     * Set Workitems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $workitems
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public function setWorkitems(\NexusDigital/MiratelForce\StructType\QueryResult $workitems = null)
    {
        if (is_null($workitems) || (is_array($workitems) && empty($workitems))) {
            unset($this->Workitems);
        } else {
            $this->Workitems = $workitems;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ProcessInstance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
