<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlatformCachePartitionType StructType
 * @subpackage Structs
 */
class PlatformCachePartitionType extends SObject
{
    /**
     * The AllocatedCapacity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AllocatedCapacity;
    /**
     * The AllocatedPurchasedCapacity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AllocatedPurchasedCapacity;
    /**
     * The AllocatedTrialCapacity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AllocatedTrialCapacity;
    /**
     * The CacheType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CacheType;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The PlatformCachePartition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\PlatformCachePartition
     */
    public $PlatformCachePartition;
    /**
     * The PlatformCachePartitionId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $PlatformCachePartitionId;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * Constructor method for PlatformCachePartitionType
     * @uses PlatformCachePartitionType::setAllocatedCapacity()
     * @uses PlatformCachePartitionType::setAllocatedPurchasedCapacity()
     * @uses PlatformCachePartitionType::setAllocatedTrialCapacity()
     * @uses PlatformCachePartitionType::setCacheType()
     * @uses PlatformCachePartitionType::setCreatedBy()
     * @uses PlatformCachePartitionType::setCreatedById()
     * @uses PlatformCachePartitionType::setCreatedDate()
     * @uses PlatformCachePartitionType::setIsDeleted()
     * @uses PlatformCachePartitionType::setLastModifiedBy()
     * @uses PlatformCachePartitionType::setLastModifiedById()
     * @uses PlatformCachePartitionType::setLastModifiedDate()
     * @uses PlatformCachePartitionType::setPlatformCachePartition()
     * @uses PlatformCachePartitionType::setPlatformCachePartitionId()
     * @uses PlatformCachePartitionType::setSystemModstamp()
     * @param int $allocatedCapacity
     * @param int $allocatedPurchasedCapacity
     * @param int $allocatedTrialCapacity
     * @param string $cacheType
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param bool $isDeleted
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param \NexusDigital/MiratelForce\StructType\PlatformCachePartition $platformCachePartition
     * @param string $platformCachePartitionId
     * @param string $systemModstamp
     */
    public function __construct($allocatedCapacity = null, $allocatedPurchasedCapacity = null, $allocatedTrialCapacity = null, $cacheType = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $isDeleted = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, \NexusDigital/MiratelForce\StructType\PlatformCachePartition $platformCachePartition = null, $platformCachePartitionId = null, $systemModstamp = null)
    {
        $this
            ->setAllocatedCapacity($allocatedCapacity)
            ->setAllocatedPurchasedCapacity($allocatedPurchasedCapacity)
            ->setAllocatedTrialCapacity($allocatedTrialCapacity)
            ->setCacheType($cacheType)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setIsDeleted($isDeleted)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setPlatformCachePartition($platformCachePartition)
            ->setPlatformCachePartitionId($platformCachePartitionId)
            ->setSystemModstamp($systemModstamp);
    }
    /**
     * Get AllocatedCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAllocatedCapacity()
    {
        return isset($this->AllocatedCapacity) ? $this->AllocatedCapacity : null;
    }
    /**
     * Set AllocatedCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $allocatedCapacity
     * @return \NexusDigital/MiratelForce\StructType\PlatformCachePartitionType
     */
    public function setAllocatedCapacity($allocatedCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($allocatedCapacity) && !(is_int($allocatedCapacity) || ctype_digit($allocatedCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($allocatedCapacity, true), gettype($allocatedCapacity)), __LINE__);
        }
        if (is_null($allocatedCapacity) || (is_array($allocatedCapacity) && empty($allocatedCapacity))) {
            unset($this->AllocatedCapacity);
        } else {
            $this->AllocatedCapacity = $allocatedCapacity;
        }
        return $this;
    }
    /**
     * Get AllocatedPurchasedCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAllocatedPurchasedCapacity()
    {
        return isset($this->AllocatedPurchasedCapacity) ? $this->AllocatedPurchasedCapacity : null;
    }
    /**
     * Set AllocatedPurchasedCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $allocatedPurchasedCapacity
     * @return \NexusDigital/MiratelForce\StructType\PlatformCachePartitionType
     */
    public function setAllocatedPurchasedCapacity($allocatedPurchasedCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($allocatedPurchasedCapacity) && !(is_int($allocatedPurchasedCapacity) || ctype_digit($allocatedPurchasedCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($allocatedPurchasedCapacity, true), gettype($allocatedPurchasedCapacity)), __LINE__);
        }
        if (is_null($allocatedPurchasedCapacity) || (is_array($allocatedPurchasedCapacity) && empty($allocatedPurchasedCapacity))) {
            unset($this->AllocatedPurchasedCapacity);
        } else {
            $this->AllocatedPurchasedCapacity = $allocatedPurchasedCapacity;
        }
        return $this;
    }
    /**
     * Get AllocatedTrialCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAllocatedTrialCapacity()
    {
        return isset($this->AllocatedTrialCapacity) ? $this->AllocatedTrialCapacity : null;
    }
    /**
     * Set AllocatedTrialCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $allocatedTrialCapacity
     * @return \NexusDigital/MiratelForce\StructType\PlatformCachePartitionType
     */
    public function setAllocatedTrialCapacity($allocatedTrialCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($allocatedTrialCapacity) && !(is_int($allocatedTrialCapacity) || ctype_digit($allocatedTrialCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($allocatedTrialCapacity, true), gettype($allocatedTrialCapacity)), __LINE__);
        }
        if (is_null($allocatedTrialCapacity) || (is_array($allocatedTrialCapacity) && empty($allocatedTrialCapacity))) {
            unset($this->AllocatedTrialCapacity);
        } else {
            $this->AllocatedTrialCapacity = $allocatedTrialCapacity;
        }
        return $this;
    }
    /**
     * Get CacheType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCacheType()
    {
        return isset($this->CacheType) ? $this->CacheType : null;
    }
    /**
     * Set CacheType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cacheType
     * @return \NexusDigital/MiratelForce\StructType\PlatformCachePartitionType
     */
    public function setCacheType($cacheType = null)
    {
        // validation for constraint: string
        if (!is_null($cacheType) && !is_string($cacheType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cacheType, true), gettype($cacheType)), __LINE__);
        }
        if (is_null($cacheType) || (is_array($cacheType) && empty($cacheType))) {
            unset($this->CacheType);
        } else {
            $this->CacheType = $cacheType;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\PlatformCachePartitionType
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\PlatformCachePartitionType
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\PlatformCachePartitionType
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\PlatformCachePartitionType
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\PlatformCachePartitionType
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\PlatformCachePartitionType
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\PlatformCachePartitionType
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get PlatformCachePartition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\PlatformCachePartition|null
     */
    public function getPlatformCachePartition()
    {
        return isset($this->PlatformCachePartition) ? $this->PlatformCachePartition : null;
    }
    /**
     * Set PlatformCachePartition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\PlatformCachePartition $platformCachePartition
     * @return \NexusDigital/MiratelForce\StructType\PlatformCachePartitionType
     */
    public function setPlatformCachePartition(\NexusDigital/MiratelForce\StructType\PlatformCachePartition $platformCachePartition = null)
    {
        if (is_null($platformCachePartition) || (is_array($platformCachePartition) && empty($platformCachePartition))) {
            unset($this->PlatformCachePartition);
        } else {
            $this->PlatformCachePartition = $platformCachePartition;
        }
        return $this;
    }
    /**
     * Get PlatformCachePartitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlatformCachePartitionId()
    {
        return isset($this->PlatformCachePartitionId) ? $this->PlatformCachePartitionId : null;
    }
    /**
     * Set PlatformCachePartitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $platformCachePartitionId
     * @return \NexusDigital/MiratelForce\StructType\PlatformCachePartitionType
     */
    public function setPlatformCachePartitionId($platformCachePartitionId = null)
    {
        // validation for constraint: string
        if (!is_null($platformCachePartitionId) && !is_string($platformCachePartitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($platformCachePartitionId, true), gettype($platformCachePartitionId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($platformCachePartitionId) && mb_strlen($platformCachePartitionId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($platformCachePartitionId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($platformCachePartitionId) && !preg_match('/[a-zA-Z0-9]{18}/', $platformCachePartitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($platformCachePartitionId, true)), __LINE__);
        }
        if (is_null($platformCachePartitionId) || (is_array($platformCachePartitionId) && empty($platformCachePartitionId))) {
            unset($this->PlatformCachePartitionId);
        } else {
            $this->PlatformCachePartitionId = $platformCachePartitionId;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\PlatformCachePartitionType
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\PlatformCachePartitionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
