<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OutgoingEmailRelation StructType
 * @subpackage Structs
 */
class OutgoingEmailRelation extends SObject
{
    /**
     * The ExternalId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalId;
    /**
     * The OutgoingEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public $OutgoingEmail;
    /**
     * The OutgoingEmailId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OutgoingEmailId;
    /**
     * The Relation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $Relation;
    /**
     * The RelationAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelationAddress;
    /**
     * The RelationId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $RelationId;
    /**
     * Constructor method for OutgoingEmailRelation
     * @uses OutgoingEmailRelation::setExternalId()
     * @uses OutgoingEmailRelation::setOutgoingEmail()
     * @uses OutgoingEmailRelation::setOutgoingEmailId()
     * @uses OutgoingEmailRelation::setRelation()
     * @uses OutgoingEmailRelation::setRelationAddress()
     * @uses OutgoingEmailRelation::setRelationId()
     * @param string $externalId
     * @param \NexusDigital/MiratelForce\StructType\OutgoingEmail $outgoingEmail
     * @param string $outgoingEmailId
     * @param \NexusDigital/MiratelForce\StructType\SObject $relation
     * @param string $relationAddress
     * @param string $relationId
     */
    public function __construct($externalId = null, \NexusDigital/MiratelForce\StructType\OutgoingEmail $outgoingEmail = null, $outgoingEmailId = null, \NexusDigital/MiratelForce\StructType\SObject $relation = null, $relationAddress = null, $relationId = null)
    {
        $this
            ->setExternalId($externalId)
            ->setOutgoingEmail($outgoingEmail)
            ->setOutgoingEmailId($outgoingEmailId)
            ->setRelation($relation)
            ->setRelationAddress($relationAddress)
            ->setRelationId($relationId);
    }
    /**
     * Get ExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalId()
    {
        return isset($this->ExternalId) ? $this->ExternalId : null;
    }
    /**
     * Set ExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalId
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmailRelation
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        if (is_null($externalId) || (is_array($externalId) && empty($externalId))) {
            unset($this->ExternalId);
        } else {
            $this->ExternalId = $externalId;
        }
        return $this;
    }
    /**
     * Get OutgoingEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail|null
     */
    public function getOutgoingEmail()
    {
        return isset($this->OutgoingEmail) ? $this->OutgoingEmail : null;
    }
    /**
     * Set OutgoingEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\OutgoingEmail $outgoingEmail
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmailRelation
     */
    public function setOutgoingEmail(\NexusDigital/MiratelForce\StructType\OutgoingEmail $outgoingEmail = null)
    {
        if (is_null($outgoingEmail) || (is_array($outgoingEmail) && empty($outgoingEmail))) {
            unset($this->OutgoingEmail);
        } else {
            $this->OutgoingEmail = $outgoingEmail;
        }
        return $this;
    }
    /**
     * Get OutgoingEmailId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOutgoingEmailId()
    {
        return isset($this->OutgoingEmailId) ? $this->OutgoingEmailId : null;
    }
    /**
     * Set OutgoingEmailId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $outgoingEmailId
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmailRelation
     */
    public function setOutgoingEmailId($outgoingEmailId = null)
    {
        // validation for constraint: string
        if (!is_null($outgoingEmailId) && !is_string($outgoingEmailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outgoingEmailId, true), gettype($outgoingEmailId)), __LINE__);
        }
        if (is_null($outgoingEmailId) || (is_array($outgoingEmailId) && empty($outgoingEmailId))) {
            unset($this->OutgoingEmailId);
        } else {
            $this->OutgoingEmailId = $outgoingEmailId;
        }
        return $this;
    }
    /**
     * Get Relation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getRelation()
    {
        return isset($this->Relation) ? $this->Relation : null;
    }
    /**
     * Set Relation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $relation
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmailRelation
     */
    public function setRelation(\NexusDigital/MiratelForce\StructType\SObject $relation = null)
    {
        if (is_null($relation) || (is_array($relation) && empty($relation))) {
            unset($this->Relation);
        } else {
            $this->Relation = $relation;
        }
        return $this;
    }
    /**
     * Get RelationAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationAddress()
    {
        return isset($this->RelationAddress) ? $this->RelationAddress : null;
    }
    /**
     * Set RelationAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationAddress
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmailRelation
     */
    public function setRelationAddress($relationAddress = null)
    {
        // validation for constraint: string
        if (!is_null($relationAddress) && !is_string($relationAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationAddress, true), gettype($relationAddress)), __LINE__);
        }
        if (is_null($relationAddress) || (is_array($relationAddress) && empty($relationAddress))) {
            unset($this->RelationAddress);
        } else {
            $this->RelationAddress = $relationAddress;
        }
        return $this;
    }
    /**
     * Get RelationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationId()
    {
        return isset($this->RelationId) ? $this->RelationId : null;
    }
    /**
     * Set RelationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationId
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmailRelation
     */
    public function setRelationId($relationId = null)
    {
        // validation for constraint: string
        if (!is_null($relationId) && !is_string($relationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationId, true), gettype($relationId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($relationId) && mb_strlen($relationId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($relationId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($relationId) && !preg_match('/[a-zA-Z0-9]{18}/', $relationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($relationId, true)), __LINE__);
        }
        if (is_null($relationId) || (is_array($relationId) && empty($relationId))) {
            unset($this->RelationId);
        } else {
            $this->RelationId = $relationId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmailRelation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
