<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OutgoingEmail StructType
 * @subpackage Structs
 */
class OutgoingEmail extends SObject
{
    /**
     * The BccAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BccAddress;
    /**
     * The BccIds
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string[]
     */
    public $BccIds;
    /**
     * The CcAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CcAddress;
    /**
     * The CcIds
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string[]
     */
    public $CcIds;
    /**
     * The ContentDocumentIds
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string[]
     */
    public $ContentDocumentIds;
    /**
     * The ContentDocumentLinks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ContentDocumentLinks;
    /**
     * The EmailTemplate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $EmailTemplate;
    /**
     * The EmailTemplateId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $EmailTemplateId;
    /**
     * The ExternalId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalId;
    /**
     * The HtmlBody
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HtmlBody;
    /**
     * The OutgoingEmailRelations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $OutgoingEmailRelations;
    /**
     * The RelatedTo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $RelatedTo;
    /**
     * The RelatedToId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $RelatedToId;
    /**
     * The Subject
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Subject;
    /**
     * The TextBody
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TextBody;
    /**
     * The ToAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToAddress;
    /**
     * The ToIds
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string[]
     */
    public $ToIds;
    /**
     * The ValidatedFromAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidatedFromAddress;
    /**
     * The Who
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $Who;
    /**
     * The WhoId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $WhoId;
    /**
     * Constructor method for OutgoingEmail
     * @uses OutgoingEmail::setBccAddress()
     * @uses OutgoingEmail::setBccIds()
     * @uses OutgoingEmail::setCcAddress()
     * @uses OutgoingEmail::setCcIds()
     * @uses OutgoingEmail::setContentDocumentIds()
     * @uses OutgoingEmail::setContentDocumentLinks()
     * @uses OutgoingEmail::setEmailTemplate()
     * @uses OutgoingEmail::setEmailTemplateId()
     * @uses OutgoingEmail::setExternalId()
     * @uses OutgoingEmail::setHtmlBody()
     * @uses OutgoingEmail::setOutgoingEmailRelations()
     * @uses OutgoingEmail::setRelatedTo()
     * @uses OutgoingEmail::setRelatedToId()
     * @uses OutgoingEmail::setSubject()
     * @uses OutgoingEmail::setTextBody()
     * @uses OutgoingEmail::setToAddress()
     * @uses OutgoingEmail::setToIds()
     * @uses OutgoingEmail::setValidatedFromAddress()
     * @uses OutgoingEmail::setWho()
     * @uses OutgoingEmail::setWhoId()
     * @param string $bccAddress
     * @param string[] $bccIds
     * @param string $ccAddress
     * @param string[] $ccIds
     * @param string[] $contentDocumentIds
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @param \NexusDigital/MiratelForce\StructType\SObject $emailTemplate
     * @param string $emailTemplateId
     * @param string $externalId
     * @param string $htmlBody
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $outgoingEmailRelations
     * @param \NexusDigital/MiratelForce\StructType\SObject $relatedTo
     * @param string $relatedToId
     * @param string $subject
     * @param string $textBody
     * @param string $toAddress
     * @param string[] $toIds
     * @param string $validatedFromAddress
     * @param \NexusDigital/MiratelForce\StructType\SObject $who
     * @param string $whoId
     */
    public function __construct($bccAddress = null, array $bccIds = array(), $ccAddress = null, array $ccIds = array(), array $contentDocumentIds = array(), \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null, \NexusDigital/MiratelForce\StructType\SObject $emailTemplate = null, $emailTemplateId = null, $externalId = null, $htmlBody = null, \NexusDigital/MiratelForce\StructType\QueryResult $outgoingEmailRelations = null, \NexusDigital/MiratelForce\StructType\SObject $relatedTo = null, $relatedToId = null, $subject = null, $textBody = null, $toAddress = null, array $toIds = array(), $validatedFromAddress = null, \NexusDigital/MiratelForce\StructType\SObject $who = null, $whoId = null)
    {
        $this
            ->setBccAddress($bccAddress)
            ->setBccIds($bccIds)
            ->setCcAddress($ccAddress)
            ->setCcIds($ccIds)
            ->setContentDocumentIds($contentDocumentIds)
            ->setContentDocumentLinks($contentDocumentLinks)
            ->setEmailTemplate($emailTemplate)
            ->setEmailTemplateId($emailTemplateId)
            ->setExternalId($externalId)
            ->setHtmlBody($htmlBody)
            ->setOutgoingEmailRelations($outgoingEmailRelations)
            ->setRelatedTo($relatedTo)
            ->setRelatedToId($relatedToId)
            ->setSubject($subject)
            ->setTextBody($textBody)
            ->setToAddress($toAddress)
            ->setToIds($toIds)
            ->setValidatedFromAddress($validatedFromAddress)
            ->setWho($who)
            ->setWhoId($whoId);
    }
    /**
     * Get BccAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBccAddress()
    {
        return isset($this->BccAddress) ? $this->BccAddress : null;
    }
    /**
     * Set BccAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bccAddress
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public function setBccAddress($bccAddress = null)
    {
        // validation for constraint: string
        if (!is_null($bccAddress) && !is_string($bccAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bccAddress, true), gettype($bccAddress)), __LINE__);
        }
        if (is_null($bccAddress) || (is_array($bccAddress) && empty($bccAddress))) {
            unset($this->BccAddress);
        } else {
            $this->BccAddress = $bccAddress;
        }
        return $this;
    }
    /**
     * Get BccIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getBccIds()
    {
        return isset($this->BccIds) ? $this->BccIds : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBccIds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBccIds method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBccIdsForArrayConstraintsFromSetBccIds(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $outgoingEmailBccIdsItem) {
            // validation for constraint: itemType
            if (!is_string($outgoingEmailBccIdsItem)) {
                $invalidValues[] = is_object($outgoingEmailBccIdsItem) ? get_class($outgoingEmailBccIdsItem) : sprintf('%s(%s)', gettype($outgoingEmailBccIdsItem), var_export($outgoingEmailBccIdsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BccIds property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setBccIds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBccIds method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBccIdsForLengthConstraintFromSetBccIds($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $outgoingEmailBccIdsItem) {
            // validation for constraint: length(18)
            if (mb_strlen($outgoingEmailBccIdsItem) !== 18) {
                $invalidValues[] = var_export($outgoingEmailBccIdsItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be equal to 18', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BccIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $bccIds
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public function setBccIds(array $bccIds = array())
    {
        // validation for constraint: array
        if ('' !== ($bccIdsArrayErrorMessage = self::validateBccIdsForArrayConstraintsFromSetBccIds($bccIds))) {
            throw new \InvalidArgumentException($bccIdsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: length(18)
        if ('' !== ($bccIdsLengthErrorMessage = self::validateBccIdsForLengthConstraintFromSetBccIds($bccIds))) {
            throw new \InvalidArgumentException($bccIdsLengthErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($bccIds) && !preg_match('/[a-zA-Z0-9]{18}/', $bccIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($bccIds, true)), __LINE__);
        }
        if (is_null($bccIds) || (is_array($bccIds) && empty($bccIds))) {
            unset($this->BccIds);
        } else {
            $this->BccIds = $bccIds;
        }
        return $this;
    }
    /**
     * Add item to BccIds value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public function addToBccIds($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The BccIds property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: length(18)
        if (mb_strlen($item) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!preg_match('/[a-zA-Z0-9]{18}/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($item, true)), __LINE__);
        }
        $this->BccIds[] = $item;
        return $this;
    }
    /**
     * Get CcAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCcAddress()
    {
        return isset($this->CcAddress) ? $this->CcAddress : null;
    }
    /**
     * Set CcAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ccAddress
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public function setCcAddress($ccAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ccAddress) && !is_string($ccAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccAddress, true), gettype($ccAddress)), __LINE__);
        }
        if (is_null($ccAddress) || (is_array($ccAddress) && empty($ccAddress))) {
            unset($this->CcAddress);
        } else {
            $this->CcAddress = $ccAddress;
        }
        return $this;
    }
    /**
     * Get CcIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getCcIds()
    {
        return isset($this->CcIds) ? $this->CcIds : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCcIds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCcIds method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCcIdsForArrayConstraintsFromSetCcIds(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $outgoingEmailCcIdsItem) {
            // validation for constraint: itemType
            if (!is_string($outgoingEmailCcIdsItem)) {
                $invalidValues[] = is_object($outgoingEmailCcIdsItem) ? get_class($outgoingEmailCcIdsItem) : sprintf('%s(%s)', gettype($outgoingEmailCcIdsItem), var_export($outgoingEmailCcIdsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CcIds property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setCcIds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCcIds method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCcIdsForLengthConstraintFromSetCcIds($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $outgoingEmailCcIdsItem) {
            // validation for constraint: length(18)
            if (mb_strlen($outgoingEmailCcIdsItem) !== 18) {
                $invalidValues[] = var_export($outgoingEmailCcIdsItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be equal to 18', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CcIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $ccIds
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public function setCcIds(array $ccIds = array())
    {
        // validation for constraint: array
        if ('' !== ($ccIdsArrayErrorMessage = self::validateCcIdsForArrayConstraintsFromSetCcIds($ccIds))) {
            throw new \InvalidArgumentException($ccIdsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: length(18)
        if ('' !== ($ccIdsLengthErrorMessage = self::validateCcIdsForLengthConstraintFromSetCcIds($ccIds))) {
            throw new \InvalidArgumentException($ccIdsLengthErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($ccIds) && !preg_match('/[a-zA-Z0-9]{18}/', $ccIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($ccIds, true)), __LINE__);
        }
        if (is_null($ccIds) || (is_array($ccIds) && empty($ccIds))) {
            unset($this->CcIds);
        } else {
            $this->CcIds = $ccIds;
        }
        return $this;
    }
    /**
     * Add item to CcIds value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public function addToCcIds($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The CcIds property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: length(18)
        if (mb_strlen($item) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!preg_match('/[a-zA-Z0-9]{18}/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($item, true)), __LINE__);
        }
        $this->CcIds[] = $item;
        return $this;
    }
    /**
     * Get ContentDocumentIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getContentDocumentIds()
    {
        return isset($this->ContentDocumentIds) ? $this->ContentDocumentIds : null;
    }
    /**
     * This method is responsible for validating the values passed to the setContentDocumentIds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContentDocumentIds method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContentDocumentIdsForArrayConstraintsFromSetContentDocumentIds(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $outgoingEmailContentDocumentIdsItem) {
            // validation for constraint: itemType
            if (!is_string($outgoingEmailContentDocumentIdsItem)) {
                $invalidValues[] = is_object($outgoingEmailContentDocumentIdsItem) ? get_class($outgoingEmailContentDocumentIdsItem) : sprintf('%s(%s)', gettype($outgoingEmailContentDocumentIdsItem), var_export($outgoingEmailContentDocumentIdsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContentDocumentIds property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setContentDocumentIds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContentDocumentIds method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContentDocumentIdsForLengthConstraintFromSetContentDocumentIds($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $outgoingEmailContentDocumentIdsItem) {
            // validation for constraint: length(18)
            if (mb_strlen($outgoingEmailContentDocumentIdsItem) !== 18) {
                $invalidValues[] = var_export($outgoingEmailContentDocumentIdsItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be equal to 18', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContentDocumentIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $contentDocumentIds
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public function setContentDocumentIds(array $contentDocumentIds = array())
    {
        // validation for constraint: array
        if ('' !== ($contentDocumentIdsArrayErrorMessage = self::validateContentDocumentIdsForArrayConstraintsFromSetContentDocumentIds($contentDocumentIds))) {
            throw new \InvalidArgumentException($contentDocumentIdsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: length(18)
        if ('' !== ($contentDocumentIdsLengthErrorMessage = self::validateContentDocumentIdsForLengthConstraintFromSetContentDocumentIds($contentDocumentIds))) {
            throw new \InvalidArgumentException($contentDocumentIdsLengthErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($contentDocumentIds) && !preg_match('/[a-zA-Z0-9]{18}/', $contentDocumentIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($contentDocumentIds, true)), __LINE__);
        }
        if (is_null($contentDocumentIds) || (is_array($contentDocumentIds) && empty($contentDocumentIds))) {
            unset($this->ContentDocumentIds);
        } else {
            $this->ContentDocumentIds = $contentDocumentIds;
        }
        return $this;
    }
    /**
     * Add item to ContentDocumentIds value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public function addToContentDocumentIds($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ContentDocumentIds property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: length(18)
        if (mb_strlen($item) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!preg_match('/[a-zA-Z0-9]{18}/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($item, true)), __LINE__);
        }
        $this->ContentDocumentIds[] = $item;
        return $this;
    }
    /**
     * Get ContentDocumentLinks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getContentDocumentLinks()
    {
        return isset($this->ContentDocumentLinks) ? $this->ContentDocumentLinks : null;
    }
    /**
     * Set ContentDocumentLinks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public function setContentDocumentLinks(\NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null)
    {
        if (is_null($contentDocumentLinks) || (is_array($contentDocumentLinks) && empty($contentDocumentLinks))) {
            unset($this->ContentDocumentLinks);
        } else {
            $this->ContentDocumentLinks = $contentDocumentLinks;
        }
        return $this;
    }
    /**
     * Get EmailTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getEmailTemplate()
    {
        return isset($this->EmailTemplate) ? $this->EmailTemplate : null;
    }
    /**
     * Set EmailTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $emailTemplate
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public function setEmailTemplate(\NexusDigital/MiratelForce\StructType\SObject $emailTemplate = null)
    {
        if (is_null($emailTemplate) || (is_array($emailTemplate) && empty($emailTemplate))) {
            unset($this->EmailTemplate);
        } else {
            $this->EmailTemplate = $emailTemplate;
        }
        return $this;
    }
    /**
     * Get EmailTemplateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailTemplateId()
    {
        return isset($this->EmailTemplateId) ? $this->EmailTemplateId : null;
    }
    /**
     * Set EmailTemplateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailTemplateId
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public function setEmailTemplateId($emailTemplateId = null)
    {
        // validation for constraint: string
        if (!is_null($emailTemplateId) && !is_string($emailTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailTemplateId, true), gettype($emailTemplateId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($emailTemplateId) && mb_strlen($emailTemplateId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($emailTemplateId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($emailTemplateId) && !preg_match('/[a-zA-Z0-9]{18}/', $emailTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($emailTemplateId, true)), __LINE__);
        }
        if (is_null($emailTemplateId) || (is_array($emailTemplateId) && empty($emailTemplateId))) {
            unset($this->EmailTemplateId);
        } else {
            $this->EmailTemplateId = $emailTemplateId;
        }
        return $this;
    }
    /**
     * Get ExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalId()
    {
        return isset($this->ExternalId) ? $this->ExternalId : null;
    }
    /**
     * Set ExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalId
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        if (is_null($externalId) || (is_array($externalId) && empty($externalId))) {
            unset($this->ExternalId);
        } else {
            $this->ExternalId = $externalId;
        }
        return $this;
    }
    /**
     * Get HtmlBody value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHtmlBody()
    {
        return isset($this->HtmlBody) ? $this->HtmlBody : null;
    }
    /**
     * Set HtmlBody value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $htmlBody
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public function setHtmlBody($htmlBody = null)
    {
        // validation for constraint: string
        if (!is_null($htmlBody) && !is_string($htmlBody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($htmlBody, true), gettype($htmlBody)), __LINE__);
        }
        if (is_null($htmlBody) || (is_array($htmlBody) && empty($htmlBody))) {
            unset($this->HtmlBody);
        } else {
            $this->HtmlBody = $htmlBody;
        }
        return $this;
    }
    /**
     * Get OutgoingEmailRelations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getOutgoingEmailRelations()
    {
        return isset($this->OutgoingEmailRelations) ? $this->OutgoingEmailRelations : null;
    }
    /**
     * Set OutgoingEmailRelations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $outgoingEmailRelations
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public function setOutgoingEmailRelations(\NexusDigital/MiratelForce\StructType\QueryResult $outgoingEmailRelations = null)
    {
        if (is_null($outgoingEmailRelations) || (is_array($outgoingEmailRelations) && empty($outgoingEmailRelations))) {
            unset($this->OutgoingEmailRelations);
        } else {
            $this->OutgoingEmailRelations = $outgoingEmailRelations;
        }
        return $this;
    }
    /**
     * Get RelatedTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getRelatedTo()
    {
        return isset($this->RelatedTo) ? $this->RelatedTo : null;
    }
    /**
     * Set RelatedTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $relatedTo
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public function setRelatedTo(\NexusDigital/MiratelForce\StructType\SObject $relatedTo = null)
    {
        if (is_null($relatedTo) || (is_array($relatedTo) && empty($relatedTo))) {
            unset($this->RelatedTo);
        } else {
            $this->RelatedTo = $relatedTo;
        }
        return $this;
    }
    /**
     * Get RelatedToId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedToId()
    {
        return isset($this->RelatedToId) ? $this->RelatedToId : null;
    }
    /**
     * Set RelatedToId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedToId
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public function setRelatedToId($relatedToId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedToId) && !is_string($relatedToId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedToId, true), gettype($relatedToId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($relatedToId) && mb_strlen($relatedToId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($relatedToId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($relatedToId) && !preg_match('/[a-zA-Z0-9]{18}/', $relatedToId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($relatedToId, true)), __LINE__);
        }
        if (is_null($relatedToId) || (is_array($relatedToId) && empty($relatedToId))) {
            unset($this->RelatedToId);
        } else {
            $this->RelatedToId = $relatedToId;
        }
        return $this;
    }
    /**
     * Get Subject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubject()
    {
        return isset($this->Subject) ? $this->Subject : null;
    }
    /**
     * Set Subject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subject
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subject, true), gettype($subject)), __LINE__);
        }
        if (is_null($subject) || (is_array($subject) && empty($subject))) {
            unset($this->Subject);
        } else {
            $this->Subject = $subject;
        }
        return $this;
    }
    /**
     * Get TextBody value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTextBody()
    {
        return isset($this->TextBody) ? $this->TextBody : null;
    }
    /**
     * Set TextBody value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $textBody
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public function setTextBody($textBody = null)
    {
        // validation for constraint: string
        if (!is_null($textBody) && !is_string($textBody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($textBody, true), gettype($textBody)), __LINE__);
        }
        if (is_null($textBody) || (is_array($textBody) && empty($textBody))) {
            unset($this->TextBody);
        } else {
            $this->TextBody = $textBody;
        }
        return $this;
    }
    /**
     * Get ToAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToAddress()
    {
        return isset($this->ToAddress) ? $this->ToAddress : null;
    }
    /**
     * Set ToAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toAddress
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public function setToAddress($toAddress = null)
    {
        // validation for constraint: string
        if (!is_null($toAddress) && !is_string($toAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toAddress, true), gettype($toAddress)), __LINE__);
        }
        if (is_null($toAddress) || (is_array($toAddress) && empty($toAddress))) {
            unset($this->ToAddress);
        } else {
            $this->ToAddress = $toAddress;
        }
        return $this;
    }
    /**
     * Get ToIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getToIds()
    {
        return isset($this->ToIds) ? $this->ToIds : null;
    }
    /**
     * This method is responsible for validating the values passed to the setToIds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setToIds method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateToIdsForArrayConstraintsFromSetToIds(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $outgoingEmailToIdsItem) {
            // validation for constraint: itemType
            if (!is_string($outgoingEmailToIdsItem)) {
                $invalidValues[] = is_object($outgoingEmailToIdsItem) ? get_class($outgoingEmailToIdsItem) : sprintf('%s(%s)', gettype($outgoingEmailToIdsItem), var_export($outgoingEmailToIdsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ToIds property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setToIds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setToIds method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateToIdsForLengthConstraintFromSetToIds($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $outgoingEmailToIdsItem) {
            // validation for constraint: length(18)
            if (mb_strlen($outgoingEmailToIdsItem) !== 18) {
                $invalidValues[] = var_export($outgoingEmailToIdsItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be equal to 18', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ToIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $toIds
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public function setToIds(array $toIds = array())
    {
        // validation for constraint: array
        if ('' !== ($toIdsArrayErrorMessage = self::validateToIdsForArrayConstraintsFromSetToIds($toIds))) {
            throw new \InvalidArgumentException($toIdsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: length(18)
        if ('' !== ($toIdsLengthErrorMessage = self::validateToIdsForLengthConstraintFromSetToIds($toIds))) {
            throw new \InvalidArgumentException($toIdsLengthErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($toIds) && !preg_match('/[a-zA-Z0-9]{18}/', $toIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($toIds, true)), __LINE__);
        }
        if (is_null($toIds) || (is_array($toIds) && empty($toIds))) {
            unset($this->ToIds);
        } else {
            $this->ToIds = $toIds;
        }
        return $this;
    }
    /**
     * Add item to ToIds value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public function addToToIds($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ToIds property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: length(18)
        if (mb_strlen($item) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!preg_match('/[a-zA-Z0-9]{18}/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($item, true)), __LINE__);
        }
        $this->ToIds[] = $item;
        return $this;
    }
    /**
     * Get ValidatedFromAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidatedFromAddress()
    {
        return isset($this->ValidatedFromAddress) ? $this->ValidatedFromAddress : null;
    }
    /**
     * Set ValidatedFromAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validatedFromAddress
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public function setValidatedFromAddress($validatedFromAddress = null)
    {
        // validation for constraint: string
        if (!is_null($validatedFromAddress) && !is_string($validatedFromAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validatedFromAddress, true), gettype($validatedFromAddress)), __LINE__);
        }
        if (is_null($validatedFromAddress) || (is_array($validatedFromAddress) && empty($validatedFromAddress))) {
            unset($this->ValidatedFromAddress);
        } else {
            $this->ValidatedFromAddress = $validatedFromAddress;
        }
        return $this;
    }
    /**
     * Get Who value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getWho()
    {
        return isset($this->Who) ? $this->Who : null;
    }
    /**
     * Set Who value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $who
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public function setWho(\NexusDigital/MiratelForce\StructType\SObject $who = null)
    {
        if (is_null($who) || (is_array($who) && empty($who))) {
            unset($this->Who);
        } else {
            $this->Who = $who;
        }
        return $this;
    }
    /**
     * Get WhoId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWhoId()
    {
        return isset($this->WhoId) ? $this->WhoId : null;
    }
    /**
     * Set WhoId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $whoId
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public function setWhoId($whoId = null)
    {
        // validation for constraint: string
        if (!is_null($whoId) && !is_string($whoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($whoId, true), gettype($whoId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($whoId) && mb_strlen($whoId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($whoId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($whoId) && !preg_match('/[a-zA-Z0-9]{18}/', $whoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($whoId, true)), __LINE__);
        }
        if (is_null($whoId) || (is_array($whoId) && empty($whoId))) {
            unset($this->WhoId);
        } else {
            $this->WhoId = $whoId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\OutgoingEmail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
