<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NamedCredential StructType
 * @subpackage Structs
 */
class NamedCredential extends SObject
{
    /**
     * The AuthProvider
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public $AuthProvider;
    /**
     * The AuthProviderId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $AuthProviderId;
    /**
     * The AuthTokenEndpointUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthTokenEndpointUrl;
    /**
     * The CalloutOptionsAllowMergeFieldsInBody
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CalloutOptionsAllowMergeFieldsInBody;
    /**
     * The CalloutOptionsAllowMergeFieldsInHeader
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CalloutOptionsAllowMergeFieldsInHeader;
    /**
     * The CalloutOptionsGenerateAuthorizationHeader
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CalloutOptionsGenerateAuthorizationHeader;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The CustomHttpHeaders
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $CustomHttpHeaders;
    /**
     * The DeveloperName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeveloperName;
    /**
     * The Endpoint
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Endpoint;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The JwtAudience
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JwtAudience;
    /**
     * The JwtFormulaSubject
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JwtFormulaSubject;
    /**
     * The JwtIssuer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JwtIssuer;
    /**
     * The JwtTextSubject
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JwtTextSubject;
    /**
     * The JwtValidityPeriodSeconds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $JwtValidityPeriodSeconds;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Language;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The MasterLabel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MasterLabel;
    /**
     * The NamespacePrefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NamespacePrefix;
    /**
     * The PrincipalType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrincipalType;
    /**
     * The SetupEntityAccessItems
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $SetupEntityAccessItems;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The UserAuths
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $UserAuths;
    /**
     * Constructor method for NamedCredential
     * @uses NamedCredential::setAuthProvider()
     * @uses NamedCredential::setAuthProviderId()
     * @uses NamedCredential::setAuthTokenEndpointUrl()
     * @uses NamedCredential::setCalloutOptionsAllowMergeFieldsInBody()
     * @uses NamedCredential::setCalloutOptionsAllowMergeFieldsInHeader()
     * @uses NamedCredential::setCalloutOptionsGenerateAuthorizationHeader()
     * @uses NamedCredential::setCreatedBy()
     * @uses NamedCredential::setCreatedById()
     * @uses NamedCredential::setCreatedDate()
     * @uses NamedCredential::setCustomHttpHeaders()
     * @uses NamedCredential::setDeveloperName()
     * @uses NamedCredential::setEndpoint()
     * @uses NamedCredential::setIsDeleted()
     * @uses NamedCredential::setJwtAudience()
     * @uses NamedCredential::setJwtFormulaSubject()
     * @uses NamedCredential::setJwtIssuer()
     * @uses NamedCredential::setJwtTextSubject()
     * @uses NamedCredential::setJwtValidityPeriodSeconds()
     * @uses NamedCredential::setLanguage()
     * @uses NamedCredential::setLastModifiedBy()
     * @uses NamedCredential::setLastModifiedById()
     * @uses NamedCredential::setLastModifiedDate()
     * @uses NamedCredential::setMasterLabel()
     * @uses NamedCredential::setNamespacePrefix()
     * @uses NamedCredential::setPrincipalType()
     * @uses NamedCredential::setSetupEntityAccessItems()
     * @uses NamedCredential::setSystemModstamp()
     * @uses NamedCredential::setUserAuths()
     * @param \NexusDigital/MiratelForce\StructType\AuthProvider $authProvider
     * @param string $authProviderId
     * @param string $authTokenEndpointUrl
     * @param bool $calloutOptionsAllowMergeFieldsInBody
     * @param bool $calloutOptionsAllowMergeFieldsInHeader
     * @param bool $calloutOptionsGenerateAuthorizationHeader
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $customHttpHeaders
     * @param string $developerName
     * @param string $endpoint
     * @param bool $isDeleted
     * @param string $jwtAudience
     * @param string $jwtFormulaSubject
     * @param string $jwtIssuer
     * @param string $jwtTextSubject
     * @param int $jwtValidityPeriodSeconds
     * @param string $language
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $masterLabel
     * @param string $namespacePrefix
     * @param string $principalType
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $setupEntityAccessItems
     * @param string $systemModstamp
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $userAuths
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\AuthProvider $authProvider = null, $authProviderId = null, $authTokenEndpointUrl = null, $calloutOptionsAllowMergeFieldsInBody = null, $calloutOptionsAllowMergeFieldsInHeader = null, $calloutOptionsGenerateAuthorizationHeader = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, \NexusDigital/MiratelForce\StructType\QueryResult $customHttpHeaders = null, $developerName = null, $endpoint = null, $isDeleted = null, $jwtAudience = null, $jwtFormulaSubject = null, $jwtIssuer = null, $jwtTextSubject = null, $jwtValidityPeriodSeconds = null, $language = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $masterLabel = null, $namespacePrefix = null, $principalType = null, \NexusDigital/MiratelForce\StructType\QueryResult $setupEntityAccessItems = null, $systemModstamp = null, \NexusDigital/MiratelForce\StructType\QueryResult $userAuths = null)
    {
        $this
            ->setAuthProvider($authProvider)
            ->setAuthProviderId($authProviderId)
            ->setAuthTokenEndpointUrl($authTokenEndpointUrl)
            ->setCalloutOptionsAllowMergeFieldsInBody($calloutOptionsAllowMergeFieldsInBody)
            ->setCalloutOptionsAllowMergeFieldsInHeader($calloutOptionsAllowMergeFieldsInHeader)
            ->setCalloutOptionsGenerateAuthorizationHeader($calloutOptionsGenerateAuthorizationHeader)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setCustomHttpHeaders($customHttpHeaders)
            ->setDeveloperName($developerName)
            ->setEndpoint($endpoint)
            ->setIsDeleted($isDeleted)
            ->setJwtAudience($jwtAudience)
            ->setJwtFormulaSubject($jwtFormulaSubject)
            ->setJwtIssuer($jwtIssuer)
            ->setJwtTextSubject($jwtTextSubject)
            ->setJwtValidityPeriodSeconds($jwtValidityPeriodSeconds)
            ->setLanguage($language)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setMasterLabel($masterLabel)
            ->setNamespacePrefix($namespacePrefix)
            ->setPrincipalType($principalType)
            ->setSetupEntityAccessItems($setupEntityAccessItems)
            ->setSystemModstamp($systemModstamp)
            ->setUserAuths($userAuths);
    }
    /**
     * Get AuthProvider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider|null
     */
    public function getAuthProvider()
    {
        return isset($this->AuthProvider) ? $this->AuthProvider : null;
    }
    /**
     * Set AuthProvider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\AuthProvider $authProvider
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setAuthProvider(\NexusDigital/MiratelForce\StructType\AuthProvider $authProvider = null)
    {
        if (is_null($authProvider) || (is_array($authProvider) && empty($authProvider))) {
            unset($this->AuthProvider);
        } else {
            $this->AuthProvider = $authProvider;
        }
        return $this;
    }
    /**
     * Get AuthProviderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthProviderId()
    {
        return isset($this->AuthProviderId) ? $this->AuthProviderId : null;
    }
    /**
     * Set AuthProviderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authProviderId
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setAuthProviderId($authProviderId = null)
    {
        // validation for constraint: string
        if (!is_null($authProviderId) && !is_string($authProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authProviderId, true), gettype($authProviderId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($authProviderId) && mb_strlen($authProviderId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($authProviderId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($authProviderId) && !preg_match('/[a-zA-Z0-9]{18}/', $authProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($authProviderId, true)), __LINE__);
        }
        if (is_null($authProviderId) || (is_array($authProviderId) && empty($authProviderId))) {
            unset($this->AuthProviderId);
        } else {
            $this->AuthProviderId = $authProviderId;
        }
        return $this;
    }
    /**
     * Get AuthTokenEndpointUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthTokenEndpointUrl()
    {
        return isset($this->AuthTokenEndpointUrl) ? $this->AuthTokenEndpointUrl : null;
    }
    /**
     * Set AuthTokenEndpointUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authTokenEndpointUrl
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setAuthTokenEndpointUrl($authTokenEndpointUrl = null)
    {
        // validation for constraint: string
        if (!is_null($authTokenEndpointUrl) && !is_string($authTokenEndpointUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authTokenEndpointUrl, true), gettype($authTokenEndpointUrl)), __LINE__);
        }
        if (is_null($authTokenEndpointUrl) || (is_array($authTokenEndpointUrl) && empty($authTokenEndpointUrl))) {
            unset($this->AuthTokenEndpointUrl);
        } else {
            $this->AuthTokenEndpointUrl = $authTokenEndpointUrl;
        }
        return $this;
    }
    /**
     * Get CalloutOptionsAllowMergeFieldsInBody value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCalloutOptionsAllowMergeFieldsInBody()
    {
        return isset($this->CalloutOptionsAllowMergeFieldsInBody) ? $this->CalloutOptionsAllowMergeFieldsInBody : null;
    }
    /**
     * Set CalloutOptionsAllowMergeFieldsInBody value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $calloutOptionsAllowMergeFieldsInBody
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setCalloutOptionsAllowMergeFieldsInBody($calloutOptionsAllowMergeFieldsInBody = null)
    {
        // validation for constraint: boolean
        if (!is_null($calloutOptionsAllowMergeFieldsInBody) && !is_bool($calloutOptionsAllowMergeFieldsInBody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($calloutOptionsAllowMergeFieldsInBody, true), gettype($calloutOptionsAllowMergeFieldsInBody)), __LINE__);
        }
        if (is_null($calloutOptionsAllowMergeFieldsInBody) || (is_array($calloutOptionsAllowMergeFieldsInBody) && empty($calloutOptionsAllowMergeFieldsInBody))) {
            unset($this->CalloutOptionsAllowMergeFieldsInBody);
        } else {
            $this->CalloutOptionsAllowMergeFieldsInBody = $calloutOptionsAllowMergeFieldsInBody;
        }
        return $this;
    }
    /**
     * Get CalloutOptionsAllowMergeFieldsInHeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCalloutOptionsAllowMergeFieldsInHeader()
    {
        return isset($this->CalloutOptionsAllowMergeFieldsInHeader) ? $this->CalloutOptionsAllowMergeFieldsInHeader : null;
    }
    /**
     * Set CalloutOptionsAllowMergeFieldsInHeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $calloutOptionsAllowMergeFieldsInHeader
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setCalloutOptionsAllowMergeFieldsInHeader($calloutOptionsAllowMergeFieldsInHeader = null)
    {
        // validation for constraint: boolean
        if (!is_null($calloutOptionsAllowMergeFieldsInHeader) && !is_bool($calloutOptionsAllowMergeFieldsInHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($calloutOptionsAllowMergeFieldsInHeader, true), gettype($calloutOptionsAllowMergeFieldsInHeader)), __LINE__);
        }
        if (is_null($calloutOptionsAllowMergeFieldsInHeader) || (is_array($calloutOptionsAllowMergeFieldsInHeader) && empty($calloutOptionsAllowMergeFieldsInHeader))) {
            unset($this->CalloutOptionsAllowMergeFieldsInHeader);
        } else {
            $this->CalloutOptionsAllowMergeFieldsInHeader = $calloutOptionsAllowMergeFieldsInHeader;
        }
        return $this;
    }
    /**
     * Get CalloutOptionsGenerateAuthorizationHeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCalloutOptionsGenerateAuthorizationHeader()
    {
        return isset($this->CalloutOptionsGenerateAuthorizationHeader) ? $this->CalloutOptionsGenerateAuthorizationHeader : null;
    }
    /**
     * Set CalloutOptionsGenerateAuthorizationHeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $calloutOptionsGenerateAuthorizationHeader
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setCalloutOptionsGenerateAuthorizationHeader($calloutOptionsGenerateAuthorizationHeader = null)
    {
        // validation for constraint: boolean
        if (!is_null($calloutOptionsGenerateAuthorizationHeader) && !is_bool($calloutOptionsGenerateAuthorizationHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($calloutOptionsGenerateAuthorizationHeader, true), gettype($calloutOptionsGenerateAuthorizationHeader)), __LINE__);
        }
        if (is_null($calloutOptionsGenerateAuthorizationHeader) || (is_array($calloutOptionsGenerateAuthorizationHeader) && empty($calloutOptionsGenerateAuthorizationHeader))) {
            unset($this->CalloutOptionsGenerateAuthorizationHeader);
        } else {
            $this->CalloutOptionsGenerateAuthorizationHeader = $calloutOptionsGenerateAuthorizationHeader;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get CustomHttpHeaders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCustomHttpHeaders()
    {
        return isset($this->CustomHttpHeaders) ? $this->CustomHttpHeaders : null;
    }
    /**
     * Set CustomHttpHeaders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $customHttpHeaders
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setCustomHttpHeaders(\NexusDigital/MiratelForce\StructType\QueryResult $customHttpHeaders = null)
    {
        if (is_null($customHttpHeaders) || (is_array($customHttpHeaders) && empty($customHttpHeaders))) {
            unset($this->CustomHttpHeaders);
        } else {
            $this->CustomHttpHeaders = $customHttpHeaders;
        }
        return $this;
    }
    /**
     * Get DeveloperName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeveloperName()
    {
        return isset($this->DeveloperName) ? $this->DeveloperName : null;
    }
    /**
     * Set DeveloperName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $developerName
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setDeveloperName($developerName = null)
    {
        // validation for constraint: string
        if (!is_null($developerName) && !is_string($developerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($developerName, true), gettype($developerName)), __LINE__);
        }
        if (is_null($developerName) || (is_array($developerName) && empty($developerName))) {
            unset($this->DeveloperName);
        } else {
            $this->DeveloperName = $developerName;
        }
        return $this;
    }
    /**
     * Get Endpoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndpoint()
    {
        return isset($this->Endpoint) ? $this->Endpoint : null;
    }
    /**
     * Set Endpoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endpoint
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setEndpoint($endpoint = null)
    {
        // validation for constraint: string
        if (!is_null($endpoint) && !is_string($endpoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endpoint, true), gettype($endpoint)), __LINE__);
        }
        if (is_null($endpoint) || (is_array($endpoint) && empty($endpoint))) {
            unset($this->Endpoint);
        } else {
            $this->Endpoint = $endpoint;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get JwtAudience value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJwtAudience()
    {
        return isset($this->JwtAudience) ? $this->JwtAudience : null;
    }
    /**
     * Set JwtAudience value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jwtAudience
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setJwtAudience($jwtAudience = null)
    {
        // validation for constraint: string
        if (!is_null($jwtAudience) && !is_string($jwtAudience)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jwtAudience, true), gettype($jwtAudience)), __LINE__);
        }
        if (is_null($jwtAudience) || (is_array($jwtAudience) && empty($jwtAudience))) {
            unset($this->JwtAudience);
        } else {
            $this->JwtAudience = $jwtAudience;
        }
        return $this;
    }
    /**
     * Get JwtFormulaSubject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJwtFormulaSubject()
    {
        return isset($this->JwtFormulaSubject) ? $this->JwtFormulaSubject : null;
    }
    /**
     * Set JwtFormulaSubject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jwtFormulaSubject
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setJwtFormulaSubject($jwtFormulaSubject = null)
    {
        // validation for constraint: string
        if (!is_null($jwtFormulaSubject) && !is_string($jwtFormulaSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jwtFormulaSubject, true), gettype($jwtFormulaSubject)), __LINE__);
        }
        if (is_null($jwtFormulaSubject) || (is_array($jwtFormulaSubject) && empty($jwtFormulaSubject))) {
            unset($this->JwtFormulaSubject);
        } else {
            $this->JwtFormulaSubject = $jwtFormulaSubject;
        }
        return $this;
    }
    /**
     * Get JwtIssuer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJwtIssuer()
    {
        return isset($this->JwtIssuer) ? $this->JwtIssuer : null;
    }
    /**
     * Set JwtIssuer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jwtIssuer
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setJwtIssuer($jwtIssuer = null)
    {
        // validation for constraint: string
        if (!is_null($jwtIssuer) && !is_string($jwtIssuer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jwtIssuer, true), gettype($jwtIssuer)), __LINE__);
        }
        if (is_null($jwtIssuer) || (is_array($jwtIssuer) && empty($jwtIssuer))) {
            unset($this->JwtIssuer);
        } else {
            $this->JwtIssuer = $jwtIssuer;
        }
        return $this;
    }
    /**
     * Get JwtTextSubject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJwtTextSubject()
    {
        return isset($this->JwtTextSubject) ? $this->JwtTextSubject : null;
    }
    /**
     * Set JwtTextSubject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jwtTextSubject
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setJwtTextSubject($jwtTextSubject = null)
    {
        // validation for constraint: string
        if (!is_null($jwtTextSubject) && !is_string($jwtTextSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jwtTextSubject, true), gettype($jwtTextSubject)), __LINE__);
        }
        if (is_null($jwtTextSubject) || (is_array($jwtTextSubject) && empty($jwtTextSubject))) {
            unset($this->JwtTextSubject);
        } else {
            $this->JwtTextSubject = $jwtTextSubject;
        }
        return $this;
    }
    /**
     * Get JwtValidityPeriodSeconds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getJwtValidityPeriodSeconds()
    {
        return isset($this->JwtValidityPeriodSeconds) ? $this->JwtValidityPeriodSeconds : null;
    }
    /**
     * Set JwtValidityPeriodSeconds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $jwtValidityPeriodSeconds
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setJwtValidityPeriodSeconds($jwtValidityPeriodSeconds = null)
    {
        // validation for constraint: int
        if (!is_null($jwtValidityPeriodSeconds) && !(is_int($jwtValidityPeriodSeconds) || ctype_digit($jwtValidityPeriodSeconds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($jwtValidityPeriodSeconds, true), gettype($jwtValidityPeriodSeconds)), __LINE__);
        }
        if (is_null($jwtValidityPeriodSeconds) || (is_array($jwtValidityPeriodSeconds) && empty($jwtValidityPeriodSeconds))) {
            unset($this->JwtValidityPeriodSeconds);
        } else {
            $this->JwtValidityPeriodSeconds = $jwtValidityPeriodSeconds;
        }
        return $this;
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = $language;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get MasterLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterLabel()
    {
        return isset($this->MasterLabel) ? $this->MasterLabel : null;
    }
    /**
     * Set MasterLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterLabel
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setMasterLabel($masterLabel = null)
    {
        // validation for constraint: string
        if (!is_null($masterLabel) && !is_string($masterLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterLabel, true), gettype($masterLabel)), __LINE__);
        }
        if (is_null($masterLabel) || (is_array($masterLabel) && empty($masterLabel))) {
            unset($this->MasterLabel);
        } else {
            $this->MasterLabel = $masterLabel;
        }
        return $this;
    }
    /**
     * Get NamespacePrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNamespacePrefix()
    {
        return isset($this->NamespacePrefix) ? $this->NamespacePrefix : null;
    }
    /**
     * Set NamespacePrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $namespacePrefix
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setNamespacePrefix($namespacePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($namespacePrefix) && !is_string($namespacePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($namespacePrefix, true), gettype($namespacePrefix)), __LINE__);
        }
        if (is_null($namespacePrefix) || (is_array($namespacePrefix) && empty($namespacePrefix))) {
            unset($this->NamespacePrefix);
        } else {
            $this->NamespacePrefix = $namespacePrefix;
        }
        return $this;
    }
    /**
     * Get PrincipalType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrincipalType()
    {
        return isset($this->PrincipalType) ? $this->PrincipalType : null;
    }
    /**
     * Set PrincipalType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $principalType
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setPrincipalType($principalType = null)
    {
        // validation for constraint: string
        if (!is_null($principalType) && !is_string($principalType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($principalType, true), gettype($principalType)), __LINE__);
        }
        if (is_null($principalType) || (is_array($principalType) && empty($principalType))) {
            unset($this->PrincipalType);
        } else {
            $this->PrincipalType = $principalType;
        }
        return $this;
    }
    /**
     * Get SetupEntityAccessItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getSetupEntityAccessItems()
    {
        return isset($this->SetupEntityAccessItems) ? $this->SetupEntityAccessItems : null;
    }
    /**
     * Set SetupEntityAccessItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $setupEntityAccessItems
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setSetupEntityAccessItems(\NexusDigital/MiratelForce\StructType\QueryResult $setupEntityAccessItems = null)
    {
        if (is_null($setupEntityAccessItems) || (is_array($setupEntityAccessItems) && empty($setupEntityAccessItems))) {
            unset($this->SetupEntityAccessItems);
        } else {
            $this->SetupEntityAccessItems = $setupEntityAccessItems;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get UserAuths value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getUserAuths()
    {
        return isset($this->UserAuths) ? $this->UserAuths : null;
    }
    /**
     * Set UserAuths value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $userAuths
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public function setUserAuths(\NexusDigital/MiratelForce\StructType\QueryResult $userAuths = null)
    {
        if (is_null($userAuths) || (is_array($userAuths) && empty($userAuths))) {
            unset($this->UserAuths);
        } else {
            $this->UserAuths = $userAuths;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\NamedCredential
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
