<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MailmergeTemplate StructType
 * @subpackage Structs
 */
class MailmergeTemplate extends SObject
{
    /**
     * The Body
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Body;
    /**
     * The BodyLength
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BodyLength;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Filename
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Filename;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastUsedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUsedDate;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The SecurityOptionsAttachmentHasFlash
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SecurityOptionsAttachmentHasFlash;
    /**
     * The SecurityOptionsAttachmentHasXSSThreat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SecurityOptionsAttachmentHasXSSThreat;
    /**
     * The SecurityOptionsAttachmentScannedForXSS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SecurityOptionsAttachmentScannedForXSS;
    /**
     * The SecurityOptionsAttachmentScannedforFlash
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SecurityOptionsAttachmentScannedforFlash;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * Constructor method for MailmergeTemplate
     * @uses MailmergeTemplate::setBody()
     * @uses MailmergeTemplate::setBodyLength()
     * @uses MailmergeTemplate::setCreatedBy()
     * @uses MailmergeTemplate::setCreatedById()
     * @uses MailmergeTemplate::setCreatedDate()
     * @uses MailmergeTemplate::setDescription()
     * @uses MailmergeTemplate::setFilename()
     * @uses MailmergeTemplate::setIsDeleted()
     * @uses MailmergeTemplate::setLastModifiedBy()
     * @uses MailmergeTemplate::setLastModifiedById()
     * @uses MailmergeTemplate::setLastModifiedDate()
     * @uses MailmergeTemplate::setLastUsedDate()
     * @uses MailmergeTemplate::setName()
     * @uses MailmergeTemplate::setSecurityOptionsAttachmentHasFlash()
     * @uses MailmergeTemplate::setSecurityOptionsAttachmentHasXSSThreat()
     * @uses MailmergeTemplate::setSecurityOptionsAttachmentScannedForXSS()
     * @uses MailmergeTemplate::setSecurityOptionsAttachmentScannedforFlash()
     * @uses MailmergeTemplate::setSystemModstamp()
     * @param string $body
     * @param int $bodyLength
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $description
     * @param string $filename
     * @param bool $isDeleted
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $lastUsedDate
     * @param string $name
     * @param bool $securityOptionsAttachmentHasFlash
     * @param bool $securityOptionsAttachmentHasXSSThreat
     * @param bool $securityOptionsAttachmentScannedForXSS
     * @param bool $securityOptionsAttachmentScannedforFlash
     * @param string $systemModstamp
     */
    public function __construct($body = null, $bodyLength = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $description = null, $filename = null, $isDeleted = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $lastUsedDate = null, $name = null, $securityOptionsAttachmentHasFlash = null, $securityOptionsAttachmentHasXSSThreat = null, $securityOptionsAttachmentScannedForXSS = null, $securityOptionsAttachmentScannedforFlash = null, $systemModstamp = null)
    {
        $this
            ->setBody($body)
            ->setBodyLength($bodyLength)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDescription($description)
            ->setFilename($filename)
            ->setIsDeleted($isDeleted)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastUsedDate($lastUsedDate)
            ->setName($name)
            ->setSecurityOptionsAttachmentHasFlash($securityOptionsAttachmentHasFlash)
            ->setSecurityOptionsAttachmentHasXSSThreat($securityOptionsAttachmentHasXSSThreat)
            ->setSecurityOptionsAttachmentScannedForXSS($securityOptionsAttachmentScannedForXSS)
            ->setSecurityOptionsAttachmentScannedforFlash($securityOptionsAttachmentScannedforFlash)
            ->setSystemModstamp($systemModstamp);
    }
    /**
     * Get Body value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBody()
    {
        return isset($this->Body) ? $this->Body : null;
    }
    /**
     * Set Body value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $body
     * @return \NexusDigital/MiratelForce\StructType\MailmergeTemplate
     */
    public function setBody($body = null)
    {
        // validation for constraint: string
        if (!is_null($body) && !is_string($body)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($body, true), gettype($body)), __LINE__);
        }
        if (is_null($body) || (is_array($body) && empty($body))) {
            unset($this->Body);
        } else {
            $this->Body = $body;
        }
        return $this;
    }
    /**
     * Get BodyLength value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBodyLength()
    {
        return isset($this->BodyLength) ? $this->BodyLength : null;
    }
    /**
     * Set BodyLength value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bodyLength
     * @return \NexusDigital/MiratelForce\StructType\MailmergeTemplate
     */
    public function setBodyLength($bodyLength = null)
    {
        // validation for constraint: int
        if (!is_null($bodyLength) && !(is_int($bodyLength) || ctype_digit($bodyLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bodyLength, true), gettype($bodyLength)), __LINE__);
        }
        if (is_null($bodyLength) || (is_array($bodyLength) && empty($bodyLength))) {
            unset($this->BodyLength);
        } else {
            $this->BodyLength = $bodyLength;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\MailmergeTemplate
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\MailmergeTemplate
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\MailmergeTemplate
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \NexusDigital/MiratelForce\StructType\MailmergeTemplate
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Filename value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFilename()
    {
        return isset($this->Filename) ? $this->Filename : null;
    }
    /**
     * Set Filename value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $filename
     * @return \NexusDigital/MiratelForce\StructType\MailmergeTemplate
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filename, true), gettype($filename)), __LINE__);
        }
        if (is_null($filename) || (is_array($filename) && empty($filename))) {
            unset($this->Filename);
        } else {
            $this->Filename = $filename;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\MailmergeTemplate
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\MailmergeTemplate
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\MailmergeTemplate
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\MailmergeTemplate
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LastUsedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUsedDate()
    {
        return isset($this->LastUsedDate) ? $this->LastUsedDate : null;
    }
    /**
     * Set LastUsedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUsedDate
     * @return \NexusDigital/MiratelForce\StructType\MailmergeTemplate
     */
    public function setLastUsedDate($lastUsedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUsedDate) && !is_string($lastUsedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUsedDate, true), gettype($lastUsedDate)), __LINE__);
        }
        if (is_null($lastUsedDate) || (is_array($lastUsedDate) && empty($lastUsedDate))) {
            unset($this->LastUsedDate);
        } else {
            $this->LastUsedDate = $lastUsedDate;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\MailmergeTemplate
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get SecurityOptionsAttachmentHasFlash value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSecurityOptionsAttachmentHasFlash()
    {
        return isset($this->SecurityOptionsAttachmentHasFlash) ? $this->SecurityOptionsAttachmentHasFlash : null;
    }
    /**
     * Set SecurityOptionsAttachmentHasFlash value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $securityOptionsAttachmentHasFlash
     * @return \NexusDigital/MiratelForce\StructType\MailmergeTemplate
     */
    public function setSecurityOptionsAttachmentHasFlash($securityOptionsAttachmentHasFlash = null)
    {
        // validation for constraint: boolean
        if (!is_null($securityOptionsAttachmentHasFlash) && !is_bool($securityOptionsAttachmentHasFlash)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($securityOptionsAttachmentHasFlash, true), gettype($securityOptionsAttachmentHasFlash)), __LINE__);
        }
        if (is_null($securityOptionsAttachmentHasFlash) || (is_array($securityOptionsAttachmentHasFlash) && empty($securityOptionsAttachmentHasFlash))) {
            unset($this->SecurityOptionsAttachmentHasFlash);
        } else {
            $this->SecurityOptionsAttachmentHasFlash = $securityOptionsAttachmentHasFlash;
        }
        return $this;
    }
    /**
     * Get SecurityOptionsAttachmentHasXSSThreat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSecurityOptionsAttachmentHasXSSThreat()
    {
        return isset($this->SecurityOptionsAttachmentHasXSSThreat) ? $this->SecurityOptionsAttachmentHasXSSThreat : null;
    }
    /**
     * Set SecurityOptionsAttachmentHasXSSThreat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $securityOptionsAttachmentHasXSSThreat
     * @return \NexusDigital/MiratelForce\StructType\MailmergeTemplate
     */
    public function setSecurityOptionsAttachmentHasXSSThreat($securityOptionsAttachmentHasXSSThreat = null)
    {
        // validation for constraint: boolean
        if (!is_null($securityOptionsAttachmentHasXSSThreat) && !is_bool($securityOptionsAttachmentHasXSSThreat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($securityOptionsAttachmentHasXSSThreat, true), gettype($securityOptionsAttachmentHasXSSThreat)), __LINE__);
        }
        if (is_null($securityOptionsAttachmentHasXSSThreat) || (is_array($securityOptionsAttachmentHasXSSThreat) && empty($securityOptionsAttachmentHasXSSThreat))) {
            unset($this->SecurityOptionsAttachmentHasXSSThreat);
        } else {
            $this->SecurityOptionsAttachmentHasXSSThreat = $securityOptionsAttachmentHasXSSThreat;
        }
        return $this;
    }
    /**
     * Get SecurityOptionsAttachmentScannedForXSS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSecurityOptionsAttachmentScannedForXSS()
    {
        return isset($this->SecurityOptionsAttachmentScannedForXSS) ? $this->SecurityOptionsAttachmentScannedForXSS : null;
    }
    /**
     * Set SecurityOptionsAttachmentScannedForXSS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $securityOptionsAttachmentScannedForXSS
     * @return \NexusDigital/MiratelForce\StructType\MailmergeTemplate
     */
    public function setSecurityOptionsAttachmentScannedForXSS($securityOptionsAttachmentScannedForXSS = null)
    {
        // validation for constraint: boolean
        if (!is_null($securityOptionsAttachmentScannedForXSS) && !is_bool($securityOptionsAttachmentScannedForXSS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($securityOptionsAttachmentScannedForXSS, true), gettype($securityOptionsAttachmentScannedForXSS)), __LINE__);
        }
        if (is_null($securityOptionsAttachmentScannedForXSS) || (is_array($securityOptionsAttachmentScannedForXSS) && empty($securityOptionsAttachmentScannedForXSS))) {
            unset($this->SecurityOptionsAttachmentScannedForXSS);
        } else {
            $this->SecurityOptionsAttachmentScannedForXSS = $securityOptionsAttachmentScannedForXSS;
        }
        return $this;
    }
    /**
     * Get SecurityOptionsAttachmentScannedforFlash value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSecurityOptionsAttachmentScannedforFlash()
    {
        return isset($this->SecurityOptionsAttachmentScannedforFlash) ? $this->SecurityOptionsAttachmentScannedforFlash : null;
    }
    /**
     * Set SecurityOptionsAttachmentScannedforFlash value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $securityOptionsAttachmentScannedforFlash
     * @return \NexusDigital/MiratelForce\StructType\MailmergeTemplate
     */
    public function setSecurityOptionsAttachmentScannedforFlash($securityOptionsAttachmentScannedforFlash = null)
    {
        // validation for constraint: boolean
        if (!is_null($securityOptionsAttachmentScannedforFlash) && !is_bool($securityOptionsAttachmentScannedforFlash)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($securityOptionsAttachmentScannedforFlash, true), gettype($securityOptionsAttachmentScannedforFlash)), __LINE__);
        }
        if (is_null($securityOptionsAttachmentScannedforFlash) || (is_array($securityOptionsAttachmentScannedforFlash) && empty($securityOptionsAttachmentScannedforFlash))) {
            unset($this->SecurityOptionsAttachmentScannedforFlash);
        } else {
            $this->SecurityOptionsAttachmentScannedforFlash = $securityOptionsAttachmentScannedforFlash;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\MailmergeTemplate
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\MailmergeTemplate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
