<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListViewChartInstance StructType
 * @subpackage Structs
 */
class ListViewChartInstance extends SObject
{
    /**
     * The AggregateField
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AggregateField;
    /**
     * The AggregateType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AggregateType;
    /**
     * The ChartType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChartType;
    /**
     * The DataQuery
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataQuery;
    /**
     * The DataQueryWithoutUserFilters
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataQueryWithoutUserFilters;
    /**
     * The DeveloperName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeveloperName;
    /**
     * The ExternalId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalId;
    /**
     * The GroupingField
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GroupingField;
    /**
     * The IsDeletable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeletable;
    /**
     * The IsEditable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsEditable;
    /**
     * The IsLastViewed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsLastViewed;
    /**
     * The Label
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Label;
    /**
     * The ListViewChart
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ListViewChart
     */
    public $ListViewChart;
    /**
     * The ListViewChartId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ListViewChartId;
    /**
     * The ListViewContext
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ListView
     */
    public $ListViewContext;
    /**
     * The ListViewContextId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ListViewContextId;
    /**
     * The SourceEntity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceEntity;
    /**
     * Constructor method for ListViewChartInstance
     * @uses ListViewChartInstance::setAggregateField()
     * @uses ListViewChartInstance::setAggregateType()
     * @uses ListViewChartInstance::setChartType()
     * @uses ListViewChartInstance::setDataQuery()
     * @uses ListViewChartInstance::setDataQueryWithoutUserFilters()
     * @uses ListViewChartInstance::setDeveloperName()
     * @uses ListViewChartInstance::setExternalId()
     * @uses ListViewChartInstance::setGroupingField()
     * @uses ListViewChartInstance::setIsDeletable()
     * @uses ListViewChartInstance::setIsEditable()
     * @uses ListViewChartInstance::setIsLastViewed()
     * @uses ListViewChartInstance::setLabel()
     * @uses ListViewChartInstance::setListViewChart()
     * @uses ListViewChartInstance::setListViewChartId()
     * @uses ListViewChartInstance::setListViewContext()
     * @uses ListViewChartInstance::setListViewContextId()
     * @uses ListViewChartInstance::setSourceEntity()
     * @param string $aggregateField
     * @param string $aggregateType
     * @param string $chartType
     * @param string $dataQuery
     * @param string $dataQueryWithoutUserFilters
     * @param string $developerName
     * @param string $externalId
     * @param string $groupingField
     * @param bool $isDeletable
     * @param bool $isEditable
     * @param bool $isLastViewed
     * @param string $label
     * @param \NexusDigital/MiratelForce\StructType\ListViewChart $listViewChart
     * @param string $listViewChartId
     * @param \NexusDigital/MiratelForce\StructType\ListView $listViewContext
     * @param string $listViewContextId
     * @param string $sourceEntity
     */
    public function __construct($aggregateField = null, $aggregateType = null, $chartType = null, $dataQuery = null, $dataQueryWithoutUserFilters = null, $developerName = null, $externalId = null, $groupingField = null, $isDeletable = null, $isEditable = null, $isLastViewed = null, $label = null, \NexusDigital/MiratelForce\StructType\ListViewChart $listViewChart = null, $listViewChartId = null, \NexusDigital/MiratelForce\StructType\ListView $listViewContext = null, $listViewContextId = null, $sourceEntity = null)
    {
        $this
            ->setAggregateField($aggregateField)
            ->setAggregateType($aggregateType)
            ->setChartType($chartType)
            ->setDataQuery($dataQuery)
            ->setDataQueryWithoutUserFilters($dataQueryWithoutUserFilters)
            ->setDeveloperName($developerName)
            ->setExternalId($externalId)
            ->setGroupingField($groupingField)
            ->setIsDeletable($isDeletable)
            ->setIsEditable($isEditable)
            ->setIsLastViewed($isLastViewed)
            ->setLabel($label)
            ->setListViewChart($listViewChart)
            ->setListViewChartId($listViewChartId)
            ->setListViewContext($listViewContext)
            ->setListViewContextId($listViewContextId)
            ->setSourceEntity($sourceEntity);
    }
    /**
     * Get AggregateField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAggregateField()
    {
        return isset($this->AggregateField) ? $this->AggregateField : null;
    }
    /**
     * Set AggregateField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aggregateField
     * @return \NexusDigital/MiratelForce\StructType\ListViewChartInstance
     */
    public function setAggregateField($aggregateField = null)
    {
        // validation for constraint: string
        if (!is_null($aggregateField) && !is_string($aggregateField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aggregateField, true), gettype($aggregateField)), __LINE__);
        }
        if (is_null($aggregateField) || (is_array($aggregateField) && empty($aggregateField))) {
            unset($this->AggregateField);
        } else {
            $this->AggregateField = $aggregateField;
        }
        return $this;
    }
    /**
     * Get AggregateType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAggregateType()
    {
        return isset($this->AggregateType) ? $this->AggregateType : null;
    }
    /**
     * Set AggregateType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aggregateType
     * @return \NexusDigital/MiratelForce\StructType\ListViewChartInstance
     */
    public function setAggregateType($aggregateType = null)
    {
        // validation for constraint: string
        if (!is_null($aggregateType) && !is_string($aggregateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aggregateType, true), gettype($aggregateType)), __LINE__);
        }
        if (is_null($aggregateType) || (is_array($aggregateType) && empty($aggregateType))) {
            unset($this->AggregateType);
        } else {
            $this->AggregateType = $aggregateType;
        }
        return $this;
    }
    /**
     * Get ChartType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChartType()
    {
        return isset($this->ChartType) ? $this->ChartType : null;
    }
    /**
     * Set ChartType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chartType
     * @return \NexusDigital/MiratelForce\StructType\ListViewChartInstance
     */
    public function setChartType($chartType = null)
    {
        // validation for constraint: string
        if (!is_null($chartType) && !is_string($chartType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chartType, true), gettype($chartType)), __LINE__);
        }
        if (is_null($chartType) || (is_array($chartType) && empty($chartType))) {
            unset($this->ChartType);
        } else {
            $this->ChartType = $chartType;
        }
        return $this;
    }
    /**
     * Get DataQuery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataQuery()
    {
        return isset($this->DataQuery) ? $this->DataQuery : null;
    }
    /**
     * Set DataQuery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataQuery
     * @return \NexusDigital/MiratelForce\StructType\ListViewChartInstance
     */
    public function setDataQuery($dataQuery = null)
    {
        // validation for constraint: string
        if (!is_null($dataQuery) && !is_string($dataQuery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataQuery, true), gettype($dataQuery)), __LINE__);
        }
        if (is_null($dataQuery) || (is_array($dataQuery) && empty($dataQuery))) {
            unset($this->DataQuery);
        } else {
            $this->DataQuery = $dataQuery;
        }
        return $this;
    }
    /**
     * Get DataQueryWithoutUserFilters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataQueryWithoutUserFilters()
    {
        return isset($this->DataQueryWithoutUserFilters) ? $this->DataQueryWithoutUserFilters : null;
    }
    /**
     * Set DataQueryWithoutUserFilters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataQueryWithoutUserFilters
     * @return \NexusDigital/MiratelForce\StructType\ListViewChartInstance
     */
    public function setDataQueryWithoutUserFilters($dataQueryWithoutUserFilters = null)
    {
        // validation for constraint: string
        if (!is_null($dataQueryWithoutUserFilters) && !is_string($dataQueryWithoutUserFilters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataQueryWithoutUserFilters, true), gettype($dataQueryWithoutUserFilters)), __LINE__);
        }
        if (is_null($dataQueryWithoutUserFilters) || (is_array($dataQueryWithoutUserFilters) && empty($dataQueryWithoutUserFilters))) {
            unset($this->DataQueryWithoutUserFilters);
        } else {
            $this->DataQueryWithoutUserFilters = $dataQueryWithoutUserFilters;
        }
        return $this;
    }
    /**
     * Get DeveloperName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeveloperName()
    {
        return isset($this->DeveloperName) ? $this->DeveloperName : null;
    }
    /**
     * Set DeveloperName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $developerName
     * @return \NexusDigital/MiratelForce\StructType\ListViewChartInstance
     */
    public function setDeveloperName($developerName = null)
    {
        // validation for constraint: string
        if (!is_null($developerName) && !is_string($developerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($developerName, true), gettype($developerName)), __LINE__);
        }
        if (is_null($developerName) || (is_array($developerName) && empty($developerName))) {
            unset($this->DeveloperName);
        } else {
            $this->DeveloperName = $developerName;
        }
        return $this;
    }
    /**
     * Get ExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalId()
    {
        return isset($this->ExternalId) ? $this->ExternalId : null;
    }
    /**
     * Set ExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalId
     * @return \NexusDigital/MiratelForce\StructType\ListViewChartInstance
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        if (is_null($externalId) || (is_array($externalId) && empty($externalId))) {
            unset($this->ExternalId);
        } else {
            $this->ExternalId = $externalId;
        }
        return $this;
    }
    /**
     * Get GroupingField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupingField()
    {
        return isset($this->GroupingField) ? $this->GroupingField : null;
    }
    /**
     * Set GroupingField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupingField
     * @return \NexusDigital/MiratelForce\StructType\ListViewChartInstance
     */
    public function setGroupingField($groupingField = null)
    {
        // validation for constraint: string
        if (!is_null($groupingField) && !is_string($groupingField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupingField, true), gettype($groupingField)), __LINE__);
        }
        if (is_null($groupingField) || (is_array($groupingField) && empty($groupingField))) {
            unset($this->GroupingField);
        } else {
            $this->GroupingField = $groupingField;
        }
        return $this;
    }
    /**
     * Get IsDeletable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeletable()
    {
        return isset($this->IsDeletable) ? $this->IsDeletable : null;
    }
    /**
     * Set IsDeletable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeletable
     * @return \NexusDigital/MiratelForce\StructType\ListViewChartInstance
     */
    public function setIsDeletable($isDeletable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeletable) && !is_bool($isDeletable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeletable, true), gettype($isDeletable)), __LINE__);
        }
        if (is_null($isDeletable) || (is_array($isDeletable) && empty($isDeletable))) {
            unset($this->IsDeletable);
        } else {
            $this->IsDeletable = $isDeletable;
        }
        return $this;
    }
    /**
     * Get IsEditable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsEditable()
    {
        return isset($this->IsEditable) ? $this->IsEditable : null;
    }
    /**
     * Set IsEditable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isEditable
     * @return \NexusDigital/MiratelForce\StructType\ListViewChartInstance
     */
    public function setIsEditable($isEditable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEditable) && !is_bool($isEditable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEditable, true), gettype($isEditable)), __LINE__);
        }
        if (is_null($isEditable) || (is_array($isEditable) && empty($isEditable))) {
            unset($this->IsEditable);
        } else {
            $this->IsEditable = $isEditable;
        }
        return $this;
    }
    /**
     * Get IsLastViewed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsLastViewed()
    {
        return isset($this->IsLastViewed) ? $this->IsLastViewed : null;
    }
    /**
     * Set IsLastViewed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isLastViewed
     * @return \NexusDigital/MiratelForce\StructType\ListViewChartInstance
     */
    public function setIsLastViewed($isLastViewed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLastViewed) && !is_bool($isLastViewed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLastViewed, true), gettype($isLastViewed)), __LINE__);
        }
        if (is_null($isLastViewed) || (is_array($isLastViewed) && empty($isLastViewed))) {
            unset($this->IsLastViewed);
        } else {
            $this->IsLastViewed = $isLastViewed;
        }
        return $this;
    }
    /**
     * Get Label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabel()
    {
        return isset($this->Label) ? $this->Label : null;
    }
    /**
     * Set Label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $label
     * @return \NexusDigital/MiratelForce\StructType\ListViewChartInstance
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        if (is_null($label) || (is_array($label) && empty($label))) {
            unset($this->Label);
        } else {
            $this->Label = $label;
        }
        return $this;
    }
    /**
     * Get ListViewChart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ListViewChart|null
     */
    public function getListViewChart()
    {
        return isset($this->ListViewChart) ? $this->ListViewChart : null;
    }
    /**
     * Set ListViewChart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ListViewChart $listViewChart
     * @return \NexusDigital/MiratelForce\StructType\ListViewChartInstance
     */
    public function setListViewChart(\NexusDigital/MiratelForce\StructType\ListViewChart $listViewChart = null)
    {
        if (is_null($listViewChart) || (is_array($listViewChart) && empty($listViewChart))) {
            unset($this->ListViewChart);
        } else {
            $this->ListViewChart = $listViewChart;
        }
        return $this;
    }
    /**
     * Get ListViewChartId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getListViewChartId()
    {
        return isset($this->ListViewChartId) ? $this->ListViewChartId : null;
    }
    /**
     * Set ListViewChartId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $listViewChartId
     * @return \NexusDigital/MiratelForce\StructType\ListViewChartInstance
     */
    public function setListViewChartId($listViewChartId = null)
    {
        // validation for constraint: string
        if (!is_null($listViewChartId) && !is_string($listViewChartId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listViewChartId, true), gettype($listViewChartId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($listViewChartId) && mb_strlen($listViewChartId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($listViewChartId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($listViewChartId) && !preg_match('/[a-zA-Z0-9]{18}/', $listViewChartId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($listViewChartId, true)), __LINE__);
        }
        if (is_null($listViewChartId) || (is_array($listViewChartId) && empty($listViewChartId))) {
            unset($this->ListViewChartId);
        } else {
            $this->ListViewChartId = $listViewChartId;
        }
        return $this;
    }
    /**
     * Get ListViewContext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ListView|null
     */
    public function getListViewContext()
    {
        return isset($this->ListViewContext) ? $this->ListViewContext : null;
    }
    /**
     * Set ListViewContext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ListView $listViewContext
     * @return \NexusDigital/MiratelForce\StructType\ListViewChartInstance
     */
    public function setListViewContext(\NexusDigital/MiratelForce\StructType\ListView $listViewContext = null)
    {
        if (is_null($listViewContext) || (is_array($listViewContext) && empty($listViewContext))) {
            unset($this->ListViewContext);
        } else {
            $this->ListViewContext = $listViewContext;
        }
        return $this;
    }
    /**
     * Get ListViewContextId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getListViewContextId()
    {
        return isset($this->ListViewContextId) ? $this->ListViewContextId : null;
    }
    /**
     * Set ListViewContextId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $listViewContextId
     * @return \NexusDigital/MiratelForce\StructType\ListViewChartInstance
     */
    public function setListViewContextId($listViewContextId = null)
    {
        // validation for constraint: string
        if (!is_null($listViewContextId) && !is_string($listViewContextId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listViewContextId, true), gettype($listViewContextId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($listViewContextId) && mb_strlen($listViewContextId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($listViewContextId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($listViewContextId) && !preg_match('/[a-zA-Z0-9]{18}/', $listViewContextId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($listViewContextId, true)), __LINE__);
        }
        if (is_null($listViewContextId) || (is_array($listViewContextId) && empty($listViewContextId))) {
            unset($this->ListViewContextId);
        } else {
            $this->ListViewContextId = $listViewContextId;
        }
        return $this;
    }
    /**
     * Get SourceEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceEntity()
    {
        return isset($this->SourceEntity) ? $this->SourceEntity : null;
    }
    /**
     * Set SourceEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceEntity
     * @return \NexusDigital/MiratelForce\StructType\ListViewChartInstance
     */
    public function setSourceEntity($sourceEntity = null)
    {
        // validation for constraint: string
        if (!is_null($sourceEntity) && !is_string($sourceEntity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceEntity, true), gettype($sourceEntity)), __LINE__);
        }
        if (is_null($sourceEntity) || (is_array($sourceEntity) && empty($sourceEntity))) {
            unset($this->SourceEntity);
        } else {
            $this->SourceEntity = $sourceEntity;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ListViewChartInstance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
