<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LinkedArticle StructType
 * @subpackage Structs
 */
class LinkedArticle extends SObject
{
    /**
     * The AttachedContentDocuments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AttachedContentDocuments;
    /**
     * The AttachedContentNotes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AttachedContentNotes;
    /**
     * The Attachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Attachments;
    /**
     * The CombinedAttachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $CombinedAttachments;
    /**
     * The ContentDocumentLinks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ContentDocumentLinks;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The FeedSubscriptionsForEntity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $FeedSubscriptionsForEntity;
    /**
     * The Feeds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Feeds;
    /**
     * The Histories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Histories;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The KnowledgeArticle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Knowledge__ka
     */
    public $KnowledgeArticle;
    /**
     * The KnowledgeArticleId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $KnowledgeArticleId;
    /**
     * The KnowledgeArticleVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Knowledge__kav
     */
    public $KnowledgeArticleVersion;
    /**
     * The KnowledgeArticleVersionId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $KnowledgeArticleVersionId;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LinkedEntity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $LinkedEntity;
    /**
     * The LinkedEntityId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LinkedEntityId;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Notes;
    /**
     * The NotesAndAttachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $NotesAndAttachments;
    /**
     * The ParentEntities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ParentEntities;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The TopicAssignments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $TopicAssignments;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The UserRecordAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\UserRecordAccess
     */
    public $UserRecordAccess;
    /**
     * Constructor method for LinkedArticle
     * @uses LinkedArticle::setAttachedContentDocuments()
     * @uses LinkedArticle::setAttachedContentNotes()
     * @uses LinkedArticle::setAttachments()
     * @uses LinkedArticle::setCombinedAttachments()
     * @uses LinkedArticle::setContentDocumentLinks()
     * @uses LinkedArticle::setCreatedBy()
     * @uses LinkedArticle::setCreatedById()
     * @uses LinkedArticle::setCreatedDate()
     * @uses LinkedArticle::setFeedSubscriptionsForEntity()
     * @uses LinkedArticle::setFeeds()
     * @uses LinkedArticle::setHistories()
     * @uses LinkedArticle::setIsDeleted()
     * @uses LinkedArticle::setKnowledgeArticle()
     * @uses LinkedArticle::setKnowledgeArticleId()
     * @uses LinkedArticle::setKnowledgeArticleVersion()
     * @uses LinkedArticle::setKnowledgeArticleVersionId()
     * @uses LinkedArticle::setLastModifiedBy()
     * @uses LinkedArticle::setLastModifiedById()
     * @uses LinkedArticle::setLastModifiedDate()
     * @uses LinkedArticle::setLinkedEntity()
     * @uses LinkedArticle::setLinkedEntityId()
     * @uses LinkedArticle::setName()
     * @uses LinkedArticle::setNotes()
     * @uses LinkedArticle::setNotesAndAttachments()
     * @uses LinkedArticle::setParentEntities()
     * @uses LinkedArticle::setSystemModstamp()
     * @uses LinkedArticle::setTopicAssignments()
     * @uses LinkedArticle::setType()
     * @uses LinkedArticle::setUserRecordAccess()
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feeds
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $histories
     * @param bool $isDeleted
     * @param \NexusDigital/MiratelForce\StructType\Knowledge__ka $knowledgeArticle
     * @param string $knowledgeArticleId
     * @param \NexusDigital/MiratelForce\StructType\Knowledge__kav $knowledgeArticleVersion
     * @param string $knowledgeArticleVersionId
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param \NexusDigital/MiratelForce\StructType\SObject $linkedEntity
     * @param string $linkedEntityId
     * @param string $name
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $notes
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $notesAndAttachments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $parentEntities
     * @param string $systemModstamp
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments
     * @param string $type
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachments = null, \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments = null, \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, \NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity = null, \NexusDigital/MiratelForce\StructType\QueryResult $feeds = null, \NexusDigital/MiratelForce\StructType\QueryResult $histories = null, $isDeleted = null, \NexusDigital/MiratelForce\StructType\Knowledge__ka $knowledgeArticle = null, $knowledgeArticleId = null, \NexusDigital/MiratelForce\StructType\Knowledge__kav $knowledgeArticleVersion = null, $knowledgeArticleVersionId = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, \NexusDigital/MiratelForce\StructType\SObject $linkedEntity = null, $linkedEntityId = null, $name = null, \NexusDigital/MiratelForce\StructType\QueryResult $notes = null, \NexusDigital/MiratelForce\StructType\QueryResult $notesAndAttachments = null, \NexusDigital/MiratelForce\StructType\QueryResult $parentEntities = null, $systemModstamp = null, \NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments = null, $type = null, \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null)
    {
        $this
            ->setAttachedContentDocuments($attachedContentDocuments)
            ->setAttachedContentNotes($attachedContentNotes)
            ->setAttachments($attachments)
            ->setCombinedAttachments($combinedAttachments)
            ->setContentDocumentLinks($contentDocumentLinks)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setFeedSubscriptionsForEntity($feedSubscriptionsForEntity)
            ->setFeeds($feeds)
            ->setHistories($histories)
            ->setIsDeleted($isDeleted)
            ->setKnowledgeArticle($knowledgeArticle)
            ->setKnowledgeArticleId($knowledgeArticleId)
            ->setKnowledgeArticleVersion($knowledgeArticleVersion)
            ->setKnowledgeArticleVersionId($knowledgeArticleVersionId)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLinkedEntity($linkedEntity)
            ->setLinkedEntityId($linkedEntityId)
            ->setName($name)
            ->setNotes($notes)
            ->setNotesAndAttachments($notesAndAttachments)
            ->setParentEntities($parentEntities)
            ->setSystemModstamp($systemModstamp)
            ->setTopicAssignments($topicAssignments)
            ->setType($type)
            ->setUserRecordAccess($userRecordAccess);
    }
    /**
     * Get AttachedContentDocuments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachedContentDocuments()
    {
        return isset($this->AttachedContentDocuments) ? $this->AttachedContentDocuments : null;
    }
    /**
     * Set AttachedContentDocuments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setAttachedContentDocuments(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments = null)
    {
        if (is_null($attachedContentDocuments) || (is_array($attachedContentDocuments) && empty($attachedContentDocuments))) {
            unset($this->AttachedContentDocuments);
        } else {
            $this->AttachedContentDocuments = $attachedContentDocuments;
        }
        return $this;
    }
    /**
     * Get AttachedContentNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachedContentNotes()
    {
        return isset($this->AttachedContentNotes) ? $this->AttachedContentNotes : null;
    }
    /**
     * Set AttachedContentNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setAttachedContentNotes(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes = null)
    {
        if (is_null($attachedContentNotes) || (is_array($attachedContentNotes) && empty($attachedContentNotes))) {
            unset($this->AttachedContentNotes);
        } else {
            $this->AttachedContentNotes = $attachedContentNotes;
        }
        return $this;
    }
    /**
     * Get Attachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachments()
    {
        return isset($this->Attachments) ? $this->Attachments : null;
    }
    /**
     * Set Attachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachments
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $attachments = null)
    {
        if (is_null($attachments) || (is_array($attachments) && empty($attachments))) {
            unset($this->Attachments);
        } else {
            $this->Attachments = $attachments;
        }
        return $this;
    }
    /**
     * Get CombinedAttachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCombinedAttachments()
    {
        return isset($this->CombinedAttachments) ? $this->CombinedAttachments : null;
    }
    /**
     * Set CombinedAttachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setCombinedAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments = null)
    {
        if (is_null($combinedAttachments) || (is_array($combinedAttachments) && empty($combinedAttachments))) {
            unset($this->CombinedAttachments);
        } else {
            $this->CombinedAttachments = $combinedAttachments;
        }
        return $this;
    }
    /**
     * Get ContentDocumentLinks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getContentDocumentLinks()
    {
        return isset($this->ContentDocumentLinks) ? $this->ContentDocumentLinks : null;
    }
    /**
     * Set ContentDocumentLinks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setContentDocumentLinks(\NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null)
    {
        if (is_null($contentDocumentLinks) || (is_array($contentDocumentLinks) && empty($contentDocumentLinks))) {
            unset($this->ContentDocumentLinks);
        } else {
            $this->ContentDocumentLinks = $contentDocumentLinks;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get FeedSubscriptionsForEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getFeedSubscriptionsForEntity()
    {
        return isset($this->FeedSubscriptionsForEntity) ? $this->FeedSubscriptionsForEntity : null;
    }
    /**
     * Set FeedSubscriptionsForEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setFeedSubscriptionsForEntity(\NexusDigital/MiratelForce\StructType\QueryResult $feedSubscriptionsForEntity = null)
    {
        if (is_null($feedSubscriptionsForEntity) || (is_array($feedSubscriptionsForEntity) && empty($feedSubscriptionsForEntity))) {
            unset($this->FeedSubscriptionsForEntity);
        } else {
            $this->FeedSubscriptionsForEntity = $feedSubscriptionsForEntity;
        }
        return $this;
    }
    /**
     * Get Feeds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getFeeds()
    {
        return isset($this->Feeds) ? $this->Feeds : null;
    }
    /**
     * Set Feeds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $feeds
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setFeeds(\NexusDigital/MiratelForce\StructType\QueryResult $feeds = null)
    {
        if (is_null($feeds) || (is_array($feeds) && empty($feeds))) {
            unset($this->Feeds);
        } else {
            $this->Feeds = $feeds;
        }
        return $this;
    }
    /**
     * Get Histories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getHistories()
    {
        return isset($this->Histories) ? $this->Histories : null;
    }
    /**
     * Set Histories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $histories
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setHistories(\NexusDigital/MiratelForce\StructType\QueryResult $histories = null)
    {
        if (is_null($histories) || (is_array($histories) && empty($histories))) {
            unset($this->Histories);
        } else {
            $this->Histories = $histories;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get KnowledgeArticle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__ka|null
     */
    public function getKnowledgeArticle()
    {
        return isset($this->KnowledgeArticle) ? $this->KnowledgeArticle : null;
    }
    /**
     * Set KnowledgeArticle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Knowledge__ka $knowledgeArticle
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setKnowledgeArticle(\NexusDigital/MiratelForce\StructType\Knowledge__ka $knowledgeArticle = null)
    {
        if (is_null($knowledgeArticle) || (is_array($knowledgeArticle) && empty($knowledgeArticle))) {
            unset($this->KnowledgeArticle);
        } else {
            $this->KnowledgeArticle = $knowledgeArticle;
        }
        return $this;
    }
    /**
     * Get KnowledgeArticleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKnowledgeArticleId()
    {
        return isset($this->KnowledgeArticleId) ? $this->KnowledgeArticleId : null;
    }
    /**
     * Set KnowledgeArticleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $knowledgeArticleId
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setKnowledgeArticleId($knowledgeArticleId = null)
    {
        // validation for constraint: string
        if (!is_null($knowledgeArticleId) && !is_string($knowledgeArticleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($knowledgeArticleId, true), gettype($knowledgeArticleId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($knowledgeArticleId) && mb_strlen($knowledgeArticleId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($knowledgeArticleId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($knowledgeArticleId) && !preg_match('/[a-zA-Z0-9]{18}/', $knowledgeArticleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($knowledgeArticleId, true)), __LINE__);
        }
        if (is_null($knowledgeArticleId) || (is_array($knowledgeArticleId) && empty($knowledgeArticleId))) {
            unset($this->KnowledgeArticleId);
        } else {
            $this->KnowledgeArticleId = $knowledgeArticleId;
        }
        return $this;
    }
    /**
     * Get KnowledgeArticleVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Knowledge__kav|null
     */
    public function getKnowledgeArticleVersion()
    {
        return isset($this->KnowledgeArticleVersion) ? $this->KnowledgeArticleVersion : null;
    }
    /**
     * Set KnowledgeArticleVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Knowledge__kav $knowledgeArticleVersion
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setKnowledgeArticleVersion(\NexusDigital/MiratelForce\StructType\Knowledge__kav $knowledgeArticleVersion = null)
    {
        if (is_null($knowledgeArticleVersion) || (is_array($knowledgeArticleVersion) && empty($knowledgeArticleVersion))) {
            unset($this->KnowledgeArticleVersion);
        } else {
            $this->KnowledgeArticleVersion = $knowledgeArticleVersion;
        }
        return $this;
    }
    /**
     * Get KnowledgeArticleVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKnowledgeArticleVersionId()
    {
        return isset($this->KnowledgeArticleVersionId) ? $this->KnowledgeArticleVersionId : null;
    }
    /**
     * Set KnowledgeArticleVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $knowledgeArticleVersionId
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setKnowledgeArticleVersionId($knowledgeArticleVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($knowledgeArticleVersionId) && !is_string($knowledgeArticleVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($knowledgeArticleVersionId, true), gettype($knowledgeArticleVersionId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($knowledgeArticleVersionId) && mb_strlen($knowledgeArticleVersionId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($knowledgeArticleVersionId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($knowledgeArticleVersionId) && !preg_match('/[a-zA-Z0-9]{18}/', $knowledgeArticleVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($knowledgeArticleVersionId, true)), __LINE__);
        }
        if (is_null($knowledgeArticleVersionId) || (is_array($knowledgeArticleVersionId) && empty($knowledgeArticleVersionId))) {
            unset($this->KnowledgeArticleVersionId);
        } else {
            $this->KnowledgeArticleVersionId = $knowledgeArticleVersionId;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LinkedEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getLinkedEntity()
    {
        return isset($this->LinkedEntity) ? $this->LinkedEntity : null;
    }
    /**
     * Set LinkedEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $linkedEntity
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setLinkedEntity(\NexusDigital/MiratelForce\StructType\SObject $linkedEntity = null)
    {
        if (is_null($linkedEntity) || (is_array($linkedEntity) && empty($linkedEntity))) {
            unset($this->LinkedEntity);
        } else {
            $this->LinkedEntity = $linkedEntity;
        }
        return $this;
    }
    /**
     * Get LinkedEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLinkedEntityId()
    {
        return isset($this->LinkedEntityId) ? $this->LinkedEntityId : null;
    }
    /**
     * Set LinkedEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $linkedEntityId
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setLinkedEntityId($linkedEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($linkedEntityId) && !is_string($linkedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkedEntityId, true), gettype($linkedEntityId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($linkedEntityId) && mb_strlen($linkedEntityId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($linkedEntityId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($linkedEntityId) && !preg_match('/[a-zA-Z0-9]{18}/', $linkedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($linkedEntityId, true)), __LINE__);
        }
        if (is_null($linkedEntityId) || (is_array($linkedEntityId) && empty($linkedEntityId))) {
            unset($this->LinkedEntityId);
        } else {
            $this->LinkedEntityId = $linkedEntityId;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $notes
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setNotes(\NexusDigital/MiratelForce\StructType\QueryResult $notes = null)
    {
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get NotesAndAttachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getNotesAndAttachments()
    {
        return isset($this->NotesAndAttachments) ? $this->NotesAndAttachments : null;
    }
    /**
     * Set NotesAndAttachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $notesAndAttachments
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setNotesAndAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $notesAndAttachments = null)
    {
        if (is_null($notesAndAttachments) || (is_array($notesAndAttachments) && empty($notesAndAttachments))) {
            unset($this->NotesAndAttachments);
        } else {
            $this->NotesAndAttachments = $notesAndAttachments;
        }
        return $this;
    }
    /**
     * Get ParentEntities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getParentEntities()
    {
        return isset($this->ParentEntities) ? $this->ParentEntities : null;
    }
    /**
     * Set ParentEntities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $parentEntities
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setParentEntities(\NexusDigital/MiratelForce\StructType\QueryResult $parentEntities = null)
    {
        if (is_null($parentEntities) || (is_array($parentEntities) && empty($parentEntities))) {
            unset($this->ParentEntities);
        } else {
            $this->ParentEntities = $parentEntities;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get TopicAssignments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getTopicAssignments()
    {
        return isset($this->TopicAssignments) ? $this->TopicAssignments : null;
    }
    /**
     * Set TopicAssignments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setTopicAssignments(\NexusDigital/MiratelForce\StructType\QueryResult $topicAssignments = null)
    {
        if (is_null($topicAssignments) || (is_array($topicAssignments) && empty($topicAssignments))) {
            unset($this->TopicAssignments);
        } else {
            $this->TopicAssignments = $topicAssignments;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get UserRecordAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\UserRecordAccess|null
     */
    public function getUserRecordAccess()
    {
        return isset($this->UserRecordAccess) ? $this->UserRecordAccess : null;
    }
    /**
     * Set UserRecordAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public function setUserRecordAccess(\NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null)
    {
        if (is_null($userRecordAccess) || (is_array($userRecordAccess) && empty($userRecordAccess))) {
            unset($this->UserRecordAccess);
        } else {
            $this->UserRecordAccess = $userRecordAccess;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\LinkedArticle
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
