<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KnowledgeArticleViewStat StructType
 * @subpackage Structs
 */
class KnowledgeArticleViewStat extends SObject
{
    /**
     * The Channel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Channel;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The NormalizedScore
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $NormalizedScore;
    /**
     * The Parent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\KnowledgeArticle
     */
    public $Parent;
    /**
     * The ParentId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ParentId;
    /**
     * The ViewCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ViewCount;
    /**
     * Constructor method for KnowledgeArticleViewStat
     * @uses KnowledgeArticleViewStat::setChannel()
     * @uses KnowledgeArticleViewStat::setIsDeleted()
     * @uses KnowledgeArticleViewStat::setNormalizedScore()
     * @uses KnowledgeArticleViewStat::setParent()
     * @uses KnowledgeArticleViewStat::setParentId()
     * @uses KnowledgeArticleViewStat::setViewCount()
     * @param string $channel
     * @param bool $isDeleted
     * @param float $normalizedScore
     * @param \NexusDigital/MiratelForce\StructType\KnowledgeArticle $parent
     * @param string $parentId
     * @param int $viewCount
     */
    public function __construct($channel = null, $isDeleted = null, $normalizedScore = null, \NexusDigital/MiratelForce\StructType\KnowledgeArticle $parent = null, $parentId = null, $viewCount = null)
    {
        $this
            ->setChannel($channel)
            ->setIsDeleted($isDeleted)
            ->setNormalizedScore($normalizedScore)
            ->setParent($parent)
            ->setParentId($parentId)
            ->setViewCount($viewCount);
    }
    /**
     * Get Channel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChannel()
    {
        return isset($this->Channel) ? $this->Channel : null;
    }
    /**
     * Set Channel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $channel
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleViewStat
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: string
        if (!is_null($channel) && !is_string($channel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channel, true), gettype($channel)), __LINE__);
        }
        if (is_null($channel) || (is_array($channel) && empty($channel))) {
            unset($this->Channel);
        } else {
            $this->Channel = $channel;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleViewStat
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get NormalizedScore value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getNormalizedScore()
    {
        return isset($this->NormalizedScore) ? $this->NormalizedScore : null;
    }
    /**
     * Set NormalizedScore value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $normalizedScore
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleViewStat
     */
    public function setNormalizedScore($normalizedScore = null)
    {
        // validation for constraint: float
        if (!is_null($normalizedScore) && !(is_float($normalizedScore) || is_numeric($normalizedScore))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($normalizedScore, true), gettype($normalizedScore)), __LINE__);
        }
        if (is_null($normalizedScore) || (is_array($normalizedScore) && empty($normalizedScore))) {
            unset($this->NormalizedScore);
        } else {
            $this->NormalizedScore = $normalizedScore;
        }
        return $this;
    }
    /**
     * Get Parent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticle|null
     */
    public function getParent()
    {
        return isset($this->Parent) ? $this->Parent : null;
    }
    /**
     * Set Parent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\KnowledgeArticle $parent
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleViewStat
     */
    public function setParent(\NexusDigital/MiratelForce\StructType\KnowledgeArticle $parent = null)
    {
        if (is_null($parent) || (is_array($parent) && empty($parent))) {
            unset($this->Parent);
        } else {
            $this->Parent = $parent;
        }
        return $this;
    }
    /**
     * Get ParentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentId()
    {
        return isset($this->ParentId) ? $this->ParentId : null;
    }
    /**
     * Set ParentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentId
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleViewStat
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: string
        if (!is_null($parentId) && !is_string($parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentId, true), gettype($parentId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($parentId) && mb_strlen($parentId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($parentId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($parentId) && !preg_match('/[a-zA-Z0-9]{18}/', $parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($parentId, true)), __LINE__);
        }
        if (is_null($parentId) || (is_array($parentId) && empty($parentId))) {
            unset($this->ParentId);
        } else {
            $this->ParentId = $parentId;
        }
        return $this;
    }
    /**
     * Get ViewCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getViewCount()
    {
        return isset($this->ViewCount) ? $this->ViewCount : null;
    }
    /**
     * Set ViewCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $viewCount
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleViewStat
     */
    public function setViewCount($viewCount = null)
    {
        // validation for constraint: int
        if (!is_null($viewCount) && !(is_int($viewCount) || ctype_digit($viewCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($viewCount, true), gettype($viewCount)), __LINE__);
        }
        if (is_null($viewCount) || (is_array($viewCount) && empty($viewCount))) {
            unset($this->ViewCount);
        } else {
            $this->ViewCount = $viewCount;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\KnowledgeArticleViewStat
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
