<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Individual StructType
 * @subpackage Structs
 */
class Individual extends SObject
{
    /**
     * The BirthDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BirthDate;
    /**
     * The CanStorePiiElsewhere
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanStorePiiElsewhere;
    /**
     * The ChildrenCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ChildrenCount;
    /**
     * The ConsumerCreditScore
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ConsumerCreditScore;
    /**
     * The ConsumerCreditScoreProviderName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConsumerCreditScoreProviderName;
    /**
     * The Contacts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Contacts;
    /**
     * The ConvictionsCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ConvictionsCount;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The DeathDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeathDate;
    /**
     * The DuplicateRecordItems
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $DuplicateRecordItems;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The HasOptedOutGeoTracking
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasOptedOutGeoTracking;
    /**
     * The HasOptedOutProcessing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasOptedOutProcessing;
    /**
     * The HasOptedOutProfiling
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasOptedOutProfiling;
    /**
     * The HasOptedOutSolicit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasOptedOutSolicit;
    /**
     * The HasOptedOutTracking
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasOptedOutTracking;
    /**
     * The Histories
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Histories;
    /**
     * The Individuals
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Individuals;
    /**
     * The IndividualsAge
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IndividualsAge;
    /**
     * The InfluencerRating
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InfluencerRating;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsHomeOwner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHomeOwner;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The LastViewedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastViewedDate;
    /**
     * The Leads
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Leads;
    /**
     * The MasterRecord
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\Individual
     */
    public $MasterRecord;
    /**
     * The MasterRecordId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $MasterRecordId;
    /**
     * The MiddleName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MiddleName;
    /**
     * The MilitaryService
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MilitaryService;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Occupation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Occupation;
    /**
     * The Owner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $Owner;
    /**
     * The OwnerId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $OwnerId;
    /**
     * The Salutation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Salutation;
    /**
     * The SendIndividualData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SendIndividualData;
    /**
     * The Shares
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Shares;
    /**
     * The ShouldForget
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShouldForget;
    /**
     * The Suffix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Suffix;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The Website
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Website;
    /**
     * Constructor method for Individual
     * @uses Individual::setBirthDate()
     * @uses Individual::setCanStorePiiElsewhere()
     * @uses Individual::setChildrenCount()
     * @uses Individual::setConsumerCreditScore()
     * @uses Individual::setConsumerCreditScoreProviderName()
     * @uses Individual::setContacts()
     * @uses Individual::setConvictionsCount()
     * @uses Individual::setCreatedBy()
     * @uses Individual::setCreatedById()
     * @uses Individual::setCreatedDate()
     * @uses Individual::setDeathDate()
     * @uses Individual::setDuplicateRecordItems()
     * @uses Individual::setFirstName()
     * @uses Individual::setHasOptedOutGeoTracking()
     * @uses Individual::setHasOptedOutProcessing()
     * @uses Individual::setHasOptedOutProfiling()
     * @uses Individual::setHasOptedOutSolicit()
     * @uses Individual::setHasOptedOutTracking()
     * @uses Individual::setHistories()
     * @uses Individual::setIndividuals()
     * @uses Individual::setIndividualsAge()
     * @uses Individual::setInfluencerRating()
     * @uses Individual::setIsDeleted()
     * @uses Individual::setIsHomeOwner()
     * @uses Individual::setLastModifiedBy()
     * @uses Individual::setLastModifiedById()
     * @uses Individual::setLastModifiedDate()
     * @uses Individual::setLastName()
     * @uses Individual::setLastViewedDate()
     * @uses Individual::setLeads()
     * @uses Individual::setMasterRecord()
     * @uses Individual::setMasterRecordId()
     * @uses Individual::setMiddleName()
     * @uses Individual::setMilitaryService()
     * @uses Individual::setName()
     * @uses Individual::setOccupation()
     * @uses Individual::setOwner()
     * @uses Individual::setOwnerId()
     * @uses Individual::setSalutation()
     * @uses Individual::setSendIndividualData()
     * @uses Individual::setShares()
     * @uses Individual::setShouldForget()
     * @uses Individual::setSuffix()
     * @uses Individual::setSystemModstamp()
     * @uses Individual::setWebsite()
     * @param string $birthDate
     * @param bool $canStorePiiElsewhere
     * @param int $childrenCount
     * @param int $consumerCreditScore
     * @param string $consumerCreditScoreProviderName
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contacts
     * @param int $convictionsCount
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $deathDate
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $duplicateRecordItems
     * @param string $firstName
     * @param bool $hasOptedOutGeoTracking
     * @param bool $hasOptedOutProcessing
     * @param bool $hasOptedOutProfiling
     * @param bool $hasOptedOutSolicit
     * @param bool $hasOptedOutTracking
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $histories
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $individuals
     * @param string $individualsAge
     * @param int $influencerRating
     * @param bool $isDeleted
     * @param bool $isHomeOwner
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $lastName
     * @param string $lastViewedDate
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $leads
     * @param \NexusDigital/MiratelForce\StructType\Individual $masterRecord
     * @param string $masterRecordId
     * @param string $middleName
     * @param string $militaryService
     * @param string $name
     * @param string $occupation
     * @param \NexusDigital/MiratelForce\StructType\User $owner
     * @param string $ownerId
     * @param string $salutation
     * @param bool $sendIndividualData
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $shares
     * @param bool $shouldForget
     * @param string $suffix
     * @param string $systemModstamp
     * @param string $website
     */
    public function __construct($birthDate = null, $canStorePiiElsewhere = null, $childrenCount = null, $consumerCreditScore = null, $consumerCreditScoreProviderName = null, \NexusDigital/MiratelForce\StructType\QueryResult $contacts = null, $convictionsCount = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $deathDate = null, \NexusDigital/MiratelForce\StructType\QueryResult $duplicateRecordItems = null, $firstName = null, $hasOptedOutGeoTracking = null, $hasOptedOutProcessing = null, $hasOptedOutProfiling = null, $hasOptedOutSolicit = null, $hasOptedOutTracking = null, \NexusDigital/MiratelForce\StructType\QueryResult $histories = null, \NexusDigital/MiratelForce\StructType\QueryResult $individuals = null, $individualsAge = null, $influencerRating = null, $isDeleted = null, $isHomeOwner = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $lastName = null, $lastViewedDate = null, \NexusDigital/MiratelForce\StructType\QueryResult $leads = null, \NexusDigital/MiratelForce\StructType\Individual $masterRecord = null, $masterRecordId = null, $middleName = null, $militaryService = null, $name = null, $occupation = null, \NexusDigital/MiratelForce\StructType\User $owner = null, $ownerId = null, $salutation = null, $sendIndividualData = null, \NexusDigital/MiratelForce\StructType\QueryResult $shares = null, $shouldForget = null, $suffix = null, $systemModstamp = null, $website = null)
    {
        $this
            ->setBirthDate($birthDate)
            ->setCanStorePiiElsewhere($canStorePiiElsewhere)
            ->setChildrenCount($childrenCount)
            ->setConsumerCreditScore($consumerCreditScore)
            ->setConsumerCreditScoreProviderName($consumerCreditScoreProviderName)
            ->setContacts($contacts)
            ->setConvictionsCount($convictionsCount)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDeathDate($deathDate)
            ->setDuplicateRecordItems($duplicateRecordItems)
            ->setFirstName($firstName)
            ->setHasOptedOutGeoTracking($hasOptedOutGeoTracking)
            ->setHasOptedOutProcessing($hasOptedOutProcessing)
            ->setHasOptedOutProfiling($hasOptedOutProfiling)
            ->setHasOptedOutSolicit($hasOptedOutSolicit)
            ->setHasOptedOutTracking($hasOptedOutTracking)
            ->setHistories($histories)
            ->setIndividuals($individuals)
            ->setIndividualsAge($individualsAge)
            ->setInfluencerRating($influencerRating)
            ->setIsDeleted($isDeleted)
            ->setIsHomeOwner($isHomeOwner)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastName($lastName)
            ->setLastViewedDate($lastViewedDate)
            ->setLeads($leads)
            ->setMasterRecord($masterRecord)
            ->setMasterRecordId($masterRecordId)
            ->setMiddleName($middleName)
            ->setMilitaryService($militaryService)
            ->setName($name)
            ->setOccupation($occupation)
            ->setOwner($owner)
            ->setOwnerId($ownerId)
            ->setSalutation($salutation)
            ->setSendIndividualData($sendIndividualData)
            ->setShares($shares)
            ->setShouldForget($shouldForget)
            ->setSuffix($suffix)
            ->setSystemModstamp($systemModstamp)
            ->setWebsite($website);
    }
    /**
     * Get BirthDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBirthDate()
    {
        return isset($this->BirthDate) ? $this->BirthDate : null;
    }
    /**
     * Set BirthDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $birthDate
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        if (is_null($birthDate) || (is_array($birthDate) && empty($birthDate))) {
            unset($this->BirthDate);
        } else {
            $this->BirthDate = $birthDate;
        }
        return $this;
    }
    /**
     * Get CanStorePiiElsewhere value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanStorePiiElsewhere()
    {
        return isset($this->CanStorePiiElsewhere) ? $this->CanStorePiiElsewhere : null;
    }
    /**
     * Set CanStorePiiElsewhere value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canStorePiiElsewhere
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setCanStorePiiElsewhere($canStorePiiElsewhere = null)
    {
        // validation for constraint: boolean
        if (!is_null($canStorePiiElsewhere) && !is_bool($canStorePiiElsewhere)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canStorePiiElsewhere, true), gettype($canStorePiiElsewhere)), __LINE__);
        }
        if (is_null($canStorePiiElsewhere) || (is_array($canStorePiiElsewhere) && empty($canStorePiiElsewhere))) {
            unset($this->CanStorePiiElsewhere);
        } else {
            $this->CanStorePiiElsewhere = $canStorePiiElsewhere;
        }
        return $this;
    }
    /**
     * Get ChildrenCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getChildrenCount()
    {
        return isset($this->ChildrenCount) ? $this->ChildrenCount : null;
    }
    /**
     * Set ChildrenCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $childrenCount
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setChildrenCount($childrenCount = null)
    {
        // validation for constraint: int
        if (!is_null($childrenCount) && !(is_int($childrenCount) || ctype_digit($childrenCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($childrenCount, true), gettype($childrenCount)), __LINE__);
        }
        if (is_null($childrenCount) || (is_array($childrenCount) && empty($childrenCount))) {
            unset($this->ChildrenCount);
        } else {
            $this->ChildrenCount = $childrenCount;
        }
        return $this;
    }
    /**
     * Get ConsumerCreditScore value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getConsumerCreditScore()
    {
        return isset($this->ConsumerCreditScore) ? $this->ConsumerCreditScore : null;
    }
    /**
     * Set ConsumerCreditScore value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $consumerCreditScore
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setConsumerCreditScore($consumerCreditScore = null)
    {
        // validation for constraint: int
        if (!is_null($consumerCreditScore) && !(is_int($consumerCreditScore) || ctype_digit($consumerCreditScore))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($consumerCreditScore, true), gettype($consumerCreditScore)), __LINE__);
        }
        if (is_null($consumerCreditScore) || (is_array($consumerCreditScore) && empty($consumerCreditScore))) {
            unset($this->ConsumerCreditScore);
        } else {
            $this->ConsumerCreditScore = $consumerCreditScore;
        }
        return $this;
    }
    /**
     * Get ConsumerCreditScoreProviderName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConsumerCreditScoreProviderName()
    {
        return isset($this->ConsumerCreditScoreProviderName) ? $this->ConsumerCreditScoreProviderName : null;
    }
    /**
     * Set ConsumerCreditScoreProviderName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $consumerCreditScoreProviderName
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setConsumerCreditScoreProviderName($consumerCreditScoreProviderName = null)
    {
        // validation for constraint: string
        if (!is_null($consumerCreditScoreProviderName) && !is_string($consumerCreditScoreProviderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consumerCreditScoreProviderName, true), gettype($consumerCreditScoreProviderName)), __LINE__);
        }
        if (is_null($consumerCreditScoreProviderName) || (is_array($consumerCreditScoreProviderName) && empty($consumerCreditScoreProviderName))) {
            unset($this->ConsumerCreditScoreProviderName);
        } else {
            $this->ConsumerCreditScoreProviderName = $consumerCreditScoreProviderName;
        }
        return $this;
    }
    /**
     * Get Contacts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getContacts()
    {
        return isset($this->Contacts) ? $this->Contacts : null;
    }
    /**
     * Set Contacts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contacts
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setContacts(\NexusDigital/MiratelForce\StructType\QueryResult $contacts = null)
    {
        if (is_null($contacts) || (is_array($contacts) && empty($contacts))) {
            unset($this->Contacts);
        } else {
            $this->Contacts = $contacts;
        }
        return $this;
    }
    /**
     * Get ConvictionsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getConvictionsCount()
    {
        return isset($this->ConvictionsCount) ? $this->ConvictionsCount : null;
    }
    /**
     * Set ConvictionsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $convictionsCount
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setConvictionsCount($convictionsCount = null)
    {
        // validation for constraint: int
        if (!is_null($convictionsCount) && !(is_int($convictionsCount) || ctype_digit($convictionsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($convictionsCount, true), gettype($convictionsCount)), __LINE__);
        }
        if (is_null($convictionsCount) || (is_array($convictionsCount) && empty($convictionsCount))) {
            unset($this->ConvictionsCount);
        } else {
            $this->ConvictionsCount = $convictionsCount;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get DeathDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeathDate()
    {
        return isset($this->DeathDate) ? $this->DeathDate : null;
    }
    /**
     * Set DeathDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deathDate
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setDeathDate($deathDate = null)
    {
        // validation for constraint: string
        if (!is_null($deathDate) && !is_string($deathDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deathDate, true), gettype($deathDate)), __LINE__);
        }
        if (is_null($deathDate) || (is_array($deathDate) && empty($deathDate))) {
            unset($this->DeathDate);
        } else {
            $this->DeathDate = $deathDate;
        }
        return $this;
    }
    /**
     * Get DuplicateRecordItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getDuplicateRecordItems()
    {
        return isset($this->DuplicateRecordItems) ? $this->DuplicateRecordItems : null;
    }
    /**
     * Set DuplicateRecordItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $duplicateRecordItems
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setDuplicateRecordItems(\NexusDigital/MiratelForce\StructType\QueryResult $duplicateRecordItems = null)
    {
        if (is_null($duplicateRecordItems) || (is_array($duplicateRecordItems) && empty($duplicateRecordItems))) {
            unset($this->DuplicateRecordItems);
        } else {
            $this->DuplicateRecordItems = $duplicateRecordItems;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get HasOptedOutGeoTracking value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasOptedOutGeoTracking()
    {
        return isset($this->HasOptedOutGeoTracking) ? $this->HasOptedOutGeoTracking : null;
    }
    /**
     * Set HasOptedOutGeoTracking value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasOptedOutGeoTracking
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setHasOptedOutGeoTracking($hasOptedOutGeoTracking = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasOptedOutGeoTracking) && !is_bool($hasOptedOutGeoTracking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasOptedOutGeoTracking, true), gettype($hasOptedOutGeoTracking)), __LINE__);
        }
        if (is_null($hasOptedOutGeoTracking) || (is_array($hasOptedOutGeoTracking) && empty($hasOptedOutGeoTracking))) {
            unset($this->HasOptedOutGeoTracking);
        } else {
            $this->HasOptedOutGeoTracking = $hasOptedOutGeoTracking;
        }
        return $this;
    }
    /**
     * Get HasOptedOutProcessing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasOptedOutProcessing()
    {
        return isset($this->HasOptedOutProcessing) ? $this->HasOptedOutProcessing : null;
    }
    /**
     * Set HasOptedOutProcessing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasOptedOutProcessing
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setHasOptedOutProcessing($hasOptedOutProcessing = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasOptedOutProcessing) && !is_bool($hasOptedOutProcessing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasOptedOutProcessing, true), gettype($hasOptedOutProcessing)), __LINE__);
        }
        if (is_null($hasOptedOutProcessing) || (is_array($hasOptedOutProcessing) && empty($hasOptedOutProcessing))) {
            unset($this->HasOptedOutProcessing);
        } else {
            $this->HasOptedOutProcessing = $hasOptedOutProcessing;
        }
        return $this;
    }
    /**
     * Get HasOptedOutProfiling value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasOptedOutProfiling()
    {
        return isset($this->HasOptedOutProfiling) ? $this->HasOptedOutProfiling : null;
    }
    /**
     * Set HasOptedOutProfiling value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasOptedOutProfiling
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setHasOptedOutProfiling($hasOptedOutProfiling = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasOptedOutProfiling) && !is_bool($hasOptedOutProfiling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasOptedOutProfiling, true), gettype($hasOptedOutProfiling)), __LINE__);
        }
        if (is_null($hasOptedOutProfiling) || (is_array($hasOptedOutProfiling) && empty($hasOptedOutProfiling))) {
            unset($this->HasOptedOutProfiling);
        } else {
            $this->HasOptedOutProfiling = $hasOptedOutProfiling;
        }
        return $this;
    }
    /**
     * Get HasOptedOutSolicit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasOptedOutSolicit()
    {
        return isset($this->HasOptedOutSolicit) ? $this->HasOptedOutSolicit : null;
    }
    /**
     * Set HasOptedOutSolicit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasOptedOutSolicit
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setHasOptedOutSolicit($hasOptedOutSolicit = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasOptedOutSolicit) && !is_bool($hasOptedOutSolicit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasOptedOutSolicit, true), gettype($hasOptedOutSolicit)), __LINE__);
        }
        if (is_null($hasOptedOutSolicit) || (is_array($hasOptedOutSolicit) && empty($hasOptedOutSolicit))) {
            unset($this->HasOptedOutSolicit);
        } else {
            $this->HasOptedOutSolicit = $hasOptedOutSolicit;
        }
        return $this;
    }
    /**
     * Get HasOptedOutTracking value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasOptedOutTracking()
    {
        return isset($this->HasOptedOutTracking) ? $this->HasOptedOutTracking : null;
    }
    /**
     * Set HasOptedOutTracking value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasOptedOutTracking
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setHasOptedOutTracking($hasOptedOutTracking = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasOptedOutTracking) && !is_bool($hasOptedOutTracking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasOptedOutTracking, true), gettype($hasOptedOutTracking)), __LINE__);
        }
        if (is_null($hasOptedOutTracking) || (is_array($hasOptedOutTracking) && empty($hasOptedOutTracking))) {
            unset($this->HasOptedOutTracking);
        } else {
            $this->HasOptedOutTracking = $hasOptedOutTracking;
        }
        return $this;
    }
    /**
     * Get Histories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getHistories()
    {
        return isset($this->Histories) ? $this->Histories : null;
    }
    /**
     * Set Histories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $histories
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setHistories(\NexusDigital/MiratelForce\StructType\QueryResult $histories = null)
    {
        if (is_null($histories) || (is_array($histories) && empty($histories))) {
            unset($this->Histories);
        } else {
            $this->Histories = $histories;
        }
        return $this;
    }
    /**
     * Get Individuals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getIndividuals()
    {
        return isset($this->Individuals) ? $this->Individuals : null;
    }
    /**
     * Set Individuals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $individuals
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setIndividuals(\NexusDigital/MiratelForce\StructType\QueryResult $individuals = null)
    {
        if (is_null($individuals) || (is_array($individuals) && empty($individuals))) {
            unset($this->Individuals);
        } else {
            $this->Individuals = $individuals;
        }
        return $this;
    }
    /**
     * Get IndividualsAge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIndividualsAge()
    {
        return isset($this->IndividualsAge) ? $this->IndividualsAge : null;
    }
    /**
     * Set IndividualsAge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $individualsAge
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setIndividualsAge($individualsAge = null)
    {
        // validation for constraint: string
        if (!is_null($individualsAge) && !is_string($individualsAge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($individualsAge, true), gettype($individualsAge)), __LINE__);
        }
        if (is_null($individualsAge) || (is_array($individualsAge) && empty($individualsAge))) {
            unset($this->IndividualsAge);
        } else {
            $this->IndividualsAge = $individualsAge;
        }
        return $this;
    }
    /**
     * Get InfluencerRating value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInfluencerRating()
    {
        return isset($this->InfluencerRating) ? $this->InfluencerRating : null;
    }
    /**
     * Set InfluencerRating value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $influencerRating
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setInfluencerRating($influencerRating = null)
    {
        // validation for constraint: int
        if (!is_null($influencerRating) && !(is_int($influencerRating) || ctype_digit($influencerRating))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($influencerRating, true), gettype($influencerRating)), __LINE__);
        }
        if (is_null($influencerRating) || (is_array($influencerRating) && empty($influencerRating))) {
            unset($this->InfluencerRating);
        } else {
            $this->InfluencerRating = $influencerRating;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get IsHomeOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHomeOwner()
    {
        return isset($this->IsHomeOwner) ? $this->IsHomeOwner : null;
    }
    /**
     * Set IsHomeOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHomeOwner
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setIsHomeOwner($isHomeOwner = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHomeOwner) && !is_bool($isHomeOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHomeOwner, true), gettype($isHomeOwner)), __LINE__);
        }
        if (is_null($isHomeOwner) || (is_array($isHomeOwner) && empty($isHomeOwner))) {
            unset($this->IsHomeOwner);
        } else {
            $this->IsHomeOwner = $isHomeOwner;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get LastViewedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastViewedDate()
    {
        return isset($this->LastViewedDate) ? $this->LastViewedDate : null;
    }
    /**
     * Set LastViewedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastViewedDate
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setLastViewedDate($lastViewedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastViewedDate) && !is_string($lastViewedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastViewedDate, true), gettype($lastViewedDate)), __LINE__);
        }
        if (is_null($lastViewedDate) || (is_array($lastViewedDate) && empty($lastViewedDate))) {
            unset($this->LastViewedDate);
        } else {
            $this->LastViewedDate = $lastViewedDate;
        }
        return $this;
    }
    /**
     * Get Leads value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getLeads()
    {
        return isset($this->Leads) ? $this->Leads : null;
    }
    /**
     * Set Leads value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $leads
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setLeads(\NexusDigital/MiratelForce\StructType\QueryResult $leads = null)
    {
        if (is_null($leads) || (is_array($leads) && empty($leads))) {
            unset($this->Leads);
        } else {
            $this->Leads = $leads;
        }
        return $this;
    }
    /**
     * Get MasterRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\Individual|null
     */
    public function getMasterRecord()
    {
        return isset($this->MasterRecord) ? $this->MasterRecord : null;
    }
    /**
     * Set MasterRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\Individual $masterRecord
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setMasterRecord(\NexusDigital/MiratelForce\StructType\Individual $masterRecord = null)
    {
        if (is_null($masterRecord) || (is_array($masterRecord) && empty($masterRecord))) {
            unset($this->MasterRecord);
        } else {
            $this->MasterRecord = $masterRecord;
        }
        return $this;
    }
    /**
     * Get MasterRecordId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterRecordId()
    {
        return isset($this->MasterRecordId) ? $this->MasterRecordId : null;
    }
    /**
     * Set MasterRecordId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterRecordId
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setMasterRecordId($masterRecordId = null)
    {
        // validation for constraint: string
        if (!is_null($masterRecordId) && !is_string($masterRecordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterRecordId, true), gettype($masterRecordId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($masterRecordId) && mb_strlen($masterRecordId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($masterRecordId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($masterRecordId) && !preg_match('/[a-zA-Z0-9]{18}/', $masterRecordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($masterRecordId, true)), __LINE__);
        }
        if (is_null($masterRecordId) || (is_array($masterRecordId) && empty($masterRecordId))) {
            unset($this->MasterRecordId);
        } else {
            $this->MasterRecordId = $masterRecordId;
        }
        return $this;
    }
    /**
     * Get MiddleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMiddleName()
    {
        return isset($this->MiddleName) ? $this->MiddleName : null;
    }
    /**
     * Set MiddleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $middleName
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        if (is_null($middleName) || (is_array($middleName) && empty($middleName))) {
            unset($this->MiddleName);
        } else {
            $this->MiddleName = $middleName;
        }
        return $this;
    }
    /**
     * Get MilitaryService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMilitaryService()
    {
        return isset($this->MilitaryService) ? $this->MilitaryService : null;
    }
    /**
     * Set MilitaryService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $militaryService
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setMilitaryService($militaryService = null)
    {
        // validation for constraint: string
        if (!is_null($militaryService) && !is_string($militaryService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($militaryService, true), gettype($militaryService)), __LINE__);
        }
        if (is_null($militaryService) || (is_array($militaryService) && empty($militaryService))) {
            unset($this->MilitaryService);
        } else {
            $this->MilitaryService = $militaryService;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Occupation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOccupation()
    {
        return isset($this->Occupation) ? $this->Occupation : null;
    }
    /**
     * Set Occupation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $occupation
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setOccupation($occupation = null)
    {
        // validation for constraint: string
        if (!is_null($occupation) && !is_string($occupation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($occupation, true), gettype($occupation)), __LINE__);
        }
        if (is_null($occupation) || (is_array($occupation) && empty($occupation))) {
            unset($this->Occupation);
        } else {
            $this->Occupation = $occupation;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $owner
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setOwner(\NexusDigital/MiratelForce\StructType\User $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($ownerId) && mb_strlen($ownerId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($ownerId) && !preg_match('/[a-zA-Z0-9]{18}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get Salutation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalutation()
    {
        return isset($this->Salutation) ? $this->Salutation : null;
    }
    /**
     * Set Salutation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salutation
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setSalutation($salutation = null)
    {
        // validation for constraint: string
        if (!is_null($salutation) && !is_string($salutation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salutation, true), gettype($salutation)), __LINE__);
        }
        if (is_null($salutation) || (is_array($salutation) && empty($salutation))) {
            unset($this->Salutation);
        } else {
            $this->Salutation = $salutation;
        }
        return $this;
    }
    /**
     * Get SendIndividualData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSendIndividualData()
    {
        return isset($this->SendIndividualData) ? $this->SendIndividualData : null;
    }
    /**
     * Set SendIndividualData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sendIndividualData
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setSendIndividualData($sendIndividualData = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendIndividualData) && !is_bool($sendIndividualData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendIndividualData, true), gettype($sendIndividualData)), __LINE__);
        }
        if (is_null($sendIndividualData) || (is_array($sendIndividualData) && empty($sendIndividualData))) {
            unset($this->SendIndividualData);
        } else {
            $this->SendIndividualData = $sendIndividualData;
        }
        return $this;
    }
    /**
     * Get Shares value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getShares()
    {
        return isset($this->Shares) ? $this->Shares : null;
    }
    /**
     * Set Shares value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $shares
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setShares(\NexusDigital/MiratelForce\StructType\QueryResult $shares = null)
    {
        if (is_null($shares) || (is_array($shares) && empty($shares))) {
            unset($this->Shares);
        } else {
            $this->Shares = $shares;
        }
        return $this;
    }
    /**
     * Get ShouldForget value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShouldForget()
    {
        return isset($this->ShouldForget) ? $this->ShouldForget : null;
    }
    /**
     * Set ShouldForget value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $shouldForget
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setShouldForget($shouldForget = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldForget) && !is_bool($shouldForget)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldForget, true), gettype($shouldForget)), __LINE__);
        }
        if (is_null($shouldForget) || (is_array($shouldForget) && empty($shouldForget))) {
            unset($this->ShouldForget);
        } else {
            $this->ShouldForget = $shouldForget;
        }
        return $this;
    }
    /**
     * Get Suffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSuffix()
    {
        return isset($this->Suffix) ? $this->Suffix : null;
    }
    /**
     * Set Suffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $suffix
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setSuffix($suffix = null)
    {
        // validation for constraint: string
        if (!is_null($suffix) && !is_string($suffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suffix, true), gettype($suffix)), __LINE__);
        }
        if (is_null($suffix) || (is_array($suffix) && empty($suffix))) {
            unset($this->Suffix);
        } else {
            $this->Suffix = $suffix;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get Website value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebsite()
    {
        return isset($this->Website) ? $this->Website : null;
    }
    /**
     * Set Website value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $website
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public function setWebsite($website = null)
    {
        // validation for constraint: string
        if (!is_null($website) && !is_string($website)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($website, true), gettype($website)), __LINE__);
        }
        if (is_null($website) || (is_array($website) && empty($website))) {
            unset($this->Website);
        } else {
            $this->Website = $website;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\Individual
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
