<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ForecastingUserPreference StructType
 * @subpackage Structs
 */
class ForecastingUserPreference extends SObject
{
    /**
     * The ExternalId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalId;
    /**
     * The ForecastingDisplayedType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ForecastingType
     */
    public $ForecastingDisplayedType;
    /**
     * The ForecastingDisplayedTypeId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ForecastingDisplayedTypeId;
    /**
     * The ForecastingPeriodDuration
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ForecastingPeriodDuration;
    /**
     * The ForecastingPeriodType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForecastingPeriodType;
    /**
     * The ForecastingStartPeriod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ForecastingStartPeriod;
    /**
     * The ForecastingViewCurrency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForecastingViewCurrency;
    /**
     * The IsForecastingHideZeroRows
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsForecastingHideZeroRows;
    /**
     * The IsForecastingShowQuantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsForecastingShowQuantity;
    /**
     * The IsHideForecastingGuidedTour
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHideForecastingGuidedTour;
    /**
     * The IsHideForecastingQuotaColumn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHideForecastingQuotaColumn;
    /**
     * The IsShowForecastingQuotaAttainment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsShowForecastingQuotaAttainment;
    /**
     * Constructor method for ForecastingUserPreference
     * @uses ForecastingUserPreference::setExternalId()
     * @uses ForecastingUserPreference::setForecastingDisplayedType()
     * @uses ForecastingUserPreference::setForecastingDisplayedTypeId()
     * @uses ForecastingUserPreference::setForecastingPeriodDuration()
     * @uses ForecastingUserPreference::setForecastingPeriodType()
     * @uses ForecastingUserPreference::setForecastingStartPeriod()
     * @uses ForecastingUserPreference::setForecastingViewCurrency()
     * @uses ForecastingUserPreference::setIsForecastingHideZeroRows()
     * @uses ForecastingUserPreference::setIsForecastingShowQuantity()
     * @uses ForecastingUserPreference::setIsHideForecastingGuidedTour()
     * @uses ForecastingUserPreference::setIsHideForecastingQuotaColumn()
     * @uses ForecastingUserPreference::setIsShowForecastingQuotaAttainment()
     * @param string $externalId
     * @param \NexusDigital/MiratelForce\StructType\ForecastingType $forecastingDisplayedType
     * @param string $forecastingDisplayedTypeId
     * @param int $forecastingPeriodDuration
     * @param string $forecastingPeriodType
     * @param int $forecastingStartPeriod
     * @param string $forecastingViewCurrency
     * @param bool $isForecastingHideZeroRows
     * @param bool $isForecastingShowQuantity
     * @param bool $isHideForecastingGuidedTour
     * @param bool $isHideForecastingQuotaColumn
     * @param bool $isShowForecastingQuotaAttainment
     */
    public function __construct($externalId = null, \NexusDigital/MiratelForce\StructType\ForecastingType $forecastingDisplayedType = null, $forecastingDisplayedTypeId = null, $forecastingPeriodDuration = null, $forecastingPeriodType = null, $forecastingStartPeriod = null, $forecastingViewCurrency = null, $isForecastingHideZeroRows = null, $isForecastingShowQuantity = null, $isHideForecastingGuidedTour = null, $isHideForecastingQuotaColumn = null, $isShowForecastingQuotaAttainment = null)
    {
        $this
            ->setExternalId($externalId)
            ->setForecastingDisplayedType($forecastingDisplayedType)
            ->setForecastingDisplayedTypeId($forecastingDisplayedTypeId)
            ->setForecastingPeriodDuration($forecastingPeriodDuration)
            ->setForecastingPeriodType($forecastingPeriodType)
            ->setForecastingStartPeriod($forecastingStartPeriod)
            ->setForecastingViewCurrency($forecastingViewCurrency)
            ->setIsForecastingHideZeroRows($isForecastingHideZeroRows)
            ->setIsForecastingShowQuantity($isForecastingShowQuantity)
            ->setIsHideForecastingGuidedTour($isHideForecastingGuidedTour)
            ->setIsHideForecastingQuotaColumn($isHideForecastingQuotaColumn)
            ->setIsShowForecastingQuotaAttainment($isShowForecastingQuotaAttainment);
    }
    /**
     * Get ExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalId()
    {
        return isset($this->ExternalId) ? $this->ExternalId : null;
    }
    /**
     * Set ExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalId
     * @return \NexusDigital/MiratelForce\StructType\ForecastingUserPreference
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        if (is_null($externalId) || (is_array($externalId) && empty($externalId))) {
            unset($this->ExternalId);
        } else {
            $this->ExternalId = $externalId;
        }
        return $this;
    }
    /**
     * Get ForecastingDisplayedType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ForecastingType|null
     */
    public function getForecastingDisplayedType()
    {
        return isset($this->ForecastingDisplayedType) ? $this->ForecastingDisplayedType : null;
    }
    /**
     * Set ForecastingDisplayedType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ForecastingType $forecastingDisplayedType
     * @return \NexusDigital/MiratelForce\StructType\ForecastingUserPreference
     */
    public function setForecastingDisplayedType(\NexusDigital/MiratelForce\StructType\ForecastingType $forecastingDisplayedType = null)
    {
        if (is_null($forecastingDisplayedType) || (is_array($forecastingDisplayedType) && empty($forecastingDisplayedType))) {
            unset($this->ForecastingDisplayedType);
        } else {
            $this->ForecastingDisplayedType = $forecastingDisplayedType;
        }
        return $this;
    }
    /**
     * Get ForecastingDisplayedTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForecastingDisplayedTypeId()
    {
        return isset($this->ForecastingDisplayedTypeId) ? $this->ForecastingDisplayedTypeId : null;
    }
    /**
     * Set ForecastingDisplayedTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forecastingDisplayedTypeId
     * @return \NexusDigital/MiratelForce\StructType\ForecastingUserPreference
     */
    public function setForecastingDisplayedTypeId($forecastingDisplayedTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($forecastingDisplayedTypeId) && !is_string($forecastingDisplayedTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastingDisplayedTypeId, true), gettype($forecastingDisplayedTypeId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($forecastingDisplayedTypeId) && mb_strlen($forecastingDisplayedTypeId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($forecastingDisplayedTypeId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($forecastingDisplayedTypeId) && !preg_match('/[a-zA-Z0-9]{18}/', $forecastingDisplayedTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($forecastingDisplayedTypeId, true)), __LINE__);
        }
        if (is_null($forecastingDisplayedTypeId) || (is_array($forecastingDisplayedTypeId) && empty($forecastingDisplayedTypeId))) {
            unset($this->ForecastingDisplayedTypeId);
        } else {
            $this->ForecastingDisplayedTypeId = $forecastingDisplayedTypeId;
        }
        return $this;
    }
    /**
     * Get ForecastingPeriodDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getForecastingPeriodDuration()
    {
        return isset($this->ForecastingPeriodDuration) ? $this->ForecastingPeriodDuration : null;
    }
    /**
     * Set ForecastingPeriodDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $forecastingPeriodDuration
     * @return \NexusDigital/MiratelForce\StructType\ForecastingUserPreference
     */
    public function setForecastingPeriodDuration($forecastingPeriodDuration = null)
    {
        // validation for constraint: int
        if (!is_null($forecastingPeriodDuration) && !(is_int($forecastingPeriodDuration) || ctype_digit($forecastingPeriodDuration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($forecastingPeriodDuration, true), gettype($forecastingPeriodDuration)), __LINE__);
        }
        if (is_null($forecastingPeriodDuration) || (is_array($forecastingPeriodDuration) && empty($forecastingPeriodDuration))) {
            unset($this->ForecastingPeriodDuration);
        } else {
            $this->ForecastingPeriodDuration = $forecastingPeriodDuration;
        }
        return $this;
    }
    /**
     * Get ForecastingPeriodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForecastingPeriodType()
    {
        return isset($this->ForecastingPeriodType) ? $this->ForecastingPeriodType : null;
    }
    /**
     * Set ForecastingPeriodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forecastingPeriodType
     * @return \NexusDigital/MiratelForce\StructType\ForecastingUserPreference
     */
    public function setForecastingPeriodType($forecastingPeriodType = null)
    {
        // validation for constraint: string
        if (!is_null($forecastingPeriodType) && !is_string($forecastingPeriodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastingPeriodType, true), gettype($forecastingPeriodType)), __LINE__);
        }
        if (is_null($forecastingPeriodType) || (is_array($forecastingPeriodType) && empty($forecastingPeriodType))) {
            unset($this->ForecastingPeriodType);
        } else {
            $this->ForecastingPeriodType = $forecastingPeriodType;
        }
        return $this;
    }
    /**
     * Get ForecastingStartPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getForecastingStartPeriod()
    {
        return isset($this->ForecastingStartPeriod) ? $this->ForecastingStartPeriod : null;
    }
    /**
     * Set ForecastingStartPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $forecastingStartPeriod
     * @return \NexusDigital/MiratelForce\StructType\ForecastingUserPreference
     */
    public function setForecastingStartPeriod($forecastingStartPeriod = null)
    {
        // validation for constraint: int
        if (!is_null($forecastingStartPeriod) && !(is_int($forecastingStartPeriod) || ctype_digit($forecastingStartPeriod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($forecastingStartPeriod, true), gettype($forecastingStartPeriod)), __LINE__);
        }
        if (is_null($forecastingStartPeriod) || (is_array($forecastingStartPeriod) && empty($forecastingStartPeriod))) {
            unset($this->ForecastingStartPeriod);
        } else {
            $this->ForecastingStartPeriod = $forecastingStartPeriod;
        }
        return $this;
    }
    /**
     * Get ForecastingViewCurrency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForecastingViewCurrency()
    {
        return isset($this->ForecastingViewCurrency) ? $this->ForecastingViewCurrency : null;
    }
    /**
     * Set ForecastingViewCurrency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forecastingViewCurrency
     * @return \NexusDigital/MiratelForce\StructType\ForecastingUserPreference
     */
    public function setForecastingViewCurrency($forecastingViewCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($forecastingViewCurrency) && !is_string($forecastingViewCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastingViewCurrency, true), gettype($forecastingViewCurrency)), __LINE__);
        }
        if (is_null($forecastingViewCurrency) || (is_array($forecastingViewCurrency) && empty($forecastingViewCurrency))) {
            unset($this->ForecastingViewCurrency);
        } else {
            $this->ForecastingViewCurrency = $forecastingViewCurrency;
        }
        return $this;
    }
    /**
     * Get IsForecastingHideZeroRows value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsForecastingHideZeroRows()
    {
        return isset($this->IsForecastingHideZeroRows) ? $this->IsForecastingHideZeroRows : null;
    }
    /**
     * Set IsForecastingHideZeroRows value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isForecastingHideZeroRows
     * @return \NexusDigital/MiratelForce\StructType\ForecastingUserPreference
     */
    public function setIsForecastingHideZeroRows($isForecastingHideZeroRows = null)
    {
        // validation for constraint: boolean
        if (!is_null($isForecastingHideZeroRows) && !is_bool($isForecastingHideZeroRows)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isForecastingHideZeroRows, true), gettype($isForecastingHideZeroRows)), __LINE__);
        }
        if (is_null($isForecastingHideZeroRows) || (is_array($isForecastingHideZeroRows) && empty($isForecastingHideZeroRows))) {
            unset($this->IsForecastingHideZeroRows);
        } else {
            $this->IsForecastingHideZeroRows = $isForecastingHideZeroRows;
        }
        return $this;
    }
    /**
     * Get IsForecastingShowQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsForecastingShowQuantity()
    {
        return isset($this->IsForecastingShowQuantity) ? $this->IsForecastingShowQuantity : null;
    }
    /**
     * Set IsForecastingShowQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isForecastingShowQuantity
     * @return \NexusDigital/MiratelForce\StructType\ForecastingUserPreference
     */
    public function setIsForecastingShowQuantity($isForecastingShowQuantity = null)
    {
        // validation for constraint: boolean
        if (!is_null($isForecastingShowQuantity) && !is_bool($isForecastingShowQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isForecastingShowQuantity, true), gettype($isForecastingShowQuantity)), __LINE__);
        }
        if (is_null($isForecastingShowQuantity) || (is_array($isForecastingShowQuantity) && empty($isForecastingShowQuantity))) {
            unset($this->IsForecastingShowQuantity);
        } else {
            $this->IsForecastingShowQuantity = $isForecastingShowQuantity;
        }
        return $this;
    }
    /**
     * Get IsHideForecastingGuidedTour value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHideForecastingGuidedTour()
    {
        return isset($this->IsHideForecastingGuidedTour) ? $this->IsHideForecastingGuidedTour : null;
    }
    /**
     * Set IsHideForecastingGuidedTour value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHideForecastingGuidedTour
     * @return \NexusDigital/MiratelForce\StructType\ForecastingUserPreference
     */
    public function setIsHideForecastingGuidedTour($isHideForecastingGuidedTour = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHideForecastingGuidedTour) && !is_bool($isHideForecastingGuidedTour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHideForecastingGuidedTour, true), gettype($isHideForecastingGuidedTour)), __LINE__);
        }
        if (is_null($isHideForecastingGuidedTour) || (is_array($isHideForecastingGuidedTour) && empty($isHideForecastingGuidedTour))) {
            unset($this->IsHideForecastingGuidedTour);
        } else {
            $this->IsHideForecastingGuidedTour = $isHideForecastingGuidedTour;
        }
        return $this;
    }
    /**
     * Get IsHideForecastingQuotaColumn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHideForecastingQuotaColumn()
    {
        return isset($this->IsHideForecastingQuotaColumn) ? $this->IsHideForecastingQuotaColumn : null;
    }
    /**
     * Set IsHideForecastingQuotaColumn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHideForecastingQuotaColumn
     * @return \NexusDigital/MiratelForce\StructType\ForecastingUserPreference
     */
    public function setIsHideForecastingQuotaColumn($isHideForecastingQuotaColumn = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHideForecastingQuotaColumn) && !is_bool($isHideForecastingQuotaColumn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHideForecastingQuotaColumn, true), gettype($isHideForecastingQuotaColumn)), __LINE__);
        }
        if (is_null($isHideForecastingQuotaColumn) || (is_array($isHideForecastingQuotaColumn) && empty($isHideForecastingQuotaColumn))) {
            unset($this->IsHideForecastingQuotaColumn);
        } else {
            $this->IsHideForecastingQuotaColumn = $isHideForecastingQuotaColumn;
        }
        return $this;
    }
    /**
     * Get IsShowForecastingQuotaAttainment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsShowForecastingQuotaAttainment()
    {
        return isset($this->IsShowForecastingQuotaAttainment) ? $this->IsShowForecastingQuotaAttainment : null;
    }
    /**
     * Set IsShowForecastingQuotaAttainment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isShowForecastingQuotaAttainment
     * @return \NexusDigital/MiratelForce\StructType\ForecastingUserPreference
     */
    public function setIsShowForecastingQuotaAttainment($isShowForecastingQuotaAttainment = null)
    {
        // validation for constraint: boolean
        if (!is_null($isShowForecastingQuotaAttainment) && !is_bool($isShowForecastingQuotaAttainment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isShowForecastingQuotaAttainment, true), gettype($isShowForecastingQuotaAttainment)), __LINE__);
        }
        if (is_null($isShowForecastingQuotaAttainment) || (is_array($isShowForecastingQuotaAttainment) && empty($isShowForecastingQuotaAttainment))) {
            unset($this->IsShowForecastingQuotaAttainment);
        } else {
            $this->IsShowForecastingQuotaAttainment = $isShowForecastingQuotaAttainment;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ForecastingUserPreference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
