<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ForecastShare StructType
 * @subpackage Structs
 */
class ForecastShare extends SObject
{
    /**
     * The AccessLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessLevel;
    /**
     * The CanSubmit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanSubmit;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The RowCause
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowCause;
    /**
     * The UserOrGroupId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $UserOrGroupId;
    /**
     * The UserRoleId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $UserRoleId;
    /**
     * Constructor method for ForecastShare
     * @uses ForecastShare::setAccessLevel()
     * @uses ForecastShare::setCanSubmit()
     * @uses ForecastShare::setLastModifiedBy()
     * @uses ForecastShare::setLastModifiedById()
     * @uses ForecastShare::setLastModifiedDate()
     * @uses ForecastShare::setRowCause()
     * @uses ForecastShare::setUserOrGroupId()
     * @uses ForecastShare::setUserRoleId()
     * @param string $accessLevel
     * @param bool $canSubmit
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $rowCause
     * @param string $userOrGroupId
     * @param string $userRoleId
     */
    public function __construct($accessLevel = null, $canSubmit = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $rowCause = null, $userOrGroupId = null, $userRoleId = null)
    {
        $this
            ->setAccessLevel($accessLevel)
            ->setCanSubmit($canSubmit)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setRowCause($rowCause)
            ->setUserOrGroupId($userOrGroupId)
            ->setUserRoleId($userRoleId);
    }
    /**
     * Get AccessLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessLevel()
    {
        return isset($this->AccessLevel) ? $this->AccessLevel : null;
    }
    /**
     * Set AccessLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessLevel
     * @return \NexusDigital/MiratelForce\StructType\ForecastShare
     */
    public function setAccessLevel($accessLevel = null)
    {
        // validation for constraint: string
        if (!is_null($accessLevel) && !is_string($accessLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessLevel, true), gettype($accessLevel)), __LINE__);
        }
        if (is_null($accessLevel) || (is_array($accessLevel) && empty($accessLevel))) {
            unset($this->AccessLevel);
        } else {
            $this->AccessLevel = $accessLevel;
        }
        return $this;
    }
    /**
     * Get CanSubmit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanSubmit()
    {
        return isset($this->CanSubmit) ? $this->CanSubmit : null;
    }
    /**
     * Set CanSubmit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canSubmit
     * @return \NexusDigital/MiratelForce\StructType\ForecastShare
     */
    public function setCanSubmit($canSubmit = null)
    {
        // validation for constraint: boolean
        if (!is_null($canSubmit) && !is_bool($canSubmit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canSubmit, true), gettype($canSubmit)), __LINE__);
        }
        if (is_null($canSubmit) || (is_array($canSubmit) && empty($canSubmit))) {
            unset($this->CanSubmit);
        } else {
            $this->CanSubmit = $canSubmit;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\ForecastShare
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\ForecastShare
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\ForecastShare
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get RowCause value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowCause()
    {
        return isset($this->RowCause) ? $this->RowCause : null;
    }
    /**
     * Set RowCause value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowCause
     * @return \NexusDigital/MiratelForce\StructType\ForecastShare
     */
    public function setRowCause($rowCause = null)
    {
        // validation for constraint: string
        if (!is_null($rowCause) && !is_string($rowCause)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowCause, true), gettype($rowCause)), __LINE__);
        }
        if (is_null($rowCause) || (is_array($rowCause) && empty($rowCause))) {
            unset($this->RowCause);
        } else {
            $this->RowCause = $rowCause;
        }
        return $this;
    }
    /**
     * Get UserOrGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserOrGroupId()
    {
        return isset($this->UserOrGroupId) ? $this->UserOrGroupId : null;
    }
    /**
     * Set UserOrGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userOrGroupId
     * @return \NexusDigital/MiratelForce\StructType\ForecastShare
     */
    public function setUserOrGroupId($userOrGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($userOrGroupId) && !is_string($userOrGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userOrGroupId, true), gettype($userOrGroupId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($userOrGroupId) && mb_strlen($userOrGroupId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($userOrGroupId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($userOrGroupId) && !preg_match('/[a-zA-Z0-9]{18}/', $userOrGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($userOrGroupId, true)), __LINE__);
        }
        if (is_null($userOrGroupId) || (is_array($userOrGroupId) && empty($userOrGroupId))) {
            unset($this->UserOrGroupId);
        } else {
            $this->UserOrGroupId = $userOrGroupId;
        }
        return $this;
    }
    /**
     * Get UserRoleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserRoleId()
    {
        return isset($this->UserRoleId) ? $this->UserRoleId : null;
    }
    /**
     * Set UserRoleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userRoleId
     * @return \NexusDigital/MiratelForce\StructType\ForecastShare
     */
    public function setUserRoleId($userRoleId = null)
    {
        // validation for constraint: string
        if (!is_null($userRoleId) && !is_string($userRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userRoleId, true), gettype($userRoleId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($userRoleId) && mb_strlen($userRoleId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($userRoleId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($userRoleId) && !preg_match('/[a-zA-Z0-9]{18}/', $userRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($userRoleId, true)), __LINE__);
        }
        if (is_null($userRoleId) || (is_array($userRoleId) && empty($userRoleId))) {
            unset($this->UserRoleId);
        } else {
            $this->UserRoleId = $userRoleId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ForecastShare
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
