<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeedTrackedChange StructType
 * @subpackage Structs
 */
class FeedTrackedChange extends SObject
{
    /**
     * The FeedItemId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $FeedItemId;
    /**
     * The FieldName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FieldName;
    /**
     * The NewValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var mixed
     */
    public $NewValue;
    /**
     * The OldValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var mixed
     */
    public $OldValue;
    /**
     * Constructor method for FeedTrackedChange
     * @uses FeedTrackedChange::setFeedItemId()
     * @uses FeedTrackedChange::setFieldName()
     * @uses FeedTrackedChange::setNewValue()
     * @uses FeedTrackedChange::setOldValue()
     * @param string $feedItemId
     * @param string $fieldName
     * @param mixed $newValue
     * @param mixed $oldValue
     */
    public function __construct($feedItemId = null, $fieldName = null, $newValue = null, $oldValue = null)
    {
        $this
            ->setFeedItemId($feedItemId)
            ->setFieldName($fieldName)
            ->setNewValue($newValue)
            ->setOldValue($oldValue);
    }
    /**
     * Get FeedItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFeedItemId()
    {
        return isset($this->FeedItemId) ? $this->FeedItemId : null;
    }
    /**
     * Set FeedItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $feedItemId
     * @return \NexusDigital/MiratelForce\StructType\FeedTrackedChange
     */
    public function setFeedItemId($feedItemId = null)
    {
        // validation for constraint: string
        if (!is_null($feedItemId) && !is_string($feedItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feedItemId, true), gettype($feedItemId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($feedItemId) && mb_strlen($feedItemId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($feedItemId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($feedItemId) && !preg_match('/[a-zA-Z0-9]{18}/', $feedItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($feedItemId, true)), __LINE__);
        }
        if (is_null($feedItemId) || (is_array($feedItemId) && empty($feedItemId))) {
            unset($this->FeedItemId);
        } else {
            $this->FeedItemId = $feedItemId;
        }
        return $this;
    }
    /**
     * Get FieldName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFieldName()
    {
        return isset($this->FieldName) ? $this->FieldName : null;
    }
    /**
     * Set FieldName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fieldName
     * @return \NexusDigital/MiratelForce\StructType\FeedTrackedChange
     */
    public function setFieldName($fieldName = null)
    {
        // validation for constraint: string
        if (!is_null($fieldName) && !is_string($fieldName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldName, true), gettype($fieldName)), __LINE__);
        }
        if (is_null($fieldName) || (is_array($fieldName) && empty($fieldName))) {
            unset($this->FieldName);
        } else {
            $this->FieldName = $fieldName;
        }
        return $this;
    }
    /**
     * Get NewValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return mixed|null
     */
    public function getNewValue()
    {
        return isset($this->NewValue) ? $this->NewValue : null;
    }
    /**
     * Set NewValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param mixed $newValue
     * @return \NexusDigital/MiratelForce\StructType\FeedTrackedChange
     */
    public function setNewValue($newValue = null)
    {
        if (is_null($newValue) || (is_array($newValue) && empty($newValue))) {
            unset($this->NewValue);
        } else {
            $this->NewValue = $newValue;
        }
        return $this;
    }
    /**
     * Get OldValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return mixed|null
     */
    public function getOldValue()
    {
        return isset($this->OldValue) ? $this->OldValue : null;
    }
    /**
     * Set OldValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param mixed $oldValue
     * @return \NexusDigital/MiratelForce\StructType\FeedTrackedChange
     */
    public function setOldValue($oldValue = null)
    {
        if (is_null($oldValue) || (is_array($oldValue) && empty($oldValue))) {
            unset($this->OldValue);
        } else {
            $this->OldValue = $oldValue;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\FeedTrackedChange
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
