<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExternalSocialAccount StructType
 * @subpackage Structs
 */
class ExternalSocialAccount extends SObject
{
    /**
     * The AuthorizedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthorizedBy;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The DataSourceId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataSourceId;
    /**
     * The DefaultResponseAccount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public $DefaultResponseAccount;
    /**
     * The DefaultResponseAccountId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $DefaultResponseAccountId;
    /**
     * The DeveloperName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeveloperName;
    /**
     * The ExternalAccountId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalAccountId;
    /**
     * The ExternalPictureURL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalPictureURL;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsAuthenticated
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAuthenticated;
    /**
     * The IsCaseCreationEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCaseCreationEnabled;
    /**
     * The IsDataSourceActive
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDataSourceActive;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Language;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The MasterLabel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MasterLabel;
    /**
     * The ProfileUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProfileUrl;
    /**
     * The Provider
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Provider;
    /**
     * The ProviderUserId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProviderUserId;
    /**
     * The RuleId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RuleId;
    /**
     * The SetupEntityAccessItems
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $SetupEntityAccessItems;
    /**
     * The SocialPropertyId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SocialPropertyId;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The TopicId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TopicId;
    /**
     * The UniqueName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UniqueName;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Username;
    /**
     * Constructor method for ExternalSocialAccount
     * @uses ExternalSocialAccount::setAuthorizedBy()
     * @uses ExternalSocialAccount::setCreatedBy()
     * @uses ExternalSocialAccount::setCreatedById()
     * @uses ExternalSocialAccount::setCreatedDate()
     * @uses ExternalSocialAccount::setDataSourceId()
     * @uses ExternalSocialAccount::setDefaultResponseAccount()
     * @uses ExternalSocialAccount::setDefaultResponseAccountId()
     * @uses ExternalSocialAccount::setDeveloperName()
     * @uses ExternalSocialAccount::setExternalAccountId()
     * @uses ExternalSocialAccount::setExternalPictureURL()
     * @uses ExternalSocialAccount::setIsActive()
     * @uses ExternalSocialAccount::setIsAuthenticated()
     * @uses ExternalSocialAccount::setIsCaseCreationEnabled()
     * @uses ExternalSocialAccount::setIsDataSourceActive()
     * @uses ExternalSocialAccount::setIsDeleted()
     * @uses ExternalSocialAccount::setLanguage()
     * @uses ExternalSocialAccount::setLastModifiedBy()
     * @uses ExternalSocialAccount::setLastModifiedById()
     * @uses ExternalSocialAccount::setLastModifiedDate()
     * @uses ExternalSocialAccount::setMasterLabel()
     * @uses ExternalSocialAccount::setProfileUrl()
     * @uses ExternalSocialAccount::setProvider()
     * @uses ExternalSocialAccount::setProviderUserId()
     * @uses ExternalSocialAccount::setRuleId()
     * @uses ExternalSocialAccount::setSetupEntityAccessItems()
     * @uses ExternalSocialAccount::setSocialPropertyId()
     * @uses ExternalSocialAccount::setSystemModstamp()
     * @uses ExternalSocialAccount::setTopicId()
     * @uses ExternalSocialAccount::setUniqueName()
     * @uses ExternalSocialAccount::setUsername()
     * @param string $authorizedBy
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $dataSourceId
     * @param \NexusDigital/MiratelForce\StructType\ExternalSocialAccount $defaultResponseAccount
     * @param string $defaultResponseAccountId
     * @param string $developerName
     * @param string $externalAccountId
     * @param string $externalPictureURL
     * @param bool $isActive
     * @param bool $isAuthenticated
     * @param bool $isCaseCreationEnabled
     * @param bool $isDataSourceActive
     * @param bool $isDeleted
     * @param string $language
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $masterLabel
     * @param string $profileUrl
     * @param string $provider
     * @param string $providerUserId
     * @param string $ruleId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $setupEntityAccessItems
     * @param string $socialPropertyId
     * @param string $systemModstamp
     * @param string $topicId
     * @param string $uniqueName
     * @param string $username
     */
    public function __construct($authorizedBy = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $dataSourceId = null, \NexusDigital/MiratelForce\StructType\ExternalSocialAccount $defaultResponseAccount = null, $defaultResponseAccountId = null, $developerName = null, $externalAccountId = null, $externalPictureURL = null, $isActive = null, $isAuthenticated = null, $isCaseCreationEnabled = null, $isDataSourceActive = null, $isDeleted = null, $language = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $masterLabel = null, $profileUrl = null, $provider = null, $providerUserId = null, $ruleId = null, \NexusDigital/MiratelForce\StructType\QueryResult $setupEntityAccessItems = null, $socialPropertyId = null, $systemModstamp = null, $topicId = null, $uniqueName = null, $username = null)
    {
        $this
            ->setAuthorizedBy($authorizedBy)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDataSourceId($dataSourceId)
            ->setDefaultResponseAccount($defaultResponseAccount)
            ->setDefaultResponseAccountId($defaultResponseAccountId)
            ->setDeveloperName($developerName)
            ->setExternalAccountId($externalAccountId)
            ->setExternalPictureURL($externalPictureURL)
            ->setIsActive($isActive)
            ->setIsAuthenticated($isAuthenticated)
            ->setIsCaseCreationEnabled($isCaseCreationEnabled)
            ->setIsDataSourceActive($isDataSourceActive)
            ->setIsDeleted($isDeleted)
            ->setLanguage($language)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setMasterLabel($masterLabel)
            ->setProfileUrl($profileUrl)
            ->setProvider($provider)
            ->setProviderUserId($providerUserId)
            ->setRuleId($ruleId)
            ->setSetupEntityAccessItems($setupEntityAccessItems)
            ->setSocialPropertyId($socialPropertyId)
            ->setSystemModstamp($systemModstamp)
            ->setTopicId($topicId)
            ->setUniqueName($uniqueName)
            ->setUsername($username);
    }
    /**
     * Get AuthorizedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthorizedBy()
    {
        return isset($this->AuthorizedBy) ? $this->AuthorizedBy : null;
    }
    /**
     * Set AuthorizedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authorizedBy
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setAuthorizedBy($authorizedBy = null)
    {
        // validation for constraint: string
        if (!is_null($authorizedBy) && !is_string($authorizedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizedBy, true), gettype($authorizedBy)), __LINE__);
        }
        if (is_null($authorizedBy) || (is_array($authorizedBy) && empty($authorizedBy))) {
            unset($this->AuthorizedBy);
        } else {
            $this->AuthorizedBy = $authorizedBy;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get DataSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataSourceId()
    {
        return isset($this->DataSourceId) ? $this->DataSourceId : null;
    }
    /**
     * Set DataSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataSourceId
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setDataSourceId($dataSourceId = null)
    {
        // validation for constraint: string
        if (!is_null($dataSourceId) && !is_string($dataSourceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataSourceId, true), gettype($dataSourceId)), __LINE__);
        }
        if (is_null($dataSourceId) || (is_array($dataSourceId) && empty($dataSourceId))) {
            unset($this->DataSourceId);
        } else {
            $this->DataSourceId = $dataSourceId;
        }
        return $this;
    }
    /**
     * Get DefaultResponseAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount|null
     */
    public function getDefaultResponseAccount()
    {
        return isset($this->DefaultResponseAccount) ? $this->DefaultResponseAccount : null;
    }
    /**
     * Set DefaultResponseAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ExternalSocialAccount $defaultResponseAccount
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setDefaultResponseAccount(\NexusDigital/MiratelForce\StructType\ExternalSocialAccount $defaultResponseAccount = null)
    {
        if (is_null($defaultResponseAccount) || (is_array($defaultResponseAccount) && empty($defaultResponseAccount))) {
            unset($this->DefaultResponseAccount);
        } else {
            $this->DefaultResponseAccount = $defaultResponseAccount;
        }
        return $this;
    }
    /**
     * Get DefaultResponseAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultResponseAccountId()
    {
        return isset($this->DefaultResponseAccountId) ? $this->DefaultResponseAccountId : null;
    }
    /**
     * Set DefaultResponseAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultResponseAccountId
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setDefaultResponseAccountId($defaultResponseAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultResponseAccountId) && !is_string($defaultResponseAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultResponseAccountId, true), gettype($defaultResponseAccountId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($defaultResponseAccountId) && mb_strlen($defaultResponseAccountId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($defaultResponseAccountId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($defaultResponseAccountId) && !preg_match('/[a-zA-Z0-9]{18}/', $defaultResponseAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($defaultResponseAccountId, true)), __LINE__);
        }
        if (is_null($defaultResponseAccountId) || (is_array($defaultResponseAccountId) && empty($defaultResponseAccountId))) {
            unset($this->DefaultResponseAccountId);
        } else {
            $this->DefaultResponseAccountId = $defaultResponseAccountId;
        }
        return $this;
    }
    /**
     * Get DeveloperName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeveloperName()
    {
        return isset($this->DeveloperName) ? $this->DeveloperName : null;
    }
    /**
     * Set DeveloperName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $developerName
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setDeveloperName($developerName = null)
    {
        // validation for constraint: string
        if (!is_null($developerName) && !is_string($developerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($developerName, true), gettype($developerName)), __LINE__);
        }
        if (is_null($developerName) || (is_array($developerName) && empty($developerName))) {
            unset($this->DeveloperName);
        } else {
            $this->DeveloperName = $developerName;
        }
        return $this;
    }
    /**
     * Get ExternalAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalAccountId()
    {
        return isset($this->ExternalAccountId) ? $this->ExternalAccountId : null;
    }
    /**
     * Set ExternalAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalAccountId
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setExternalAccountId($externalAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($externalAccountId) && !is_string($externalAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalAccountId, true), gettype($externalAccountId)), __LINE__);
        }
        if (is_null($externalAccountId) || (is_array($externalAccountId) && empty($externalAccountId))) {
            unset($this->ExternalAccountId);
        } else {
            $this->ExternalAccountId = $externalAccountId;
        }
        return $this;
    }
    /**
     * Get ExternalPictureURL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalPictureURL()
    {
        return isset($this->ExternalPictureURL) ? $this->ExternalPictureURL : null;
    }
    /**
     * Set ExternalPictureURL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalPictureURL
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setExternalPictureURL($externalPictureURL = null)
    {
        // validation for constraint: string
        if (!is_null($externalPictureURL) && !is_string($externalPictureURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalPictureURL, true), gettype($externalPictureURL)), __LINE__);
        }
        if (is_null($externalPictureURL) || (is_array($externalPictureURL) && empty($externalPictureURL))) {
            unset($this->ExternalPictureURL);
        } else {
            $this->ExternalPictureURL = $externalPictureURL;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsAuthenticated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAuthenticated()
    {
        return isset($this->IsAuthenticated) ? $this->IsAuthenticated : null;
    }
    /**
     * Set IsAuthenticated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAuthenticated
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setIsAuthenticated($isAuthenticated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAuthenticated) && !is_bool($isAuthenticated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAuthenticated, true), gettype($isAuthenticated)), __LINE__);
        }
        if (is_null($isAuthenticated) || (is_array($isAuthenticated) && empty($isAuthenticated))) {
            unset($this->IsAuthenticated);
        } else {
            $this->IsAuthenticated = $isAuthenticated;
        }
        return $this;
    }
    /**
     * Get IsCaseCreationEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCaseCreationEnabled()
    {
        return isset($this->IsCaseCreationEnabled) ? $this->IsCaseCreationEnabled : null;
    }
    /**
     * Set IsCaseCreationEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCaseCreationEnabled
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setIsCaseCreationEnabled($isCaseCreationEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCaseCreationEnabled) && !is_bool($isCaseCreationEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCaseCreationEnabled, true), gettype($isCaseCreationEnabled)), __LINE__);
        }
        if (is_null($isCaseCreationEnabled) || (is_array($isCaseCreationEnabled) && empty($isCaseCreationEnabled))) {
            unset($this->IsCaseCreationEnabled);
        } else {
            $this->IsCaseCreationEnabled = $isCaseCreationEnabled;
        }
        return $this;
    }
    /**
     * Get IsDataSourceActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDataSourceActive()
    {
        return isset($this->IsDataSourceActive) ? $this->IsDataSourceActive : null;
    }
    /**
     * Set IsDataSourceActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDataSourceActive
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setIsDataSourceActive($isDataSourceActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDataSourceActive) && !is_bool($isDataSourceActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDataSourceActive, true), gettype($isDataSourceActive)), __LINE__);
        }
        if (is_null($isDataSourceActive) || (is_array($isDataSourceActive) && empty($isDataSourceActive))) {
            unset($this->IsDataSourceActive);
        } else {
            $this->IsDataSourceActive = $isDataSourceActive;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = $language;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get MasterLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterLabel()
    {
        return isset($this->MasterLabel) ? $this->MasterLabel : null;
    }
    /**
     * Set MasterLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterLabel
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setMasterLabel($masterLabel = null)
    {
        // validation for constraint: string
        if (!is_null($masterLabel) && !is_string($masterLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterLabel, true), gettype($masterLabel)), __LINE__);
        }
        if (is_null($masterLabel) || (is_array($masterLabel) && empty($masterLabel))) {
            unset($this->MasterLabel);
        } else {
            $this->MasterLabel = $masterLabel;
        }
        return $this;
    }
    /**
     * Get ProfileUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProfileUrl()
    {
        return isset($this->ProfileUrl) ? $this->ProfileUrl : null;
    }
    /**
     * Set ProfileUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $profileUrl
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setProfileUrl($profileUrl = null)
    {
        // validation for constraint: string
        if (!is_null($profileUrl) && !is_string($profileUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileUrl, true), gettype($profileUrl)), __LINE__);
        }
        if (is_null($profileUrl) || (is_array($profileUrl) && empty($profileUrl))) {
            unset($this->ProfileUrl);
        } else {
            $this->ProfileUrl = $profileUrl;
        }
        return $this;
    }
    /**
     * Get Provider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvider()
    {
        return isset($this->Provider) ? $this->Provider : null;
    }
    /**
     * Set Provider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provider
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setProvider($provider = null)
    {
        // validation for constraint: string
        if (!is_null($provider) && !is_string($provider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provider, true), gettype($provider)), __LINE__);
        }
        if (is_null($provider) || (is_array($provider) && empty($provider))) {
            unset($this->Provider);
        } else {
            $this->Provider = $provider;
        }
        return $this;
    }
    /**
     * Get ProviderUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProviderUserId()
    {
        return isset($this->ProviderUserId) ? $this->ProviderUserId : null;
    }
    /**
     * Set ProviderUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $providerUserId
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setProviderUserId($providerUserId = null)
    {
        // validation for constraint: string
        if (!is_null($providerUserId) && !is_string($providerUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerUserId, true), gettype($providerUserId)), __LINE__);
        }
        if (is_null($providerUserId) || (is_array($providerUserId) && empty($providerUserId))) {
            unset($this->ProviderUserId);
        } else {
            $this->ProviderUserId = $providerUserId;
        }
        return $this;
    }
    /**
     * Get RuleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRuleId()
    {
        return isset($this->RuleId) ? $this->RuleId : null;
    }
    /**
     * Set RuleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ruleId
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setRuleId($ruleId = null)
    {
        // validation for constraint: string
        if (!is_null($ruleId) && !is_string($ruleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleId, true), gettype($ruleId)), __LINE__);
        }
        if (is_null($ruleId) || (is_array($ruleId) && empty($ruleId))) {
            unset($this->RuleId);
        } else {
            $this->RuleId = $ruleId;
        }
        return $this;
    }
    /**
     * Get SetupEntityAccessItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getSetupEntityAccessItems()
    {
        return isset($this->SetupEntityAccessItems) ? $this->SetupEntityAccessItems : null;
    }
    /**
     * Set SetupEntityAccessItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $setupEntityAccessItems
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setSetupEntityAccessItems(\NexusDigital/MiratelForce\StructType\QueryResult $setupEntityAccessItems = null)
    {
        if (is_null($setupEntityAccessItems) || (is_array($setupEntityAccessItems) && empty($setupEntityAccessItems))) {
            unset($this->SetupEntityAccessItems);
        } else {
            $this->SetupEntityAccessItems = $setupEntityAccessItems;
        }
        return $this;
    }
    /**
     * Get SocialPropertyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSocialPropertyId()
    {
        return isset($this->SocialPropertyId) ? $this->SocialPropertyId : null;
    }
    /**
     * Set SocialPropertyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $socialPropertyId
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setSocialPropertyId($socialPropertyId = null)
    {
        // validation for constraint: string
        if (!is_null($socialPropertyId) && !is_string($socialPropertyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($socialPropertyId, true), gettype($socialPropertyId)), __LINE__);
        }
        if (is_null($socialPropertyId) || (is_array($socialPropertyId) && empty($socialPropertyId))) {
            unset($this->SocialPropertyId);
        } else {
            $this->SocialPropertyId = $socialPropertyId;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get TopicId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTopicId()
    {
        return isset($this->TopicId) ? $this->TopicId : null;
    }
    /**
     * Set TopicId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $topicId
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setTopicId($topicId = null)
    {
        // validation for constraint: string
        if (!is_null($topicId) && !is_string($topicId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($topicId, true), gettype($topicId)), __LINE__);
        }
        if (is_null($topicId) || (is_array($topicId) && empty($topicId))) {
            unset($this->TopicId);
        } else {
            $this->TopicId = $topicId;
        }
        return $this;
    }
    /**
     * Get UniqueName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUniqueName()
    {
        return isset($this->UniqueName) ? $this->UniqueName : null;
    }
    /**
     * Set UniqueName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uniqueName
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setUniqueName($uniqueName = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueName) && !is_string($uniqueName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueName, true), gettype($uniqueName)), __LINE__);
        }
        if (is_null($uniqueName) || (is_array($uniqueName) && empty($uniqueName))) {
            unset($this->UniqueName);
        } else {
            $this->UniqueName = $uniqueName;
        }
        return $this;
    }
    /**
     * Get Username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsername()
    {
        return isset($this->Username) ? $this->Username : null;
    }
    /**
     * Set Username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $username
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        if (is_null($username) || (is_array($username) && empty($username))) {
            unset($this->Username);
        } else {
            $this->Username = $username;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ExternalSocialAccount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
