<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmbeddedServiceLabel StructType
 * @subpackage Structs
 */
class EmbeddedServiceLabel extends SObject
{
    /**
     * The CustomLabelName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomLabelName;
    /**
     * The DurableId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DurableId;
    /**
     * The EmbeddedServiceConfigDeveloperName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmbeddedServiceConfigDeveloperName;
    /**
     * The LabelKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LabelKey;
    /**
     * Constructor method for EmbeddedServiceLabel
     * @uses EmbeddedServiceLabel::setCustomLabelName()
     * @uses EmbeddedServiceLabel::setDurableId()
     * @uses EmbeddedServiceLabel::setEmbeddedServiceConfigDeveloperName()
     * @uses EmbeddedServiceLabel::setLabelKey()
     * @param string $customLabelName
     * @param string $durableId
     * @param string $embeddedServiceConfigDeveloperName
     * @param string $labelKey
     */
    public function __construct($customLabelName = null, $durableId = null, $embeddedServiceConfigDeveloperName = null, $labelKey = null)
    {
        $this
            ->setCustomLabelName($customLabelName)
            ->setDurableId($durableId)
            ->setEmbeddedServiceConfigDeveloperName($embeddedServiceConfigDeveloperName)
            ->setLabelKey($labelKey);
    }
    /**
     * Get CustomLabelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomLabelName()
    {
        return isset($this->CustomLabelName) ? $this->CustomLabelName : null;
    }
    /**
     * Set CustomLabelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customLabelName
     * @return \NexusDigital/MiratelForce\StructType\EmbeddedServiceLabel
     */
    public function setCustomLabelName($customLabelName = null)
    {
        // validation for constraint: string
        if (!is_null($customLabelName) && !is_string($customLabelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customLabelName, true), gettype($customLabelName)), __LINE__);
        }
        if (is_null($customLabelName) || (is_array($customLabelName) && empty($customLabelName))) {
            unset($this->CustomLabelName);
        } else {
            $this->CustomLabelName = $customLabelName;
        }
        return $this;
    }
    /**
     * Get DurableId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDurableId()
    {
        return isset($this->DurableId) ? $this->DurableId : null;
    }
    /**
     * Set DurableId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $durableId
     * @return \NexusDigital/MiratelForce\StructType\EmbeddedServiceLabel
     */
    public function setDurableId($durableId = null)
    {
        // validation for constraint: string
        if (!is_null($durableId) && !is_string($durableId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($durableId, true), gettype($durableId)), __LINE__);
        }
        if (is_null($durableId) || (is_array($durableId) && empty($durableId))) {
            unset($this->DurableId);
        } else {
            $this->DurableId = $durableId;
        }
        return $this;
    }
    /**
     * Get EmbeddedServiceConfigDeveloperName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmbeddedServiceConfigDeveloperName()
    {
        return isset($this->EmbeddedServiceConfigDeveloperName) ? $this->EmbeddedServiceConfigDeveloperName : null;
    }
    /**
     * Set EmbeddedServiceConfigDeveloperName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $embeddedServiceConfigDeveloperName
     * @return \NexusDigital/MiratelForce\StructType\EmbeddedServiceLabel
     */
    public function setEmbeddedServiceConfigDeveloperName($embeddedServiceConfigDeveloperName = null)
    {
        // validation for constraint: string
        if (!is_null($embeddedServiceConfigDeveloperName) && !is_string($embeddedServiceConfigDeveloperName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($embeddedServiceConfigDeveloperName, true), gettype($embeddedServiceConfigDeveloperName)), __LINE__);
        }
        if (is_null($embeddedServiceConfigDeveloperName) || (is_array($embeddedServiceConfigDeveloperName) && empty($embeddedServiceConfigDeveloperName))) {
            unset($this->EmbeddedServiceConfigDeveloperName);
        } else {
            $this->EmbeddedServiceConfigDeveloperName = $embeddedServiceConfigDeveloperName;
        }
        return $this;
    }
    /**
     * Get LabelKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabelKey()
    {
        return isset($this->LabelKey) ? $this->LabelKey : null;
    }
    /**
     * Set LabelKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $labelKey
     * @return \NexusDigital/MiratelForce\StructType\EmbeddedServiceLabel
     */
    public function setLabelKey($labelKey = null)
    {
        // validation for constraint: string
        if (!is_null($labelKey) && !is_string($labelKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelKey, true), gettype($labelKey)), __LINE__);
        }
        if (is_null($labelKey) || (is_array($labelKey) && empty($labelKey))) {
            unset($this->LabelKey);
        } else {
            $this->LabelKey = $labelKey;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\EmbeddedServiceLabel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
