<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmailServicesFunction StructType
 * @subpackage Structs
 */
class EmailServicesFunction extends SObject
{
    /**
     * The AddressInactiveAction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressInactiveAction;
    /**
     * The Addresses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Addresses;
    /**
     * The ApexClassId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ApexClassId;
    /**
     * The AttachmentOption
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AttachmentOption;
    /**
     * The AuthenticationFailureAction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthenticationFailureAction;
    /**
     * The AuthorizationFailureAction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthorizationFailureAction;
    /**
     * The AuthorizedSenders
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthorizedSenders;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The ErrorRoutingAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorRoutingAddress;
    /**
     * The FunctionInactiveAction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FunctionInactiveAction;
    /**
     * The FunctionName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FunctionName;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsAuthenticationRequired
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAuthenticationRequired;
    /**
     * The IsErrorRoutingEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsErrorRoutingEnabled;
    /**
     * The IsTextAttachmentsAsBinary
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTextAttachmentsAsBinary;
    /**
     * The IsTlsRequired
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTlsRequired;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The OverLimitAction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OverLimitAction;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * Constructor method for EmailServicesFunction
     * @uses EmailServicesFunction::setAddressInactiveAction()
     * @uses EmailServicesFunction::setAddresses()
     * @uses EmailServicesFunction::setApexClassId()
     * @uses EmailServicesFunction::setAttachmentOption()
     * @uses EmailServicesFunction::setAuthenticationFailureAction()
     * @uses EmailServicesFunction::setAuthorizationFailureAction()
     * @uses EmailServicesFunction::setAuthorizedSenders()
     * @uses EmailServicesFunction::setCreatedBy()
     * @uses EmailServicesFunction::setCreatedById()
     * @uses EmailServicesFunction::setCreatedDate()
     * @uses EmailServicesFunction::setErrorRoutingAddress()
     * @uses EmailServicesFunction::setFunctionInactiveAction()
     * @uses EmailServicesFunction::setFunctionName()
     * @uses EmailServicesFunction::setIsActive()
     * @uses EmailServicesFunction::setIsAuthenticationRequired()
     * @uses EmailServicesFunction::setIsErrorRoutingEnabled()
     * @uses EmailServicesFunction::setIsTextAttachmentsAsBinary()
     * @uses EmailServicesFunction::setIsTlsRequired()
     * @uses EmailServicesFunction::setLastModifiedBy()
     * @uses EmailServicesFunction::setLastModifiedById()
     * @uses EmailServicesFunction::setLastModifiedDate()
     * @uses EmailServicesFunction::setOverLimitAction()
     * @uses EmailServicesFunction::setSystemModstamp()
     * @param string $addressInactiveAction
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $addresses
     * @param string $apexClassId
     * @param string $attachmentOption
     * @param string $authenticationFailureAction
     * @param string $authorizationFailureAction
     * @param string $authorizedSenders
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $errorRoutingAddress
     * @param string $functionInactiveAction
     * @param string $functionName
     * @param bool $isActive
     * @param bool $isAuthenticationRequired
     * @param bool $isErrorRoutingEnabled
     * @param bool $isTextAttachmentsAsBinary
     * @param bool $isTlsRequired
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $overLimitAction
     * @param string $systemModstamp
     */
    public function __construct($addressInactiveAction = null, \NexusDigital/MiratelForce\StructType\QueryResult $addresses = null, $apexClassId = null, $attachmentOption = null, $authenticationFailureAction = null, $authorizationFailureAction = null, $authorizedSenders = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $errorRoutingAddress = null, $functionInactiveAction = null, $functionName = null, $isActive = null, $isAuthenticationRequired = null, $isErrorRoutingEnabled = null, $isTextAttachmentsAsBinary = null, $isTlsRequired = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $overLimitAction = null, $systemModstamp = null)
    {
        $this
            ->setAddressInactiveAction($addressInactiveAction)
            ->setAddresses($addresses)
            ->setApexClassId($apexClassId)
            ->setAttachmentOption($attachmentOption)
            ->setAuthenticationFailureAction($authenticationFailureAction)
            ->setAuthorizationFailureAction($authorizationFailureAction)
            ->setAuthorizedSenders($authorizedSenders)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setErrorRoutingAddress($errorRoutingAddress)
            ->setFunctionInactiveAction($functionInactiveAction)
            ->setFunctionName($functionName)
            ->setIsActive($isActive)
            ->setIsAuthenticationRequired($isAuthenticationRequired)
            ->setIsErrorRoutingEnabled($isErrorRoutingEnabled)
            ->setIsTextAttachmentsAsBinary($isTextAttachmentsAsBinary)
            ->setIsTlsRequired($isTlsRequired)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setOverLimitAction($overLimitAction)
            ->setSystemModstamp($systemModstamp);
    }
    /**
     * Get AddressInactiveAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressInactiveAction()
    {
        return isset($this->AddressInactiveAction) ? $this->AddressInactiveAction : null;
    }
    /**
     * Set AddressInactiveAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressInactiveAction
     * @return \NexusDigital/MiratelForce\StructType\EmailServicesFunction
     */
    public function setAddressInactiveAction($addressInactiveAction = null)
    {
        // validation for constraint: string
        if (!is_null($addressInactiveAction) && !is_string($addressInactiveAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressInactiveAction, true), gettype($addressInactiveAction)), __LINE__);
        }
        if (is_null($addressInactiveAction) || (is_array($addressInactiveAction) && empty($addressInactiveAction))) {
            unset($this->AddressInactiveAction);
        } else {
            $this->AddressInactiveAction = $addressInactiveAction;
        }
        return $this;
    }
    /**
     * Get Addresses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAddresses()
    {
        return isset($this->Addresses) ? $this->Addresses : null;
    }
    /**
     * Set Addresses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $addresses
     * @return \NexusDigital/MiratelForce\StructType\EmailServicesFunction
     */
    public function setAddresses(\NexusDigital/MiratelForce\StructType\QueryResult $addresses = null)
    {
        if (is_null($addresses) || (is_array($addresses) && empty($addresses))) {
            unset($this->Addresses);
        } else {
            $this->Addresses = $addresses;
        }
        return $this;
    }
    /**
     * Get ApexClassId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApexClassId()
    {
        return isset($this->ApexClassId) ? $this->ApexClassId : null;
    }
    /**
     * Set ApexClassId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apexClassId
     * @return \NexusDigital/MiratelForce\StructType\EmailServicesFunction
     */
    public function setApexClassId($apexClassId = null)
    {
        // validation for constraint: string
        if (!is_null($apexClassId) && !is_string($apexClassId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apexClassId, true), gettype($apexClassId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($apexClassId) && mb_strlen($apexClassId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($apexClassId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($apexClassId) && !preg_match('/[a-zA-Z0-9]{18}/', $apexClassId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($apexClassId, true)), __LINE__);
        }
        if (is_null($apexClassId) || (is_array($apexClassId) && empty($apexClassId))) {
            unset($this->ApexClassId);
        } else {
            $this->ApexClassId = $apexClassId;
        }
        return $this;
    }
    /**
     * Get AttachmentOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttachmentOption()
    {
        return isset($this->AttachmentOption) ? $this->AttachmentOption : null;
    }
    /**
     * Set AttachmentOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attachmentOption
     * @return \NexusDigital/MiratelForce\StructType\EmailServicesFunction
     */
    public function setAttachmentOption($attachmentOption = null)
    {
        // validation for constraint: string
        if (!is_null($attachmentOption) && !is_string($attachmentOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachmentOption, true), gettype($attachmentOption)), __LINE__);
        }
        if (is_null($attachmentOption) || (is_array($attachmentOption) && empty($attachmentOption))) {
            unset($this->AttachmentOption);
        } else {
            $this->AttachmentOption = $attachmentOption;
        }
        return $this;
    }
    /**
     * Get AuthenticationFailureAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthenticationFailureAction()
    {
        return isset($this->AuthenticationFailureAction) ? $this->AuthenticationFailureAction : null;
    }
    /**
     * Set AuthenticationFailureAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authenticationFailureAction
     * @return \NexusDigital/MiratelForce\StructType\EmailServicesFunction
     */
    public function setAuthenticationFailureAction($authenticationFailureAction = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationFailureAction) && !is_string($authenticationFailureAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authenticationFailureAction, true), gettype($authenticationFailureAction)), __LINE__);
        }
        if (is_null($authenticationFailureAction) || (is_array($authenticationFailureAction) && empty($authenticationFailureAction))) {
            unset($this->AuthenticationFailureAction);
        } else {
            $this->AuthenticationFailureAction = $authenticationFailureAction;
        }
        return $this;
    }
    /**
     * Get AuthorizationFailureAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthorizationFailureAction()
    {
        return isset($this->AuthorizationFailureAction) ? $this->AuthorizationFailureAction : null;
    }
    /**
     * Set AuthorizationFailureAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authorizationFailureAction
     * @return \NexusDigital/MiratelForce\StructType\EmailServicesFunction
     */
    public function setAuthorizationFailureAction($authorizationFailureAction = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationFailureAction) && !is_string($authorizationFailureAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationFailureAction, true), gettype($authorizationFailureAction)), __LINE__);
        }
        if (is_null($authorizationFailureAction) || (is_array($authorizationFailureAction) && empty($authorizationFailureAction))) {
            unset($this->AuthorizationFailureAction);
        } else {
            $this->AuthorizationFailureAction = $authorizationFailureAction;
        }
        return $this;
    }
    /**
     * Get AuthorizedSenders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthorizedSenders()
    {
        return isset($this->AuthorizedSenders) ? $this->AuthorizedSenders : null;
    }
    /**
     * Set AuthorizedSenders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authorizedSenders
     * @return \NexusDigital/MiratelForce\StructType\EmailServicesFunction
     */
    public function setAuthorizedSenders($authorizedSenders = null)
    {
        // validation for constraint: string
        if (!is_null($authorizedSenders) && !is_string($authorizedSenders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizedSenders, true), gettype($authorizedSenders)), __LINE__);
        }
        if (is_null($authorizedSenders) || (is_array($authorizedSenders) && empty($authorizedSenders))) {
            unset($this->AuthorizedSenders);
        } else {
            $this->AuthorizedSenders = $authorizedSenders;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\EmailServicesFunction
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\EmailServicesFunction
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\EmailServicesFunction
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get ErrorRoutingAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorRoutingAddress()
    {
        return isset($this->ErrorRoutingAddress) ? $this->ErrorRoutingAddress : null;
    }
    /**
     * Set ErrorRoutingAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorRoutingAddress
     * @return \NexusDigital/MiratelForce\StructType\EmailServicesFunction
     */
    public function setErrorRoutingAddress($errorRoutingAddress = null)
    {
        // validation for constraint: string
        if (!is_null($errorRoutingAddress) && !is_string($errorRoutingAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorRoutingAddress, true), gettype($errorRoutingAddress)), __LINE__);
        }
        if (is_null($errorRoutingAddress) || (is_array($errorRoutingAddress) && empty($errorRoutingAddress))) {
            unset($this->ErrorRoutingAddress);
        } else {
            $this->ErrorRoutingAddress = $errorRoutingAddress;
        }
        return $this;
    }
    /**
     * Get FunctionInactiveAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFunctionInactiveAction()
    {
        return isset($this->FunctionInactiveAction) ? $this->FunctionInactiveAction : null;
    }
    /**
     * Set FunctionInactiveAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $functionInactiveAction
     * @return \NexusDigital/MiratelForce\StructType\EmailServicesFunction
     */
    public function setFunctionInactiveAction($functionInactiveAction = null)
    {
        // validation for constraint: string
        if (!is_null($functionInactiveAction) && !is_string($functionInactiveAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($functionInactiveAction, true), gettype($functionInactiveAction)), __LINE__);
        }
        if (is_null($functionInactiveAction) || (is_array($functionInactiveAction) && empty($functionInactiveAction))) {
            unset($this->FunctionInactiveAction);
        } else {
            $this->FunctionInactiveAction = $functionInactiveAction;
        }
        return $this;
    }
    /**
     * Get FunctionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFunctionName()
    {
        return isset($this->FunctionName) ? $this->FunctionName : null;
    }
    /**
     * Set FunctionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $functionName
     * @return \NexusDigital/MiratelForce\StructType\EmailServicesFunction
     */
    public function setFunctionName($functionName = null)
    {
        // validation for constraint: string
        if (!is_null($functionName) && !is_string($functionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($functionName, true), gettype($functionName)), __LINE__);
        }
        if (is_null($functionName) || (is_array($functionName) && empty($functionName))) {
            unset($this->FunctionName);
        } else {
            $this->FunctionName = $functionName;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \NexusDigital/MiratelForce\StructType\EmailServicesFunction
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsAuthenticationRequired value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAuthenticationRequired()
    {
        return isset($this->IsAuthenticationRequired) ? $this->IsAuthenticationRequired : null;
    }
    /**
     * Set IsAuthenticationRequired value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAuthenticationRequired
     * @return \NexusDigital/MiratelForce\StructType\EmailServicesFunction
     */
    public function setIsAuthenticationRequired($isAuthenticationRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAuthenticationRequired) && !is_bool($isAuthenticationRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAuthenticationRequired, true), gettype($isAuthenticationRequired)), __LINE__);
        }
        if (is_null($isAuthenticationRequired) || (is_array($isAuthenticationRequired) && empty($isAuthenticationRequired))) {
            unset($this->IsAuthenticationRequired);
        } else {
            $this->IsAuthenticationRequired = $isAuthenticationRequired;
        }
        return $this;
    }
    /**
     * Get IsErrorRoutingEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsErrorRoutingEnabled()
    {
        return isset($this->IsErrorRoutingEnabled) ? $this->IsErrorRoutingEnabled : null;
    }
    /**
     * Set IsErrorRoutingEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isErrorRoutingEnabled
     * @return \NexusDigital/MiratelForce\StructType\EmailServicesFunction
     */
    public function setIsErrorRoutingEnabled($isErrorRoutingEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isErrorRoutingEnabled) && !is_bool($isErrorRoutingEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isErrorRoutingEnabled, true), gettype($isErrorRoutingEnabled)), __LINE__);
        }
        if (is_null($isErrorRoutingEnabled) || (is_array($isErrorRoutingEnabled) && empty($isErrorRoutingEnabled))) {
            unset($this->IsErrorRoutingEnabled);
        } else {
            $this->IsErrorRoutingEnabled = $isErrorRoutingEnabled;
        }
        return $this;
    }
    /**
     * Get IsTextAttachmentsAsBinary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTextAttachmentsAsBinary()
    {
        return isset($this->IsTextAttachmentsAsBinary) ? $this->IsTextAttachmentsAsBinary : null;
    }
    /**
     * Set IsTextAttachmentsAsBinary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTextAttachmentsAsBinary
     * @return \NexusDigital/MiratelForce\StructType\EmailServicesFunction
     */
    public function setIsTextAttachmentsAsBinary($isTextAttachmentsAsBinary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTextAttachmentsAsBinary) && !is_bool($isTextAttachmentsAsBinary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTextAttachmentsAsBinary, true), gettype($isTextAttachmentsAsBinary)), __LINE__);
        }
        if (is_null($isTextAttachmentsAsBinary) || (is_array($isTextAttachmentsAsBinary) && empty($isTextAttachmentsAsBinary))) {
            unset($this->IsTextAttachmentsAsBinary);
        } else {
            $this->IsTextAttachmentsAsBinary = $isTextAttachmentsAsBinary;
        }
        return $this;
    }
    /**
     * Get IsTlsRequired value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTlsRequired()
    {
        return isset($this->IsTlsRequired) ? $this->IsTlsRequired : null;
    }
    /**
     * Set IsTlsRequired value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTlsRequired
     * @return \NexusDigital/MiratelForce\StructType\EmailServicesFunction
     */
    public function setIsTlsRequired($isTlsRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTlsRequired) && !is_bool($isTlsRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTlsRequired, true), gettype($isTlsRequired)), __LINE__);
        }
        if (is_null($isTlsRequired) || (is_array($isTlsRequired) && empty($isTlsRequired))) {
            unset($this->IsTlsRequired);
        } else {
            $this->IsTlsRequired = $isTlsRequired;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\EmailServicesFunction
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\EmailServicesFunction
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\EmailServicesFunction
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get OverLimitAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOverLimitAction()
    {
        return isset($this->OverLimitAction) ? $this->OverLimitAction : null;
    }
    /**
     * Set OverLimitAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $overLimitAction
     * @return \NexusDigital/MiratelForce\StructType\EmailServicesFunction
     */
    public function setOverLimitAction($overLimitAction = null)
    {
        // validation for constraint: string
        if (!is_null($overLimitAction) && !is_string($overLimitAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overLimitAction, true), gettype($overLimitAction)), __LINE__);
        }
        if (is_null($overLimitAction) || (is_array($overLimitAction) && empty($overLimitAction))) {
            unset($this->OverLimitAction);
        } else {
            $this->OverLimitAction = $overLimitAction;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\EmailServicesFunction
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\EmailServicesFunction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
