<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmailMessage StructType
 * @subpackage Structs
 */
class EmailMessage extends SObject
{
    /**
     * The ActivityId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ActivityId;
    /**
     * The AttachedContentDocuments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AttachedContentDocuments;
    /**
     * The AttachedContentNotes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $AttachedContentNotes;
    /**
     * The Attachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $Attachments;
    /**
     * The BccAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BccAddress;
    /**
     * The BccIds
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string[]
     */
    public $BccIds;
    /**
     * The CcAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CcAddress;
    /**
     * The CcIds
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string[]
     */
    public $CcIds;
    /**
     * The CombinedAttachments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $CombinedAttachments;
    /**
     * The ContentDocumentIds
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string[]
     */
    public $ContentDocumentIds;
    /**
     * The ContentDocumentLinks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ContentDocumentLinks;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The EmailMessageRelations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $EmailMessageRelations;
    /**
     * The EmailTemplate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\EmailTemplate
     */
    public $EmailTemplate;
    /**
     * The EmailTemplateId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $EmailTemplateId;
    /**
     * The FirstOpenedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstOpenedDate;
    /**
     * The FromAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromAddress;
    /**
     * The FromName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromName;
    /**
     * The HasAttachment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasAttachment;
    /**
     * The Headers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Headers;
    /**
     * The HtmlBody
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HtmlBody;
    /**
     * The Incoming
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Incoming;
    /**
     * The IsBounced
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsBounced;
    /**
     * The IsClientManaged
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsClientManaged;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsExternallyVisible
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExternallyVisible;
    /**
     * The IsOpened
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOpened;
    /**
     * The IsTracked
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTracked;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastOpenedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastOpenedDate;
    /**
     * The MessageDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MessageDate;
    /**
     * The MessageIdentifier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MessageIdentifier;
    /**
     * The Parent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\_Case
     */
    public $Parent;
    /**
     * The ParentId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ParentId;
    /**
     * The ProcessInstances
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ProcessInstances;
    /**
     * The ProcessSteps
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ProcessSteps;
    /**
     * The RelatedTo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $RelatedTo;
    /**
     * The RelatedToId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $RelatedToId;
    /**
     * The ReplyToEmailMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public $ReplyToEmailMessage;
    /**
     * The ReplyToEmailMessageId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ReplyToEmailMessageId;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The Subject
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Subject;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The TextBody
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TextBody;
    /**
     * The ThreadIdentifier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ThreadIdentifier;
    /**
     * The ToAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToAddress;
    /**
     * The ToIds
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string[]
     */
    public $ToIds;
    /**
     * The ValidatedFromAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidatedFromAddress;
    /**
     * Constructor method for EmailMessage
     * @uses EmailMessage::setActivityId()
     * @uses EmailMessage::setAttachedContentDocuments()
     * @uses EmailMessage::setAttachedContentNotes()
     * @uses EmailMessage::setAttachments()
     * @uses EmailMessage::setBccAddress()
     * @uses EmailMessage::setBccIds()
     * @uses EmailMessage::setCcAddress()
     * @uses EmailMessage::setCcIds()
     * @uses EmailMessage::setCombinedAttachments()
     * @uses EmailMessage::setContentDocumentIds()
     * @uses EmailMessage::setContentDocumentLinks()
     * @uses EmailMessage::setCreatedBy()
     * @uses EmailMessage::setCreatedById()
     * @uses EmailMessage::setCreatedDate()
     * @uses EmailMessage::setEmailMessageRelations()
     * @uses EmailMessage::setEmailTemplate()
     * @uses EmailMessage::setEmailTemplateId()
     * @uses EmailMessage::setFirstOpenedDate()
     * @uses EmailMessage::setFromAddress()
     * @uses EmailMessage::setFromName()
     * @uses EmailMessage::setHasAttachment()
     * @uses EmailMessage::setHeaders()
     * @uses EmailMessage::setHtmlBody()
     * @uses EmailMessage::setIncoming()
     * @uses EmailMessage::setIsBounced()
     * @uses EmailMessage::setIsClientManaged()
     * @uses EmailMessage::setIsDeleted()
     * @uses EmailMessage::setIsExternallyVisible()
     * @uses EmailMessage::setIsOpened()
     * @uses EmailMessage::setIsTracked()
     * @uses EmailMessage::setLastModifiedBy()
     * @uses EmailMessage::setLastModifiedById()
     * @uses EmailMessage::setLastModifiedDate()
     * @uses EmailMessage::setLastOpenedDate()
     * @uses EmailMessage::setMessageDate()
     * @uses EmailMessage::setMessageIdentifier()
     * @uses EmailMessage::setParent()
     * @uses EmailMessage::setParentId()
     * @uses EmailMessage::setProcessInstances()
     * @uses EmailMessage::setProcessSteps()
     * @uses EmailMessage::setRelatedTo()
     * @uses EmailMessage::setRelatedToId()
     * @uses EmailMessage::setReplyToEmailMessage()
     * @uses EmailMessage::setReplyToEmailMessageId()
     * @uses EmailMessage::setStatus()
     * @uses EmailMessage::setSubject()
     * @uses EmailMessage::setSystemModstamp()
     * @uses EmailMessage::setTextBody()
     * @uses EmailMessage::setThreadIdentifier()
     * @uses EmailMessage::setToAddress()
     * @uses EmailMessage::setToIds()
     * @uses EmailMessage::setValidatedFromAddress()
     * @param string $activityId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachments
     * @param string $bccAddress
     * @param string[] $bccIds
     * @param string $ccAddress
     * @param string[] $ccIds
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments
     * @param string[] $contentDocumentIds
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $emailMessageRelations
     * @param \NexusDigital/MiratelForce\StructType\EmailTemplate $emailTemplate
     * @param string $emailTemplateId
     * @param string $firstOpenedDate
     * @param string $fromAddress
     * @param string $fromName
     * @param bool $hasAttachment
     * @param string $headers
     * @param string $htmlBody
     * @param bool $incoming
     * @param bool $isBounced
     * @param bool $isClientManaged
     * @param bool $isDeleted
     * @param bool $isExternallyVisible
     * @param bool $isOpened
     * @param bool $isTracked
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $lastOpenedDate
     * @param string $messageDate
     * @param string $messageIdentifier
     * @param \NexusDigital/MiratelForce\StructType\_Case $parent
     * @param string $parentId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processInstances
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processSteps
     * @param \NexusDigital/MiratelForce\StructType\SObject $relatedTo
     * @param string $relatedToId
     * @param \NexusDigital/MiratelForce\StructType\EmailMessage $replyToEmailMessage
     * @param string $replyToEmailMessageId
     * @param string $status
     * @param string $subject
     * @param string $systemModstamp
     * @param string $textBody
     * @param string $threadIdentifier
     * @param string $toAddress
     * @param string[] $toIds
     * @param string $validatedFromAddress
     */
    public function __construct($activityId = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes = null, \NexusDigital/MiratelForce\StructType\QueryResult $attachments = null, $bccAddress = null, array $bccIds = array(), $ccAddress = null, array $ccIds = array(), \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments = null, array $contentDocumentIds = array(), \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, \NexusDigital/MiratelForce\StructType\QueryResult $emailMessageRelations = null, \NexusDigital/MiratelForce\StructType\EmailTemplate $emailTemplate = null, $emailTemplateId = null, $firstOpenedDate = null, $fromAddress = null, $fromName = null, $hasAttachment = null, $headers = null, $htmlBody = null, $incoming = null, $isBounced = null, $isClientManaged = null, $isDeleted = null, $isExternallyVisible = null, $isOpened = null, $isTracked = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $lastOpenedDate = null, $messageDate = null, $messageIdentifier = null, \NexusDigital/MiratelForce\StructType\_Case $parent = null, $parentId = null, \NexusDigital/MiratelForce\StructType\QueryResult $processInstances = null, \NexusDigital/MiratelForce\StructType\QueryResult $processSteps = null, \NexusDigital/MiratelForce\StructType\SObject $relatedTo = null, $relatedToId = null, \NexusDigital/MiratelForce\StructType\EmailMessage $replyToEmailMessage = null, $replyToEmailMessageId = null, $status = null, $subject = null, $systemModstamp = null, $textBody = null, $threadIdentifier = null, $toAddress = null, array $toIds = array(), $validatedFromAddress = null)
    {
        $this
            ->setActivityId($activityId)
            ->setAttachedContentDocuments($attachedContentDocuments)
            ->setAttachedContentNotes($attachedContentNotes)
            ->setAttachments($attachments)
            ->setBccAddress($bccAddress)
            ->setBccIds($bccIds)
            ->setCcAddress($ccAddress)
            ->setCcIds($ccIds)
            ->setCombinedAttachments($combinedAttachments)
            ->setContentDocumentIds($contentDocumentIds)
            ->setContentDocumentLinks($contentDocumentLinks)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setEmailMessageRelations($emailMessageRelations)
            ->setEmailTemplate($emailTemplate)
            ->setEmailTemplateId($emailTemplateId)
            ->setFirstOpenedDate($firstOpenedDate)
            ->setFromAddress($fromAddress)
            ->setFromName($fromName)
            ->setHasAttachment($hasAttachment)
            ->setHeaders($headers)
            ->setHtmlBody($htmlBody)
            ->setIncoming($incoming)
            ->setIsBounced($isBounced)
            ->setIsClientManaged($isClientManaged)
            ->setIsDeleted($isDeleted)
            ->setIsExternallyVisible($isExternallyVisible)
            ->setIsOpened($isOpened)
            ->setIsTracked($isTracked)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastOpenedDate($lastOpenedDate)
            ->setMessageDate($messageDate)
            ->setMessageIdentifier($messageIdentifier)
            ->setParent($parent)
            ->setParentId($parentId)
            ->setProcessInstances($processInstances)
            ->setProcessSteps($processSteps)
            ->setRelatedTo($relatedTo)
            ->setRelatedToId($relatedToId)
            ->setReplyToEmailMessage($replyToEmailMessage)
            ->setReplyToEmailMessageId($replyToEmailMessageId)
            ->setStatus($status)
            ->setSubject($subject)
            ->setSystemModstamp($systemModstamp)
            ->setTextBody($textBody)
            ->setThreadIdentifier($threadIdentifier)
            ->setToAddress($toAddress)
            ->setToIds($toIds)
            ->setValidatedFromAddress($validatedFromAddress);
    }
    /**
     * Get ActivityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivityId()
    {
        return isset($this->ActivityId) ? $this->ActivityId : null;
    }
    /**
     * Set ActivityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activityId
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: string
        if (!is_null($activityId) && !is_string($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityId, true), gettype($activityId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($activityId) && mb_strlen($activityId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($activityId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($activityId) && !preg_match('/[a-zA-Z0-9]{18}/', $activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($activityId, true)), __LINE__);
        }
        if (is_null($activityId) || (is_array($activityId) && empty($activityId))) {
            unset($this->ActivityId);
        } else {
            $this->ActivityId = $activityId;
        }
        return $this;
    }
    /**
     * Get AttachedContentDocuments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachedContentDocuments()
    {
        return isset($this->AttachedContentDocuments) ? $this->AttachedContentDocuments : null;
    }
    /**
     * Set AttachedContentDocuments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setAttachedContentDocuments(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentDocuments = null)
    {
        if (is_null($attachedContentDocuments) || (is_array($attachedContentDocuments) && empty($attachedContentDocuments))) {
            unset($this->AttachedContentDocuments);
        } else {
            $this->AttachedContentDocuments = $attachedContentDocuments;
        }
        return $this;
    }
    /**
     * Get AttachedContentNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachedContentNotes()
    {
        return isset($this->AttachedContentNotes) ? $this->AttachedContentNotes : null;
    }
    /**
     * Set AttachedContentNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setAttachedContentNotes(\NexusDigital/MiratelForce\StructType\QueryResult $attachedContentNotes = null)
    {
        if (is_null($attachedContentNotes) || (is_array($attachedContentNotes) && empty($attachedContentNotes))) {
            unset($this->AttachedContentNotes);
        } else {
            $this->AttachedContentNotes = $attachedContentNotes;
        }
        return $this;
    }
    /**
     * Get Attachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getAttachments()
    {
        return isset($this->Attachments) ? $this->Attachments : null;
    }
    /**
     * Set Attachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $attachments
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $attachments = null)
    {
        if (is_null($attachments) || (is_array($attachments) && empty($attachments))) {
            unset($this->Attachments);
        } else {
            $this->Attachments = $attachments;
        }
        return $this;
    }
    /**
     * Get BccAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBccAddress()
    {
        return isset($this->BccAddress) ? $this->BccAddress : null;
    }
    /**
     * Set BccAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bccAddress
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setBccAddress($bccAddress = null)
    {
        // validation for constraint: string
        if (!is_null($bccAddress) && !is_string($bccAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bccAddress, true), gettype($bccAddress)), __LINE__);
        }
        if (is_null($bccAddress) || (is_array($bccAddress) && empty($bccAddress))) {
            unset($this->BccAddress);
        } else {
            $this->BccAddress = $bccAddress;
        }
        return $this;
    }
    /**
     * Get BccIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getBccIds()
    {
        return isset($this->BccIds) ? $this->BccIds : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBccIds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBccIds method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBccIdsForArrayConstraintsFromSetBccIds(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $emailMessageBccIdsItem) {
            // validation for constraint: itemType
            if (!is_string($emailMessageBccIdsItem)) {
                $invalidValues[] = is_object($emailMessageBccIdsItem) ? get_class($emailMessageBccIdsItem) : sprintf('%s(%s)', gettype($emailMessageBccIdsItem), var_export($emailMessageBccIdsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BccIds property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setBccIds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBccIds method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBccIdsForLengthConstraintFromSetBccIds($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $emailMessageBccIdsItem) {
            // validation for constraint: length(18)
            if (mb_strlen($emailMessageBccIdsItem) !== 18) {
                $invalidValues[] = var_export($emailMessageBccIdsItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be equal to 18', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BccIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $bccIds
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setBccIds(array $bccIds = array())
    {
        // validation for constraint: array
        if ('' !== ($bccIdsArrayErrorMessage = self::validateBccIdsForArrayConstraintsFromSetBccIds($bccIds))) {
            throw new \InvalidArgumentException($bccIdsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: length(18)
        if ('' !== ($bccIdsLengthErrorMessage = self::validateBccIdsForLengthConstraintFromSetBccIds($bccIds))) {
            throw new \InvalidArgumentException($bccIdsLengthErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($bccIds) && !preg_match('/[a-zA-Z0-9]{18}/', $bccIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($bccIds, true)), __LINE__);
        }
        if (is_null($bccIds) || (is_array($bccIds) && empty($bccIds))) {
            unset($this->BccIds);
        } else {
            $this->BccIds = $bccIds;
        }
        return $this;
    }
    /**
     * Add item to BccIds value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function addToBccIds($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The BccIds property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: length(18)
        if (mb_strlen($item) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!preg_match('/[a-zA-Z0-9]{18}/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($item, true)), __LINE__);
        }
        $this->BccIds[] = $item;
        return $this;
    }
    /**
     * Get CcAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCcAddress()
    {
        return isset($this->CcAddress) ? $this->CcAddress : null;
    }
    /**
     * Set CcAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ccAddress
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setCcAddress($ccAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ccAddress) && !is_string($ccAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccAddress, true), gettype($ccAddress)), __LINE__);
        }
        if (is_null($ccAddress) || (is_array($ccAddress) && empty($ccAddress))) {
            unset($this->CcAddress);
        } else {
            $this->CcAddress = $ccAddress;
        }
        return $this;
    }
    /**
     * Get CcIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getCcIds()
    {
        return isset($this->CcIds) ? $this->CcIds : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCcIds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCcIds method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCcIdsForArrayConstraintsFromSetCcIds(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $emailMessageCcIdsItem) {
            // validation for constraint: itemType
            if (!is_string($emailMessageCcIdsItem)) {
                $invalidValues[] = is_object($emailMessageCcIdsItem) ? get_class($emailMessageCcIdsItem) : sprintf('%s(%s)', gettype($emailMessageCcIdsItem), var_export($emailMessageCcIdsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CcIds property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setCcIds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCcIds method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCcIdsForLengthConstraintFromSetCcIds($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $emailMessageCcIdsItem) {
            // validation for constraint: length(18)
            if (mb_strlen($emailMessageCcIdsItem) !== 18) {
                $invalidValues[] = var_export($emailMessageCcIdsItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be equal to 18', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CcIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $ccIds
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setCcIds(array $ccIds = array())
    {
        // validation for constraint: array
        if ('' !== ($ccIdsArrayErrorMessage = self::validateCcIdsForArrayConstraintsFromSetCcIds($ccIds))) {
            throw new \InvalidArgumentException($ccIdsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: length(18)
        if ('' !== ($ccIdsLengthErrorMessage = self::validateCcIdsForLengthConstraintFromSetCcIds($ccIds))) {
            throw new \InvalidArgumentException($ccIdsLengthErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($ccIds) && !preg_match('/[a-zA-Z0-9]{18}/', $ccIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($ccIds, true)), __LINE__);
        }
        if (is_null($ccIds) || (is_array($ccIds) && empty($ccIds))) {
            unset($this->CcIds);
        } else {
            $this->CcIds = $ccIds;
        }
        return $this;
    }
    /**
     * Add item to CcIds value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function addToCcIds($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The CcIds property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: length(18)
        if (mb_strlen($item) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!preg_match('/[a-zA-Z0-9]{18}/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($item, true)), __LINE__);
        }
        $this->CcIds[] = $item;
        return $this;
    }
    /**
     * Get CombinedAttachments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getCombinedAttachments()
    {
        return isset($this->CombinedAttachments) ? $this->CombinedAttachments : null;
    }
    /**
     * Set CombinedAttachments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setCombinedAttachments(\NexusDigital/MiratelForce\StructType\QueryResult $combinedAttachments = null)
    {
        if (is_null($combinedAttachments) || (is_array($combinedAttachments) && empty($combinedAttachments))) {
            unset($this->CombinedAttachments);
        } else {
            $this->CombinedAttachments = $combinedAttachments;
        }
        return $this;
    }
    /**
     * Get ContentDocumentIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getContentDocumentIds()
    {
        return isset($this->ContentDocumentIds) ? $this->ContentDocumentIds : null;
    }
    /**
     * This method is responsible for validating the values passed to the setContentDocumentIds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContentDocumentIds method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContentDocumentIdsForArrayConstraintsFromSetContentDocumentIds(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $emailMessageContentDocumentIdsItem) {
            // validation for constraint: itemType
            if (!is_string($emailMessageContentDocumentIdsItem)) {
                $invalidValues[] = is_object($emailMessageContentDocumentIdsItem) ? get_class($emailMessageContentDocumentIdsItem) : sprintf('%s(%s)', gettype($emailMessageContentDocumentIdsItem), var_export($emailMessageContentDocumentIdsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContentDocumentIds property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setContentDocumentIds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContentDocumentIds method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContentDocumentIdsForLengthConstraintFromSetContentDocumentIds($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $emailMessageContentDocumentIdsItem) {
            // validation for constraint: length(18)
            if (mb_strlen($emailMessageContentDocumentIdsItem) !== 18) {
                $invalidValues[] = var_export($emailMessageContentDocumentIdsItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be equal to 18', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContentDocumentIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $contentDocumentIds
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setContentDocumentIds(array $contentDocumentIds = array())
    {
        // validation for constraint: array
        if ('' !== ($contentDocumentIdsArrayErrorMessage = self::validateContentDocumentIdsForArrayConstraintsFromSetContentDocumentIds($contentDocumentIds))) {
            throw new \InvalidArgumentException($contentDocumentIdsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: length(18)
        if ('' !== ($contentDocumentIdsLengthErrorMessage = self::validateContentDocumentIdsForLengthConstraintFromSetContentDocumentIds($contentDocumentIds))) {
            throw new \InvalidArgumentException($contentDocumentIdsLengthErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($contentDocumentIds) && !preg_match('/[a-zA-Z0-9]{18}/', $contentDocumentIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($contentDocumentIds, true)), __LINE__);
        }
        if (is_null($contentDocumentIds) || (is_array($contentDocumentIds) && empty($contentDocumentIds))) {
            unset($this->ContentDocumentIds);
        } else {
            $this->ContentDocumentIds = $contentDocumentIds;
        }
        return $this;
    }
    /**
     * Add item to ContentDocumentIds value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function addToContentDocumentIds($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ContentDocumentIds property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: length(18)
        if (mb_strlen($item) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!preg_match('/[a-zA-Z0-9]{18}/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($item, true)), __LINE__);
        }
        $this->ContentDocumentIds[] = $item;
        return $this;
    }
    /**
     * Get ContentDocumentLinks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getContentDocumentLinks()
    {
        return isset($this->ContentDocumentLinks) ? $this->ContentDocumentLinks : null;
    }
    /**
     * Set ContentDocumentLinks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setContentDocumentLinks(\NexusDigital/MiratelForce\StructType\QueryResult $contentDocumentLinks = null)
    {
        if (is_null($contentDocumentLinks) || (is_array($contentDocumentLinks) && empty($contentDocumentLinks))) {
            unset($this->ContentDocumentLinks);
        } else {
            $this->ContentDocumentLinks = $contentDocumentLinks;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get EmailMessageRelations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getEmailMessageRelations()
    {
        return isset($this->EmailMessageRelations) ? $this->EmailMessageRelations : null;
    }
    /**
     * Set EmailMessageRelations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $emailMessageRelations
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setEmailMessageRelations(\NexusDigital/MiratelForce\StructType\QueryResult $emailMessageRelations = null)
    {
        if (is_null($emailMessageRelations) || (is_array($emailMessageRelations) && empty($emailMessageRelations))) {
            unset($this->EmailMessageRelations);
        } else {
            $this->EmailMessageRelations = $emailMessageRelations;
        }
        return $this;
    }
    /**
     * Get EmailTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\EmailTemplate|null
     */
    public function getEmailTemplate()
    {
        return isset($this->EmailTemplate) ? $this->EmailTemplate : null;
    }
    /**
     * Set EmailTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\EmailTemplate $emailTemplate
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setEmailTemplate(\NexusDigital/MiratelForce\StructType\EmailTemplate $emailTemplate = null)
    {
        if (is_null($emailTemplate) || (is_array($emailTemplate) && empty($emailTemplate))) {
            unset($this->EmailTemplate);
        } else {
            $this->EmailTemplate = $emailTemplate;
        }
        return $this;
    }
    /**
     * Get EmailTemplateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailTemplateId()
    {
        return isset($this->EmailTemplateId) ? $this->EmailTemplateId : null;
    }
    /**
     * Set EmailTemplateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailTemplateId
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setEmailTemplateId($emailTemplateId = null)
    {
        // validation for constraint: string
        if (!is_null($emailTemplateId) && !is_string($emailTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailTemplateId, true), gettype($emailTemplateId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($emailTemplateId) && mb_strlen($emailTemplateId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($emailTemplateId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($emailTemplateId) && !preg_match('/[a-zA-Z0-9]{18}/', $emailTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($emailTemplateId, true)), __LINE__);
        }
        if (is_null($emailTemplateId) || (is_array($emailTemplateId) && empty($emailTemplateId))) {
            unset($this->EmailTemplateId);
        } else {
            $this->EmailTemplateId = $emailTemplateId;
        }
        return $this;
    }
    /**
     * Get FirstOpenedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstOpenedDate()
    {
        return isset($this->FirstOpenedDate) ? $this->FirstOpenedDate : null;
    }
    /**
     * Set FirstOpenedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstOpenedDate
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setFirstOpenedDate($firstOpenedDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstOpenedDate) && !is_string($firstOpenedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstOpenedDate, true), gettype($firstOpenedDate)), __LINE__);
        }
        if (is_null($firstOpenedDate) || (is_array($firstOpenedDate) && empty($firstOpenedDate))) {
            unset($this->FirstOpenedDate);
        } else {
            $this->FirstOpenedDate = $firstOpenedDate;
        }
        return $this;
    }
    /**
     * Get FromAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromAddress()
    {
        return isset($this->FromAddress) ? $this->FromAddress : null;
    }
    /**
     * Set FromAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromAddress
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setFromAddress($fromAddress = null)
    {
        // validation for constraint: string
        if (!is_null($fromAddress) && !is_string($fromAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromAddress, true), gettype($fromAddress)), __LINE__);
        }
        if (is_null($fromAddress) || (is_array($fromAddress) && empty($fromAddress))) {
            unset($this->FromAddress);
        } else {
            $this->FromAddress = $fromAddress;
        }
        return $this;
    }
    /**
     * Get FromName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromName()
    {
        return isset($this->FromName) ? $this->FromName : null;
    }
    /**
     * Set FromName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromName
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setFromName($fromName = null)
    {
        // validation for constraint: string
        if (!is_null($fromName) && !is_string($fromName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromName, true), gettype($fromName)), __LINE__);
        }
        if (is_null($fromName) || (is_array($fromName) && empty($fromName))) {
            unset($this->FromName);
        } else {
            $this->FromName = $fromName;
        }
        return $this;
    }
    /**
     * Get HasAttachment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasAttachment()
    {
        return isset($this->HasAttachment) ? $this->HasAttachment : null;
    }
    /**
     * Set HasAttachment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasAttachment
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setHasAttachment($hasAttachment = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasAttachment) && !is_bool($hasAttachment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasAttachment, true), gettype($hasAttachment)), __LINE__);
        }
        if (is_null($hasAttachment) || (is_array($hasAttachment) && empty($hasAttachment))) {
            unset($this->HasAttachment);
        } else {
            $this->HasAttachment = $hasAttachment;
        }
        return $this;
    }
    /**
     * Get Headers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHeaders()
    {
        return isset($this->Headers) ? $this->Headers : null;
    }
    /**
     * Set Headers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $headers
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setHeaders($headers = null)
    {
        // validation for constraint: string
        if (!is_null($headers) && !is_string($headers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($headers, true), gettype($headers)), __LINE__);
        }
        if (is_null($headers) || (is_array($headers) && empty($headers))) {
            unset($this->Headers);
        } else {
            $this->Headers = $headers;
        }
        return $this;
    }
    /**
     * Get HtmlBody value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHtmlBody()
    {
        return isset($this->HtmlBody) ? $this->HtmlBody : null;
    }
    /**
     * Set HtmlBody value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $htmlBody
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setHtmlBody($htmlBody = null)
    {
        // validation for constraint: string
        if (!is_null($htmlBody) && !is_string($htmlBody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($htmlBody, true), gettype($htmlBody)), __LINE__);
        }
        if (is_null($htmlBody) || (is_array($htmlBody) && empty($htmlBody))) {
            unset($this->HtmlBody);
        } else {
            $this->HtmlBody = $htmlBody;
        }
        return $this;
    }
    /**
     * Get Incoming value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncoming()
    {
        return isset($this->Incoming) ? $this->Incoming : null;
    }
    /**
     * Set Incoming value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $incoming
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setIncoming($incoming = null)
    {
        // validation for constraint: boolean
        if (!is_null($incoming) && !is_bool($incoming)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($incoming, true), gettype($incoming)), __LINE__);
        }
        if (is_null($incoming) || (is_array($incoming) && empty($incoming))) {
            unset($this->Incoming);
        } else {
            $this->Incoming = $incoming;
        }
        return $this;
    }
    /**
     * Get IsBounced value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsBounced()
    {
        return isset($this->IsBounced) ? $this->IsBounced : null;
    }
    /**
     * Set IsBounced value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isBounced
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setIsBounced($isBounced = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBounced) && !is_bool($isBounced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBounced, true), gettype($isBounced)), __LINE__);
        }
        if (is_null($isBounced) || (is_array($isBounced) && empty($isBounced))) {
            unset($this->IsBounced);
        } else {
            $this->IsBounced = $isBounced;
        }
        return $this;
    }
    /**
     * Get IsClientManaged value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsClientManaged()
    {
        return isset($this->IsClientManaged) ? $this->IsClientManaged : null;
    }
    /**
     * Set IsClientManaged value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isClientManaged
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setIsClientManaged($isClientManaged = null)
    {
        // validation for constraint: boolean
        if (!is_null($isClientManaged) && !is_bool($isClientManaged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isClientManaged, true), gettype($isClientManaged)), __LINE__);
        }
        if (is_null($isClientManaged) || (is_array($isClientManaged) && empty($isClientManaged))) {
            unset($this->IsClientManaged);
        } else {
            $this->IsClientManaged = $isClientManaged;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get IsExternallyVisible value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExternallyVisible()
    {
        return isset($this->IsExternallyVisible) ? $this->IsExternallyVisible : null;
    }
    /**
     * Set IsExternallyVisible value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExternallyVisible
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setIsExternallyVisible($isExternallyVisible = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExternallyVisible) && !is_bool($isExternallyVisible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExternallyVisible, true), gettype($isExternallyVisible)), __LINE__);
        }
        if (is_null($isExternallyVisible) || (is_array($isExternallyVisible) && empty($isExternallyVisible))) {
            unset($this->IsExternallyVisible);
        } else {
            $this->IsExternallyVisible = $isExternallyVisible;
        }
        return $this;
    }
    /**
     * Get IsOpened value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOpened()
    {
        return isset($this->IsOpened) ? $this->IsOpened : null;
    }
    /**
     * Set IsOpened value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOpened
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setIsOpened($isOpened = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOpened) && !is_bool($isOpened)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOpened, true), gettype($isOpened)), __LINE__);
        }
        if (is_null($isOpened) || (is_array($isOpened) && empty($isOpened))) {
            unset($this->IsOpened);
        } else {
            $this->IsOpened = $isOpened;
        }
        return $this;
    }
    /**
     * Get IsTracked value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTracked()
    {
        return isset($this->IsTracked) ? $this->IsTracked : null;
    }
    /**
     * Set IsTracked value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTracked
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setIsTracked($isTracked = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTracked) && !is_bool($isTracked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTracked, true), gettype($isTracked)), __LINE__);
        }
        if (is_null($isTracked) || (is_array($isTracked) && empty($isTracked))) {
            unset($this->IsTracked);
        } else {
            $this->IsTracked = $isTracked;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LastOpenedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastOpenedDate()
    {
        return isset($this->LastOpenedDate) ? $this->LastOpenedDate : null;
    }
    /**
     * Set LastOpenedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastOpenedDate
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setLastOpenedDate($lastOpenedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastOpenedDate) && !is_string($lastOpenedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastOpenedDate, true), gettype($lastOpenedDate)), __LINE__);
        }
        if (is_null($lastOpenedDate) || (is_array($lastOpenedDate) && empty($lastOpenedDate))) {
            unset($this->LastOpenedDate);
        } else {
            $this->LastOpenedDate = $lastOpenedDate;
        }
        return $this;
    }
    /**
     * Get MessageDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessageDate()
    {
        return isset($this->MessageDate) ? $this->MessageDate : null;
    }
    /**
     * Set MessageDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $messageDate
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setMessageDate($messageDate = null)
    {
        // validation for constraint: string
        if (!is_null($messageDate) && !is_string($messageDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageDate, true), gettype($messageDate)), __LINE__);
        }
        if (is_null($messageDate) || (is_array($messageDate) && empty($messageDate))) {
            unset($this->MessageDate);
        } else {
            $this->MessageDate = $messageDate;
        }
        return $this;
    }
    /**
     * Get MessageIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessageIdentifier()
    {
        return isset($this->MessageIdentifier) ? $this->MessageIdentifier : null;
    }
    /**
     * Set MessageIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $messageIdentifier
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setMessageIdentifier($messageIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($messageIdentifier) && !is_string($messageIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageIdentifier, true), gettype($messageIdentifier)), __LINE__);
        }
        if (is_null($messageIdentifier) || (is_array($messageIdentifier) && empty($messageIdentifier))) {
            unset($this->MessageIdentifier);
        } else {
            $this->MessageIdentifier = $messageIdentifier;
        }
        return $this;
    }
    /**
     * Get Parent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\_Case|null
     */
    public function getParent()
    {
        return isset($this->Parent) ? $this->Parent : null;
    }
    /**
     * Set Parent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\_Case $parent
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setParent(\NexusDigital/MiratelForce\StructType\_Case $parent = null)
    {
        if (is_null($parent) || (is_array($parent) && empty($parent))) {
            unset($this->Parent);
        } else {
            $this->Parent = $parent;
        }
        return $this;
    }
    /**
     * Get ParentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentId()
    {
        return isset($this->ParentId) ? $this->ParentId : null;
    }
    /**
     * Set ParentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentId
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: string
        if (!is_null($parentId) && !is_string($parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentId, true), gettype($parentId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($parentId) && mb_strlen($parentId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($parentId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($parentId) && !preg_match('/[a-zA-Z0-9]{18}/', $parentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($parentId, true)), __LINE__);
        }
        if (is_null($parentId) || (is_array($parentId) && empty($parentId))) {
            unset($this->ParentId);
        } else {
            $this->ParentId = $parentId;
        }
        return $this;
    }
    /**
     * Get ProcessInstances value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getProcessInstances()
    {
        return isset($this->ProcessInstances) ? $this->ProcessInstances : null;
    }
    /**
     * Set ProcessInstances value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processInstances
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setProcessInstances(\NexusDigital/MiratelForce\StructType\QueryResult $processInstances = null)
    {
        if (is_null($processInstances) || (is_array($processInstances) && empty($processInstances))) {
            unset($this->ProcessInstances);
        } else {
            $this->ProcessInstances = $processInstances;
        }
        return $this;
    }
    /**
     * Get ProcessSteps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getProcessSteps()
    {
        return isset($this->ProcessSteps) ? $this->ProcessSteps : null;
    }
    /**
     * Set ProcessSteps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $processSteps
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setProcessSteps(\NexusDigital/MiratelForce\StructType\QueryResult $processSteps = null)
    {
        if (is_null($processSteps) || (is_array($processSteps) && empty($processSteps))) {
            unset($this->ProcessSteps);
        } else {
            $this->ProcessSteps = $processSteps;
        }
        return $this;
    }
    /**
     * Get RelatedTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getRelatedTo()
    {
        return isset($this->RelatedTo) ? $this->RelatedTo : null;
    }
    /**
     * Set RelatedTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $relatedTo
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setRelatedTo(\NexusDigital/MiratelForce\StructType\SObject $relatedTo = null)
    {
        if (is_null($relatedTo) || (is_array($relatedTo) && empty($relatedTo))) {
            unset($this->RelatedTo);
        } else {
            $this->RelatedTo = $relatedTo;
        }
        return $this;
    }
    /**
     * Get RelatedToId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedToId()
    {
        return isset($this->RelatedToId) ? $this->RelatedToId : null;
    }
    /**
     * Set RelatedToId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedToId
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setRelatedToId($relatedToId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedToId) && !is_string($relatedToId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedToId, true), gettype($relatedToId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($relatedToId) && mb_strlen($relatedToId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($relatedToId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($relatedToId) && !preg_match('/[a-zA-Z0-9]{18}/', $relatedToId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($relatedToId, true)), __LINE__);
        }
        if (is_null($relatedToId) || (is_array($relatedToId) && empty($relatedToId))) {
            unset($this->RelatedToId);
        } else {
            $this->RelatedToId = $relatedToId;
        }
        return $this;
    }
    /**
     * Get ReplyToEmailMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage|null
     */
    public function getReplyToEmailMessage()
    {
        return isset($this->ReplyToEmailMessage) ? $this->ReplyToEmailMessage : null;
    }
    /**
     * Set ReplyToEmailMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\EmailMessage $replyToEmailMessage
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setReplyToEmailMessage(\NexusDigital/MiratelForce\StructType\EmailMessage $replyToEmailMessage = null)
    {
        if (is_null($replyToEmailMessage) || (is_array($replyToEmailMessage) && empty($replyToEmailMessage))) {
            unset($this->ReplyToEmailMessage);
        } else {
            $this->ReplyToEmailMessage = $replyToEmailMessage;
        }
        return $this;
    }
    /**
     * Get ReplyToEmailMessageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReplyToEmailMessageId()
    {
        return isset($this->ReplyToEmailMessageId) ? $this->ReplyToEmailMessageId : null;
    }
    /**
     * Set ReplyToEmailMessageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $replyToEmailMessageId
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setReplyToEmailMessageId($replyToEmailMessageId = null)
    {
        // validation for constraint: string
        if (!is_null($replyToEmailMessageId) && !is_string($replyToEmailMessageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($replyToEmailMessageId, true), gettype($replyToEmailMessageId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($replyToEmailMessageId) && mb_strlen($replyToEmailMessageId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($replyToEmailMessageId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($replyToEmailMessageId) && !preg_match('/[a-zA-Z0-9]{18}/', $replyToEmailMessageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($replyToEmailMessageId, true)), __LINE__);
        }
        if (is_null($replyToEmailMessageId) || (is_array($replyToEmailMessageId) && empty($replyToEmailMessageId))) {
            unset($this->ReplyToEmailMessageId);
        } else {
            $this->ReplyToEmailMessageId = $replyToEmailMessageId;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Subject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubject()
    {
        return isset($this->Subject) ? $this->Subject : null;
    }
    /**
     * Set Subject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subject
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subject, true), gettype($subject)), __LINE__);
        }
        if (is_null($subject) || (is_array($subject) && empty($subject))) {
            unset($this->Subject);
        } else {
            $this->Subject = $subject;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get TextBody value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTextBody()
    {
        return isset($this->TextBody) ? $this->TextBody : null;
    }
    /**
     * Set TextBody value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $textBody
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setTextBody($textBody = null)
    {
        // validation for constraint: string
        if (!is_null($textBody) && !is_string($textBody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($textBody, true), gettype($textBody)), __LINE__);
        }
        if (is_null($textBody) || (is_array($textBody) && empty($textBody))) {
            unset($this->TextBody);
        } else {
            $this->TextBody = $textBody;
        }
        return $this;
    }
    /**
     * Get ThreadIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getThreadIdentifier()
    {
        return isset($this->ThreadIdentifier) ? $this->ThreadIdentifier : null;
    }
    /**
     * Set ThreadIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $threadIdentifier
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setThreadIdentifier($threadIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($threadIdentifier) && !is_string($threadIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($threadIdentifier, true), gettype($threadIdentifier)), __LINE__);
        }
        if (is_null($threadIdentifier) || (is_array($threadIdentifier) && empty($threadIdentifier))) {
            unset($this->ThreadIdentifier);
        } else {
            $this->ThreadIdentifier = $threadIdentifier;
        }
        return $this;
    }
    /**
     * Get ToAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToAddress()
    {
        return isset($this->ToAddress) ? $this->ToAddress : null;
    }
    /**
     * Set ToAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toAddress
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setToAddress($toAddress = null)
    {
        // validation for constraint: string
        if (!is_null($toAddress) && !is_string($toAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toAddress, true), gettype($toAddress)), __LINE__);
        }
        if (is_null($toAddress) || (is_array($toAddress) && empty($toAddress))) {
            unset($this->ToAddress);
        } else {
            $this->ToAddress = $toAddress;
        }
        return $this;
    }
    /**
     * Get ToIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getToIds()
    {
        return isset($this->ToIds) ? $this->ToIds : null;
    }
    /**
     * This method is responsible for validating the values passed to the setToIds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setToIds method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateToIdsForArrayConstraintsFromSetToIds(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $emailMessageToIdsItem) {
            // validation for constraint: itemType
            if (!is_string($emailMessageToIdsItem)) {
                $invalidValues[] = is_object($emailMessageToIdsItem) ? get_class($emailMessageToIdsItem) : sprintf('%s(%s)', gettype($emailMessageToIdsItem), var_export($emailMessageToIdsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ToIds property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setToIds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setToIds method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateToIdsForLengthConstraintFromSetToIds($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $emailMessageToIdsItem) {
            // validation for constraint: length(18)
            if (mb_strlen($emailMessageToIdsItem) !== 18) {
                $invalidValues[] = var_export($emailMessageToIdsItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be equal to 18', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ToIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $toIds
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setToIds(array $toIds = array())
    {
        // validation for constraint: array
        if ('' !== ($toIdsArrayErrorMessage = self::validateToIdsForArrayConstraintsFromSetToIds($toIds))) {
            throw new \InvalidArgumentException($toIdsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: length(18)
        if ('' !== ($toIdsLengthErrorMessage = self::validateToIdsForLengthConstraintFromSetToIds($toIds))) {
            throw new \InvalidArgumentException($toIdsLengthErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($toIds) && !preg_match('/[a-zA-Z0-9]{18}/', $toIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($toIds, true)), __LINE__);
        }
        if (is_null($toIds) || (is_array($toIds) && empty($toIds))) {
            unset($this->ToIds);
        } else {
            $this->ToIds = $toIds;
        }
        return $this;
    }
    /**
     * Add item to ToIds value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function addToToIds($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ToIds property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: length(18)
        if (mb_strlen($item) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!preg_match('/[a-zA-Z0-9]{18}/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($item, true)), __LINE__);
        }
        $this->ToIds[] = $item;
        return $this;
    }
    /**
     * Get ValidatedFromAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidatedFromAddress()
    {
        return isset($this->ValidatedFromAddress) ? $this->ValidatedFromAddress : null;
    }
    /**
     * Set ValidatedFromAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validatedFromAddress
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public function setValidatedFromAddress($validatedFromAddress = null)
    {
        // validation for constraint: string
        if (!is_null($validatedFromAddress) && !is_string($validatedFromAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validatedFromAddress, true), gettype($validatedFromAddress)), __LINE__);
        }
        if (is_null($validatedFromAddress) || (is_array($validatedFromAddress) && empty($validatedFromAddress))) {
            unset($this->ValidatedFromAddress);
        } else {
            $this->ValidatedFromAddress = $validatedFromAddress;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\EmailMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
