<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmailDomainKey StructType
 * @subpackage Structs
 */
class EmailDomainKey extends SObject
{
    /**
     * The AlternatePublicKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlternatePublicKey;
    /**
     * The AlternateSelector
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlternateSelector;
    /**
     * The AlternateTxtRecordName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlternateTxtRecordName;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The Domain
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Domain;
    /**
     * The DomainMatch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DomainMatch;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The KeySize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $KeySize;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The PublicKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PublicKey;
    /**
     * The Selector
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Selector;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The TxtRecordName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TxtRecordName;
    /**
     * The TxtRecordsPublishState
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TxtRecordsPublishState;
    /**
     * Constructor method for EmailDomainKey
     * @uses EmailDomainKey::setAlternatePublicKey()
     * @uses EmailDomainKey::setAlternateSelector()
     * @uses EmailDomainKey::setAlternateTxtRecordName()
     * @uses EmailDomainKey::setCreatedBy()
     * @uses EmailDomainKey::setCreatedById()
     * @uses EmailDomainKey::setCreatedDate()
     * @uses EmailDomainKey::setDomain()
     * @uses EmailDomainKey::setDomainMatch()
     * @uses EmailDomainKey::setIsActive()
     * @uses EmailDomainKey::setIsDeleted()
     * @uses EmailDomainKey::setKeySize()
     * @uses EmailDomainKey::setLastModifiedBy()
     * @uses EmailDomainKey::setLastModifiedById()
     * @uses EmailDomainKey::setLastModifiedDate()
     * @uses EmailDomainKey::setPublicKey()
     * @uses EmailDomainKey::setSelector()
     * @uses EmailDomainKey::setSystemModstamp()
     * @uses EmailDomainKey::setTxtRecordName()
     * @uses EmailDomainKey::setTxtRecordsPublishState()
     * @param string $alternatePublicKey
     * @param string $alternateSelector
     * @param string $alternateTxtRecordName
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $domain
     * @param string $domainMatch
     * @param bool $isActive
     * @param bool $isDeleted
     * @param int $keySize
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $publicKey
     * @param string $selector
     * @param string $systemModstamp
     * @param string $txtRecordName
     * @param string $txtRecordsPublishState
     */
    public function __construct($alternatePublicKey = null, $alternateSelector = null, $alternateTxtRecordName = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $domain = null, $domainMatch = null, $isActive = null, $isDeleted = null, $keySize = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $publicKey = null, $selector = null, $systemModstamp = null, $txtRecordName = null, $txtRecordsPublishState = null)
    {
        $this
            ->setAlternatePublicKey($alternatePublicKey)
            ->setAlternateSelector($alternateSelector)
            ->setAlternateTxtRecordName($alternateTxtRecordName)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDomain($domain)
            ->setDomainMatch($domainMatch)
            ->setIsActive($isActive)
            ->setIsDeleted($isDeleted)
            ->setKeySize($keySize)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setPublicKey($publicKey)
            ->setSelector($selector)
            ->setSystemModstamp($systemModstamp)
            ->setTxtRecordName($txtRecordName)
            ->setTxtRecordsPublishState($txtRecordsPublishState);
    }
    /**
     * Get AlternatePublicKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlternatePublicKey()
    {
        return isset($this->AlternatePublicKey) ? $this->AlternatePublicKey : null;
    }
    /**
     * Set AlternatePublicKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alternatePublicKey
     * @return \NexusDigital/MiratelForce\StructType\EmailDomainKey
     */
    public function setAlternatePublicKey($alternatePublicKey = null)
    {
        // validation for constraint: string
        if (!is_null($alternatePublicKey) && !is_string($alternatePublicKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternatePublicKey, true), gettype($alternatePublicKey)), __LINE__);
        }
        if (is_null($alternatePublicKey) || (is_array($alternatePublicKey) && empty($alternatePublicKey))) {
            unset($this->AlternatePublicKey);
        } else {
            $this->AlternatePublicKey = $alternatePublicKey;
        }
        return $this;
    }
    /**
     * Get AlternateSelector value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlternateSelector()
    {
        return isset($this->AlternateSelector) ? $this->AlternateSelector : null;
    }
    /**
     * Set AlternateSelector value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alternateSelector
     * @return \NexusDigital/MiratelForce\StructType\EmailDomainKey
     */
    public function setAlternateSelector($alternateSelector = null)
    {
        // validation for constraint: string
        if (!is_null($alternateSelector) && !is_string($alternateSelector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateSelector, true), gettype($alternateSelector)), __LINE__);
        }
        if (is_null($alternateSelector) || (is_array($alternateSelector) && empty($alternateSelector))) {
            unset($this->AlternateSelector);
        } else {
            $this->AlternateSelector = $alternateSelector;
        }
        return $this;
    }
    /**
     * Get AlternateTxtRecordName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlternateTxtRecordName()
    {
        return isset($this->AlternateTxtRecordName) ? $this->AlternateTxtRecordName : null;
    }
    /**
     * Set AlternateTxtRecordName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alternateTxtRecordName
     * @return \NexusDigital/MiratelForce\StructType\EmailDomainKey
     */
    public function setAlternateTxtRecordName($alternateTxtRecordName = null)
    {
        // validation for constraint: string
        if (!is_null($alternateTxtRecordName) && !is_string($alternateTxtRecordName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateTxtRecordName, true), gettype($alternateTxtRecordName)), __LINE__);
        }
        if (is_null($alternateTxtRecordName) || (is_array($alternateTxtRecordName) && empty($alternateTxtRecordName))) {
            unset($this->AlternateTxtRecordName);
        } else {
            $this->AlternateTxtRecordName = $alternateTxtRecordName;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\EmailDomainKey
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\EmailDomainKey
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\EmailDomainKey
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get Domain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDomain()
    {
        return isset($this->Domain) ? $this->Domain : null;
    }
    /**
     * Set Domain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $domain
     * @return \NexusDigital/MiratelForce\StructType\EmailDomainKey
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domain, true), gettype($domain)), __LINE__);
        }
        if (is_null($domain) || (is_array($domain) && empty($domain))) {
            unset($this->Domain);
        } else {
            $this->Domain = $domain;
        }
        return $this;
    }
    /**
     * Get DomainMatch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDomainMatch()
    {
        return isset($this->DomainMatch) ? $this->DomainMatch : null;
    }
    /**
     * Set DomainMatch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $domainMatch
     * @return \NexusDigital/MiratelForce\StructType\EmailDomainKey
     */
    public function setDomainMatch($domainMatch = null)
    {
        // validation for constraint: string
        if (!is_null($domainMatch) && !is_string($domainMatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domainMatch, true), gettype($domainMatch)), __LINE__);
        }
        if (is_null($domainMatch) || (is_array($domainMatch) && empty($domainMatch))) {
            unset($this->DomainMatch);
        } else {
            $this->DomainMatch = $domainMatch;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \NexusDigital/MiratelForce\StructType\EmailDomainKey
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\EmailDomainKey
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get KeySize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getKeySize()
    {
        return isset($this->KeySize) ? $this->KeySize : null;
    }
    /**
     * Set KeySize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $keySize
     * @return \NexusDigital/MiratelForce\StructType\EmailDomainKey
     */
    public function setKeySize($keySize = null)
    {
        // validation for constraint: int
        if (!is_null($keySize) && !(is_int($keySize) || ctype_digit($keySize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($keySize, true), gettype($keySize)), __LINE__);
        }
        if (is_null($keySize) || (is_array($keySize) && empty($keySize))) {
            unset($this->KeySize);
        } else {
            $this->KeySize = $keySize;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\EmailDomainKey
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\EmailDomainKey
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\EmailDomainKey
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get PublicKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPublicKey()
    {
        return isset($this->PublicKey) ? $this->PublicKey : null;
    }
    /**
     * Set PublicKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $publicKey
     * @return \NexusDigital/MiratelForce\StructType\EmailDomainKey
     */
    public function setPublicKey($publicKey = null)
    {
        // validation for constraint: string
        if (!is_null($publicKey) && !is_string($publicKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publicKey, true), gettype($publicKey)), __LINE__);
        }
        if (is_null($publicKey) || (is_array($publicKey) && empty($publicKey))) {
            unset($this->PublicKey);
        } else {
            $this->PublicKey = $publicKey;
        }
        return $this;
    }
    /**
     * Get Selector value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelector()
    {
        return isset($this->Selector) ? $this->Selector : null;
    }
    /**
     * Set Selector value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selector
     * @return \NexusDigital/MiratelForce\StructType\EmailDomainKey
     */
    public function setSelector($selector = null)
    {
        // validation for constraint: string
        if (!is_null($selector) && !is_string($selector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selector, true), gettype($selector)), __LINE__);
        }
        if (is_null($selector) || (is_array($selector) && empty($selector))) {
            unset($this->Selector);
        } else {
            $this->Selector = $selector;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\EmailDomainKey
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get TxtRecordName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTxtRecordName()
    {
        return isset($this->TxtRecordName) ? $this->TxtRecordName : null;
    }
    /**
     * Set TxtRecordName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $txtRecordName
     * @return \NexusDigital/MiratelForce\StructType\EmailDomainKey
     */
    public function setTxtRecordName($txtRecordName = null)
    {
        // validation for constraint: string
        if (!is_null($txtRecordName) && !is_string($txtRecordName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($txtRecordName, true), gettype($txtRecordName)), __LINE__);
        }
        if (is_null($txtRecordName) || (is_array($txtRecordName) && empty($txtRecordName))) {
            unset($this->TxtRecordName);
        } else {
            $this->TxtRecordName = $txtRecordName;
        }
        return $this;
    }
    /**
     * Get TxtRecordsPublishState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTxtRecordsPublishState()
    {
        return isset($this->TxtRecordsPublishState) ? $this->TxtRecordsPublishState : null;
    }
    /**
     * Set TxtRecordsPublishState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $txtRecordsPublishState
     * @return \NexusDigital/MiratelForce\StructType\EmailDomainKey
     */
    public function setTxtRecordsPublishState($txtRecordsPublishState = null)
    {
        // validation for constraint: string
        if (!is_null($txtRecordsPublishState) && !is_string($txtRecordsPublishState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($txtRecordsPublishState, true), gettype($txtRecordsPublishState)), __LINE__);
        }
        if (is_null($txtRecordsPublishState) || (is_array($txtRecordsPublishState) && empty($txtRecordsPublishState))) {
            unset($this->TxtRecordsPublishState);
        } else {
            $this->TxtRecordsPublishState = $txtRecordsPublishState;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\EmailDomainKey
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
