<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataIntegrationRecordPurchasePermission StructType
 * @subpackage Structs
 */
class DataIntegrationRecordPurchasePermission extends SObject
{
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The ExternalObject
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalObject;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $User;
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $UserId;
    /**
     * The UserRecordPurchaseLimit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UserRecordPurchaseLimit;
    /**
     * Constructor method for DataIntegrationRecordPurchasePermission
     * @uses DataIntegrationRecordPurchasePermission::setCreatedBy()
     * @uses DataIntegrationRecordPurchasePermission::setCreatedById()
     * @uses DataIntegrationRecordPurchasePermission::setCreatedDate()
     * @uses DataIntegrationRecordPurchasePermission::setExternalObject()
     * @uses DataIntegrationRecordPurchasePermission::setIsDeleted()
     * @uses DataIntegrationRecordPurchasePermission::setLastModifiedBy()
     * @uses DataIntegrationRecordPurchasePermission::setLastModifiedById()
     * @uses DataIntegrationRecordPurchasePermission::setLastModifiedDate()
     * @uses DataIntegrationRecordPurchasePermission::setSystemModstamp()
     * @uses DataIntegrationRecordPurchasePermission::setUser()
     * @uses DataIntegrationRecordPurchasePermission::setUserId()
     * @uses DataIntegrationRecordPurchasePermission::setUserRecordPurchaseLimit()
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $externalObject
     * @param bool $isDeleted
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $systemModstamp
     * @param \NexusDigital/MiratelForce\StructType\User $user
     * @param string $userId
     * @param int $userRecordPurchaseLimit
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $externalObject = null, $isDeleted = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $systemModstamp = null, \NexusDigital/MiratelForce\StructType\User $user = null, $userId = null, $userRecordPurchaseLimit = null)
    {
        $this
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setExternalObject($externalObject)
            ->setIsDeleted($isDeleted)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setSystemModstamp($systemModstamp)
            ->setUser($user)
            ->setUserId($userId)
            ->setUserRecordPurchaseLimit($userRecordPurchaseLimit);
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\DataIntegrationRecordPurchasePermission
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\DataIntegrationRecordPurchasePermission
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\DataIntegrationRecordPurchasePermission
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get ExternalObject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalObject()
    {
        return isset($this->ExternalObject) ? $this->ExternalObject : null;
    }
    /**
     * Set ExternalObject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalObject
     * @return \NexusDigital/MiratelForce\StructType\DataIntegrationRecordPurchasePermission
     */
    public function setExternalObject($externalObject = null)
    {
        // validation for constraint: string
        if (!is_null($externalObject) && !is_string($externalObject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalObject, true), gettype($externalObject)), __LINE__);
        }
        if (is_null($externalObject) || (is_array($externalObject) && empty($externalObject))) {
            unset($this->ExternalObject);
        } else {
            $this->ExternalObject = $externalObject;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\DataIntegrationRecordPurchasePermission
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\DataIntegrationRecordPurchasePermission
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\DataIntegrationRecordPurchasePermission
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\DataIntegrationRecordPurchasePermission
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\DataIntegrationRecordPurchasePermission
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get User value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getUser()
    {
        return isset($this->User) ? $this->User : null;
    }
    /**
     * Set User value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $user
     * @return \NexusDigital/MiratelForce\StructType\DataIntegrationRecordPurchasePermission
     */
    public function setUser(\NexusDigital/MiratelForce\StructType\User $user = null)
    {
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->User);
        } else {
            $this->User = $user;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \NexusDigital/MiratelForce\StructType\DataIntegrationRecordPurchasePermission
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($userId) && mb_strlen($userId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($userId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($userId) && !preg_match('/[a-zA-Z0-9]{18}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Get UserRecordPurchaseLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUserRecordPurchaseLimit()
    {
        return isset($this->UserRecordPurchaseLimit) ? $this->UserRecordPurchaseLimit : null;
    }
    /**
     * Set UserRecordPurchaseLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $userRecordPurchaseLimit
     * @return \NexusDigital/MiratelForce\StructType\DataIntegrationRecordPurchasePermission
     */
    public function setUserRecordPurchaseLimit($userRecordPurchaseLimit = null)
    {
        // validation for constraint: int
        if (!is_null($userRecordPurchaseLimit) && !(is_int($userRecordPurchaseLimit) || ctype_digit($userRecordPurchaseLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userRecordPurchaseLimit, true), gettype($userRecordPurchaseLimit)), __LINE__);
        }
        if (is_null($userRecordPurchaseLimit) || (is_array($userRecordPurchaseLimit) && empty($userRecordPurchaseLimit))) {
            unset($this->UserRecordPurchaseLimit);
        } else {
            $this->UserRecordPurchaseLimit = $userRecordPurchaseLimit;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\DataIntegrationRecordPurchasePermission
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
