<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomSetupDefinition StructType
 * @subpackage Structs
 */
class CustomSetupDefinition extends SObject
{
    /**
     * The ClientName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientName;
    /**
     * The DataType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataType;
    /**
     * The DomainSobjectType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DomainSobjectType;
    /**
     * The KeyPath
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KeyPath;
    /**
     * The MasterLabel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MasterLabel;
    /**
     * The OptionsFlagIsReadOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsFlagIsReadOnly;
    /**
     * The OptionsFlagIsVisible
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsFlagIsVisible;
    /**
     * The SobjectType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SobjectType;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * Constructor method for CustomSetupDefinition
     * @uses CustomSetupDefinition::setClientName()
     * @uses CustomSetupDefinition::setDataType()
     * @uses CustomSetupDefinition::setDomainSobjectType()
     * @uses CustomSetupDefinition::setKeyPath()
     * @uses CustomSetupDefinition::setMasterLabel()
     * @uses CustomSetupDefinition::setOptionsFlagIsReadOnly()
     * @uses CustomSetupDefinition::setOptionsFlagIsVisible()
     * @uses CustomSetupDefinition::setSobjectType()
     * @uses CustomSetupDefinition::setSystemModstamp()
     * @param string $clientName
     * @param string $dataType
     * @param string $domainSobjectType
     * @param string $keyPath
     * @param string $masterLabel
     * @param bool $optionsFlagIsReadOnly
     * @param bool $optionsFlagIsVisible
     * @param string $sobjectType
     * @param string $systemModstamp
     */
    public function __construct($clientName = null, $dataType = null, $domainSobjectType = null, $keyPath = null, $masterLabel = null, $optionsFlagIsReadOnly = null, $optionsFlagIsVisible = null, $sobjectType = null, $systemModstamp = null)
    {
        $this
            ->setClientName($clientName)
            ->setDataType($dataType)
            ->setDomainSobjectType($domainSobjectType)
            ->setKeyPath($keyPath)
            ->setMasterLabel($masterLabel)
            ->setOptionsFlagIsReadOnly($optionsFlagIsReadOnly)
            ->setOptionsFlagIsVisible($optionsFlagIsVisible)
            ->setSobjectType($sobjectType)
            ->setSystemModstamp($systemModstamp);
    }
    /**
     * Get ClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientName()
    {
        return isset($this->ClientName) ? $this->ClientName : null;
    }
    /**
     * Set ClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientName
     * @return \NexusDigital/MiratelForce\StructType\CustomSetupDefinition
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        if (is_null($clientName) || (is_array($clientName) && empty($clientName))) {
            unset($this->ClientName);
        } else {
            $this->ClientName = $clientName;
        }
        return $this;
    }
    /**
     * Get DataType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataType()
    {
        return isset($this->DataType) ? $this->DataType : null;
    }
    /**
     * Set DataType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataType
     * @return \NexusDigital/MiratelForce\StructType\CustomSetupDefinition
     */
    public function setDataType($dataType = null)
    {
        // validation for constraint: string
        if (!is_null($dataType) && !is_string($dataType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataType, true), gettype($dataType)), __LINE__);
        }
        if (is_null($dataType) || (is_array($dataType) && empty($dataType))) {
            unset($this->DataType);
        } else {
            $this->DataType = $dataType;
        }
        return $this;
    }
    /**
     * Get DomainSobjectType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDomainSobjectType()
    {
        return isset($this->DomainSobjectType) ? $this->DomainSobjectType : null;
    }
    /**
     * Set DomainSobjectType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $domainSobjectType
     * @return \NexusDigital/MiratelForce\StructType\CustomSetupDefinition
     */
    public function setDomainSobjectType($domainSobjectType = null)
    {
        // validation for constraint: string
        if (!is_null($domainSobjectType) && !is_string($domainSobjectType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domainSobjectType, true), gettype($domainSobjectType)), __LINE__);
        }
        if (is_null($domainSobjectType) || (is_array($domainSobjectType) && empty($domainSobjectType))) {
            unset($this->DomainSobjectType);
        } else {
            $this->DomainSobjectType = $domainSobjectType;
        }
        return $this;
    }
    /**
     * Get KeyPath value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKeyPath()
    {
        return isset($this->KeyPath) ? $this->KeyPath : null;
    }
    /**
     * Set KeyPath value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $keyPath
     * @return \NexusDigital/MiratelForce\StructType\CustomSetupDefinition
     */
    public function setKeyPath($keyPath = null)
    {
        // validation for constraint: string
        if (!is_null($keyPath) && !is_string($keyPath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyPath, true), gettype($keyPath)), __LINE__);
        }
        if (is_null($keyPath) || (is_array($keyPath) && empty($keyPath))) {
            unset($this->KeyPath);
        } else {
            $this->KeyPath = $keyPath;
        }
        return $this;
    }
    /**
     * Get MasterLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterLabel()
    {
        return isset($this->MasterLabel) ? $this->MasterLabel : null;
    }
    /**
     * Set MasterLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterLabel
     * @return \NexusDigital/MiratelForce\StructType\CustomSetupDefinition
     */
    public function setMasterLabel($masterLabel = null)
    {
        // validation for constraint: string
        if (!is_null($masterLabel) && !is_string($masterLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterLabel, true), gettype($masterLabel)), __LINE__);
        }
        if (is_null($masterLabel) || (is_array($masterLabel) && empty($masterLabel))) {
            unset($this->MasterLabel);
        } else {
            $this->MasterLabel = $masterLabel;
        }
        return $this;
    }
    /**
     * Get OptionsFlagIsReadOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsFlagIsReadOnly()
    {
        return isset($this->OptionsFlagIsReadOnly) ? $this->OptionsFlagIsReadOnly : null;
    }
    /**
     * Set OptionsFlagIsReadOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsFlagIsReadOnly
     * @return \NexusDigital/MiratelForce\StructType\CustomSetupDefinition
     */
    public function setOptionsFlagIsReadOnly($optionsFlagIsReadOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsFlagIsReadOnly) && !is_bool($optionsFlagIsReadOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsFlagIsReadOnly, true), gettype($optionsFlagIsReadOnly)), __LINE__);
        }
        if (is_null($optionsFlagIsReadOnly) || (is_array($optionsFlagIsReadOnly) && empty($optionsFlagIsReadOnly))) {
            unset($this->OptionsFlagIsReadOnly);
        } else {
            $this->OptionsFlagIsReadOnly = $optionsFlagIsReadOnly;
        }
        return $this;
    }
    /**
     * Get OptionsFlagIsVisible value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsFlagIsVisible()
    {
        return isset($this->OptionsFlagIsVisible) ? $this->OptionsFlagIsVisible : null;
    }
    /**
     * Set OptionsFlagIsVisible value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsFlagIsVisible
     * @return \NexusDigital/MiratelForce\StructType\CustomSetupDefinition
     */
    public function setOptionsFlagIsVisible($optionsFlagIsVisible = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsFlagIsVisible) && !is_bool($optionsFlagIsVisible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsFlagIsVisible, true), gettype($optionsFlagIsVisible)), __LINE__);
        }
        if (is_null($optionsFlagIsVisible) || (is_array($optionsFlagIsVisible) && empty($optionsFlagIsVisible))) {
            unset($this->OptionsFlagIsVisible);
        } else {
            $this->OptionsFlagIsVisible = $optionsFlagIsVisible;
        }
        return $this;
    }
    /**
     * Get SobjectType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSobjectType()
    {
        return isset($this->SobjectType) ? $this->SobjectType : null;
    }
    /**
     * Set SobjectType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sobjectType
     * @return \NexusDigital/MiratelForce\StructType\CustomSetupDefinition
     */
    public function setSobjectType($sobjectType = null)
    {
        // validation for constraint: string
        if (!is_null($sobjectType) && !is_string($sobjectType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sobjectType, true), gettype($sobjectType)), __LINE__);
        }
        if (is_null($sobjectType) || (is_array($sobjectType) && empty($sobjectType))) {
            unset($this->SobjectType);
        } else {
            $this->SobjectType = $sobjectType;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\CustomSetupDefinition
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\CustomSetupDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
