<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContentVersionComment StructType
 * @subpackage Structs
 */
class ContentVersionComment extends SObject
{
    /**
     * The ContentDocument
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ContentDocument
     */
    public $ContentDocument;
    /**
     * The ContentDocumentId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ContentDocumentId;
    /**
     * The ContentVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public $ContentVersion;
    /**
     * The ContentVersionId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ContentVersionId;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The UserComment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserComment;
    /**
     * Constructor method for ContentVersionComment
     * @uses ContentVersionComment::setContentDocument()
     * @uses ContentVersionComment::setContentDocumentId()
     * @uses ContentVersionComment::setContentVersion()
     * @uses ContentVersionComment::setContentVersionId()
     * @uses ContentVersionComment::setCreatedDate()
     * @uses ContentVersionComment::setUserComment()
     * @param \NexusDigital/MiratelForce\StructType\ContentDocument $contentDocument
     * @param string $contentDocumentId
     * @param \NexusDigital/MiratelForce\StructType\ContentVersion $contentVersion
     * @param string $contentVersionId
     * @param string $createdDate
     * @param string $userComment
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\ContentDocument $contentDocument = null, $contentDocumentId = null, \NexusDigital/MiratelForce\StructType\ContentVersion $contentVersion = null, $contentVersionId = null, $createdDate = null, $userComment = null)
    {
        $this
            ->setContentDocument($contentDocument)
            ->setContentDocumentId($contentDocumentId)
            ->setContentVersion($contentVersion)
            ->setContentVersionId($contentVersionId)
            ->setCreatedDate($createdDate)
            ->setUserComment($userComment);
    }
    /**
     * Get ContentDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ContentDocument|null
     */
    public function getContentDocument()
    {
        return isset($this->ContentDocument) ? $this->ContentDocument : null;
    }
    /**
     * Set ContentDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ContentDocument $contentDocument
     * @return \NexusDigital/MiratelForce\StructType\ContentVersionComment
     */
    public function setContentDocument(\NexusDigital/MiratelForce\StructType\ContentDocument $contentDocument = null)
    {
        if (is_null($contentDocument) || (is_array($contentDocument) && empty($contentDocument))) {
            unset($this->ContentDocument);
        } else {
            $this->ContentDocument = $contentDocument;
        }
        return $this;
    }
    /**
     * Get ContentDocumentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContentDocumentId()
    {
        return isset($this->ContentDocumentId) ? $this->ContentDocumentId : null;
    }
    /**
     * Set ContentDocumentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contentDocumentId
     * @return \NexusDigital/MiratelForce\StructType\ContentVersionComment
     */
    public function setContentDocumentId($contentDocumentId = null)
    {
        // validation for constraint: string
        if (!is_null($contentDocumentId) && !is_string($contentDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentDocumentId, true), gettype($contentDocumentId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($contentDocumentId) && mb_strlen($contentDocumentId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($contentDocumentId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($contentDocumentId) && !preg_match('/[a-zA-Z0-9]{18}/', $contentDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($contentDocumentId, true)), __LINE__);
        }
        if (is_null($contentDocumentId) || (is_array($contentDocumentId) && empty($contentDocumentId))) {
            unset($this->ContentDocumentId);
        } else {
            $this->ContentDocumentId = $contentDocumentId;
        }
        return $this;
    }
    /**
     * Get ContentVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion|null
     */
    public function getContentVersion()
    {
        return isset($this->ContentVersion) ? $this->ContentVersion : null;
    }
    /**
     * Set ContentVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ContentVersion $contentVersion
     * @return \NexusDigital/MiratelForce\StructType\ContentVersionComment
     */
    public function setContentVersion(\NexusDigital/MiratelForce\StructType\ContentVersion $contentVersion = null)
    {
        if (is_null($contentVersion) || (is_array($contentVersion) && empty($contentVersion))) {
            unset($this->ContentVersion);
        } else {
            $this->ContentVersion = $contentVersion;
        }
        return $this;
    }
    /**
     * Get ContentVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContentVersionId()
    {
        return isset($this->ContentVersionId) ? $this->ContentVersionId : null;
    }
    /**
     * Set ContentVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contentVersionId
     * @return \NexusDigital/MiratelForce\StructType\ContentVersionComment
     */
    public function setContentVersionId($contentVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($contentVersionId) && !is_string($contentVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentVersionId, true), gettype($contentVersionId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($contentVersionId) && mb_strlen($contentVersionId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($contentVersionId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($contentVersionId) && !preg_match('/[a-zA-Z0-9]{18}/', $contentVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($contentVersionId, true)), __LINE__);
        }
        if (is_null($contentVersionId) || (is_array($contentVersionId) && empty($contentVersionId))) {
            unset($this->ContentVersionId);
        } else {
            $this->ContentVersionId = $contentVersionId;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\ContentVersionComment
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get UserComment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserComment()
    {
        return isset($this->UserComment) ? $this->UserComment : null;
    }
    /**
     * Set UserComment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userComment
     * @return \NexusDigital/MiratelForce\StructType\ContentVersionComment
     */
    public function setUserComment($userComment = null)
    {
        // validation for constraint: string
        if (!is_null($userComment) && !is_string($userComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userComment, true), gettype($userComment)), __LINE__);
        }
        if (is_null($userComment) || (is_array($userComment) && empty($userComment))) {
            unset($this->UserComment);
        } else {
            $this->UserComment = $userComment;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ContentVersionComment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
