<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContentDistribution StructType
 * @subpackage Structs
 */
class ContentDistribution extends SObject
{
    /**
     * The ContentDistributionViews
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ContentDistributionViews;
    /**
     * The ContentDocumentId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ContentDocumentId;
    /**
     * The ContentDownloadUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContentDownloadUrl;
    /**
     * The ContentVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ContentVersion
     */
    public $ContentVersion;
    /**
     * The ContentVersionId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ContentVersionId;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The DistributionPublicUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DistributionPublicUrl;
    /**
     * The ExpiryDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryDate;
    /**
     * The FirstViewDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstViewDate;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LastViewDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastViewDate;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Owner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $Owner;
    /**
     * The OwnerId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $OwnerId;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * The PdfDownloadUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PdfDownloadUrl;
    /**
     * The PreferencesAllowOriginalDownload
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesAllowOriginalDownload;
    /**
     * The PreferencesAllowPDFDownload
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesAllowPDFDownload;
    /**
     * The PreferencesAllowViewInBrowser
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesAllowViewInBrowser;
    /**
     * The PreferencesExpires
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesExpires;
    /**
     * The PreferencesLinkLatestVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesLinkLatestVersion;
    /**
     * The PreferencesNotifyOnVisit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesNotifyOnVisit;
    /**
     * The PreferencesNotifyRndtnComplete
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesNotifyRndtnComplete;
    /**
     * The PreferencesPasswordRequired
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PreferencesPasswordRequired;
    /**
     * The RelatedRecord
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\SObject
     */
    public $RelatedRecord;
    /**
     * The RelatedRecordId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $RelatedRecordId;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The ViewCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ViewCount;
    /**
     * Constructor method for ContentDistribution
     * @uses ContentDistribution::setContentDistributionViews()
     * @uses ContentDistribution::setContentDocumentId()
     * @uses ContentDistribution::setContentDownloadUrl()
     * @uses ContentDistribution::setContentVersion()
     * @uses ContentDistribution::setContentVersionId()
     * @uses ContentDistribution::setCreatedBy()
     * @uses ContentDistribution::setCreatedById()
     * @uses ContentDistribution::setCreatedDate()
     * @uses ContentDistribution::setDistributionPublicUrl()
     * @uses ContentDistribution::setExpiryDate()
     * @uses ContentDistribution::setFirstViewDate()
     * @uses ContentDistribution::setIsDeleted()
     * @uses ContentDistribution::setLastModifiedBy()
     * @uses ContentDistribution::setLastModifiedById()
     * @uses ContentDistribution::setLastModifiedDate()
     * @uses ContentDistribution::setLastViewDate()
     * @uses ContentDistribution::setName()
     * @uses ContentDistribution::setOwner()
     * @uses ContentDistribution::setOwnerId()
     * @uses ContentDistribution::setPassword()
     * @uses ContentDistribution::setPdfDownloadUrl()
     * @uses ContentDistribution::setPreferencesAllowOriginalDownload()
     * @uses ContentDistribution::setPreferencesAllowPDFDownload()
     * @uses ContentDistribution::setPreferencesAllowViewInBrowser()
     * @uses ContentDistribution::setPreferencesExpires()
     * @uses ContentDistribution::setPreferencesLinkLatestVersion()
     * @uses ContentDistribution::setPreferencesNotifyOnVisit()
     * @uses ContentDistribution::setPreferencesNotifyRndtnComplete()
     * @uses ContentDistribution::setPreferencesPasswordRequired()
     * @uses ContentDistribution::setRelatedRecord()
     * @uses ContentDistribution::setRelatedRecordId()
     * @uses ContentDistribution::setSystemModstamp()
     * @uses ContentDistribution::setViewCount()
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDistributionViews
     * @param string $contentDocumentId
     * @param string $contentDownloadUrl
     * @param \NexusDigital/MiratelForce\StructType\ContentVersion $contentVersion
     * @param string $contentVersionId
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $distributionPublicUrl
     * @param string $expiryDate
     * @param string $firstViewDate
     * @param bool $isDeleted
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $lastViewDate
     * @param string $name
     * @param \NexusDigital/MiratelForce\StructType\User $owner
     * @param string $ownerId
     * @param string $password
     * @param string $pdfDownloadUrl
     * @param bool $preferencesAllowOriginalDownload
     * @param bool $preferencesAllowPDFDownload
     * @param bool $preferencesAllowViewInBrowser
     * @param bool $preferencesExpires
     * @param bool $preferencesLinkLatestVersion
     * @param bool $preferencesNotifyOnVisit
     * @param bool $preferencesNotifyRndtnComplete
     * @param bool $preferencesPasswordRequired
     * @param \NexusDigital/MiratelForce\StructType\SObject $relatedRecord
     * @param string $relatedRecordId
     * @param string $systemModstamp
     * @param int $viewCount
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\QueryResult $contentDistributionViews = null, $contentDocumentId = null, $contentDownloadUrl = null, \NexusDigital/MiratelForce\StructType\ContentVersion $contentVersion = null, $contentVersionId = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $distributionPublicUrl = null, $expiryDate = null, $firstViewDate = null, $isDeleted = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $lastViewDate = null, $name = null, \NexusDigital/MiratelForce\StructType\User $owner = null, $ownerId = null, $password = null, $pdfDownloadUrl = null, $preferencesAllowOriginalDownload = null, $preferencesAllowPDFDownload = null, $preferencesAllowViewInBrowser = null, $preferencesExpires = null, $preferencesLinkLatestVersion = null, $preferencesNotifyOnVisit = null, $preferencesNotifyRndtnComplete = null, $preferencesPasswordRequired = null, \NexusDigital/MiratelForce\StructType\SObject $relatedRecord = null, $relatedRecordId = null, $systemModstamp = null, $viewCount = null)
    {
        $this
            ->setContentDistributionViews($contentDistributionViews)
            ->setContentDocumentId($contentDocumentId)
            ->setContentDownloadUrl($contentDownloadUrl)
            ->setContentVersion($contentVersion)
            ->setContentVersionId($contentVersionId)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDistributionPublicUrl($distributionPublicUrl)
            ->setExpiryDate($expiryDate)
            ->setFirstViewDate($firstViewDate)
            ->setIsDeleted($isDeleted)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLastViewDate($lastViewDate)
            ->setName($name)
            ->setOwner($owner)
            ->setOwnerId($ownerId)
            ->setPassword($password)
            ->setPdfDownloadUrl($pdfDownloadUrl)
            ->setPreferencesAllowOriginalDownload($preferencesAllowOriginalDownload)
            ->setPreferencesAllowPDFDownload($preferencesAllowPDFDownload)
            ->setPreferencesAllowViewInBrowser($preferencesAllowViewInBrowser)
            ->setPreferencesExpires($preferencesExpires)
            ->setPreferencesLinkLatestVersion($preferencesLinkLatestVersion)
            ->setPreferencesNotifyOnVisit($preferencesNotifyOnVisit)
            ->setPreferencesNotifyRndtnComplete($preferencesNotifyRndtnComplete)
            ->setPreferencesPasswordRequired($preferencesPasswordRequired)
            ->setRelatedRecord($relatedRecord)
            ->setRelatedRecordId($relatedRecordId)
            ->setSystemModstamp($systemModstamp)
            ->setViewCount($viewCount);
    }
    /**
     * Get ContentDistributionViews value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getContentDistributionViews()
    {
        return isset($this->ContentDistributionViews) ? $this->ContentDistributionViews : null;
    }
    /**
     * Set ContentDistributionViews value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $contentDistributionViews
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setContentDistributionViews(\NexusDigital/MiratelForce\StructType\QueryResult $contentDistributionViews = null)
    {
        if (is_null($contentDistributionViews) || (is_array($contentDistributionViews) && empty($contentDistributionViews))) {
            unset($this->ContentDistributionViews);
        } else {
            $this->ContentDistributionViews = $contentDistributionViews;
        }
        return $this;
    }
    /**
     * Get ContentDocumentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContentDocumentId()
    {
        return isset($this->ContentDocumentId) ? $this->ContentDocumentId : null;
    }
    /**
     * Set ContentDocumentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contentDocumentId
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setContentDocumentId($contentDocumentId = null)
    {
        // validation for constraint: string
        if (!is_null($contentDocumentId) && !is_string($contentDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentDocumentId, true), gettype($contentDocumentId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($contentDocumentId) && mb_strlen($contentDocumentId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($contentDocumentId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($contentDocumentId) && !preg_match('/[a-zA-Z0-9]{18}/', $contentDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($contentDocumentId, true)), __LINE__);
        }
        if (is_null($contentDocumentId) || (is_array($contentDocumentId) && empty($contentDocumentId))) {
            unset($this->ContentDocumentId);
        } else {
            $this->ContentDocumentId = $contentDocumentId;
        }
        return $this;
    }
    /**
     * Get ContentDownloadUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContentDownloadUrl()
    {
        return isset($this->ContentDownloadUrl) ? $this->ContentDownloadUrl : null;
    }
    /**
     * Set ContentDownloadUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contentDownloadUrl
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setContentDownloadUrl($contentDownloadUrl = null)
    {
        // validation for constraint: string
        if (!is_null($contentDownloadUrl) && !is_string($contentDownloadUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentDownloadUrl, true), gettype($contentDownloadUrl)), __LINE__);
        }
        if (is_null($contentDownloadUrl) || (is_array($contentDownloadUrl) && empty($contentDownloadUrl))) {
            unset($this->ContentDownloadUrl);
        } else {
            $this->ContentDownloadUrl = $contentDownloadUrl;
        }
        return $this;
    }
    /**
     * Get ContentVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ContentVersion|null
     */
    public function getContentVersion()
    {
        return isset($this->ContentVersion) ? $this->ContentVersion : null;
    }
    /**
     * Set ContentVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ContentVersion $contentVersion
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setContentVersion(\NexusDigital/MiratelForce\StructType\ContentVersion $contentVersion = null)
    {
        if (is_null($contentVersion) || (is_array($contentVersion) && empty($contentVersion))) {
            unset($this->ContentVersion);
        } else {
            $this->ContentVersion = $contentVersion;
        }
        return $this;
    }
    /**
     * Get ContentVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContentVersionId()
    {
        return isset($this->ContentVersionId) ? $this->ContentVersionId : null;
    }
    /**
     * Set ContentVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contentVersionId
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setContentVersionId($contentVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($contentVersionId) && !is_string($contentVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentVersionId, true), gettype($contentVersionId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($contentVersionId) && mb_strlen($contentVersionId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($contentVersionId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($contentVersionId) && !preg_match('/[a-zA-Z0-9]{18}/', $contentVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($contentVersionId, true)), __LINE__);
        }
        if (is_null($contentVersionId) || (is_array($contentVersionId) && empty($contentVersionId))) {
            unset($this->ContentVersionId);
        } else {
            $this->ContentVersionId = $contentVersionId;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get DistributionPublicUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDistributionPublicUrl()
    {
        return isset($this->DistributionPublicUrl) ? $this->DistributionPublicUrl : null;
    }
    /**
     * Set DistributionPublicUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $distributionPublicUrl
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setDistributionPublicUrl($distributionPublicUrl = null)
    {
        // validation for constraint: string
        if (!is_null($distributionPublicUrl) && !is_string($distributionPublicUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distributionPublicUrl, true), gettype($distributionPublicUrl)), __LINE__);
        }
        if (is_null($distributionPublicUrl) || (is_array($distributionPublicUrl) && empty($distributionPublicUrl))) {
            unset($this->DistributionPublicUrl);
        } else {
            $this->DistributionPublicUrl = $distributionPublicUrl;
        }
        return $this;
    }
    /**
     * Get ExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryDate()
    {
        return isset($this->ExpiryDate) ? $this->ExpiryDate : null;
    }
    /**
     * Set ExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryDate
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        if (is_null($expiryDate) || (is_array($expiryDate) && empty($expiryDate))) {
            unset($this->ExpiryDate);
        } else {
            $this->ExpiryDate = $expiryDate;
        }
        return $this;
    }
    /**
     * Get FirstViewDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstViewDate()
    {
        return isset($this->FirstViewDate) ? $this->FirstViewDate : null;
    }
    /**
     * Set FirstViewDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstViewDate
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setFirstViewDate($firstViewDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstViewDate) && !is_string($firstViewDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstViewDate, true), gettype($firstViewDate)), __LINE__);
        }
        if (is_null($firstViewDate) || (is_array($firstViewDate) && empty($firstViewDate))) {
            unset($this->FirstViewDate);
        } else {
            $this->FirstViewDate = $firstViewDate;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LastViewDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastViewDate()
    {
        return isset($this->LastViewDate) ? $this->LastViewDate : null;
    }
    /**
     * Set LastViewDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastViewDate
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setLastViewDate($lastViewDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastViewDate) && !is_string($lastViewDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastViewDate, true), gettype($lastViewDate)), __LINE__);
        }
        if (is_null($lastViewDate) || (is_array($lastViewDate) && empty($lastViewDate))) {
            unset($this->LastViewDate);
        } else {
            $this->LastViewDate = $lastViewDate;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $owner
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setOwner(\NexusDigital/MiratelForce\StructType\User $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($ownerId) && mb_strlen($ownerId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($ownerId) && !preg_match('/[a-zA-Z0-9]{18}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->Password) ? $this->Password : null;
    }
    /**
     * Set Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->Password);
        } else {
            $this->Password = $password;
        }
        return $this;
    }
    /**
     * Get PdfDownloadUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPdfDownloadUrl()
    {
        return isset($this->PdfDownloadUrl) ? $this->PdfDownloadUrl : null;
    }
    /**
     * Set PdfDownloadUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pdfDownloadUrl
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setPdfDownloadUrl($pdfDownloadUrl = null)
    {
        // validation for constraint: string
        if (!is_null($pdfDownloadUrl) && !is_string($pdfDownloadUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pdfDownloadUrl, true), gettype($pdfDownloadUrl)), __LINE__);
        }
        if (is_null($pdfDownloadUrl) || (is_array($pdfDownloadUrl) && empty($pdfDownloadUrl))) {
            unset($this->PdfDownloadUrl);
        } else {
            $this->PdfDownloadUrl = $pdfDownloadUrl;
        }
        return $this;
    }
    /**
     * Get PreferencesAllowOriginalDownload value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesAllowOriginalDownload()
    {
        return isset($this->PreferencesAllowOriginalDownload) ? $this->PreferencesAllowOriginalDownload : null;
    }
    /**
     * Set PreferencesAllowOriginalDownload value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesAllowOriginalDownload
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setPreferencesAllowOriginalDownload($preferencesAllowOriginalDownload = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesAllowOriginalDownload) && !is_bool($preferencesAllowOriginalDownload)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesAllowOriginalDownload, true), gettype($preferencesAllowOriginalDownload)), __LINE__);
        }
        if (is_null($preferencesAllowOriginalDownload) || (is_array($preferencesAllowOriginalDownload) && empty($preferencesAllowOriginalDownload))) {
            unset($this->PreferencesAllowOriginalDownload);
        } else {
            $this->PreferencesAllowOriginalDownload = $preferencesAllowOriginalDownload;
        }
        return $this;
    }
    /**
     * Get PreferencesAllowPDFDownload value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesAllowPDFDownload()
    {
        return isset($this->PreferencesAllowPDFDownload) ? $this->PreferencesAllowPDFDownload : null;
    }
    /**
     * Set PreferencesAllowPDFDownload value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesAllowPDFDownload
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setPreferencesAllowPDFDownload($preferencesAllowPDFDownload = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesAllowPDFDownload) && !is_bool($preferencesAllowPDFDownload)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesAllowPDFDownload, true), gettype($preferencesAllowPDFDownload)), __LINE__);
        }
        if (is_null($preferencesAllowPDFDownload) || (is_array($preferencesAllowPDFDownload) && empty($preferencesAllowPDFDownload))) {
            unset($this->PreferencesAllowPDFDownload);
        } else {
            $this->PreferencesAllowPDFDownload = $preferencesAllowPDFDownload;
        }
        return $this;
    }
    /**
     * Get PreferencesAllowViewInBrowser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesAllowViewInBrowser()
    {
        return isset($this->PreferencesAllowViewInBrowser) ? $this->PreferencesAllowViewInBrowser : null;
    }
    /**
     * Set PreferencesAllowViewInBrowser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesAllowViewInBrowser
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setPreferencesAllowViewInBrowser($preferencesAllowViewInBrowser = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesAllowViewInBrowser) && !is_bool($preferencesAllowViewInBrowser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesAllowViewInBrowser, true), gettype($preferencesAllowViewInBrowser)), __LINE__);
        }
        if (is_null($preferencesAllowViewInBrowser) || (is_array($preferencesAllowViewInBrowser) && empty($preferencesAllowViewInBrowser))) {
            unset($this->PreferencesAllowViewInBrowser);
        } else {
            $this->PreferencesAllowViewInBrowser = $preferencesAllowViewInBrowser;
        }
        return $this;
    }
    /**
     * Get PreferencesExpires value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesExpires()
    {
        return isset($this->PreferencesExpires) ? $this->PreferencesExpires : null;
    }
    /**
     * Set PreferencesExpires value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesExpires
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setPreferencesExpires($preferencesExpires = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesExpires) && !is_bool($preferencesExpires)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesExpires, true), gettype($preferencesExpires)), __LINE__);
        }
        if (is_null($preferencesExpires) || (is_array($preferencesExpires) && empty($preferencesExpires))) {
            unset($this->PreferencesExpires);
        } else {
            $this->PreferencesExpires = $preferencesExpires;
        }
        return $this;
    }
    /**
     * Get PreferencesLinkLatestVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesLinkLatestVersion()
    {
        return isset($this->PreferencesLinkLatestVersion) ? $this->PreferencesLinkLatestVersion : null;
    }
    /**
     * Set PreferencesLinkLatestVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesLinkLatestVersion
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setPreferencesLinkLatestVersion($preferencesLinkLatestVersion = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesLinkLatestVersion) && !is_bool($preferencesLinkLatestVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesLinkLatestVersion, true), gettype($preferencesLinkLatestVersion)), __LINE__);
        }
        if (is_null($preferencesLinkLatestVersion) || (is_array($preferencesLinkLatestVersion) && empty($preferencesLinkLatestVersion))) {
            unset($this->PreferencesLinkLatestVersion);
        } else {
            $this->PreferencesLinkLatestVersion = $preferencesLinkLatestVersion;
        }
        return $this;
    }
    /**
     * Get PreferencesNotifyOnVisit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesNotifyOnVisit()
    {
        return isset($this->PreferencesNotifyOnVisit) ? $this->PreferencesNotifyOnVisit : null;
    }
    /**
     * Set PreferencesNotifyOnVisit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesNotifyOnVisit
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setPreferencesNotifyOnVisit($preferencesNotifyOnVisit = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesNotifyOnVisit) && !is_bool($preferencesNotifyOnVisit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesNotifyOnVisit, true), gettype($preferencesNotifyOnVisit)), __LINE__);
        }
        if (is_null($preferencesNotifyOnVisit) || (is_array($preferencesNotifyOnVisit) && empty($preferencesNotifyOnVisit))) {
            unset($this->PreferencesNotifyOnVisit);
        } else {
            $this->PreferencesNotifyOnVisit = $preferencesNotifyOnVisit;
        }
        return $this;
    }
    /**
     * Get PreferencesNotifyRndtnComplete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesNotifyRndtnComplete()
    {
        return isset($this->PreferencesNotifyRndtnComplete) ? $this->PreferencesNotifyRndtnComplete : null;
    }
    /**
     * Set PreferencesNotifyRndtnComplete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesNotifyRndtnComplete
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setPreferencesNotifyRndtnComplete($preferencesNotifyRndtnComplete = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesNotifyRndtnComplete) && !is_bool($preferencesNotifyRndtnComplete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesNotifyRndtnComplete, true), gettype($preferencesNotifyRndtnComplete)), __LINE__);
        }
        if (is_null($preferencesNotifyRndtnComplete) || (is_array($preferencesNotifyRndtnComplete) && empty($preferencesNotifyRndtnComplete))) {
            unset($this->PreferencesNotifyRndtnComplete);
        } else {
            $this->PreferencesNotifyRndtnComplete = $preferencesNotifyRndtnComplete;
        }
        return $this;
    }
    /**
     * Get PreferencesPasswordRequired value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPreferencesPasswordRequired()
    {
        return isset($this->PreferencesPasswordRequired) ? $this->PreferencesPasswordRequired : null;
    }
    /**
     * Set PreferencesPasswordRequired value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $preferencesPasswordRequired
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setPreferencesPasswordRequired($preferencesPasswordRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferencesPasswordRequired) && !is_bool($preferencesPasswordRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferencesPasswordRequired, true), gettype($preferencesPasswordRequired)), __LINE__);
        }
        if (is_null($preferencesPasswordRequired) || (is_array($preferencesPasswordRequired) && empty($preferencesPasswordRequired))) {
            unset($this->PreferencesPasswordRequired);
        } else {
            $this->PreferencesPasswordRequired = $preferencesPasswordRequired;
        }
        return $this;
    }
    /**
     * Get RelatedRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\SObject|null
     */
    public function getRelatedRecord()
    {
        return isset($this->RelatedRecord) ? $this->RelatedRecord : null;
    }
    /**
     * Set RelatedRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\SObject $relatedRecord
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setRelatedRecord(\NexusDigital/MiratelForce\StructType\SObject $relatedRecord = null)
    {
        if (is_null($relatedRecord) || (is_array($relatedRecord) && empty($relatedRecord))) {
            unset($this->RelatedRecord);
        } else {
            $this->RelatedRecord = $relatedRecord;
        }
        return $this;
    }
    /**
     * Get RelatedRecordId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedRecordId()
    {
        return isset($this->RelatedRecordId) ? $this->RelatedRecordId : null;
    }
    /**
     * Set RelatedRecordId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedRecordId
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setRelatedRecordId($relatedRecordId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedRecordId) && !is_string($relatedRecordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedRecordId, true), gettype($relatedRecordId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($relatedRecordId) && mb_strlen($relatedRecordId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($relatedRecordId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($relatedRecordId) && !preg_match('/[a-zA-Z0-9]{18}/', $relatedRecordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($relatedRecordId, true)), __LINE__);
        }
        if (is_null($relatedRecordId) || (is_array($relatedRecordId) && empty($relatedRecordId))) {
            unset($this->RelatedRecordId);
        } else {
            $this->RelatedRecordId = $relatedRecordId;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get ViewCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getViewCount()
    {
        return isset($this->ViewCount) ? $this->ViewCount : null;
    }
    /**
     * Set ViewCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $viewCount
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public function setViewCount($viewCount = null)
    {
        // validation for constraint: int
        if (!is_null($viewCount) && !(is_int($viewCount) || ctype_digit($viewCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($viewCount, true), gettype($viewCount)), __LINE__);
        }
        if (is_null($viewCount) || (is_array($viewCount) && empty($viewCount))) {
            unset($this->ViewCount);
        } else {
            $this->ViewCount = $viewCount;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ContentDistribution
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
