<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientBrowser StructType
 * @subpackage Structs
 */
class ClientBrowser extends SObject
{
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The FullUserAgent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FullUserAgent;
    /**
     * The LastUpdate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUpdate;
    /**
     * The ProxyInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProxyInfo;
    /**
     * The Users
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $Users;
    /**
     * The UsersId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $UsersId;
    /**
     * Constructor method for ClientBrowser
     * @uses ClientBrowser::setCreatedDate()
     * @uses ClientBrowser::setFullUserAgent()
     * @uses ClientBrowser::setLastUpdate()
     * @uses ClientBrowser::setProxyInfo()
     * @uses ClientBrowser::setUsers()
     * @uses ClientBrowser::setUsersId()
     * @param string $createdDate
     * @param string $fullUserAgent
     * @param string $lastUpdate
     * @param string $proxyInfo
     * @param \NexusDigital/MiratelForce\StructType\User $users
     * @param string $usersId
     */
    public function __construct($createdDate = null, $fullUserAgent = null, $lastUpdate = null, $proxyInfo = null, \NexusDigital/MiratelForce\StructType\User $users = null, $usersId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setFullUserAgent($fullUserAgent)
            ->setLastUpdate($lastUpdate)
            ->setProxyInfo($proxyInfo)
            ->setUsers($users)
            ->setUsersId($usersId);
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\ClientBrowser
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get FullUserAgent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFullUserAgent()
    {
        return isset($this->FullUserAgent) ? $this->FullUserAgent : null;
    }
    /**
     * Set FullUserAgent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fullUserAgent
     * @return \NexusDigital/MiratelForce\StructType\ClientBrowser
     */
    public function setFullUserAgent($fullUserAgent = null)
    {
        // validation for constraint: string
        if (!is_null($fullUserAgent) && !is_string($fullUserAgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullUserAgent, true), gettype($fullUserAgent)), __LINE__);
        }
        if (is_null($fullUserAgent) || (is_array($fullUserAgent) && empty($fullUserAgent))) {
            unset($this->FullUserAgent);
        } else {
            $this->FullUserAgent = $fullUserAgent;
        }
        return $this;
    }
    /**
     * Get LastUpdate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUpdate()
    {
        return isset($this->LastUpdate) ? $this->LastUpdate : null;
    }
    /**
     * Set LastUpdate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUpdate
     * @return \NexusDigital/MiratelForce\StructType\ClientBrowser
     */
    public function setLastUpdate($lastUpdate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdate) && !is_string($lastUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdate, true), gettype($lastUpdate)), __LINE__);
        }
        if (is_null($lastUpdate) || (is_array($lastUpdate) && empty($lastUpdate))) {
            unset($this->LastUpdate);
        } else {
            $this->LastUpdate = $lastUpdate;
        }
        return $this;
    }
    /**
     * Get ProxyInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProxyInfo()
    {
        return isset($this->ProxyInfo) ? $this->ProxyInfo : null;
    }
    /**
     * Set ProxyInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $proxyInfo
     * @return \NexusDigital/MiratelForce\StructType\ClientBrowser
     */
    public function setProxyInfo($proxyInfo = null)
    {
        // validation for constraint: string
        if (!is_null($proxyInfo) && !is_string($proxyInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proxyInfo, true), gettype($proxyInfo)), __LINE__);
        }
        if (is_null($proxyInfo) || (is_array($proxyInfo) && empty($proxyInfo))) {
            unset($this->ProxyInfo);
        } else {
            $this->ProxyInfo = $proxyInfo;
        }
        return $this;
    }
    /**
     * Get Users value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getUsers()
    {
        return isset($this->Users) ? $this->Users : null;
    }
    /**
     * Set Users value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $users
     * @return \NexusDigital/MiratelForce\StructType\ClientBrowser
     */
    public function setUsers(\NexusDigital/MiratelForce\StructType\User $users = null)
    {
        if (is_null($users) || (is_array($users) && empty($users))) {
            unset($this->Users);
        } else {
            $this->Users = $users;
        }
        return $this;
    }
    /**
     * Get UsersId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsersId()
    {
        return isset($this->UsersId) ? $this->UsersId : null;
    }
    /**
     * Set UsersId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $usersId
     * @return \NexusDigital/MiratelForce\StructType\ClientBrowser
     */
    public function setUsersId($usersId = null)
    {
        // validation for constraint: string
        if (!is_null($usersId) && !is_string($usersId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usersId, true), gettype($usersId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($usersId) && mb_strlen($usersId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($usersId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($usersId) && !preg_match('/[a-zA-Z0-9]{18}/', $usersId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($usersId, true)), __LINE__);
        }
        if (is_null($usersId) || (is_array($usersId) && empty($usersId))) {
            unset($this->UsersId);
        } else {
            $this->UsersId = $usersId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ClientBrowser
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
