<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BatchApexErrorEvent StructType
 * @subpackage Structs
 */
class BatchApexErrorEvent extends SObject
{
    /**
     * The AsyncApexJobId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AsyncApexJobId;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The DoesExceedJobScopeMaxLength
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DoesExceedJobScopeMaxLength;
    /**
     * The ExceptionType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExceptionType;
    /**
     * The JobScope
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JobScope;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The Phase
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phase;
    /**
     * The ReplayId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReplayId;
    /**
     * The RequestId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestId;
    /**
     * The StackTrace
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StackTrace;
    /**
     * Constructor method for BatchApexErrorEvent
     * @uses BatchApexErrorEvent::setAsyncApexJobId()
     * @uses BatchApexErrorEvent::setCreatedBy()
     * @uses BatchApexErrorEvent::setCreatedById()
     * @uses BatchApexErrorEvent::setCreatedDate()
     * @uses BatchApexErrorEvent::setDoesExceedJobScopeMaxLength()
     * @uses BatchApexErrorEvent::setExceptionType()
     * @uses BatchApexErrorEvent::setJobScope()
     * @uses BatchApexErrorEvent::setMessage()
     * @uses BatchApexErrorEvent::setPhase()
     * @uses BatchApexErrorEvent::setReplayId()
     * @uses BatchApexErrorEvent::setRequestId()
     * @uses BatchApexErrorEvent::setStackTrace()
     * @param string $asyncApexJobId
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param bool $doesExceedJobScopeMaxLength
     * @param string $exceptionType
     * @param string $jobScope
     * @param string $message
     * @param string $phase
     * @param string $replayId
     * @param string $requestId
     * @param string $stackTrace
     */
    public function __construct($asyncApexJobId = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $doesExceedJobScopeMaxLength = null, $exceptionType = null, $jobScope = null, $message = null, $phase = null, $replayId = null, $requestId = null, $stackTrace = null)
    {
        $this
            ->setAsyncApexJobId($asyncApexJobId)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDoesExceedJobScopeMaxLength($doesExceedJobScopeMaxLength)
            ->setExceptionType($exceptionType)
            ->setJobScope($jobScope)
            ->setMessage($message)
            ->setPhase($phase)
            ->setReplayId($replayId)
            ->setRequestId($requestId)
            ->setStackTrace($stackTrace);
    }
    /**
     * Get AsyncApexJobId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsyncApexJobId()
    {
        return isset($this->AsyncApexJobId) ? $this->AsyncApexJobId : null;
    }
    /**
     * Set AsyncApexJobId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asyncApexJobId
     * @return \NexusDigital/MiratelForce\StructType\BatchApexErrorEvent
     */
    public function setAsyncApexJobId($asyncApexJobId = null)
    {
        // validation for constraint: string
        if (!is_null($asyncApexJobId) && !is_string($asyncApexJobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asyncApexJobId, true), gettype($asyncApexJobId)), __LINE__);
        }
        if (is_null($asyncApexJobId) || (is_array($asyncApexJobId) && empty($asyncApexJobId))) {
            unset($this->AsyncApexJobId);
        } else {
            $this->AsyncApexJobId = $asyncApexJobId;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\BatchApexErrorEvent
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\BatchApexErrorEvent
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\BatchApexErrorEvent
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get DoesExceedJobScopeMaxLength value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDoesExceedJobScopeMaxLength()
    {
        return isset($this->DoesExceedJobScopeMaxLength) ? $this->DoesExceedJobScopeMaxLength : null;
    }
    /**
     * Set DoesExceedJobScopeMaxLength value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $doesExceedJobScopeMaxLength
     * @return \NexusDigital/MiratelForce\StructType\BatchApexErrorEvent
     */
    public function setDoesExceedJobScopeMaxLength($doesExceedJobScopeMaxLength = null)
    {
        // validation for constraint: boolean
        if (!is_null($doesExceedJobScopeMaxLength) && !is_bool($doesExceedJobScopeMaxLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doesExceedJobScopeMaxLength, true), gettype($doesExceedJobScopeMaxLength)), __LINE__);
        }
        if (is_null($doesExceedJobScopeMaxLength) || (is_array($doesExceedJobScopeMaxLength) && empty($doesExceedJobScopeMaxLength))) {
            unset($this->DoesExceedJobScopeMaxLength);
        } else {
            $this->DoesExceedJobScopeMaxLength = $doesExceedJobScopeMaxLength;
        }
        return $this;
    }
    /**
     * Get ExceptionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExceptionType()
    {
        return isset($this->ExceptionType) ? $this->ExceptionType : null;
    }
    /**
     * Set ExceptionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exceptionType
     * @return \NexusDigital/MiratelForce\StructType\BatchApexErrorEvent
     */
    public function setExceptionType($exceptionType = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionType) && !is_string($exceptionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exceptionType, true), gettype($exceptionType)), __LINE__);
        }
        if (is_null($exceptionType) || (is_array($exceptionType) && empty($exceptionType))) {
            unset($this->ExceptionType);
        } else {
            $this->ExceptionType = $exceptionType;
        }
        return $this;
    }
    /**
     * Get JobScope value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJobScope()
    {
        return isset($this->JobScope) ? $this->JobScope : null;
    }
    /**
     * Set JobScope value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jobScope
     * @return \NexusDigital/MiratelForce\StructType\BatchApexErrorEvent
     */
    public function setJobScope($jobScope = null)
    {
        // validation for constraint: string
        if (!is_null($jobScope) && !is_string($jobScope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobScope, true), gettype($jobScope)), __LINE__);
        }
        if (is_null($jobScope) || (is_array($jobScope) && empty($jobScope))) {
            unset($this->JobScope);
        } else {
            $this->JobScope = $jobScope;
        }
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \NexusDigital/MiratelForce\StructType\BatchApexErrorEvent
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get Phase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhase()
    {
        return isset($this->Phase) ? $this->Phase : null;
    }
    /**
     * Set Phase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phase
     * @return \NexusDigital/MiratelForce\StructType\BatchApexErrorEvent
     */
    public function setPhase($phase = null)
    {
        // validation for constraint: string
        if (!is_null($phase) && !is_string($phase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phase, true), gettype($phase)), __LINE__);
        }
        if (is_null($phase) || (is_array($phase) && empty($phase))) {
            unset($this->Phase);
        } else {
            $this->Phase = $phase;
        }
        return $this;
    }
    /**
     * Get ReplayId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReplayId()
    {
        return isset($this->ReplayId) ? $this->ReplayId : null;
    }
    /**
     * Set ReplayId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $replayId
     * @return \NexusDigital/MiratelForce\StructType\BatchApexErrorEvent
     */
    public function setReplayId($replayId = null)
    {
        // validation for constraint: string
        if (!is_null($replayId) && !is_string($replayId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($replayId, true), gettype($replayId)), __LINE__);
        }
        if (is_null($replayId) || (is_array($replayId) && empty($replayId))) {
            unset($this->ReplayId);
        } else {
            $this->ReplayId = $replayId;
        }
        return $this;
    }
    /**
     * Get RequestId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestId()
    {
        return isset($this->RequestId) ? $this->RequestId : null;
    }
    /**
     * Set RequestId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestId
     * @return \NexusDigital/MiratelForce\StructType\BatchApexErrorEvent
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestId, true), gettype($requestId)), __LINE__);
        }
        if (is_null($requestId) || (is_array($requestId) && empty($requestId))) {
            unset($this->RequestId);
        } else {
            $this->RequestId = $requestId;
        }
        return $this;
    }
    /**
     * Get StackTrace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStackTrace()
    {
        return isset($this->StackTrace) ? $this->StackTrace : null;
    }
    /**
     * Set StackTrace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stackTrace
     * @return \NexusDigital/MiratelForce\StructType\BatchApexErrorEvent
     */
    public function setStackTrace($stackTrace = null)
    {
        // validation for constraint: string
        if (!is_null($stackTrace) && !is_string($stackTrace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stackTrace, true), gettype($stackTrace)), __LINE__);
        }
        if (is_null($stackTrace) || (is_array($stackTrace) && empty($stackTrace))) {
            unset($this->StackTrace);
        } else {
            $this->StackTrace = $stackTrace;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\BatchApexErrorEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
