<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BackgroundOperation StructType
 * @subpackage Structs
 */
class BackgroundOperation extends SObject
{
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The Error
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Error;
    /**
     * The ExecutionGroup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExecutionGroup;
    /**
     * The ExpiresAt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiresAt;
    /**
     * The FinishedAt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FinishedAt;
    /**
     * The GroupLeader
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public $GroupLeader;
    /**
     * The GroupLeaderId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $GroupLeaderId;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The MergedOperations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $MergedOperations;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NumFollowers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumFollowers;
    /**
     * The ParentKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ParentKey;
    /**
     * The ProcessAfter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProcessAfter;
    /**
     * The RetryBackoff
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RetryBackoff;
    /**
     * The RetryCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RetryCount;
    /**
     * The RetryLimit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RetryLimit;
    /**
     * The SequenceGroup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SequenceGroup;
    /**
     * The SequenceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SequenceNumber;
    /**
     * The StartedAt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartedAt;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The SubmittedAt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubmittedAt;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The Timeout
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Timeout;
    /**
     * The UserRecordAccess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\UserRecordAccess
     */
    public $UserRecordAccess;
    /**
     * The WorkerUri
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WorkerUri;
    /**
     * Constructor method for BackgroundOperation
     * @uses BackgroundOperation::setCreatedBy()
     * @uses BackgroundOperation::setCreatedById()
     * @uses BackgroundOperation::setCreatedDate()
     * @uses BackgroundOperation::setError()
     * @uses BackgroundOperation::setExecutionGroup()
     * @uses BackgroundOperation::setExpiresAt()
     * @uses BackgroundOperation::setFinishedAt()
     * @uses BackgroundOperation::setGroupLeader()
     * @uses BackgroundOperation::setGroupLeaderId()
     * @uses BackgroundOperation::setIsDeleted()
     * @uses BackgroundOperation::setLastModifiedBy()
     * @uses BackgroundOperation::setLastModifiedById()
     * @uses BackgroundOperation::setLastModifiedDate()
     * @uses BackgroundOperation::setMergedOperations()
     * @uses BackgroundOperation::setName()
     * @uses BackgroundOperation::setNumFollowers()
     * @uses BackgroundOperation::setParentKey()
     * @uses BackgroundOperation::setProcessAfter()
     * @uses BackgroundOperation::setRetryBackoff()
     * @uses BackgroundOperation::setRetryCount()
     * @uses BackgroundOperation::setRetryLimit()
     * @uses BackgroundOperation::setSequenceGroup()
     * @uses BackgroundOperation::setSequenceNumber()
     * @uses BackgroundOperation::setStartedAt()
     * @uses BackgroundOperation::setStatus()
     * @uses BackgroundOperation::setSubmittedAt()
     * @uses BackgroundOperation::setSystemModstamp()
     * @uses BackgroundOperation::setTimeout()
     * @uses BackgroundOperation::setUserRecordAccess()
     * @uses BackgroundOperation::setWorkerUri()
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $error
     * @param string $executionGroup
     * @param string $expiresAt
     * @param string $finishedAt
     * @param \NexusDigital/MiratelForce\StructType\BackgroundOperation $groupLeader
     * @param string $groupLeaderId
     * @param bool $isDeleted
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $mergedOperations
     * @param string $name
     * @param int $numFollowers
     * @param string $parentKey
     * @param string $processAfter
     * @param int $retryBackoff
     * @param int $retryCount
     * @param int $retryLimit
     * @param string $sequenceGroup
     * @param int $sequenceNumber
     * @param string $startedAt
     * @param string $status
     * @param string $submittedAt
     * @param string $systemModstamp
     * @param int $timeout
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     * @param string $workerUri
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $error = null, $executionGroup = null, $expiresAt = null, $finishedAt = null, \NexusDigital/MiratelForce\StructType\BackgroundOperation $groupLeader = null, $groupLeaderId = null, $isDeleted = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, \NexusDigital/MiratelForce\StructType\QueryResult $mergedOperations = null, $name = null, $numFollowers = null, $parentKey = null, $processAfter = null, $retryBackoff = null, $retryCount = null, $retryLimit = null, $sequenceGroup = null, $sequenceNumber = null, $startedAt = null, $status = null, $submittedAt = null, $systemModstamp = null, $timeout = null, \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null, $workerUri = null)
    {
        $this
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setError($error)
            ->setExecutionGroup($executionGroup)
            ->setExpiresAt($expiresAt)
            ->setFinishedAt($finishedAt)
            ->setGroupLeader($groupLeader)
            ->setGroupLeaderId($groupLeaderId)
            ->setIsDeleted($isDeleted)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setMergedOperations($mergedOperations)
            ->setName($name)
            ->setNumFollowers($numFollowers)
            ->setParentKey($parentKey)
            ->setProcessAfter($processAfter)
            ->setRetryBackoff($retryBackoff)
            ->setRetryCount($retryCount)
            ->setRetryLimit($retryLimit)
            ->setSequenceGroup($sequenceGroup)
            ->setSequenceNumber($sequenceNumber)
            ->setStartedAt($startedAt)
            ->setStatus($status)
            ->setSubmittedAt($submittedAt)
            ->setSystemModstamp($systemModstamp)
            ->setTimeout($timeout)
            ->setUserRecordAccess($userRecordAccess)
            ->setWorkerUri($workerUri);
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $error
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get ExecutionGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecutionGroup()
    {
        return isset($this->ExecutionGroup) ? $this->ExecutionGroup : null;
    }
    /**
     * Set ExecutionGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $executionGroup
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setExecutionGroup($executionGroup = null)
    {
        // validation for constraint: string
        if (!is_null($executionGroup) && !is_string($executionGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executionGroup, true), gettype($executionGroup)), __LINE__);
        }
        if (is_null($executionGroup) || (is_array($executionGroup) && empty($executionGroup))) {
            unset($this->ExecutionGroup);
        } else {
            $this->ExecutionGroup = $executionGroup;
        }
        return $this;
    }
    /**
     * Get ExpiresAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiresAt()
    {
        return isset($this->ExpiresAt) ? $this->ExpiresAt : null;
    }
    /**
     * Set ExpiresAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiresAt
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setExpiresAt($expiresAt = null)
    {
        // validation for constraint: string
        if (!is_null($expiresAt) && !is_string($expiresAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiresAt, true), gettype($expiresAt)), __LINE__);
        }
        if (is_null($expiresAt) || (is_array($expiresAt) && empty($expiresAt))) {
            unset($this->ExpiresAt);
        } else {
            $this->ExpiresAt = $expiresAt;
        }
        return $this;
    }
    /**
     * Get FinishedAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFinishedAt()
    {
        return isset($this->FinishedAt) ? $this->FinishedAt : null;
    }
    /**
     * Set FinishedAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $finishedAt
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setFinishedAt($finishedAt = null)
    {
        // validation for constraint: string
        if (!is_null($finishedAt) && !is_string($finishedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($finishedAt, true), gettype($finishedAt)), __LINE__);
        }
        if (is_null($finishedAt) || (is_array($finishedAt) && empty($finishedAt))) {
            unset($this->FinishedAt);
        } else {
            $this->FinishedAt = $finishedAt;
        }
        return $this;
    }
    /**
     * Get GroupLeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation|null
     */
    public function getGroupLeader()
    {
        return isset($this->GroupLeader) ? $this->GroupLeader : null;
    }
    /**
     * Set GroupLeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\BackgroundOperation $groupLeader
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setGroupLeader(\NexusDigital/MiratelForce\StructType\BackgroundOperation $groupLeader = null)
    {
        if (is_null($groupLeader) || (is_array($groupLeader) && empty($groupLeader))) {
            unset($this->GroupLeader);
        } else {
            $this->GroupLeader = $groupLeader;
        }
        return $this;
    }
    /**
     * Get GroupLeaderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupLeaderId()
    {
        return isset($this->GroupLeaderId) ? $this->GroupLeaderId : null;
    }
    /**
     * Set GroupLeaderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupLeaderId
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setGroupLeaderId($groupLeaderId = null)
    {
        // validation for constraint: string
        if (!is_null($groupLeaderId) && !is_string($groupLeaderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupLeaderId, true), gettype($groupLeaderId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($groupLeaderId) && mb_strlen($groupLeaderId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($groupLeaderId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($groupLeaderId) && !preg_match('/[a-zA-Z0-9]{18}/', $groupLeaderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($groupLeaderId, true)), __LINE__);
        }
        if (is_null($groupLeaderId) || (is_array($groupLeaderId) && empty($groupLeaderId))) {
            unset($this->GroupLeaderId);
        } else {
            $this->GroupLeaderId = $groupLeaderId;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get MergedOperations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getMergedOperations()
    {
        return isset($this->MergedOperations) ? $this->MergedOperations : null;
    }
    /**
     * Set MergedOperations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $mergedOperations
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setMergedOperations(\NexusDigital/MiratelForce\StructType\QueryResult $mergedOperations = null)
    {
        if (is_null($mergedOperations) || (is_array($mergedOperations) && empty($mergedOperations))) {
            unset($this->MergedOperations);
        } else {
            $this->MergedOperations = $mergedOperations;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NumFollowers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumFollowers()
    {
        return isset($this->NumFollowers) ? $this->NumFollowers : null;
    }
    /**
     * Set NumFollowers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numFollowers
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setNumFollowers($numFollowers = null)
    {
        // validation for constraint: int
        if (!is_null($numFollowers) && !(is_int($numFollowers) || ctype_digit($numFollowers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numFollowers, true), gettype($numFollowers)), __LINE__);
        }
        if (is_null($numFollowers) || (is_array($numFollowers) && empty($numFollowers))) {
            unset($this->NumFollowers);
        } else {
            $this->NumFollowers = $numFollowers;
        }
        return $this;
    }
    /**
     * Get ParentKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentKey()
    {
        return isset($this->ParentKey) ? $this->ParentKey : null;
    }
    /**
     * Set ParentKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentKey
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setParentKey($parentKey = null)
    {
        // validation for constraint: string
        if (!is_null($parentKey) && !is_string($parentKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentKey, true), gettype($parentKey)), __LINE__);
        }
        if (is_null($parentKey) || (is_array($parentKey) && empty($parentKey))) {
            unset($this->ParentKey);
        } else {
            $this->ParentKey = $parentKey;
        }
        return $this;
    }
    /**
     * Get ProcessAfter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessAfter()
    {
        return isset($this->ProcessAfter) ? $this->ProcessAfter : null;
    }
    /**
     * Set ProcessAfter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processAfter
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setProcessAfter($processAfter = null)
    {
        // validation for constraint: string
        if (!is_null($processAfter) && !is_string($processAfter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processAfter, true), gettype($processAfter)), __LINE__);
        }
        if (is_null($processAfter) || (is_array($processAfter) && empty($processAfter))) {
            unset($this->ProcessAfter);
        } else {
            $this->ProcessAfter = $processAfter;
        }
        return $this;
    }
    /**
     * Get RetryBackoff value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRetryBackoff()
    {
        return isset($this->RetryBackoff) ? $this->RetryBackoff : null;
    }
    /**
     * Set RetryBackoff value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $retryBackoff
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setRetryBackoff($retryBackoff = null)
    {
        // validation for constraint: int
        if (!is_null($retryBackoff) && !(is_int($retryBackoff) || ctype_digit($retryBackoff))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($retryBackoff, true), gettype($retryBackoff)), __LINE__);
        }
        if (is_null($retryBackoff) || (is_array($retryBackoff) && empty($retryBackoff))) {
            unset($this->RetryBackoff);
        } else {
            $this->RetryBackoff = $retryBackoff;
        }
        return $this;
    }
    /**
     * Get RetryCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRetryCount()
    {
        return isset($this->RetryCount) ? $this->RetryCount : null;
    }
    /**
     * Set RetryCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $retryCount
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setRetryCount($retryCount = null)
    {
        // validation for constraint: int
        if (!is_null($retryCount) && !(is_int($retryCount) || ctype_digit($retryCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($retryCount, true), gettype($retryCount)), __LINE__);
        }
        if (is_null($retryCount) || (is_array($retryCount) && empty($retryCount))) {
            unset($this->RetryCount);
        } else {
            $this->RetryCount = $retryCount;
        }
        return $this;
    }
    /**
     * Get RetryLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRetryLimit()
    {
        return isset($this->RetryLimit) ? $this->RetryLimit : null;
    }
    /**
     * Set RetryLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $retryLimit
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setRetryLimit($retryLimit = null)
    {
        // validation for constraint: int
        if (!is_null($retryLimit) && !(is_int($retryLimit) || ctype_digit($retryLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($retryLimit, true), gettype($retryLimit)), __LINE__);
        }
        if (is_null($retryLimit) || (is_array($retryLimit) && empty($retryLimit))) {
            unset($this->RetryLimit);
        } else {
            $this->RetryLimit = $retryLimit;
        }
        return $this;
    }
    /**
     * Get SequenceGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSequenceGroup()
    {
        return isset($this->SequenceGroup) ? $this->SequenceGroup : null;
    }
    /**
     * Set SequenceGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sequenceGroup
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setSequenceGroup($sequenceGroup = null)
    {
        // validation for constraint: string
        if (!is_null($sequenceGroup) && !is_string($sequenceGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sequenceGroup, true), gettype($sequenceGroup)), __LINE__);
        }
        if (is_null($sequenceGroup) || (is_array($sequenceGroup) && empty($sequenceGroup))) {
            unset($this->SequenceGroup);
        } else {
            $this->SequenceGroup = $sequenceGroup;
        }
        return $this;
    }
    /**
     * Get SequenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSequenceNumber()
    {
        return isset($this->SequenceNumber) ? $this->SequenceNumber : null;
    }
    /**
     * Set SequenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sequenceNumber
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setSequenceNumber($sequenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNumber) && !(is_int($sequenceNumber) || ctype_digit($sequenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequenceNumber, true), gettype($sequenceNumber)), __LINE__);
        }
        if (is_null($sequenceNumber) || (is_array($sequenceNumber) && empty($sequenceNumber))) {
            unset($this->SequenceNumber);
        } else {
            $this->SequenceNumber = $sequenceNumber;
        }
        return $this;
    }
    /**
     * Get StartedAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartedAt()
    {
        return isset($this->StartedAt) ? $this->StartedAt : null;
    }
    /**
     * Set StartedAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startedAt
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setStartedAt($startedAt = null)
    {
        // validation for constraint: string
        if (!is_null($startedAt) && !is_string($startedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startedAt, true), gettype($startedAt)), __LINE__);
        }
        if (is_null($startedAt) || (is_array($startedAt) && empty($startedAt))) {
            unset($this->StartedAt);
        } else {
            $this->StartedAt = $startedAt;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get SubmittedAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubmittedAt()
    {
        return isset($this->SubmittedAt) ? $this->SubmittedAt : null;
    }
    /**
     * Set SubmittedAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $submittedAt
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setSubmittedAt($submittedAt = null)
    {
        // validation for constraint: string
        if (!is_null($submittedAt) && !is_string($submittedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($submittedAt, true), gettype($submittedAt)), __LINE__);
        }
        if (is_null($submittedAt) || (is_array($submittedAt) && empty($submittedAt))) {
            unset($this->SubmittedAt);
        } else {
            $this->SubmittedAt = $submittedAt;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get Timeout value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTimeout()
    {
        return isset($this->Timeout) ? $this->Timeout : null;
    }
    /**
     * Set Timeout value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $timeout
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setTimeout($timeout = null)
    {
        // validation for constraint: int
        if (!is_null($timeout) && !(is_int($timeout) || ctype_digit($timeout))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timeout, true), gettype($timeout)), __LINE__);
        }
        if (is_null($timeout) || (is_array($timeout) && empty($timeout))) {
            unset($this->Timeout);
        } else {
            $this->Timeout = $timeout;
        }
        return $this;
    }
    /**
     * Get UserRecordAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\UserRecordAccess|null
     */
    public function getUserRecordAccess()
    {
        return isset($this->UserRecordAccess) ? $this->UserRecordAccess : null;
    }
    /**
     * Set UserRecordAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setUserRecordAccess(\NexusDigital/MiratelForce\StructType\UserRecordAccess $userRecordAccess = null)
    {
        if (is_null($userRecordAccess) || (is_array($userRecordAccess) && empty($userRecordAccess))) {
            unset($this->UserRecordAccess);
        } else {
            $this->UserRecordAccess = $userRecordAccess;
        }
        return $this;
    }
    /**
     * Get WorkerUri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWorkerUri()
    {
        return isset($this->WorkerUri) ? $this->WorkerUri : null;
    }
    /**
     * Set WorkerUri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $workerUri
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public function setWorkerUri($workerUri = null)
    {
        // validation for constraint: string
        if (!is_null($workerUri) && !is_string($workerUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workerUri, true), gettype($workerUri)), __LINE__);
        }
        if (is_null($workerUri) || (is_array($workerUri) && empty($workerUri))) {
            unset($this->WorkerUri);
        } else {
            $this->WorkerUri = $workerUri;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\BackgroundOperation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
