<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthProvider StructType
 * @subpackage Structs
 */
class AuthProvider extends SObject
{
    /**
     * The AuthorizeUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthorizeUrl;
    /**
     * The ConsumerKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConsumerKey;
    /**
     * The ConsumerSecret
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConsumerSecret;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The CustomMetadataTypeRecord
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomMetadataTypeRecord;
    /**
     * The DefaultScopes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultScopes;
    /**
     * The DeveloperName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeveloperName;
    /**
     * The ErrorUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorUrl;
    /**
     * The ExecutionUserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ExecutionUserId;
    /**
     * The FriendlyName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FriendlyName;
    /**
     * The IconUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IconUrl;
    /**
     * The IdTokenIssuer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdTokenIssuer;
    /**
     * The LinkKickoffUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LinkKickoffUrl;
    /**
     * The LogoutUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LogoutUrl;
    /**
     * The OauthKickoffUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OauthKickoffUrl;
    /**
     * The OptionsIncludeOrgIdInId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsIncludeOrgIdInId;
    /**
     * The OptionsSendAccessTokenInHeader
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsSendAccessTokenInHeader;
    /**
     * The OptionsSendClientCredentialsInHeader
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OptionsSendClientCredentialsInHeader;
    /**
     * The PluginId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $PluginId;
    /**
     * The ProviderType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProviderType;
    /**
     * The RegistrationHandlerId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $RegistrationHandlerId;
    /**
     * The SsoKickoffUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SsoKickoffUrl;
    /**
     * The TokenUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TokenUrl;
    /**
     * The UserInfoUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserInfoUrl;
    /**
     * Constructor method for AuthProvider
     * @uses AuthProvider::setAuthorizeUrl()
     * @uses AuthProvider::setConsumerKey()
     * @uses AuthProvider::setConsumerSecret()
     * @uses AuthProvider::setCreatedDate()
     * @uses AuthProvider::setCustomMetadataTypeRecord()
     * @uses AuthProvider::setDefaultScopes()
     * @uses AuthProvider::setDeveloperName()
     * @uses AuthProvider::setErrorUrl()
     * @uses AuthProvider::setExecutionUserId()
     * @uses AuthProvider::setFriendlyName()
     * @uses AuthProvider::setIconUrl()
     * @uses AuthProvider::setIdTokenIssuer()
     * @uses AuthProvider::setLinkKickoffUrl()
     * @uses AuthProvider::setLogoutUrl()
     * @uses AuthProvider::setOauthKickoffUrl()
     * @uses AuthProvider::setOptionsIncludeOrgIdInId()
     * @uses AuthProvider::setOptionsSendAccessTokenInHeader()
     * @uses AuthProvider::setOptionsSendClientCredentialsInHeader()
     * @uses AuthProvider::setPluginId()
     * @uses AuthProvider::setProviderType()
     * @uses AuthProvider::setRegistrationHandlerId()
     * @uses AuthProvider::setSsoKickoffUrl()
     * @uses AuthProvider::setTokenUrl()
     * @uses AuthProvider::setUserInfoUrl()
     * @param string $authorizeUrl
     * @param string $consumerKey
     * @param string $consumerSecret
     * @param string $createdDate
     * @param string $customMetadataTypeRecord
     * @param string $defaultScopes
     * @param string $developerName
     * @param string $errorUrl
     * @param string $executionUserId
     * @param string $friendlyName
     * @param string $iconUrl
     * @param string $idTokenIssuer
     * @param string $linkKickoffUrl
     * @param string $logoutUrl
     * @param string $oauthKickoffUrl
     * @param bool $optionsIncludeOrgIdInId
     * @param bool $optionsSendAccessTokenInHeader
     * @param bool $optionsSendClientCredentialsInHeader
     * @param string $pluginId
     * @param string $providerType
     * @param string $registrationHandlerId
     * @param string $ssoKickoffUrl
     * @param string $tokenUrl
     * @param string $userInfoUrl
     */
    public function __construct($authorizeUrl = null, $consumerKey = null, $consumerSecret = null, $createdDate = null, $customMetadataTypeRecord = null, $defaultScopes = null, $developerName = null, $errorUrl = null, $executionUserId = null, $friendlyName = null, $iconUrl = null, $idTokenIssuer = null, $linkKickoffUrl = null, $logoutUrl = null, $oauthKickoffUrl = null, $optionsIncludeOrgIdInId = null, $optionsSendAccessTokenInHeader = null, $optionsSendClientCredentialsInHeader = null, $pluginId = null, $providerType = null, $registrationHandlerId = null, $ssoKickoffUrl = null, $tokenUrl = null, $userInfoUrl = null)
    {
        $this
            ->setAuthorizeUrl($authorizeUrl)
            ->setConsumerKey($consumerKey)
            ->setConsumerSecret($consumerSecret)
            ->setCreatedDate($createdDate)
            ->setCustomMetadataTypeRecord($customMetadataTypeRecord)
            ->setDefaultScopes($defaultScopes)
            ->setDeveloperName($developerName)
            ->setErrorUrl($errorUrl)
            ->setExecutionUserId($executionUserId)
            ->setFriendlyName($friendlyName)
            ->setIconUrl($iconUrl)
            ->setIdTokenIssuer($idTokenIssuer)
            ->setLinkKickoffUrl($linkKickoffUrl)
            ->setLogoutUrl($logoutUrl)
            ->setOauthKickoffUrl($oauthKickoffUrl)
            ->setOptionsIncludeOrgIdInId($optionsIncludeOrgIdInId)
            ->setOptionsSendAccessTokenInHeader($optionsSendAccessTokenInHeader)
            ->setOptionsSendClientCredentialsInHeader($optionsSendClientCredentialsInHeader)
            ->setPluginId($pluginId)
            ->setProviderType($providerType)
            ->setRegistrationHandlerId($registrationHandlerId)
            ->setSsoKickoffUrl($ssoKickoffUrl)
            ->setTokenUrl($tokenUrl)
            ->setUserInfoUrl($userInfoUrl);
    }
    /**
     * Get AuthorizeUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthorizeUrl()
    {
        return isset($this->AuthorizeUrl) ? $this->AuthorizeUrl : null;
    }
    /**
     * Set AuthorizeUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authorizeUrl
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public function setAuthorizeUrl($authorizeUrl = null)
    {
        // validation for constraint: string
        if (!is_null($authorizeUrl) && !is_string($authorizeUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizeUrl, true), gettype($authorizeUrl)), __LINE__);
        }
        if (is_null($authorizeUrl) || (is_array($authorizeUrl) && empty($authorizeUrl))) {
            unset($this->AuthorizeUrl);
        } else {
            $this->AuthorizeUrl = $authorizeUrl;
        }
        return $this;
    }
    /**
     * Get ConsumerKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConsumerKey()
    {
        return isset($this->ConsumerKey) ? $this->ConsumerKey : null;
    }
    /**
     * Set ConsumerKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $consumerKey
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public function setConsumerKey($consumerKey = null)
    {
        // validation for constraint: string
        if (!is_null($consumerKey) && !is_string($consumerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consumerKey, true), gettype($consumerKey)), __LINE__);
        }
        if (is_null($consumerKey) || (is_array($consumerKey) && empty($consumerKey))) {
            unset($this->ConsumerKey);
        } else {
            $this->ConsumerKey = $consumerKey;
        }
        return $this;
    }
    /**
     * Get ConsumerSecret value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConsumerSecret()
    {
        return isset($this->ConsumerSecret) ? $this->ConsumerSecret : null;
    }
    /**
     * Set ConsumerSecret value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $consumerSecret
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public function setConsumerSecret($consumerSecret = null)
    {
        // validation for constraint: string
        if (!is_null($consumerSecret) && !is_string($consumerSecret)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consumerSecret, true), gettype($consumerSecret)), __LINE__);
        }
        if (is_null($consumerSecret) || (is_array($consumerSecret) && empty($consumerSecret))) {
            unset($this->ConsumerSecret);
        } else {
            $this->ConsumerSecret = $consumerSecret;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get CustomMetadataTypeRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomMetadataTypeRecord()
    {
        return isset($this->CustomMetadataTypeRecord) ? $this->CustomMetadataTypeRecord : null;
    }
    /**
     * Set CustomMetadataTypeRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customMetadataTypeRecord
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public function setCustomMetadataTypeRecord($customMetadataTypeRecord = null)
    {
        // validation for constraint: string
        if (!is_null($customMetadataTypeRecord) && !is_string($customMetadataTypeRecord)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customMetadataTypeRecord, true), gettype($customMetadataTypeRecord)), __LINE__);
        }
        if (is_null($customMetadataTypeRecord) || (is_array($customMetadataTypeRecord) && empty($customMetadataTypeRecord))) {
            unset($this->CustomMetadataTypeRecord);
        } else {
            $this->CustomMetadataTypeRecord = $customMetadataTypeRecord;
        }
        return $this;
    }
    /**
     * Get DefaultScopes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultScopes()
    {
        return isset($this->DefaultScopes) ? $this->DefaultScopes : null;
    }
    /**
     * Set DefaultScopes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultScopes
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public function setDefaultScopes($defaultScopes = null)
    {
        // validation for constraint: string
        if (!is_null($defaultScopes) && !is_string($defaultScopes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultScopes, true), gettype($defaultScopes)), __LINE__);
        }
        if (is_null($defaultScopes) || (is_array($defaultScopes) && empty($defaultScopes))) {
            unset($this->DefaultScopes);
        } else {
            $this->DefaultScopes = $defaultScopes;
        }
        return $this;
    }
    /**
     * Get DeveloperName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeveloperName()
    {
        return isset($this->DeveloperName) ? $this->DeveloperName : null;
    }
    /**
     * Set DeveloperName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $developerName
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public function setDeveloperName($developerName = null)
    {
        // validation for constraint: string
        if (!is_null($developerName) && !is_string($developerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($developerName, true), gettype($developerName)), __LINE__);
        }
        if (is_null($developerName) || (is_array($developerName) && empty($developerName))) {
            unset($this->DeveloperName);
        } else {
            $this->DeveloperName = $developerName;
        }
        return $this;
    }
    /**
     * Get ErrorUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorUrl()
    {
        return isset($this->ErrorUrl) ? $this->ErrorUrl : null;
    }
    /**
     * Set ErrorUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorUrl
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public function setErrorUrl($errorUrl = null)
    {
        // validation for constraint: string
        if (!is_null($errorUrl) && !is_string($errorUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorUrl, true), gettype($errorUrl)), __LINE__);
        }
        if (is_null($errorUrl) || (is_array($errorUrl) && empty($errorUrl))) {
            unset($this->ErrorUrl);
        } else {
            $this->ErrorUrl = $errorUrl;
        }
        return $this;
    }
    /**
     * Get ExecutionUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecutionUserId()
    {
        return isset($this->ExecutionUserId) ? $this->ExecutionUserId : null;
    }
    /**
     * Set ExecutionUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $executionUserId
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public function setExecutionUserId($executionUserId = null)
    {
        // validation for constraint: string
        if (!is_null($executionUserId) && !is_string($executionUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executionUserId, true), gettype($executionUserId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($executionUserId) && mb_strlen($executionUserId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($executionUserId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($executionUserId) && !preg_match('/[a-zA-Z0-9]{18}/', $executionUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($executionUserId, true)), __LINE__);
        }
        if (is_null($executionUserId) || (is_array($executionUserId) && empty($executionUserId))) {
            unset($this->ExecutionUserId);
        } else {
            $this->ExecutionUserId = $executionUserId;
        }
        return $this;
    }
    /**
     * Get FriendlyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFriendlyName()
    {
        return isset($this->FriendlyName) ? $this->FriendlyName : null;
    }
    /**
     * Set FriendlyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $friendlyName
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public function setFriendlyName($friendlyName = null)
    {
        // validation for constraint: string
        if (!is_null($friendlyName) && !is_string($friendlyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($friendlyName, true), gettype($friendlyName)), __LINE__);
        }
        if (is_null($friendlyName) || (is_array($friendlyName) && empty($friendlyName))) {
            unset($this->FriendlyName);
        } else {
            $this->FriendlyName = $friendlyName;
        }
        return $this;
    }
    /**
     * Get IconUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIconUrl()
    {
        return isset($this->IconUrl) ? $this->IconUrl : null;
    }
    /**
     * Set IconUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iconUrl
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public function setIconUrl($iconUrl = null)
    {
        // validation for constraint: string
        if (!is_null($iconUrl) && !is_string($iconUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iconUrl, true), gettype($iconUrl)), __LINE__);
        }
        if (is_null($iconUrl) || (is_array($iconUrl) && empty($iconUrl))) {
            unset($this->IconUrl);
        } else {
            $this->IconUrl = $iconUrl;
        }
        return $this;
    }
    /**
     * Get IdTokenIssuer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdTokenIssuer()
    {
        return isset($this->IdTokenIssuer) ? $this->IdTokenIssuer : null;
    }
    /**
     * Set IdTokenIssuer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idTokenIssuer
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public function setIdTokenIssuer($idTokenIssuer = null)
    {
        // validation for constraint: string
        if (!is_null($idTokenIssuer) && !is_string($idTokenIssuer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idTokenIssuer, true), gettype($idTokenIssuer)), __LINE__);
        }
        if (is_null($idTokenIssuer) || (is_array($idTokenIssuer) && empty($idTokenIssuer))) {
            unset($this->IdTokenIssuer);
        } else {
            $this->IdTokenIssuer = $idTokenIssuer;
        }
        return $this;
    }
    /**
     * Get LinkKickoffUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLinkKickoffUrl()
    {
        return isset($this->LinkKickoffUrl) ? $this->LinkKickoffUrl : null;
    }
    /**
     * Set LinkKickoffUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $linkKickoffUrl
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public function setLinkKickoffUrl($linkKickoffUrl = null)
    {
        // validation for constraint: string
        if (!is_null($linkKickoffUrl) && !is_string($linkKickoffUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkKickoffUrl, true), gettype($linkKickoffUrl)), __LINE__);
        }
        if (is_null($linkKickoffUrl) || (is_array($linkKickoffUrl) && empty($linkKickoffUrl))) {
            unset($this->LinkKickoffUrl);
        } else {
            $this->LinkKickoffUrl = $linkKickoffUrl;
        }
        return $this;
    }
    /**
     * Get LogoutUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogoutUrl()
    {
        return isset($this->LogoutUrl) ? $this->LogoutUrl : null;
    }
    /**
     * Set LogoutUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $logoutUrl
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public function setLogoutUrl($logoutUrl = null)
    {
        // validation for constraint: string
        if (!is_null($logoutUrl) && !is_string($logoutUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logoutUrl, true), gettype($logoutUrl)), __LINE__);
        }
        if (is_null($logoutUrl) || (is_array($logoutUrl) && empty($logoutUrl))) {
            unset($this->LogoutUrl);
        } else {
            $this->LogoutUrl = $logoutUrl;
        }
        return $this;
    }
    /**
     * Get OauthKickoffUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOauthKickoffUrl()
    {
        return isset($this->OauthKickoffUrl) ? $this->OauthKickoffUrl : null;
    }
    /**
     * Set OauthKickoffUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oauthKickoffUrl
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public function setOauthKickoffUrl($oauthKickoffUrl = null)
    {
        // validation for constraint: string
        if (!is_null($oauthKickoffUrl) && !is_string($oauthKickoffUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oauthKickoffUrl, true), gettype($oauthKickoffUrl)), __LINE__);
        }
        if (is_null($oauthKickoffUrl) || (is_array($oauthKickoffUrl) && empty($oauthKickoffUrl))) {
            unset($this->OauthKickoffUrl);
        } else {
            $this->OauthKickoffUrl = $oauthKickoffUrl;
        }
        return $this;
    }
    /**
     * Get OptionsIncludeOrgIdInId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsIncludeOrgIdInId()
    {
        return isset($this->OptionsIncludeOrgIdInId) ? $this->OptionsIncludeOrgIdInId : null;
    }
    /**
     * Set OptionsIncludeOrgIdInId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsIncludeOrgIdInId
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public function setOptionsIncludeOrgIdInId($optionsIncludeOrgIdInId = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsIncludeOrgIdInId) && !is_bool($optionsIncludeOrgIdInId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsIncludeOrgIdInId, true), gettype($optionsIncludeOrgIdInId)), __LINE__);
        }
        if (is_null($optionsIncludeOrgIdInId) || (is_array($optionsIncludeOrgIdInId) && empty($optionsIncludeOrgIdInId))) {
            unset($this->OptionsIncludeOrgIdInId);
        } else {
            $this->OptionsIncludeOrgIdInId = $optionsIncludeOrgIdInId;
        }
        return $this;
    }
    /**
     * Get OptionsSendAccessTokenInHeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsSendAccessTokenInHeader()
    {
        return isset($this->OptionsSendAccessTokenInHeader) ? $this->OptionsSendAccessTokenInHeader : null;
    }
    /**
     * Set OptionsSendAccessTokenInHeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsSendAccessTokenInHeader
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public function setOptionsSendAccessTokenInHeader($optionsSendAccessTokenInHeader = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsSendAccessTokenInHeader) && !is_bool($optionsSendAccessTokenInHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsSendAccessTokenInHeader, true), gettype($optionsSendAccessTokenInHeader)), __LINE__);
        }
        if (is_null($optionsSendAccessTokenInHeader) || (is_array($optionsSendAccessTokenInHeader) && empty($optionsSendAccessTokenInHeader))) {
            unset($this->OptionsSendAccessTokenInHeader);
        } else {
            $this->OptionsSendAccessTokenInHeader = $optionsSendAccessTokenInHeader;
        }
        return $this;
    }
    /**
     * Get OptionsSendClientCredentialsInHeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOptionsSendClientCredentialsInHeader()
    {
        return isset($this->OptionsSendClientCredentialsInHeader) ? $this->OptionsSendClientCredentialsInHeader : null;
    }
    /**
     * Set OptionsSendClientCredentialsInHeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $optionsSendClientCredentialsInHeader
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public function setOptionsSendClientCredentialsInHeader($optionsSendClientCredentialsInHeader = null)
    {
        // validation for constraint: boolean
        if (!is_null($optionsSendClientCredentialsInHeader) && !is_bool($optionsSendClientCredentialsInHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optionsSendClientCredentialsInHeader, true), gettype($optionsSendClientCredentialsInHeader)), __LINE__);
        }
        if (is_null($optionsSendClientCredentialsInHeader) || (is_array($optionsSendClientCredentialsInHeader) && empty($optionsSendClientCredentialsInHeader))) {
            unset($this->OptionsSendClientCredentialsInHeader);
        } else {
            $this->OptionsSendClientCredentialsInHeader = $optionsSendClientCredentialsInHeader;
        }
        return $this;
    }
    /**
     * Get PluginId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPluginId()
    {
        return isset($this->PluginId) ? $this->PluginId : null;
    }
    /**
     * Set PluginId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pluginId
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public function setPluginId($pluginId = null)
    {
        // validation for constraint: string
        if (!is_null($pluginId) && !is_string($pluginId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pluginId, true), gettype($pluginId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($pluginId) && mb_strlen($pluginId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($pluginId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($pluginId) && !preg_match('/[a-zA-Z0-9]{18}/', $pluginId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($pluginId, true)), __LINE__);
        }
        if (is_null($pluginId) || (is_array($pluginId) && empty($pluginId))) {
            unset($this->PluginId);
        } else {
            $this->PluginId = $pluginId;
        }
        return $this;
    }
    /**
     * Get ProviderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProviderType()
    {
        return isset($this->ProviderType) ? $this->ProviderType : null;
    }
    /**
     * Set ProviderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $providerType
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public function setProviderType($providerType = null)
    {
        // validation for constraint: string
        if (!is_null($providerType) && !is_string($providerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerType, true), gettype($providerType)), __LINE__);
        }
        if (is_null($providerType) || (is_array($providerType) && empty($providerType))) {
            unset($this->ProviderType);
        } else {
            $this->ProviderType = $providerType;
        }
        return $this;
    }
    /**
     * Get RegistrationHandlerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegistrationHandlerId()
    {
        return isset($this->RegistrationHandlerId) ? $this->RegistrationHandlerId : null;
    }
    /**
     * Set RegistrationHandlerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $registrationHandlerId
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public function setRegistrationHandlerId($registrationHandlerId = null)
    {
        // validation for constraint: string
        if (!is_null($registrationHandlerId) && !is_string($registrationHandlerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationHandlerId, true), gettype($registrationHandlerId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($registrationHandlerId) && mb_strlen($registrationHandlerId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($registrationHandlerId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($registrationHandlerId) && !preg_match('/[a-zA-Z0-9]{18}/', $registrationHandlerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($registrationHandlerId, true)), __LINE__);
        }
        if (is_null($registrationHandlerId) || (is_array($registrationHandlerId) && empty($registrationHandlerId))) {
            unset($this->RegistrationHandlerId);
        } else {
            $this->RegistrationHandlerId = $registrationHandlerId;
        }
        return $this;
    }
    /**
     * Get SsoKickoffUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSsoKickoffUrl()
    {
        return isset($this->SsoKickoffUrl) ? $this->SsoKickoffUrl : null;
    }
    /**
     * Set SsoKickoffUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ssoKickoffUrl
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public function setSsoKickoffUrl($ssoKickoffUrl = null)
    {
        // validation for constraint: string
        if (!is_null($ssoKickoffUrl) && !is_string($ssoKickoffUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ssoKickoffUrl, true), gettype($ssoKickoffUrl)), __LINE__);
        }
        if (is_null($ssoKickoffUrl) || (is_array($ssoKickoffUrl) && empty($ssoKickoffUrl))) {
            unset($this->SsoKickoffUrl);
        } else {
            $this->SsoKickoffUrl = $ssoKickoffUrl;
        }
        return $this;
    }
    /**
     * Get TokenUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTokenUrl()
    {
        return isset($this->TokenUrl) ? $this->TokenUrl : null;
    }
    /**
     * Set TokenUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tokenUrl
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public function setTokenUrl($tokenUrl = null)
    {
        // validation for constraint: string
        if (!is_null($tokenUrl) && !is_string($tokenUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenUrl, true), gettype($tokenUrl)), __LINE__);
        }
        if (is_null($tokenUrl) || (is_array($tokenUrl) && empty($tokenUrl))) {
            unset($this->TokenUrl);
        } else {
            $this->TokenUrl = $tokenUrl;
        }
        return $this;
    }
    /**
     * Get UserInfoUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserInfoUrl()
    {
        return isset($this->UserInfoUrl) ? $this->UserInfoUrl : null;
    }
    /**
     * Set UserInfoUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userInfoUrl
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public function setUserInfoUrl($userInfoUrl = null)
    {
        // validation for constraint: string
        if (!is_null($userInfoUrl) && !is_string($userInfoUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userInfoUrl, true), gettype($userInfoUrl)), __LINE__);
        }
        if (is_null($userInfoUrl) || (is_array($userInfoUrl) && empty($userInfoUrl))) {
            unset($this->UserInfoUrl);
        } else {
            $this->UserInfoUrl = $userInfoUrl;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\AuthProvider
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
