<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AppMenuItem StructType
 * @subpackage Structs
 */
class AppMenuItem extends SObject
{
    /**
     * The ApplicationId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ApplicationId;
    /**
     * The CanvasAccessMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CanvasAccessMethod;
    /**
     * The CanvasEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanvasEnabled;
    /**
     * The CanvasOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CanvasOptions;
    /**
     * The CanvasReferenceId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CanvasReferenceId;
    /**
     * The CanvasSelectedLocations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CanvasSelectedLocations;
    /**
     * The CanvasUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CanvasUrl;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The IconUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IconUrl;
    /**
     * The InfoUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InfoUrl;
    /**
     * The IsAccessible
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAccessible;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The IsRegisteredDeviceOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRegisteredDeviceOnly;
    /**
     * The IsUsingAdminAuthorization
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUsingAdminAuthorization;
    /**
     * The IsVisible
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVisible;
    /**
     * The Label
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Label;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LogoUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LogoUrl;
    /**
     * The MobileAppBinaryId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobileAppBinaryId;
    /**
     * The MobileAppInstallUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobileAppInstallUrl;
    /**
     * The MobileAppInstalledDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobileAppInstalledDate;
    /**
     * The MobileAppInstalledVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobileAppInstalledVersion;
    /**
     * The MobileAppVer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobileAppVer;
    /**
     * The MobileDeviceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobileDeviceType;
    /**
     * The MobileMinOsVer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobileMinOsVer;
    /**
     * The MobilePlatform
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobilePlatform;
    /**
     * The MobileStartUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobileStartUrl;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NamespacePrefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NamespacePrefix;
    /**
     * The SortOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SortOrder;
    /**
     * The StartUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartUrl;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The UserSortOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UserSortOrder;
    /**
     * Constructor method for AppMenuItem
     * @uses AppMenuItem::setApplicationId()
     * @uses AppMenuItem::setCanvasAccessMethod()
     * @uses AppMenuItem::setCanvasEnabled()
     * @uses AppMenuItem::setCanvasOptions()
     * @uses AppMenuItem::setCanvasReferenceId()
     * @uses AppMenuItem::setCanvasSelectedLocations()
     * @uses AppMenuItem::setCanvasUrl()
     * @uses AppMenuItem::setCreatedBy()
     * @uses AppMenuItem::setCreatedById()
     * @uses AppMenuItem::setCreatedDate()
     * @uses AppMenuItem::setDescription()
     * @uses AppMenuItem::setIconUrl()
     * @uses AppMenuItem::setInfoUrl()
     * @uses AppMenuItem::setIsAccessible()
     * @uses AppMenuItem::setIsDeleted()
     * @uses AppMenuItem::setIsRegisteredDeviceOnly()
     * @uses AppMenuItem::setIsUsingAdminAuthorization()
     * @uses AppMenuItem::setIsVisible()
     * @uses AppMenuItem::setLabel()
     * @uses AppMenuItem::setLastModifiedBy()
     * @uses AppMenuItem::setLastModifiedById()
     * @uses AppMenuItem::setLastModifiedDate()
     * @uses AppMenuItem::setLogoUrl()
     * @uses AppMenuItem::setMobileAppBinaryId()
     * @uses AppMenuItem::setMobileAppInstallUrl()
     * @uses AppMenuItem::setMobileAppInstalledDate()
     * @uses AppMenuItem::setMobileAppInstalledVersion()
     * @uses AppMenuItem::setMobileAppVer()
     * @uses AppMenuItem::setMobileDeviceType()
     * @uses AppMenuItem::setMobileMinOsVer()
     * @uses AppMenuItem::setMobilePlatform()
     * @uses AppMenuItem::setMobileStartUrl()
     * @uses AppMenuItem::setName()
     * @uses AppMenuItem::setNamespacePrefix()
     * @uses AppMenuItem::setSortOrder()
     * @uses AppMenuItem::setStartUrl()
     * @uses AppMenuItem::setSystemModstamp()
     * @uses AppMenuItem::setType()
     * @uses AppMenuItem::setUserSortOrder()
     * @param string $applicationId
     * @param string $canvasAccessMethod
     * @param bool $canvasEnabled
     * @param string $canvasOptions
     * @param string $canvasReferenceId
     * @param string $canvasSelectedLocations
     * @param string $canvasUrl
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $description
     * @param string $iconUrl
     * @param string $infoUrl
     * @param bool $isAccessible
     * @param bool $isDeleted
     * @param bool $isRegisteredDeviceOnly
     * @param bool $isUsingAdminAuthorization
     * @param bool $isVisible
     * @param string $label
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param string $logoUrl
     * @param string $mobileAppBinaryId
     * @param string $mobileAppInstallUrl
     * @param string $mobileAppInstalledDate
     * @param string $mobileAppInstalledVersion
     * @param string $mobileAppVer
     * @param string $mobileDeviceType
     * @param string $mobileMinOsVer
     * @param string $mobilePlatform
     * @param string $mobileStartUrl
     * @param string $name
     * @param string $namespacePrefix
     * @param int $sortOrder
     * @param string $startUrl
     * @param string $systemModstamp
     * @param string $type
     * @param int $userSortOrder
     */
    public function __construct($applicationId = null, $canvasAccessMethod = null, $canvasEnabled = null, $canvasOptions = null, $canvasReferenceId = null, $canvasSelectedLocations = null, $canvasUrl = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $description = null, $iconUrl = null, $infoUrl = null, $isAccessible = null, $isDeleted = null, $isRegisteredDeviceOnly = null, $isUsingAdminAuthorization = null, $isVisible = null, $label = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $logoUrl = null, $mobileAppBinaryId = null, $mobileAppInstallUrl = null, $mobileAppInstalledDate = null, $mobileAppInstalledVersion = null, $mobileAppVer = null, $mobileDeviceType = null, $mobileMinOsVer = null, $mobilePlatform = null, $mobileStartUrl = null, $name = null, $namespacePrefix = null, $sortOrder = null, $startUrl = null, $systemModstamp = null, $type = null, $userSortOrder = null)
    {
        $this
            ->setApplicationId($applicationId)
            ->setCanvasAccessMethod($canvasAccessMethod)
            ->setCanvasEnabled($canvasEnabled)
            ->setCanvasOptions($canvasOptions)
            ->setCanvasReferenceId($canvasReferenceId)
            ->setCanvasSelectedLocations($canvasSelectedLocations)
            ->setCanvasUrl($canvasUrl)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setDescription($description)
            ->setIconUrl($iconUrl)
            ->setInfoUrl($infoUrl)
            ->setIsAccessible($isAccessible)
            ->setIsDeleted($isDeleted)
            ->setIsRegisteredDeviceOnly($isRegisteredDeviceOnly)
            ->setIsUsingAdminAuthorization($isUsingAdminAuthorization)
            ->setIsVisible($isVisible)
            ->setLabel($label)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLogoUrl($logoUrl)
            ->setMobileAppBinaryId($mobileAppBinaryId)
            ->setMobileAppInstallUrl($mobileAppInstallUrl)
            ->setMobileAppInstalledDate($mobileAppInstalledDate)
            ->setMobileAppInstalledVersion($mobileAppInstalledVersion)
            ->setMobileAppVer($mobileAppVer)
            ->setMobileDeviceType($mobileDeviceType)
            ->setMobileMinOsVer($mobileMinOsVer)
            ->setMobilePlatform($mobilePlatform)
            ->setMobileStartUrl($mobileStartUrl)
            ->setName($name)
            ->setNamespacePrefix($namespacePrefix)
            ->setSortOrder($sortOrder)
            ->setStartUrl($startUrl)
            ->setSystemModstamp($systemModstamp)
            ->setType($type)
            ->setUserSortOrder($userSortOrder);
    }
    /**
     * Get ApplicationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationId()
    {
        return isset($this->ApplicationId) ? $this->ApplicationId : null;
    }
    /**
     * Set ApplicationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationId
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setApplicationId($applicationId = null)
    {
        // validation for constraint: string
        if (!is_null($applicationId) && !is_string($applicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationId, true), gettype($applicationId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($applicationId) && mb_strlen($applicationId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($applicationId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($applicationId) && !preg_match('/[a-zA-Z0-9]{18}/', $applicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($applicationId, true)), __LINE__);
        }
        if (is_null($applicationId) || (is_array($applicationId) && empty($applicationId))) {
            unset($this->ApplicationId);
        } else {
            $this->ApplicationId = $applicationId;
        }
        return $this;
    }
    /**
     * Get CanvasAccessMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCanvasAccessMethod()
    {
        return isset($this->CanvasAccessMethod) ? $this->CanvasAccessMethod : null;
    }
    /**
     * Set CanvasAccessMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $canvasAccessMethod
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setCanvasAccessMethod($canvasAccessMethod = null)
    {
        // validation for constraint: string
        if (!is_null($canvasAccessMethod) && !is_string($canvasAccessMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($canvasAccessMethod, true), gettype($canvasAccessMethod)), __LINE__);
        }
        if (is_null($canvasAccessMethod) || (is_array($canvasAccessMethod) && empty($canvasAccessMethod))) {
            unset($this->CanvasAccessMethod);
        } else {
            $this->CanvasAccessMethod = $canvasAccessMethod;
        }
        return $this;
    }
    /**
     * Get CanvasEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanvasEnabled()
    {
        return isset($this->CanvasEnabled) ? $this->CanvasEnabled : null;
    }
    /**
     * Set CanvasEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canvasEnabled
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setCanvasEnabled($canvasEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($canvasEnabled) && !is_bool($canvasEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canvasEnabled, true), gettype($canvasEnabled)), __LINE__);
        }
        if (is_null($canvasEnabled) || (is_array($canvasEnabled) && empty($canvasEnabled))) {
            unset($this->CanvasEnabled);
        } else {
            $this->CanvasEnabled = $canvasEnabled;
        }
        return $this;
    }
    /**
     * Get CanvasOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCanvasOptions()
    {
        return isset($this->CanvasOptions) ? $this->CanvasOptions : null;
    }
    /**
     * Set CanvasOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $canvasOptions
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setCanvasOptions($canvasOptions = null)
    {
        // validation for constraint: string
        if (!is_null($canvasOptions) && !is_string($canvasOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($canvasOptions, true), gettype($canvasOptions)), __LINE__);
        }
        if (is_null($canvasOptions) || (is_array($canvasOptions) && empty($canvasOptions))) {
            unset($this->CanvasOptions);
        } else {
            $this->CanvasOptions = $canvasOptions;
        }
        return $this;
    }
    /**
     * Get CanvasReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCanvasReferenceId()
    {
        return isset($this->CanvasReferenceId) ? $this->CanvasReferenceId : null;
    }
    /**
     * Set CanvasReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $canvasReferenceId
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setCanvasReferenceId($canvasReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($canvasReferenceId) && !is_string($canvasReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($canvasReferenceId, true), gettype($canvasReferenceId)), __LINE__);
        }
        if (is_null($canvasReferenceId) || (is_array($canvasReferenceId) && empty($canvasReferenceId))) {
            unset($this->CanvasReferenceId);
        } else {
            $this->CanvasReferenceId = $canvasReferenceId;
        }
        return $this;
    }
    /**
     * Get CanvasSelectedLocations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCanvasSelectedLocations()
    {
        return isset($this->CanvasSelectedLocations) ? $this->CanvasSelectedLocations : null;
    }
    /**
     * Set CanvasSelectedLocations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $canvasSelectedLocations
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setCanvasSelectedLocations($canvasSelectedLocations = null)
    {
        // validation for constraint: string
        if (!is_null($canvasSelectedLocations) && !is_string($canvasSelectedLocations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($canvasSelectedLocations, true), gettype($canvasSelectedLocations)), __LINE__);
        }
        if (is_null($canvasSelectedLocations) || (is_array($canvasSelectedLocations) && empty($canvasSelectedLocations))) {
            unset($this->CanvasSelectedLocations);
        } else {
            $this->CanvasSelectedLocations = $canvasSelectedLocations;
        }
        return $this;
    }
    /**
     * Get CanvasUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCanvasUrl()
    {
        return isset($this->CanvasUrl) ? $this->CanvasUrl : null;
    }
    /**
     * Set CanvasUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $canvasUrl
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setCanvasUrl($canvasUrl = null)
    {
        // validation for constraint: string
        if (!is_null($canvasUrl) && !is_string($canvasUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($canvasUrl, true), gettype($canvasUrl)), __LINE__);
        }
        if (is_null($canvasUrl) || (is_array($canvasUrl) && empty($canvasUrl))) {
            unset($this->CanvasUrl);
        } else {
            $this->CanvasUrl = $canvasUrl;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get IconUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIconUrl()
    {
        return isset($this->IconUrl) ? $this->IconUrl : null;
    }
    /**
     * Set IconUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iconUrl
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setIconUrl($iconUrl = null)
    {
        // validation for constraint: string
        if (!is_null($iconUrl) && !is_string($iconUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iconUrl, true), gettype($iconUrl)), __LINE__);
        }
        if (is_null($iconUrl) || (is_array($iconUrl) && empty($iconUrl))) {
            unset($this->IconUrl);
        } else {
            $this->IconUrl = $iconUrl;
        }
        return $this;
    }
    /**
     * Get InfoUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInfoUrl()
    {
        return isset($this->InfoUrl) ? $this->InfoUrl : null;
    }
    /**
     * Set InfoUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $infoUrl
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setInfoUrl($infoUrl = null)
    {
        // validation for constraint: string
        if (!is_null($infoUrl) && !is_string($infoUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infoUrl, true), gettype($infoUrl)), __LINE__);
        }
        if (is_null($infoUrl) || (is_array($infoUrl) && empty($infoUrl))) {
            unset($this->InfoUrl);
        } else {
            $this->InfoUrl = $infoUrl;
        }
        return $this;
    }
    /**
     * Get IsAccessible value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAccessible()
    {
        return isset($this->IsAccessible) ? $this->IsAccessible : null;
    }
    /**
     * Set IsAccessible value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAccessible
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setIsAccessible($isAccessible = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAccessible) && !is_bool($isAccessible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAccessible, true), gettype($isAccessible)), __LINE__);
        }
        if (is_null($isAccessible) || (is_array($isAccessible) && empty($isAccessible))) {
            unset($this->IsAccessible);
        } else {
            $this->IsAccessible = $isAccessible;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get IsRegisteredDeviceOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRegisteredDeviceOnly()
    {
        return isset($this->IsRegisteredDeviceOnly) ? $this->IsRegisteredDeviceOnly : null;
    }
    /**
     * Set IsRegisteredDeviceOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRegisteredDeviceOnly
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setIsRegisteredDeviceOnly($isRegisteredDeviceOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRegisteredDeviceOnly) && !is_bool($isRegisteredDeviceOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRegisteredDeviceOnly, true), gettype($isRegisteredDeviceOnly)), __LINE__);
        }
        if (is_null($isRegisteredDeviceOnly) || (is_array($isRegisteredDeviceOnly) && empty($isRegisteredDeviceOnly))) {
            unset($this->IsRegisteredDeviceOnly);
        } else {
            $this->IsRegisteredDeviceOnly = $isRegisteredDeviceOnly;
        }
        return $this;
    }
    /**
     * Get IsUsingAdminAuthorization value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUsingAdminAuthorization()
    {
        return isset($this->IsUsingAdminAuthorization) ? $this->IsUsingAdminAuthorization : null;
    }
    /**
     * Set IsUsingAdminAuthorization value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUsingAdminAuthorization
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setIsUsingAdminAuthorization($isUsingAdminAuthorization = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUsingAdminAuthorization) && !is_bool($isUsingAdminAuthorization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUsingAdminAuthorization, true), gettype($isUsingAdminAuthorization)), __LINE__);
        }
        if (is_null($isUsingAdminAuthorization) || (is_array($isUsingAdminAuthorization) && empty($isUsingAdminAuthorization))) {
            unset($this->IsUsingAdminAuthorization);
        } else {
            $this->IsUsingAdminAuthorization = $isUsingAdminAuthorization;
        }
        return $this;
    }
    /**
     * Get IsVisible value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVisible()
    {
        return isset($this->IsVisible) ? $this->IsVisible : null;
    }
    /**
     * Set IsVisible value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVisible
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setIsVisible($isVisible = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVisible) && !is_bool($isVisible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVisible, true), gettype($isVisible)), __LINE__);
        }
        if (is_null($isVisible) || (is_array($isVisible) && empty($isVisible))) {
            unset($this->IsVisible);
        } else {
            $this->IsVisible = $isVisible;
        }
        return $this;
    }
    /**
     * Get Label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabel()
    {
        return isset($this->Label) ? $this->Label : null;
    }
    /**
     * Set Label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $label
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        if (is_null($label) || (is_array($label) && empty($label))) {
            unset($this->Label);
        } else {
            $this->Label = $label;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LogoUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogoUrl()
    {
        return isset($this->LogoUrl) ? $this->LogoUrl : null;
    }
    /**
     * Set LogoUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $logoUrl
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setLogoUrl($logoUrl = null)
    {
        // validation for constraint: string
        if (!is_null($logoUrl) && !is_string($logoUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logoUrl, true), gettype($logoUrl)), __LINE__);
        }
        if (is_null($logoUrl) || (is_array($logoUrl) && empty($logoUrl))) {
            unset($this->LogoUrl);
        } else {
            $this->LogoUrl = $logoUrl;
        }
        return $this;
    }
    /**
     * Get MobileAppBinaryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobileAppBinaryId()
    {
        return isset($this->MobileAppBinaryId) ? $this->MobileAppBinaryId : null;
    }
    /**
     * Set MobileAppBinaryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobileAppBinaryId
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setMobileAppBinaryId($mobileAppBinaryId = null)
    {
        // validation for constraint: string
        if (!is_null($mobileAppBinaryId) && !is_string($mobileAppBinaryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileAppBinaryId, true), gettype($mobileAppBinaryId)), __LINE__);
        }
        if (is_null($mobileAppBinaryId) || (is_array($mobileAppBinaryId) && empty($mobileAppBinaryId))) {
            unset($this->MobileAppBinaryId);
        } else {
            $this->MobileAppBinaryId = $mobileAppBinaryId;
        }
        return $this;
    }
    /**
     * Get MobileAppInstallUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobileAppInstallUrl()
    {
        return isset($this->MobileAppInstallUrl) ? $this->MobileAppInstallUrl : null;
    }
    /**
     * Set MobileAppInstallUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobileAppInstallUrl
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setMobileAppInstallUrl($mobileAppInstallUrl = null)
    {
        // validation for constraint: string
        if (!is_null($mobileAppInstallUrl) && !is_string($mobileAppInstallUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileAppInstallUrl, true), gettype($mobileAppInstallUrl)), __LINE__);
        }
        if (is_null($mobileAppInstallUrl) || (is_array($mobileAppInstallUrl) && empty($mobileAppInstallUrl))) {
            unset($this->MobileAppInstallUrl);
        } else {
            $this->MobileAppInstallUrl = $mobileAppInstallUrl;
        }
        return $this;
    }
    /**
     * Get MobileAppInstalledDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobileAppInstalledDate()
    {
        return isset($this->MobileAppInstalledDate) ? $this->MobileAppInstalledDate : null;
    }
    /**
     * Set MobileAppInstalledDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobileAppInstalledDate
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setMobileAppInstalledDate($mobileAppInstalledDate = null)
    {
        // validation for constraint: string
        if (!is_null($mobileAppInstalledDate) && !is_string($mobileAppInstalledDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileAppInstalledDate, true), gettype($mobileAppInstalledDate)), __LINE__);
        }
        if (is_null($mobileAppInstalledDate) || (is_array($mobileAppInstalledDate) && empty($mobileAppInstalledDate))) {
            unset($this->MobileAppInstalledDate);
        } else {
            $this->MobileAppInstalledDate = $mobileAppInstalledDate;
        }
        return $this;
    }
    /**
     * Get MobileAppInstalledVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobileAppInstalledVersion()
    {
        return isset($this->MobileAppInstalledVersion) ? $this->MobileAppInstalledVersion : null;
    }
    /**
     * Set MobileAppInstalledVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobileAppInstalledVersion
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setMobileAppInstalledVersion($mobileAppInstalledVersion = null)
    {
        // validation for constraint: string
        if (!is_null($mobileAppInstalledVersion) && !is_string($mobileAppInstalledVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileAppInstalledVersion, true), gettype($mobileAppInstalledVersion)), __LINE__);
        }
        if (is_null($mobileAppInstalledVersion) || (is_array($mobileAppInstalledVersion) && empty($mobileAppInstalledVersion))) {
            unset($this->MobileAppInstalledVersion);
        } else {
            $this->MobileAppInstalledVersion = $mobileAppInstalledVersion;
        }
        return $this;
    }
    /**
     * Get MobileAppVer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobileAppVer()
    {
        return isset($this->MobileAppVer) ? $this->MobileAppVer : null;
    }
    /**
     * Set MobileAppVer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobileAppVer
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setMobileAppVer($mobileAppVer = null)
    {
        // validation for constraint: string
        if (!is_null($mobileAppVer) && !is_string($mobileAppVer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileAppVer, true), gettype($mobileAppVer)), __LINE__);
        }
        if (is_null($mobileAppVer) || (is_array($mobileAppVer) && empty($mobileAppVer))) {
            unset($this->MobileAppVer);
        } else {
            $this->MobileAppVer = $mobileAppVer;
        }
        return $this;
    }
    /**
     * Get MobileDeviceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobileDeviceType()
    {
        return isset($this->MobileDeviceType) ? $this->MobileDeviceType : null;
    }
    /**
     * Set MobileDeviceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobileDeviceType
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setMobileDeviceType($mobileDeviceType = null)
    {
        // validation for constraint: string
        if (!is_null($mobileDeviceType) && !is_string($mobileDeviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileDeviceType, true), gettype($mobileDeviceType)), __LINE__);
        }
        if (is_null($mobileDeviceType) || (is_array($mobileDeviceType) && empty($mobileDeviceType))) {
            unset($this->MobileDeviceType);
        } else {
            $this->MobileDeviceType = $mobileDeviceType;
        }
        return $this;
    }
    /**
     * Get MobileMinOsVer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobileMinOsVer()
    {
        return isset($this->MobileMinOsVer) ? $this->MobileMinOsVer : null;
    }
    /**
     * Set MobileMinOsVer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobileMinOsVer
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setMobileMinOsVer($mobileMinOsVer = null)
    {
        // validation for constraint: string
        if (!is_null($mobileMinOsVer) && !is_string($mobileMinOsVer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileMinOsVer, true), gettype($mobileMinOsVer)), __LINE__);
        }
        if (is_null($mobileMinOsVer) || (is_array($mobileMinOsVer) && empty($mobileMinOsVer))) {
            unset($this->MobileMinOsVer);
        } else {
            $this->MobileMinOsVer = $mobileMinOsVer;
        }
        return $this;
    }
    /**
     * Get MobilePlatform value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobilePlatform()
    {
        return isset($this->MobilePlatform) ? $this->MobilePlatform : null;
    }
    /**
     * Set MobilePlatform value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobilePlatform
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setMobilePlatform($mobilePlatform = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePlatform) && !is_string($mobilePlatform)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilePlatform, true), gettype($mobilePlatform)), __LINE__);
        }
        if (is_null($mobilePlatform) || (is_array($mobilePlatform) && empty($mobilePlatform))) {
            unset($this->MobilePlatform);
        } else {
            $this->MobilePlatform = $mobilePlatform;
        }
        return $this;
    }
    /**
     * Get MobileStartUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobileStartUrl()
    {
        return isset($this->MobileStartUrl) ? $this->MobileStartUrl : null;
    }
    /**
     * Set MobileStartUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobileStartUrl
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setMobileStartUrl($mobileStartUrl = null)
    {
        // validation for constraint: string
        if (!is_null($mobileStartUrl) && !is_string($mobileStartUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileStartUrl, true), gettype($mobileStartUrl)), __LINE__);
        }
        if (is_null($mobileStartUrl) || (is_array($mobileStartUrl) && empty($mobileStartUrl))) {
            unset($this->MobileStartUrl);
        } else {
            $this->MobileStartUrl = $mobileStartUrl;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NamespacePrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNamespacePrefix()
    {
        return isset($this->NamespacePrefix) ? $this->NamespacePrefix : null;
    }
    /**
     * Set NamespacePrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $namespacePrefix
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setNamespacePrefix($namespacePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($namespacePrefix) && !is_string($namespacePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($namespacePrefix, true), gettype($namespacePrefix)), __LINE__);
        }
        if (is_null($namespacePrefix) || (is_array($namespacePrefix) && empty($namespacePrefix))) {
            unset($this->NamespacePrefix);
        } else {
            $this->NamespacePrefix = $namespacePrefix;
        }
        return $this;
    }
    /**
     * Get SortOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSortOrder()
    {
        return isset($this->SortOrder) ? $this->SortOrder : null;
    }
    /**
     * Set SortOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sortOrder
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: int
        if (!is_null($sortOrder) && !(is_int($sortOrder) || ctype_digit($sortOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sortOrder, true), gettype($sortOrder)), __LINE__);
        }
        if (is_null($sortOrder) || (is_array($sortOrder) && empty($sortOrder))) {
            unset($this->SortOrder);
        } else {
            $this->SortOrder = $sortOrder;
        }
        return $this;
    }
    /**
     * Get StartUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartUrl()
    {
        return isset($this->StartUrl) ? $this->StartUrl : null;
    }
    /**
     * Set StartUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startUrl
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setStartUrl($startUrl = null)
    {
        // validation for constraint: string
        if (!is_null($startUrl) && !is_string($startUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startUrl, true), gettype($startUrl)), __LINE__);
        }
        if (is_null($startUrl) || (is_array($startUrl) && empty($startUrl))) {
            unset($this->StartUrl);
        } else {
            $this->StartUrl = $startUrl;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get UserSortOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUserSortOrder()
    {
        return isset($this->UserSortOrder) ? $this->UserSortOrder : null;
    }
    /**
     * Set UserSortOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $userSortOrder
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public function setUserSortOrder($userSortOrder = null)
    {
        // validation for constraint: int
        if (!is_null($userSortOrder) && !(is_int($userSortOrder) || ctype_digit($userSortOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userSortOrder, true), gettype($userSortOrder)), __LINE__);
        }
        if (is_null($userSortOrder) || (is_array($userSortOrder) && empty($userSortOrder))) {
            unset($this->UserSortOrder);
        } else {
            $this->UserSortOrder = $userSortOrder;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\AppMenuItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
