<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApexTestRunResult StructType
 * @subpackage Structs
 */
class ApexTestRunResult extends SObject
{
    /**
     * The AsyncApexJob
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\AsyncApexJob
     */
    public $AsyncApexJob;
    /**
     * The AsyncApexJobId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $AsyncApexJobId;
    /**
     * The ClassesCompleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ClassesCompleted;
    /**
     * The ClassesEnqueued
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ClassesEnqueued;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $CreatedBy;
    /**
     * The CreatedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $CreatedById;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedDate;
    /**
     * The EndTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndTime;
    /**
     * The IsAllTests
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAllTests;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The JobName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JobName;
    /**
     * The LastModifiedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $LastModifiedBy;
    /**
     * The LastModifiedById
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $LastModifiedById;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The MethodsCompleted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MethodsCompleted;
    /**
     * The MethodsEnqueued
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MethodsEnqueued;
    /**
     * The MethodsFailed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MethodsFailed;
    /**
     * The Source
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Source;
    /**
     * The StartTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartTime;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The TestTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TestTime;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\User
     */
    public $User;
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for ApexTestRunResult
     * @uses ApexTestRunResult::setAsyncApexJob()
     * @uses ApexTestRunResult::setAsyncApexJobId()
     * @uses ApexTestRunResult::setClassesCompleted()
     * @uses ApexTestRunResult::setClassesEnqueued()
     * @uses ApexTestRunResult::setCreatedBy()
     * @uses ApexTestRunResult::setCreatedById()
     * @uses ApexTestRunResult::setCreatedDate()
     * @uses ApexTestRunResult::setEndTime()
     * @uses ApexTestRunResult::setIsAllTests()
     * @uses ApexTestRunResult::setIsDeleted()
     * @uses ApexTestRunResult::setJobName()
     * @uses ApexTestRunResult::setLastModifiedBy()
     * @uses ApexTestRunResult::setLastModifiedById()
     * @uses ApexTestRunResult::setLastModifiedDate()
     * @uses ApexTestRunResult::setMethodsCompleted()
     * @uses ApexTestRunResult::setMethodsEnqueued()
     * @uses ApexTestRunResult::setMethodsFailed()
     * @uses ApexTestRunResult::setSource()
     * @uses ApexTestRunResult::setStartTime()
     * @uses ApexTestRunResult::setStatus()
     * @uses ApexTestRunResult::setSystemModstamp()
     * @uses ApexTestRunResult::setTestTime()
     * @uses ApexTestRunResult::setUser()
     * @uses ApexTestRunResult::setUserId()
     * @param \NexusDigital/MiratelForce\StructType\AsyncApexJob $asyncApexJob
     * @param string $asyncApexJobId
     * @param int $classesCompleted
     * @param int $classesEnqueued
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @param string $createdById
     * @param string $createdDate
     * @param string $endTime
     * @param bool $isAllTests
     * @param bool $isDeleted
     * @param string $jobName
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @param string $lastModifiedById
     * @param string $lastModifiedDate
     * @param int $methodsCompleted
     * @param int $methodsEnqueued
     * @param int $methodsFailed
     * @param string $source
     * @param string $startTime
     * @param string $status
     * @param string $systemModstamp
     * @param int $testTime
     * @param \NexusDigital/MiratelForce\StructType\User $user
     * @param string $userId
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\AsyncApexJob $asyncApexJob = null, $asyncApexJobId = null, $classesCompleted = null, $classesEnqueued = null, \NexusDigital/MiratelForce\StructType\User $createdBy = null, $createdById = null, $createdDate = null, $endTime = null, $isAllTests = null, $isDeleted = null, $jobName = null, \NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null, $lastModifiedById = null, $lastModifiedDate = null, $methodsCompleted = null, $methodsEnqueued = null, $methodsFailed = null, $source = null, $startTime = null, $status = null, $systemModstamp = null, $testTime = null, \NexusDigital/MiratelForce\StructType\User $user = null, $userId = null)
    {
        $this
            ->setAsyncApexJob($asyncApexJob)
            ->setAsyncApexJobId($asyncApexJobId)
            ->setClassesCompleted($classesCompleted)
            ->setClassesEnqueued($classesEnqueued)
            ->setCreatedBy($createdBy)
            ->setCreatedById($createdById)
            ->setCreatedDate($createdDate)
            ->setEndTime($endTime)
            ->setIsAllTests($isAllTests)
            ->setIsDeleted($isDeleted)
            ->setJobName($jobName)
            ->setLastModifiedBy($lastModifiedBy)
            ->setLastModifiedById($lastModifiedById)
            ->setLastModifiedDate($lastModifiedDate)
            ->setMethodsCompleted($methodsCompleted)
            ->setMethodsEnqueued($methodsEnqueued)
            ->setMethodsFailed($methodsFailed)
            ->setSource($source)
            ->setStartTime($startTime)
            ->setStatus($status)
            ->setSystemModstamp($systemModstamp)
            ->setTestTime($testTime)
            ->setUser($user)
            ->setUserId($userId);
    }
    /**
     * Get AsyncApexJob value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\AsyncApexJob|null
     */
    public function getAsyncApexJob()
    {
        return isset($this->AsyncApexJob) ? $this->AsyncApexJob : null;
    }
    /**
     * Set AsyncApexJob value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\AsyncApexJob $asyncApexJob
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public function setAsyncApexJob(\NexusDigital/MiratelForce\StructType\AsyncApexJob $asyncApexJob = null)
    {
        if (is_null($asyncApexJob) || (is_array($asyncApexJob) && empty($asyncApexJob))) {
            unset($this->AsyncApexJob);
        } else {
            $this->AsyncApexJob = $asyncApexJob;
        }
        return $this;
    }
    /**
     * Get AsyncApexJobId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsyncApexJobId()
    {
        return isset($this->AsyncApexJobId) ? $this->AsyncApexJobId : null;
    }
    /**
     * Set AsyncApexJobId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asyncApexJobId
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public function setAsyncApexJobId($asyncApexJobId = null)
    {
        // validation for constraint: string
        if (!is_null($asyncApexJobId) && !is_string($asyncApexJobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asyncApexJobId, true), gettype($asyncApexJobId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($asyncApexJobId) && mb_strlen($asyncApexJobId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($asyncApexJobId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($asyncApexJobId) && !preg_match('/[a-zA-Z0-9]{18}/', $asyncApexJobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($asyncApexJobId, true)), __LINE__);
        }
        if (is_null($asyncApexJobId) || (is_array($asyncApexJobId) && empty($asyncApexJobId))) {
            unset($this->AsyncApexJobId);
        } else {
            $this->AsyncApexJobId = $asyncApexJobId;
        }
        return $this;
    }
    /**
     * Get ClassesCompleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getClassesCompleted()
    {
        return isset($this->ClassesCompleted) ? $this->ClassesCompleted : null;
    }
    /**
     * Set ClassesCompleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $classesCompleted
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public function setClassesCompleted($classesCompleted = null)
    {
        // validation for constraint: int
        if (!is_null($classesCompleted) && !(is_int($classesCompleted) || ctype_digit($classesCompleted))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($classesCompleted, true), gettype($classesCompleted)), __LINE__);
        }
        if (is_null($classesCompleted) || (is_array($classesCompleted) && empty($classesCompleted))) {
            unset($this->ClassesCompleted);
        } else {
            $this->ClassesCompleted = $classesCompleted;
        }
        return $this;
    }
    /**
     * Get ClassesEnqueued value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getClassesEnqueued()
    {
        return isset($this->ClassesEnqueued) ? $this->ClassesEnqueued : null;
    }
    /**
     * Set ClassesEnqueued value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $classesEnqueued
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public function setClassesEnqueued($classesEnqueued = null)
    {
        // validation for constraint: int
        if (!is_null($classesEnqueued) && !(is_int($classesEnqueued) || ctype_digit($classesEnqueued))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($classesEnqueued, true), gettype($classesEnqueued)), __LINE__);
        }
        if (is_null($classesEnqueued) || (is_array($classesEnqueued) && empty($classesEnqueued))) {
            unset($this->ClassesEnqueued);
        } else {
            $this->ClassesEnqueued = $classesEnqueued;
        }
        return $this;
    }
    /**
     * Get CreatedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getCreatedBy()
    {
        return isset($this->CreatedBy) ? $this->CreatedBy : null;
    }
    /**
     * Set CreatedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $createdBy
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public function setCreatedBy(\NexusDigital/MiratelForce\StructType\User $createdBy = null)
    {
        if (is_null($createdBy) || (is_array($createdBy) && empty($createdBy))) {
            unset($this->CreatedBy);
        } else {
            $this->CreatedBy = $createdBy;
        }
        return $this;
    }
    /**
     * Get CreatedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedById()
    {
        return isset($this->CreatedById) ? $this->CreatedById : null;
    }
    /**
     * Set CreatedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdById
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public function setCreatedById($createdById = null)
    {
        // validation for constraint: string
        if (!is_null($createdById) && !is_string($createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdById, true), gettype($createdById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($createdById) && mb_strlen($createdById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($createdById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($createdById) && !preg_match('/[a-zA-Z0-9]{18}/', $createdById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($createdById, true)), __LINE__);
        }
        if (is_null($createdById) || (is_array($createdById) && empty($createdById))) {
            unset($this->CreatedById);
        } else {
            $this->CreatedById = $createdById;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedDate()
    {
        return isset($this->CreatedDate) ? $this->CreatedDate : null;
    }
    /**
     * Set CreatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdDate
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        if (is_null($createdDate) || (is_array($createdDate) && empty($createdDate))) {
            unset($this->CreatedDate);
        } else {
            $this->CreatedDate = $createdDate;
        }
        return $this;
    }
    /**
     * Get EndTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndTime()
    {
        return isset($this->EndTime) ? $this->EndTime : null;
    }
    /**
     * Set EndTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endTime
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: string
        if (!is_null($endTime) && !is_string($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endTime, true), gettype($endTime)), __LINE__);
        }
        if (is_null($endTime) || (is_array($endTime) && empty($endTime))) {
            unset($this->EndTime);
        } else {
            $this->EndTime = $endTime;
        }
        return $this;
    }
    /**
     * Get IsAllTests value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAllTests()
    {
        return isset($this->IsAllTests) ? $this->IsAllTests : null;
    }
    /**
     * Set IsAllTests value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAllTests
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public function setIsAllTests($isAllTests = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAllTests) && !is_bool($isAllTests)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAllTests, true), gettype($isAllTests)), __LINE__);
        }
        if (is_null($isAllTests) || (is_array($isAllTests) && empty($isAllTests))) {
            unset($this->IsAllTests);
        } else {
            $this->IsAllTests = $isAllTests;
        }
        return $this;
    }
    /**
     * Get IsDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return isset($this->IsDeleted) ? $this->IsDeleted : null;
    }
    /**
     * Set IsDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeleted
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        if (is_null($isDeleted) || (is_array($isDeleted) && empty($isDeleted))) {
            unset($this->IsDeleted);
        } else {
            $this->IsDeleted = $isDeleted;
        }
        return $this;
    }
    /**
     * Get JobName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJobName()
    {
        return isset($this->JobName) ? $this->JobName : null;
    }
    /**
     * Set JobName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jobName
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public function setJobName($jobName = null)
    {
        // validation for constraint: string
        if (!is_null($jobName) && !is_string($jobName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobName, true), gettype($jobName)), __LINE__);
        }
        if (is_null($jobName) || (is_array($jobName) && empty($jobName))) {
            unset($this->JobName);
        } else {
            $this->JobName = $jobName;
        }
        return $this;
    }
    /**
     * Get LastModifiedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getLastModifiedBy()
    {
        return isset($this->LastModifiedBy) ? $this->LastModifiedBy : null;
    }
    /**
     * Set LastModifiedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $lastModifiedBy
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public function setLastModifiedBy(\NexusDigital/MiratelForce\StructType\User $lastModifiedBy = null)
    {
        if (is_null($lastModifiedBy) || (is_array($lastModifiedBy) && empty($lastModifiedBy))) {
            unset($this->LastModifiedBy);
        } else {
            $this->LastModifiedBy = $lastModifiedBy;
        }
        return $this;
    }
    /**
     * Get LastModifiedById value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedById()
    {
        return isset($this->LastModifiedById) ? $this->LastModifiedById : null;
    }
    /**
     * Set LastModifiedById value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedById
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public function setLastModifiedById($lastModifiedById = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedById) && !is_string($lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedById, true), gettype($lastModifiedById)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($lastModifiedById) && mb_strlen($lastModifiedById) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($lastModifiedById)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($lastModifiedById) && !preg_match('/[a-zA-Z0-9]{18}/', $lastModifiedById)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($lastModifiedById, true)), __LINE__);
        }
        if (is_null($lastModifiedById) || (is_array($lastModifiedById) && empty($lastModifiedById))) {
            unset($this->LastModifiedById);
        } else {
            $this->LastModifiedById = $lastModifiedById;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get MethodsCompleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMethodsCompleted()
    {
        return isset($this->MethodsCompleted) ? $this->MethodsCompleted : null;
    }
    /**
     * Set MethodsCompleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $methodsCompleted
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public function setMethodsCompleted($methodsCompleted = null)
    {
        // validation for constraint: int
        if (!is_null($methodsCompleted) && !(is_int($methodsCompleted) || ctype_digit($methodsCompleted))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($methodsCompleted, true), gettype($methodsCompleted)), __LINE__);
        }
        if (is_null($methodsCompleted) || (is_array($methodsCompleted) && empty($methodsCompleted))) {
            unset($this->MethodsCompleted);
        } else {
            $this->MethodsCompleted = $methodsCompleted;
        }
        return $this;
    }
    /**
     * Get MethodsEnqueued value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMethodsEnqueued()
    {
        return isset($this->MethodsEnqueued) ? $this->MethodsEnqueued : null;
    }
    /**
     * Set MethodsEnqueued value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $methodsEnqueued
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public function setMethodsEnqueued($methodsEnqueued = null)
    {
        // validation for constraint: int
        if (!is_null($methodsEnqueued) && !(is_int($methodsEnqueued) || ctype_digit($methodsEnqueued))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($methodsEnqueued, true), gettype($methodsEnqueued)), __LINE__);
        }
        if (is_null($methodsEnqueued) || (is_array($methodsEnqueued) && empty($methodsEnqueued))) {
            unset($this->MethodsEnqueued);
        } else {
            $this->MethodsEnqueued = $methodsEnqueued;
        }
        return $this;
    }
    /**
     * Get MethodsFailed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMethodsFailed()
    {
        return isset($this->MethodsFailed) ? $this->MethodsFailed : null;
    }
    /**
     * Set MethodsFailed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $methodsFailed
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public function setMethodsFailed($methodsFailed = null)
    {
        // validation for constraint: int
        if (!is_null($methodsFailed) && !(is_int($methodsFailed) || ctype_digit($methodsFailed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($methodsFailed, true), gettype($methodsFailed)), __LINE__);
        }
        if (is_null($methodsFailed) || (is_array($methodsFailed) && empty($methodsFailed))) {
            unset($this->MethodsFailed);
        } else {
            $this->MethodsFailed = $methodsFailed;
        }
        return $this;
    }
    /**
     * Get Source value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSource()
    {
        return isset($this->Source) ? $this->Source : null;
    }
    /**
     * Set Source value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $source
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        if (is_null($source) || (is_array($source) && empty($source))) {
            unset($this->Source);
        } else {
            $this->Source = $source;
        }
        return $this;
    }
    /**
     * Get StartTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartTime()
    {
        return isset($this->StartTime) ? $this->StartTime : null;
    }
    /**
     * Set StartTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startTime
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startTime, true), gettype($startTime)), __LINE__);
        }
        if (is_null($startTime) || (is_array($startTime) && empty($startTime))) {
            unset($this->StartTime);
        } else {
            $this->StartTime = $startTime;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get TestTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTestTime()
    {
        return isset($this->TestTime) ? $this->TestTime : null;
    }
    /**
     * Set TestTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $testTime
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public function setTestTime($testTime = null)
    {
        // validation for constraint: int
        if (!is_null($testTime) && !(is_int($testTime) || ctype_digit($testTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($testTime, true), gettype($testTime)), __LINE__);
        }
        if (is_null($testTime) || (is_array($testTime) && empty($testTime))) {
            unset($this->TestTime);
        } else {
            $this->TestTime = $testTime;
        }
        return $this;
    }
    /**
     * Get User value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\User|null
     */
    public function getUser()
    {
        return isset($this->User) ? $this->User : null;
    }
    /**
     * Set User value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\User $user
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public function setUser(\NexusDigital/MiratelForce\StructType\User $user = null)
    {
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->User);
        } else {
            $this->User = $user;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($userId) && mb_strlen($userId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($userId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($userId) && !preg_match('/[a-zA-Z0-9]{18}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
