<?php

namespace NexusDigital/MiratelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApexTestResult StructType
 * @subpackage Structs
 */
class ApexTestResult extends SObject
{
    /**
     * The ApexClass
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ApexClass
     */
    public $ApexClass;
    /**
     * The ApexClassId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ApexClassId;
    /**
     * The ApexLog
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ApexLog
     */
    public $ApexLog;
    /**
     * The ApexLogId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ApexLogId;
    /**
     * The ApexTestResults
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\QueryResult
     */
    public $ApexTestResults;
    /**
     * The ApexTestRunResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ApexTestRunResult
     */
    public $ApexTestRunResult;
    /**
     * The ApexTestRunResultId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ApexTestRunResultId;
    /**
     * The AsyncApexJob
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\AsyncApexJob
     */
    public $AsyncApexJob;
    /**
     * The AsyncApexJobId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $AsyncApexJobId;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The MethodName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MethodName;
    /**
     * The Outcome
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Outcome;
    /**
     * The QueueItem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \NexusDigital/MiratelForce\StructType\ApexTestQueueItem
     */
    public $QueueItem;
    /**
     * The QueueItemId
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $QueueItemId;
    /**
     * The RunTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RunTime;
    /**
     * The StackTrace
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StackTrace;
    /**
     * The SystemModstamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemModstamp;
    /**
     * The TestTimestamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TestTimestamp;
    /**
     * Constructor method for ApexTestResult
     * @uses ApexTestResult::setApexClass()
     * @uses ApexTestResult::setApexClassId()
     * @uses ApexTestResult::setApexLog()
     * @uses ApexTestResult::setApexLogId()
     * @uses ApexTestResult::setApexTestResults()
     * @uses ApexTestResult::setApexTestRunResult()
     * @uses ApexTestResult::setApexTestRunResultId()
     * @uses ApexTestResult::setAsyncApexJob()
     * @uses ApexTestResult::setAsyncApexJobId()
     * @uses ApexTestResult::setMessage()
     * @uses ApexTestResult::setMethodName()
     * @uses ApexTestResult::setOutcome()
     * @uses ApexTestResult::setQueueItem()
     * @uses ApexTestResult::setQueueItemId()
     * @uses ApexTestResult::setRunTime()
     * @uses ApexTestResult::setStackTrace()
     * @uses ApexTestResult::setSystemModstamp()
     * @uses ApexTestResult::setTestTimestamp()
     * @param \NexusDigital/MiratelForce\StructType\ApexClass $apexClass
     * @param string $apexClassId
     * @param \NexusDigital/MiratelForce\StructType\ApexLog $apexLog
     * @param string $apexLogId
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $apexTestResults
     * @param \NexusDigital/MiratelForce\StructType\ApexTestRunResult $apexTestRunResult
     * @param string $apexTestRunResultId
     * @param \NexusDigital/MiratelForce\StructType\AsyncApexJob $asyncApexJob
     * @param string $asyncApexJobId
     * @param string $message
     * @param string $methodName
     * @param string $outcome
     * @param \NexusDigital/MiratelForce\StructType\ApexTestQueueItem $queueItem
     * @param string $queueItemId
     * @param int $runTime
     * @param string $stackTrace
     * @param string $systemModstamp
     * @param string $testTimestamp
     */
    public function __construct(\NexusDigital/MiratelForce\StructType\ApexClass $apexClass = null, $apexClassId = null, \NexusDigital/MiratelForce\StructType\ApexLog $apexLog = null, $apexLogId = null, \NexusDigital/MiratelForce\StructType\QueryResult $apexTestResults = null, \NexusDigital/MiratelForce\StructType\ApexTestRunResult $apexTestRunResult = null, $apexTestRunResultId = null, \NexusDigital/MiratelForce\StructType\AsyncApexJob $asyncApexJob = null, $asyncApexJobId = null, $message = null, $methodName = null, $outcome = null, \NexusDigital/MiratelForce\StructType\ApexTestQueueItem $queueItem = null, $queueItemId = null, $runTime = null, $stackTrace = null, $systemModstamp = null, $testTimestamp = null)
    {
        $this
            ->setApexClass($apexClass)
            ->setApexClassId($apexClassId)
            ->setApexLog($apexLog)
            ->setApexLogId($apexLogId)
            ->setApexTestResults($apexTestResults)
            ->setApexTestRunResult($apexTestRunResult)
            ->setApexTestRunResultId($apexTestRunResultId)
            ->setAsyncApexJob($asyncApexJob)
            ->setAsyncApexJobId($asyncApexJobId)
            ->setMessage($message)
            ->setMethodName($methodName)
            ->setOutcome($outcome)
            ->setQueueItem($queueItem)
            ->setQueueItemId($queueItemId)
            ->setRunTime($runTime)
            ->setStackTrace($stackTrace)
            ->setSystemModstamp($systemModstamp)
            ->setTestTimestamp($testTimestamp);
    }
    /**
     * Get ApexClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ApexClass|null
     */
    public function getApexClass()
    {
        return isset($this->ApexClass) ? $this->ApexClass : null;
    }
    /**
     * Set ApexClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ApexClass $apexClass
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResult
     */
    public function setApexClass(\NexusDigital/MiratelForce\StructType\ApexClass $apexClass = null)
    {
        if (is_null($apexClass) || (is_array($apexClass) && empty($apexClass))) {
            unset($this->ApexClass);
        } else {
            $this->ApexClass = $apexClass;
        }
        return $this;
    }
    /**
     * Get ApexClassId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApexClassId()
    {
        return isset($this->ApexClassId) ? $this->ApexClassId : null;
    }
    /**
     * Set ApexClassId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apexClassId
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResult
     */
    public function setApexClassId($apexClassId = null)
    {
        // validation for constraint: string
        if (!is_null($apexClassId) && !is_string($apexClassId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apexClassId, true), gettype($apexClassId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($apexClassId) && mb_strlen($apexClassId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($apexClassId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($apexClassId) && !preg_match('/[a-zA-Z0-9]{18}/', $apexClassId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($apexClassId, true)), __LINE__);
        }
        if (is_null($apexClassId) || (is_array($apexClassId) && empty($apexClassId))) {
            unset($this->ApexClassId);
        } else {
            $this->ApexClassId = $apexClassId;
        }
        return $this;
    }
    /**
     * Get ApexLog value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ApexLog|null
     */
    public function getApexLog()
    {
        return isset($this->ApexLog) ? $this->ApexLog : null;
    }
    /**
     * Set ApexLog value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ApexLog $apexLog
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResult
     */
    public function setApexLog(\NexusDigital/MiratelForce\StructType\ApexLog $apexLog = null)
    {
        if (is_null($apexLog) || (is_array($apexLog) && empty($apexLog))) {
            unset($this->ApexLog);
        } else {
            $this->ApexLog = $apexLog;
        }
        return $this;
    }
    /**
     * Get ApexLogId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApexLogId()
    {
        return isset($this->ApexLogId) ? $this->ApexLogId : null;
    }
    /**
     * Set ApexLogId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apexLogId
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResult
     */
    public function setApexLogId($apexLogId = null)
    {
        // validation for constraint: string
        if (!is_null($apexLogId) && !is_string($apexLogId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apexLogId, true), gettype($apexLogId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($apexLogId) && mb_strlen($apexLogId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($apexLogId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($apexLogId) && !preg_match('/[a-zA-Z0-9]{18}/', $apexLogId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($apexLogId, true)), __LINE__);
        }
        if (is_null($apexLogId) || (is_array($apexLogId) && empty($apexLogId))) {
            unset($this->ApexLogId);
        } else {
            $this->ApexLogId = $apexLogId;
        }
        return $this;
    }
    /**
     * Get ApexTestResults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\QueryResult|null
     */
    public function getApexTestResults()
    {
        return isset($this->ApexTestResults) ? $this->ApexTestResults : null;
    }
    /**
     * Set ApexTestResults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\QueryResult $apexTestResults
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResult
     */
    public function setApexTestResults(\NexusDigital/MiratelForce\StructType\QueryResult $apexTestResults = null)
    {
        if (is_null($apexTestResults) || (is_array($apexTestResults) && empty($apexTestResults))) {
            unset($this->ApexTestResults);
        } else {
            $this->ApexTestResults = $apexTestResults;
        }
        return $this;
    }
    /**
     * Get ApexTestRunResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ApexTestRunResult|null
     */
    public function getApexTestRunResult()
    {
        return isset($this->ApexTestRunResult) ? $this->ApexTestRunResult : null;
    }
    /**
     * Set ApexTestRunResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ApexTestRunResult $apexTestRunResult
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResult
     */
    public function setApexTestRunResult(\NexusDigital/MiratelForce\StructType\ApexTestRunResult $apexTestRunResult = null)
    {
        if (is_null($apexTestRunResult) || (is_array($apexTestRunResult) && empty($apexTestRunResult))) {
            unset($this->ApexTestRunResult);
        } else {
            $this->ApexTestRunResult = $apexTestRunResult;
        }
        return $this;
    }
    /**
     * Get ApexTestRunResultId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApexTestRunResultId()
    {
        return isset($this->ApexTestRunResultId) ? $this->ApexTestRunResultId : null;
    }
    /**
     * Set ApexTestRunResultId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apexTestRunResultId
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResult
     */
    public function setApexTestRunResultId($apexTestRunResultId = null)
    {
        // validation for constraint: string
        if (!is_null($apexTestRunResultId) && !is_string($apexTestRunResultId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apexTestRunResultId, true), gettype($apexTestRunResultId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($apexTestRunResultId) && mb_strlen($apexTestRunResultId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($apexTestRunResultId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($apexTestRunResultId) && !preg_match('/[a-zA-Z0-9]{18}/', $apexTestRunResultId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($apexTestRunResultId, true)), __LINE__);
        }
        if (is_null($apexTestRunResultId) || (is_array($apexTestRunResultId) && empty($apexTestRunResultId))) {
            unset($this->ApexTestRunResultId);
        } else {
            $this->ApexTestRunResultId = $apexTestRunResultId;
        }
        return $this;
    }
    /**
     * Get AsyncApexJob value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\AsyncApexJob|null
     */
    public function getAsyncApexJob()
    {
        return isset($this->AsyncApexJob) ? $this->AsyncApexJob : null;
    }
    /**
     * Set AsyncApexJob value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\AsyncApexJob $asyncApexJob
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResult
     */
    public function setAsyncApexJob(\NexusDigital/MiratelForce\StructType\AsyncApexJob $asyncApexJob = null)
    {
        if (is_null($asyncApexJob) || (is_array($asyncApexJob) && empty($asyncApexJob))) {
            unset($this->AsyncApexJob);
        } else {
            $this->AsyncApexJob = $asyncApexJob;
        }
        return $this;
    }
    /**
     * Get AsyncApexJobId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsyncApexJobId()
    {
        return isset($this->AsyncApexJobId) ? $this->AsyncApexJobId : null;
    }
    /**
     * Set AsyncApexJobId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asyncApexJobId
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResult
     */
    public function setAsyncApexJobId($asyncApexJobId = null)
    {
        // validation for constraint: string
        if (!is_null($asyncApexJobId) && !is_string($asyncApexJobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asyncApexJobId, true), gettype($asyncApexJobId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($asyncApexJobId) && mb_strlen($asyncApexJobId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($asyncApexJobId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($asyncApexJobId) && !preg_match('/[a-zA-Z0-9]{18}/', $asyncApexJobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($asyncApexJobId, true)), __LINE__);
        }
        if (is_null($asyncApexJobId) || (is_array($asyncApexJobId) && empty($asyncApexJobId))) {
            unset($this->AsyncApexJobId);
        } else {
            $this->AsyncApexJobId = $asyncApexJobId;
        }
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResult
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get MethodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMethodName()
    {
        return isset($this->MethodName) ? $this->MethodName : null;
    }
    /**
     * Set MethodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $methodName
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResult
     */
    public function setMethodName($methodName = null)
    {
        // validation for constraint: string
        if (!is_null($methodName) && !is_string($methodName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($methodName, true), gettype($methodName)), __LINE__);
        }
        if (is_null($methodName) || (is_array($methodName) && empty($methodName))) {
            unset($this->MethodName);
        } else {
            $this->MethodName = $methodName;
        }
        return $this;
    }
    /**
     * Get Outcome value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOutcome()
    {
        return isset($this->Outcome) ? $this->Outcome : null;
    }
    /**
     * Set Outcome value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $outcome
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResult
     */
    public function setOutcome($outcome = null)
    {
        // validation for constraint: string
        if (!is_null($outcome) && !is_string($outcome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outcome, true), gettype($outcome)), __LINE__);
        }
        if (is_null($outcome) || (is_array($outcome) && empty($outcome))) {
            unset($this->Outcome);
        } else {
            $this->Outcome = $outcome;
        }
        return $this;
    }
    /**
     * Get QueueItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \NexusDigital/MiratelForce\StructType\ApexTestQueueItem|null
     */
    public function getQueueItem()
    {
        return isset($this->QueueItem) ? $this->QueueItem : null;
    }
    /**
     * Set QueueItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \NexusDigital/MiratelForce\StructType\ApexTestQueueItem $queueItem
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResult
     */
    public function setQueueItem(\NexusDigital/MiratelForce\StructType\ApexTestQueueItem $queueItem = null)
    {
        if (is_null($queueItem) || (is_array($queueItem) && empty($queueItem))) {
            unset($this->QueueItem);
        } else {
            $this->QueueItem = $queueItem;
        }
        return $this;
    }
    /**
     * Get QueueItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueueItemId()
    {
        return isset($this->QueueItemId) ? $this->QueueItemId : null;
    }
    /**
     * Set QueueItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queueItemId
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResult
     */
    public function setQueueItemId($queueItemId = null)
    {
        // validation for constraint: string
        if (!is_null($queueItemId) && !is_string($queueItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queueItemId, true), gettype($queueItemId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($queueItemId) && mb_strlen($queueItemId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($queueItemId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($queueItemId) && !preg_match('/[a-zA-Z0-9]{18}/', $queueItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($queueItemId, true)), __LINE__);
        }
        if (is_null($queueItemId) || (is_array($queueItemId) && empty($queueItemId))) {
            unset($this->QueueItemId);
        } else {
            $this->QueueItemId = $queueItemId;
        }
        return $this;
    }
    /**
     * Get RunTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRunTime()
    {
        return isset($this->RunTime) ? $this->RunTime : null;
    }
    /**
     * Set RunTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $runTime
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResult
     */
    public function setRunTime($runTime = null)
    {
        // validation for constraint: int
        if (!is_null($runTime) && !(is_int($runTime) || ctype_digit($runTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($runTime, true), gettype($runTime)), __LINE__);
        }
        if (is_null($runTime) || (is_array($runTime) && empty($runTime))) {
            unset($this->RunTime);
        } else {
            $this->RunTime = $runTime;
        }
        return $this;
    }
    /**
     * Get StackTrace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStackTrace()
    {
        return isset($this->StackTrace) ? $this->StackTrace : null;
    }
    /**
     * Set StackTrace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stackTrace
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResult
     */
    public function setStackTrace($stackTrace = null)
    {
        // validation for constraint: string
        if (!is_null($stackTrace) && !is_string($stackTrace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stackTrace, true), gettype($stackTrace)), __LINE__);
        }
        if (is_null($stackTrace) || (is_array($stackTrace) && empty($stackTrace))) {
            unset($this->StackTrace);
        } else {
            $this->StackTrace = $stackTrace;
        }
        return $this;
    }
    /**
     * Get SystemModstamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemModstamp()
    {
        return isset($this->SystemModstamp) ? $this->SystemModstamp : null;
    }
    /**
     * Set SystemModstamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemModstamp
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResult
     */
    public function setSystemModstamp($systemModstamp = null)
    {
        // validation for constraint: string
        if (!is_null($systemModstamp) && !is_string($systemModstamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemModstamp, true), gettype($systemModstamp)), __LINE__);
        }
        if (is_null($systemModstamp) || (is_array($systemModstamp) && empty($systemModstamp))) {
            unset($this->SystemModstamp);
        } else {
            $this->SystemModstamp = $systemModstamp;
        }
        return $this;
    }
    /**
     * Get TestTimestamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTestTimestamp()
    {
        return isset($this->TestTimestamp) ? $this->TestTimestamp : null;
    }
    /**
     * Set TestTimestamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $testTimestamp
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResult
     */
    public function setTestTimestamp($testTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($testTimestamp) && !is_string($testTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($testTimestamp, true), gettype($testTimestamp)), __LINE__);
        }
        if (is_null($testTimestamp) || (is_array($testTimestamp) && empty($testTimestamp))) {
            unset($this->TestTimestamp);
        } else {
            $this->TestTimestamp = $testTimestamp;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \NexusDigital/MiratelForce\StructType\ApexTestResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
