<?php

namespace NexusDigital/MiratelForce\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Undelete ServiceType
 * @subpackage Services
 */
class Undelete extends AbstractSoapClientBase
{
    /**
     * Sets the SessionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\SessionHeader $sessionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSessionHeader(\NexusDigital/MiratelForce\StructType\SessionHeader $sessionHeader, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SessionHeader', $sessionHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the AllowFieldTruncationHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\AllowFieldTruncationHeader $allowFieldTruncationHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAllowFieldTruncationHeader(\NexusDigital/MiratelForce\StructType\AllowFieldTruncationHeader $allowFieldTruncationHeader, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AllowFieldTruncationHeader', $allowFieldTruncationHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the DisableFeedTrackingHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\DisableFeedTrackingHeader $disableFeedTrackingHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderDisableFeedTrackingHeader(\NexusDigital/MiratelForce\StructType\DisableFeedTrackingHeader $disableFeedTrackingHeader, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'DisableFeedTrackingHeader', $disableFeedTrackingHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the StreamingEnabledHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\StreamingEnabledHeader $streamingEnabledHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderStreamingEnabledHeader(\NexusDigital/MiratelForce\StructType\StreamingEnabledHeader $streamingEnabledHeader, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'StreamingEnabledHeader', $streamingEnabledHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the AllOrNoneHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\AllOrNoneHeader $allOrNoneHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAllOrNoneHeader(\NexusDigital/MiratelForce\StructType\AllOrNoneHeader $allOrNoneHeader, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AllOrNoneHeader', $allOrNoneHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the DuplicateRuleHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\DuplicateRuleHeader $duplicateRuleHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderDuplicateRuleHeader(\NexusDigital/MiratelForce\StructType\DuplicateRuleHeader $duplicateRuleHeader, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'DuplicateRuleHeader', $duplicateRuleHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the LocaleOptions SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\LocaleOptions $localeOptions
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderLocaleOptions(\NexusDigital/MiratelForce\StructType\LocaleOptions $localeOptions, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'LocaleOptions', $localeOptions, $mustUnderstand, $actor);
    }
    /**
     * Sets the DebuggingHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\DebuggingHeader $debuggingHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderDebuggingHeader(\NexusDigital/MiratelForce\StructType\DebuggingHeader $debuggingHeader, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'DebuggingHeader', $debuggingHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the PackageVersionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\PackageVersionHeader $packageVersionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPackageVersionHeader(\NexusDigital/MiratelForce\StructType\PackageVersionHeader $packageVersionHeader, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'PackageVersionHeader', $packageVersionHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named undelete
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, AllowFieldTruncationHeader, DisableFeedTrackingHeader, StreamingEnabledHeader, AllOrNoneHeader, DuplicateRuleHeader, LocaleOptions, DebuggingHeader, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\AllowFieldTruncationHeader, \NexusDigital/MiratelForce\StructType\DisableFeedTrackingHeader, \NexusDigital/MiratelForce\StructType\StreamingEnabledHeader, \NexusDigital/MiratelForce\StructType\AllOrNoneHeader, \NexusDigital/MiratelForce\StructType\DuplicateRuleHeader, \NexusDigital/MiratelForce\StructType\LocaleOptions, \NexusDigital/MiratelForce\StructType\DebuggingHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required, required, required, required, required, required, required, required
     * - documentation: Undelete a set of sObjects
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\Undelete $parameters
     * @return \NexusDigital/MiratelForce\StructType\UndeleteResponse|bool
     */
    public function undelete(\NexusDigital/MiratelForce\StructType\Undelete $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->undelete($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \NexusDigital/MiratelForce\StructType\UndeleteResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
