<?php

namespace NexusDigital/MiratelForce\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Sets the SessionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\SessionHeader $sessionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSessionHeader(\NexusDigital/MiratelForce\StructType\SessionHeader $sessionHeader, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SessionHeader', $sessionHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named sendEmailMessage
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader
     * - SOAPHeaders: required
     * - documentation: Send existing draft EmailMessage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\SendEmailMessage $parameters
     * @return \NexusDigital/MiratelForce\StructType\SendEmailMessageResponse|bool
     */
    public function sendEmailMessage(\NexusDigital/MiratelForce\StructType\SendEmailMessage $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->sendEmailMessage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendEmail
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader
     * - SOAPHeaders: required
     * - documentation: Send outbound email
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\SendEmail $parameters
     * @return \NexusDigital/MiratelForce\StructType\SendEmailResponse|bool
     */
    public function sendEmail(\NexusDigital/MiratelForce\StructType\SendEmail $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->sendEmail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \NexusDigital/MiratelForce\StructType\SendEmailMessageResponse|\NexusDigital/MiratelForce\StructType\SendEmailResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
