<?php

namespace NexusDigital/MiratelForce\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Retrieve ServiceType
 * @subpackage Services
 */
class Retrieve extends AbstractSoapClientBase
{
    /**
     * Sets the SessionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\SessionHeader $sessionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSessionHeader(\NexusDigital/MiratelForce\StructType\SessionHeader $sessionHeader, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SessionHeader', $sessionHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the QueryOptions SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\QueryOptions $queryOptions
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderQueryOptions(\NexusDigital/MiratelForce\StructType\QueryOptions $queryOptions, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'QueryOptions', $queryOptions, $mustUnderstand, $actor);
    }
    /**
     * Sets the MruHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\MruHeader $mruHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderMruHeader(\NexusDigital/MiratelForce\StructType\MruHeader $mruHeader, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'MruHeader', $mruHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the PackageVersionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\PackageVersionHeader $packageVersionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPackageVersionHeader(\NexusDigital/MiratelForce\StructType\PackageVersionHeader $packageVersionHeader, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'PackageVersionHeader', $packageVersionHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the LocaleOptions SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\LocaleOptions $localeOptions
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderLocaleOptions(\NexusDigital/MiratelForce\StructType\LocaleOptions $localeOptions, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'LocaleOptions', $localeOptions, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named retrieve
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, QueryOptions, MruHeader, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\QueryOptions, \NexusDigital/MiratelForce\StructType\MruHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required, required, required
     * - documentation: Get a set of sObjects
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\Retrieve $parameters
     * @return \NexusDigital/MiratelForce\StructType\RetrieveResponse|bool
     */
    public function retrieve(\NexusDigital/MiratelForce\StructType\Retrieve $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->retrieve($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named retrieveQuickActionTemplates
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader, LocaleOptions
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader, \NexusDigital/MiratelForce\StructType\LocaleOptions
     * - SOAPHeaders: required, required, required
     * - documentation: Retrieve the template sobjects, if appropriate, for the given quick action names in a given context
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\RetrieveQuickActionTemplates $parameters
     * @return \NexusDigital/MiratelForce\StructType\RetrieveQuickActionTemplatesResponse|bool
     */
    public function retrieveQuickActionTemplates(\NexusDigital/MiratelForce\StructType\RetrieveQuickActionTemplates $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->retrieveQuickActionTemplates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named retrieveMassQuickActionTemplates
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, PackageVersionHeader, LocaleOptions
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader, \NexusDigital/MiratelForce\StructType\LocaleOptions
     * - SOAPHeaders: required, required, required
     * - documentation: Retrieve the template sobjects, if appropriate, for the given quick action names in a given contexts when used a mass quick action
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\RetrieveMassQuickActionTemplates $parameters
     * @return \NexusDigital/MiratelForce\StructType\RetrieveMassQuickActionTemplatesResponse|bool
     */
    public function retrieveMassQuickActionTemplates(\NexusDigital/MiratelForce\StructType\RetrieveMassQuickActionTemplates $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->retrieveMassQuickActionTemplates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \NexusDigital/MiratelForce\StructType\RetrieveMassQuickActionTemplatesResponse|\NexusDigital/MiratelForce\StructType\RetrieveQuickActionTemplatesResponse|\NexusDigital/MiratelForce\StructType\RetrieveResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
