<?php

namespace NexusDigital/MiratelForce\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Render ServiceType
 * @subpackage Services
 */
class Render extends AbstractSoapClientBase
{
    /**
     * Sets the SessionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\SessionHeader $sessionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSessionHeader(\NexusDigital/MiratelForce\StructType\SessionHeader $sessionHeader, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SessionHeader', $sessionHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named renderEmailTemplate
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader
     * - SOAPHeaders: required
     * - documentation: Perform a template merge on one or more blocks of text.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\RenderEmailTemplate $parameters
     * @return \NexusDigital/MiratelForce\StructType\RenderEmailTemplateResponse|bool
     */
    public function renderEmailTemplate(\NexusDigital/MiratelForce\StructType\RenderEmailTemplate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->renderEmailTemplate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named renderStoredEmailTemplate
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader
     * - SOAPHeaders: required
     * - documentation: Perform a template merge using an email template stored in the database.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\RenderStoredEmailTemplate $parameters
     * @return \NexusDigital/MiratelForce\StructType\RenderStoredEmailTemplateResponse|bool
     */
    public function renderStoredEmailTemplate(\NexusDigital/MiratelForce\StructType\RenderStoredEmailTemplate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->renderStoredEmailTemplate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \NexusDigital/MiratelForce\StructType\RenderEmailTemplateResponse|\NexusDigital/MiratelForce\StructType\RenderStoredEmailTemplateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
