<?php

namespace NexusDigital/MiratelForce\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Query ServiceType
 * @subpackage Services
 */
class Query extends AbstractSoapClientBase
{
    /**
     * Sets the SessionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\SessionHeader $sessionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSessionHeader(\NexusDigital/MiratelForce\StructType\SessionHeader $sessionHeader, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SessionHeader', $sessionHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the QueryOptions SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\QueryOptions $queryOptions
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderQueryOptions(\NexusDigital/MiratelForce\StructType\QueryOptions $queryOptions, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'QueryOptions', $queryOptions, $mustUnderstand, $actor);
    }
    /**
     * Sets the MruHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\MruHeader $mruHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderMruHeader(\NexusDigital/MiratelForce\StructType\MruHeader $mruHeader, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'MruHeader', $mruHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the PackageVersionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\PackageVersionHeader $packageVersionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderPackageVersionHeader(\NexusDigital/MiratelForce\StructType\PackageVersionHeader $packageVersionHeader, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'PackageVersionHeader', $packageVersionHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named query
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, QueryOptions, MruHeader, PackageVersionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\QueryOptions, \NexusDigital/MiratelForce\StructType\MruHeader, \NexusDigital/MiratelForce\StructType\PackageVersionHeader
     * - SOAPHeaders: required, required, required, required
     * - documentation: Create a Query Cursor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\Query $parameters
     * @return \NexusDigital/MiratelForce\StructType\QueryResponse|bool
     */
    public function query(\NexusDigital/MiratelForce\StructType\Query $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->query($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryAll
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, QueryOptions
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\QueryOptions
     * - SOAPHeaders: required, required
     * - documentation: Create a Query Cursor, including deleted sObjects
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\QueryAll $parameters
     * @return \NexusDigital/MiratelForce\StructType\QueryAllResponse|bool
     */
    public function queryAll(\NexusDigital/MiratelForce\StructType\QueryAll $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->queryAll($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named queryMore
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, QueryOptions
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\QueryOptions
     * - SOAPHeaders: required, required
     * - documentation: Gets the next batch of sObjects from a query
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\QueryMore $parameters
     * @return \NexusDigital/MiratelForce\StructType\QueryMoreResponse|bool
     */
    public function queryMore(\NexusDigital/MiratelForce\StructType\QueryMore $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->queryMore($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \NexusDigital/MiratelForce\StructType\QueryAllResponse|\NexusDigital/MiratelForce\StructType\QueryMoreResponse|\NexusDigital/MiratelForce\StructType\QueryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
