<?php

namespace NexusDigital/MiratelForce\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the SessionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\SessionHeader $sessionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSessionHeader(\NexusDigital/MiratelForce\StructType\SessionHeader $sessionHeader, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SessionHeader', $sessionHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named getDeleted
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader
     * - SOAPHeaders: required
     * - documentation: Get the IDs for deleted sObjects
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\GetDeleted $parameters
     * @return \NexusDigital/MiratelForce\StructType\GetDeletedResponse|bool
     */
    public function getDeleted(\NexusDigital/MiratelForce\StructType\GetDeleted $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getDeleted($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUpdated
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader
     * - SOAPHeaders: required
     * - documentation: Get the IDs for updated sObjects
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\GetUpdated $parameters
     * @return \NexusDigital/MiratelForce\StructType\GetUpdatedResponse|bool
     */
    public function getUpdated(\NexusDigital/MiratelForce\StructType\GetUpdated $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getUpdated($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getServerTimestamp
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader
     * - SOAPHeaders: required
     * - documentation: Gets server timestamp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\GetServerTimestamp $parameters
     * @return \NexusDigital/MiratelForce\StructType\GetServerTimestampResponse|bool
     */
    public function getServerTimestamp(\NexusDigital/MiratelForce\StructType\GetServerTimestamp $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getServerTimestamp($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUserInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader
     * - SOAPHeaders: required
     * - documentation: Returns standard information relevant to the current user
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\GetUserInfo $parameters
     * @return \NexusDigital/MiratelForce\StructType\GetUserInfoResponse|bool
     */
    public function getUserInfo(\NexusDigital/MiratelForce\StructType\GetUserInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getUserInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \NexusDigital/MiratelForce\StructType\GetDeletedResponse|\NexusDigital/MiratelForce\StructType\GetServerTimestampResponse|\NexusDigital/MiratelForce\StructType\GetUpdatedResponse|\NexusDigital/MiratelForce\StructType\GetUserInfoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
