<?php

namespace NexusDigital/MiratelForce\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Execute ServiceType
 * @subpackage Services
 */
class Execute extends AbstractSoapClientBase
{
    /**
     * Sets the SessionHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\SessionHeader $sessionHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSessionHeader(\NexusDigital/MiratelForce\StructType\SessionHeader $sessionHeader, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SessionHeader', $sessionHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the MruHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \NexusDigital/MiratelForce\StructType\MruHeader $mruHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderMruHeader(\NexusDigital/MiratelForce\StructType\MruHeader $mruHeader, $nameSpace = 'urn:enterprise.soap.sforce.com', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'MruHeader', $mruHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named executeListView
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: SessionHeader, MruHeader
     * - SOAPHeaderNamespaces: urn:enterprise.soap.sforce.com, urn:enterprise.soap.sforce.com
     * - SOAPHeaderTypes: \NexusDigital/MiratelForce\StructType\SessionHeader, \NexusDigital/MiratelForce\StructType\MruHeader
     * - SOAPHeaders: required, required
     * - documentation: Execute the specified list view and return the presentation-ready results.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \NexusDigital/MiratelForce\StructType\ExecuteListView $parameters
     * @return \NexusDigital/MiratelForce\StructType\ExecuteListViewResponse|bool
     */
    public function executeListView(\NexusDigital/MiratelForce\StructType\ExecuteListView $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->executeListView($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \NexusDigital/MiratelForce\StructType\ExecuteListViewResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
