<?php

namespace NexusDigital/MiratelForce\EnumType;

/**
 * This class stands for ExceptionCode EnumType
 * @subpackage Enumerations
 */
class ExceptionCode
{
    /**
     * Constant for value 'APEX_REST_SERVICES_DISABLED'
     * @return string 'APEX_REST_SERVICES_DISABLED'
     */
    const VALUE_APEX_REST_SERVICES_DISABLED = 'APEX_REST_SERVICES_DISABLED';
    /**
     * Constant for value 'APEX_TRIGGER_COUPLING_LIMIT'
     * @return string 'APEX_TRIGGER_COUPLING_LIMIT'
     */
    const VALUE_APEX_TRIGGER_COUPLING_LIMIT = 'APEX_TRIGGER_COUPLING_LIMIT';
    /**
     * Constant for value 'API_CURRENTLY_DISABLED'
     * @return string 'API_CURRENTLY_DISABLED'
     */
    const VALUE_API_CURRENTLY_DISABLED = 'API_CURRENTLY_DISABLED';
    /**
     * Constant for value 'API_DISABLED_FOR_ORG'
     * @return string 'API_DISABLED_FOR_ORG'
     */
    const VALUE_API_DISABLED_FOR_ORG = 'API_DISABLED_FOR_ORG';
    /**
     * Constant for value 'ARGUMENT_OBJECT_PARSE_ERROR'
     * @return string 'ARGUMENT_OBJECT_PARSE_ERROR'
     */
    const VALUE_ARGUMENT_OBJECT_PARSE_ERROR = 'ARGUMENT_OBJECT_PARSE_ERROR';
    /**
     * Constant for value 'ASYNC_OPERATION_LOCATOR'
     * @return string 'ASYNC_OPERATION_LOCATOR'
     */
    const VALUE_ASYNC_OPERATION_LOCATOR = 'ASYNC_OPERATION_LOCATOR';
    /**
     * Constant for value 'ASYNC_QUERY_UNSUPPORTED_QUERY'
     * @return string 'ASYNC_QUERY_UNSUPPORTED_QUERY'
     */
    const VALUE_ASYNC_QUERY_UNSUPPORTED_QUERY = 'ASYNC_QUERY_UNSUPPORTED_QUERY';
    /**
     * Constant for value 'BATCH_PROCESSING_HALTED'
     * @return string 'BATCH_PROCESSING_HALTED'
     */
    const VALUE_BATCH_PROCESSING_HALTED = 'BATCH_PROCESSING_HALTED';
    /**
     * Constant for value 'BIG_OBJECT_UNSUPPORTED_OPERATION'
     * @return string 'BIG_OBJECT_UNSUPPORTED_OPERATION'
     */
    const VALUE_BIG_OBJECT_UNSUPPORTED_OPERATION = 'BIG_OBJECT_UNSUPPORTED_OPERATION';
    /**
     * Constant for value 'CANNOT_DELETE_ENTITY'
     * @return string 'CANNOT_DELETE_ENTITY'
     */
    const VALUE_CANNOT_DELETE_ENTITY = 'CANNOT_DELETE_ENTITY';
    /**
     * Constant for value 'CANNOT_DELETE_OWNER'
     * @return string 'CANNOT_DELETE_OWNER'
     */
    const VALUE_CANNOT_DELETE_OWNER = 'CANNOT_DELETE_OWNER';
    /**
     * Constant for value 'CANT_ADD_STANDADRD_PORTAL_USER_TO_TERRITORY'
     * @return string 'CANT_ADD_STANDADRD_PORTAL_USER_TO_TERRITORY'
     */
    const VALUE_CANT_ADD_STANDADRD_PORTAL_USER_TO_TERRITORY = 'CANT_ADD_STANDADRD_PORTAL_USER_TO_TERRITORY';
    /**
     * Constant for value 'CANT_ADD_STANDARD_PORTAL_USER_TO_TERRITORY'
     * @return string 'CANT_ADD_STANDARD_PORTAL_USER_TO_TERRITORY'
     */
    const VALUE_CANT_ADD_STANDARD_PORTAL_USER_TO_TERRITORY = 'CANT_ADD_STANDARD_PORTAL_USER_TO_TERRITORY';
    /**
     * Constant for value 'CATEGORY_NOT_FOUND'
     * @return string 'CATEGORY_NOT_FOUND'
     */
    const VALUE_CATEGORY_NOT_FOUND = 'CATEGORY_NOT_FOUND';
    /**
     * Constant for value 'CIRCULAR_OBJECT_GRAPH'
     * @return string 'CIRCULAR_OBJECT_GRAPH'
     */
    const VALUE_CIRCULAR_OBJECT_GRAPH = 'CIRCULAR_OBJECT_GRAPH';
    /**
     * Constant for value 'CLIENT_NOT_ACCESSIBLE_FOR_USER'
     * @return string 'CLIENT_NOT_ACCESSIBLE_FOR_USER'
     */
    const VALUE_CLIENT_NOT_ACCESSIBLE_FOR_USER = 'CLIENT_NOT_ACCESSIBLE_FOR_USER';
    /**
     * Constant for value 'CLIENT_REQUIRE_UPDATE_FOR_USER'
     * @return string 'CLIENT_REQUIRE_UPDATE_FOR_USER'
     */
    const VALUE_CLIENT_REQUIRE_UPDATE_FOR_USER = 'CLIENT_REQUIRE_UPDATE_FOR_USER';
    /**
     * Constant for value 'CONTENT_ALREADY_AN_ASSET_EXCEPTION'
     * @return string 'CONTENT_ALREADY_AN_ASSET_EXCEPTION'
     */
    const VALUE_CONTENT_ALREADY_AN_ASSET_EXCEPTION = 'CONTENT_ALREADY_AN_ASSET_EXCEPTION';
    /**
     * Constant for value 'CONTENT_CUSTOM_DOWNLOAD_EXCEPTION'
     * @return string 'CONTENT_CUSTOM_DOWNLOAD_EXCEPTION'
     */
    const VALUE_CONTENT_CUSTOM_DOWNLOAD_EXCEPTION = 'CONTENT_CUSTOM_DOWNLOAD_EXCEPTION';
    /**
     * Constant for value 'CONTENT_HUB_AUTHENTICATION_EXCEPTION'
     * @return string 'CONTENT_HUB_AUTHENTICATION_EXCEPTION'
     */
    const VALUE_CONTENT_HUB_AUTHENTICATION_EXCEPTION = 'CONTENT_HUB_AUTHENTICATION_EXCEPTION';
    /**
     * Constant for value 'CONTENT_HUB_FILE_DOWNLOAD_EXCEPTION'
     * @return string 'CONTENT_HUB_FILE_DOWNLOAD_EXCEPTION'
     */
    const VALUE_CONTENT_HUB_FILE_DOWNLOAD_EXCEPTION = 'CONTENT_HUB_FILE_DOWNLOAD_EXCEPTION';
    /**
     * Constant for value 'CONTENT_HUB_FILE_HAS_NO_URL_EXCEPTION'
     * @return string 'CONTENT_HUB_FILE_HAS_NO_URL_EXCEPTION'
     */
    const VALUE_CONTENT_HUB_FILE_HAS_NO_URL_EXCEPTION = 'CONTENT_HUB_FILE_HAS_NO_URL_EXCEPTION';
    /**
     * Constant for value 'CONTENT_HUB_FILE_NOT_FOUND_EXCEPTION'
     * @return string 'CONTENT_HUB_FILE_NOT_FOUND_EXCEPTION'
     */
    const VALUE_CONTENT_HUB_FILE_NOT_FOUND_EXCEPTION = 'CONTENT_HUB_FILE_NOT_FOUND_EXCEPTION';
    /**
     * Constant for value 'CONTENT_HUB_INVALID_OBJECT_TYPE_EXCEPTION'
     * @return string 'CONTENT_HUB_INVALID_OBJECT_TYPE_EXCEPTION'
     */
    const VALUE_CONTENT_HUB_INVALID_OBJECT_TYPE_EXCEPTION = 'CONTENT_HUB_INVALID_OBJECT_TYPE_EXCEPTION';
    /**
     * Constant for value 'CONTENT_HUB_INVALID_PAGE_NUMBER_EXCEPTION'
     * @return string 'CONTENT_HUB_INVALID_PAGE_NUMBER_EXCEPTION'
     */
    const VALUE_CONTENT_HUB_INVALID_PAGE_NUMBER_EXCEPTION = 'CONTENT_HUB_INVALID_PAGE_NUMBER_EXCEPTION';
    /**
     * Constant for value 'CONTENT_HUB_INVALID_PAYLOAD'
     * @return string 'CONTENT_HUB_INVALID_PAYLOAD'
     */
    const VALUE_CONTENT_HUB_INVALID_PAYLOAD = 'CONTENT_HUB_INVALID_PAYLOAD';
    /**
     * Constant for value 'CONTENT_HUB_INVALID_RENDITION_PAGE_NUMBER_EXCEPTION'
     * @return string 'CONTENT_HUB_INVALID_RENDITION_PAGE_NUMBER_EXCEPTION'
     */
    const VALUE_CONTENT_HUB_INVALID_RENDITION_PAGE_NUMBER_EXCEPTION = 'CONTENT_HUB_INVALID_RENDITION_PAGE_NUMBER_EXCEPTION';
    /**
     * Constant for value 'CONTENT_HUB_ITEM_TYPE_NOT_FOUND_EXCEPTION'
     * @return string 'CONTENT_HUB_ITEM_TYPE_NOT_FOUND_EXCEPTION'
     */
    const VALUE_CONTENT_HUB_ITEM_TYPE_NOT_FOUND_EXCEPTION = 'CONTENT_HUB_ITEM_TYPE_NOT_FOUND_EXCEPTION';
    /**
     * Constant for value 'CONTENT_HUB_OBJECT_NOT_FOUND_EXCEPTION'
     * @return string 'CONTENT_HUB_OBJECT_NOT_FOUND_EXCEPTION'
     */
    const VALUE_CONTENT_HUB_OBJECT_NOT_FOUND_EXCEPTION = 'CONTENT_HUB_OBJECT_NOT_FOUND_EXCEPTION';
    /**
     * Constant for value 'CONTENT_HUB_OPERATION_NOT_SUPPORTED_EXCEPTION'
     * @return string 'CONTENT_HUB_OPERATION_NOT_SUPPORTED_EXCEPTION'
     */
    const VALUE_CONTENT_HUB_OPERATION_NOT_SUPPORTED_EXCEPTION = 'CONTENT_HUB_OPERATION_NOT_SUPPORTED_EXCEPTION';
    /**
     * Constant for value 'CONTENT_HUB_SECURITY_EXCEPTION'
     * @return string 'CONTENT_HUB_SECURITY_EXCEPTION'
     */
    const VALUE_CONTENT_HUB_SECURITY_EXCEPTION = 'CONTENT_HUB_SECURITY_EXCEPTION';
    /**
     * Constant for value 'CONTENT_HUB_TIMEOUT_EXCEPTION'
     * @return string 'CONTENT_HUB_TIMEOUT_EXCEPTION'
     */
    const VALUE_CONTENT_HUB_TIMEOUT_EXCEPTION = 'CONTENT_HUB_TIMEOUT_EXCEPTION';
    /**
     * Constant for value 'CONTENT_HUB_UNEXPECTED_EXCEPTION'
     * @return string 'CONTENT_HUB_UNEXPECTED_EXCEPTION'
     */
    const VALUE_CONTENT_HUB_UNEXPECTED_EXCEPTION = 'CONTENT_HUB_UNEXPECTED_EXCEPTION';
    /**
     * Constant for value 'CONTENT_IMAGE_SCALING_INVALID_ARGUMENTS_EXCEPTION'
     * @return string 'CONTENT_IMAGE_SCALING_INVALID_ARGUMENTS_EXCEPTION'
     */
    const VALUE_CONTENT_IMAGE_SCALING_INVALID_ARGUMENTS_EXCEPTION = 'CONTENT_IMAGE_SCALING_INVALID_ARGUMENTS_EXCEPTION';
    /**
     * Constant for value 'CONTENT_IMAGE_SCALING_INVALID_IMAGE_EXCEPTION'
     * @return string 'CONTENT_IMAGE_SCALING_INVALID_IMAGE_EXCEPTION'
     */
    const VALUE_CONTENT_IMAGE_SCALING_INVALID_IMAGE_EXCEPTION = 'CONTENT_IMAGE_SCALING_INVALID_IMAGE_EXCEPTION';
    /**
     * Constant for value 'CONTENT_IMAGE_SCALING_MAX_RENDITIONS_EXCEPTION'
     * @return string 'CONTENT_IMAGE_SCALING_MAX_RENDITIONS_EXCEPTION'
     */
    const VALUE_CONTENT_IMAGE_SCALING_MAX_RENDITIONS_EXCEPTION = 'CONTENT_IMAGE_SCALING_MAX_RENDITIONS_EXCEPTION';
    /**
     * Constant for value 'CONTENT_IMAGE_SCALING_TIMEOUT_EXCEPTION'
     * @return string 'CONTENT_IMAGE_SCALING_TIMEOUT_EXCEPTION'
     */
    const VALUE_CONTENT_IMAGE_SCALING_TIMEOUT_EXCEPTION = 'CONTENT_IMAGE_SCALING_TIMEOUT_EXCEPTION';
    /**
     * Constant for value 'CONTENT_IMAGE_SCALING_UNKNOWN_EXCEPTION'
     * @return string 'CONTENT_IMAGE_SCALING_UNKNOWN_EXCEPTION'
     */
    const VALUE_CONTENT_IMAGE_SCALING_UNKNOWN_EXCEPTION = 'CONTENT_IMAGE_SCALING_UNKNOWN_EXCEPTION';
    /**
     * Constant for value 'CUSTOM_METADATA_LIMIT_EXCEEDED'
     * @return string 'CUSTOM_METADATA_LIMIT_EXCEEDED'
     */
    const VALUE_CUSTOM_METADATA_LIMIT_EXCEEDED = 'CUSTOM_METADATA_LIMIT_EXCEEDED';
    /**
     * Constant for value 'CUSTOM_SETTINGS_LIMIT_EXCEEDED'
     * @return string 'CUSTOM_SETTINGS_LIMIT_EXCEEDED'
     */
    const VALUE_CUSTOM_SETTINGS_LIMIT_EXCEEDED = 'CUSTOM_SETTINGS_LIMIT_EXCEEDED';
    /**
     * Constant for value 'DATACLOUD_API_CLIENT_EXCEPTION'
     * @return string 'DATACLOUD_API_CLIENT_EXCEPTION'
     */
    const VALUE_DATACLOUD_API_CLIENT_EXCEPTION = 'DATACLOUD_API_CLIENT_EXCEPTION';
    /**
     * Constant for value 'DATACLOUD_API_DISABLED_EXCEPTION'
     * @return string 'DATACLOUD_API_DISABLED_EXCEPTION'
     */
    const VALUE_DATACLOUD_API_DISABLED_EXCEPTION = 'DATACLOUD_API_DISABLED_EXCEPTION';
    /**
     * Constant for value 'DATACLOUD_API_INVALID_QUERY_EXCEPTION'
     * @return string 'DATACLOUD_API_INVALID_QUERY_EXCEPTION'
     */
    const VALUE_DATACLOUD_API_INVALID_QUERY_EXCEPTION = 'DATACLOUD_API_INVALID_QUERY_EXCEPTION';
    /**
     * Constant for value 'DATACLOUD_API_SERVER_BUSY_EXCEPTION'
     * @return string 'DATACLOUD_API_SERVER_BUSY_EXCEPTION'
     */
    const VALUE_DATACLOUD_API_SERVER_BUSY_EXCEPTION = 'DATACLOUD_API_SERVER_BUSY_EXCEPTION';
    /**
     * Constant for value 'DATACLOUD_API_SERVER_EXCEPTION'
     * @return string 'DATACLOUD_API_SERVER_EXCEPTION'
     */
    const VALUE_DATACLOUD_API_SERVER_EXCEPTION = 'DATACLOUD_API_SERVER_EXCEPTION';
    /**
     * Constant for value 'DATACLOUD_API_TIMEOUT_EXCEPTION'
     * @return string 'DATACLOUD_API_TIMEOUT_EXCEPTION'
     */
    const VALUE_DATACLOUD_API_TIMEOUT_EXCEPTION = 'DATACLOUD_API_TIMEOUT_EXCEPTION';
    /**
     * Constant for value 'DATACLOUD_API_UNAVAILABLE'
     * @return string 'DATACLOUD_API_UNAVAILABLE'
     */
    const VALUE_DATACLOUD_API_UNAVAILABLE = 'DATACLOUD_API_UNAVAILABLE';
    /**
     * Constant for value 'DATA_INTEGRATION_INPUT_ERROR'
     * @return string 'DATA_INTEGRATION_INPUT_ERROR'
     */
    const VALUE_DATA_INTEGRATION_INPUT_ERROR = 'DATA_INTEGRATION_INPUT_ERROR';
    /**
     * Constant for value 'DATA_INTEGRATION_NOT_FOUND'
     * @return string 'DATA_INTEGRATION_NOT_FOUND'
     */
    const VALUE_DATA_INTEGRATION_NOT_FOUND = 'DATA_INTEGRATION_NOT_FOUND';
    /**
     * Constant for value 'DATA_INTEGRATION_NO_ACCESS'
     * @return string 'DATA_INTEGRATION_NO_ACCESS'
     */
    const VALUE_DATA_INTEGRATION_NO_ACCESS = 'DATA_INTEGRATION_NO_ACCESS';
    /**
     * Constant for value 'DATA_INTEGRATION_PACKAGE_ERROR'
     * @return string 'DATA_INTEGRATION_PACKAGE_ERROR'
     */
    const VALUE_DATA_INTEGRATION_PACKAGE_ERROR = 'DATA_INTEGRATION_PACKAGE_ERROR';
    /**
     * Constant for value 'DATA_INTEGRATION_SERVER_ERROR'
     * @return string 'DATA_INTEGRATION_SERVER_ERROR'
     */
    const VALUE_DATA_INTEGRATION_SERVER_ERROR = 'DATA_INTEGRATION_SERVER_ERROR';
    /**
     * Constant for value 'DATA_INTEGRATION_VENDOR_SETUP_ERROR'
     * @return string 'DATA_INTEGRATION_VENDOR_SETUP_ERROR'
     */
    const VALUE_DATA_INTEGRATION_VENDOR_SETUP_ERROR = 'DATA_INTEGRATION_VENDOR_SETUP_ERROR';
    /**
     * Constant for value 'DUPLICATE_ARGUMENT_VALUE'
     * @return string 'DUPLICATE_ARGUMENT_VALUE'
     */
    const VALUE_DUPLICATE_ARGUMENT_VALUE = 'DUPLICATE_ARGUMENT_VALUE';
    /**
     * Constant for value 'DUPLICATE_VALUE'
     * @return string 'DUPLICATE_VALUE'
     */
    const VALUE_DUPLICATE_VALUE = 'DUPLICATE_VALUE';
    /**
     * Constant for value 'EMAIL_BATCH_SIZE_LIMIT_EXCEEDED'
     * @return string 'EMAIL_BATCH_SIZE_LIMIT_EXCEEDED'
     */
    const VALUE_EMAIL_BATCH_SIZE_LIMIT_EXCEEDED = 'EMAIL_BATCH_SIZE_LIMIT_EXCEEDED';
    /**
     * Constant for value 'EMAIL_TO_CASE_INVALID_ROUTING'
     * @return string 'EMAIL_TO_CASE_INVALID_ROUTING'
     */
    const VALUE_EMAIL_TO_CASE_INVALID_ROUTING = 'EMAIL_TO_CASE_INVALID_ROUTING';
    /**
     * Constant for value 'EMAIL_TO_CASE_LIMIT_EXCEEDED'
     * @return string 'EMAIL_TO_CASE_LIMIT_EXCEEDED'
     */
    const VALUE_EMAIL_TO_CASE_LIMIT_EXCEEDED = 'EMAIL_TO_CASE_LIMIT_EXCEEDED';
    /**
     * Constant for value 'EMAIL_TO_CASE_NOT_ENABLED'
     * @return string 'EMAIL_TO_CASE_NOT_ENABLED'
     */
    const VALUE_EMAIL_TO_CASE_NOT_ENABLED = 'EMAIL_TO_CASE_NOT_ENABLED';
    /**
     * Constant for value 'ENTITY_NOT_QUERYABLE'
     * @return string 'ENTITY_NOT_QUERYABLE'
     */
    const VALUE_ENTITY_NOT_QUERYABLE = 'ENTITY_NOT_QUERYABLE';
    /**
     * Constant for value 'ENVIRONMENT_HUB_MEMBERSHIP_CONFLICT'
     * @return string 'ENVIRONMENT_HUB_MEMBERSHIP_CONFLICT'
     */
    const VALUE_ENVIRONMENT_HUB_MEMBERSHIP_CONFLICT = 'ENVIRONMENT_HUB_MEMBERSHIP_CONFLICT';
    /**
     * Constant for value 'EXCEEDED_ID_LIMIT'
     * @return string 'EXCEEDED_ID_LIMIT'
     */
    const VALUE_EXCEEDED_ID_LIMIT = 'EXCEEDED_ID_LIMIT';
    /**
     * Constant for value 'EXCEEDED_LEAD_CONVERT_LIMIT'
     * @return string 'EXCEEDED_LEAD_CONVERT_LIMIT'
     */
    const VALUE_EXCEEDED_LEAD_CONVERT_LIMIT = 'EXCEEDED_LEAD_CONVERT_LIMIT';
    /**
     * Constant for value 'EXCEEDED_MAX_FILTER_ENTITIES'
     * @return string 'EXCEEDED_MAX_FILTER_ENTITIES'
     */
    const VALUE_EXCEEDED_MAX_FILTER_ENTITIES = 'EXCEEDED_MAX_FILTER_ENTITIES';
    /**
     * Constant for value 'EXCEEDED_MAX_SIZE_REQUEST'
     * @return string 'EXCEEDED_MAX_SIZE_REQUEST'
     */
    const VALUE_EXCEEDED_MAX_SIZE_REQUEST = 'EXCEEDED_MAX_SIZE_REQUEST';
    /**
     * Constant for value 'EXCEEDED_MAX_SOBJECTS'
     * @return string 'EXCEEDED_MAX_SOBJECTS'
     */
    const VALUE_EXCEEDED_MAX_SOBJECTS = 'EXCEEDED_MAX_SOBJECTS';
    /**
     * Constant for value 'EXCEEDED_MAX_TYPES_LIMIT'
     * @return string 'EXCEEDED_MAX_TYPES_LIMIT'
     */
    const VALUE_EXCEEDED_MAX_TYPES_LIMIT = 'EXCEEDED_MAX_TYPES_LIMIT';
    /**
     * Constant for value 'EXCEEDED_QUOTA'
     * @return string 'EXCEEDED_QUOTA'
     */
    const VALUE_EXCEEDED_QUOTA = 'EXCEEDED_QUOTA';
    /**
     * Constant for value 'EXTERNAL_OBJECT_AUTHENTICATION_EXCEPTION'
     * @return string 'EXTERNAL_OBJECT_AUTHENTICATION_EXCEPTION'
     */
    const VALUE_EXTERNAL_OBJECT_AUTHENTICATION_EXCEPTION = 'EXTERNAL_OBJECT_AUTHENTICATION_EXCEPTION';
    /**
     * Constant for value 'EXTERNAL_OBJECT_CONNECTION_EXCEPTION'
     * @return string 'EXTERNAL_OBJECT_CONNECTION_EXCEPTION'
     */
    const VALUE_EXTERNAL_OBJECT_CONNECTION_EXCEPTION = 'EXTERNAL_OBJECT_CONNECTION_EXCEPTION';
    /**
     * Constant for value 'EXTERNAL_OBJECT_EXCEPTION'
     * @return string 'EXTERNAL_OBJECT_EXCEPTION'
     */
    const VALUE_EXTERNAL_OBJECT_EXCEPTION = 'EXTERNAL_OBJECT_EXCEPTION';
    /**
     * Constant for value 'EXTERNAL_OBJECT_UNSUPPORTED_EXCEPTION'
     * @return string 'EXTERNAL_OBJECT_UNSUPPORTED_EXCEPTION'
     */
    const VALUE_EXTERNAL_OBJECT_UNSUPPORTED_EXCEPTION = 'EXTERNAL_OBJECT_UNSUPPORTED_EXCEPTION';
    /**
     * Constant for value 'FEDERATED_SEARCH_ERROR'
     * @return string 'FEDERATED_SEARCH_ERROR'
     */
    const VALUE_FEDERATED_SEARCH_ERROR = 'FEDERATED_SEARCH_ERROR';
    /**
     * Constant for value 'FEED_NOT_ENABLED_FOR_OBJECT'
     * @return string 'FEED_NOT_ENABLED_FOR_OBJECT'
     */
    const VALUE_FEED_NOT_ENABLED_FOR_OBJECT = 'FEED_NOT_ENABLED_FOR_OBJECT';
    /**
     * Constant for value 'FUNCTIONALITY_NOT_ENABLED'
     * @return string 'FUNCTIONALITY_NOT_ENABLED'
     */
    const VALUE_FUNCTIONALITY_NOT_ENABLED = 'FUNCTIONALITY_NOT_ENABLED';
    /**
     * Constant for value 'FUNCTIONALITY_TEMPORARILY_UNAVAILABLE'
     * @return string 'FUNCTIONALITY_TEMPORARILY_UNAVAILABLE'
     */
    const VALUE_FUNCTIONALITY_TEMPORARILY_UNAVAILABLE = 'FUNCTIONALITY_TEMPORARILY_UNAVAILABLE';
    /**
     * Constant for value 'ID_REQUIRED'
     * @return string 'ID_REQUIRED'
     */
    const VALUE_ID_REQUIRED = 'ID_REQUIRED';
    /**
     * Constant for value 'ILLEGAL_QUERY_PARAMETER_VALUE'
     * @return string 'ILLEGAL_QUERY_PARAMETER_VALUE'
     */
    const VALUE_ILLEGAL_QUERY_PARAMETER_VALUE = 'ILLEGAL_QUERY_PARAMETER_VALUE';
    /**
     * Constant for value 'INACTIVE_OWNER_OR_USER'
     * @return string 'INACTIVE_OWNER_OR_USER'
     */
    const VALUE_INACTIVE_OWNER_OR_USER = 'INACTIVE_OWNER_OR_USER';
    /**
     * Constant for value 'INACTIVE_PORTAL'
     * @return string 'INACTIVE_PORTAL'
     */
    const VALUE_INACTIVE_PORTAL = 'INACTIVE_PORTAL';
    /**
     * Constant for value 'INSERT_UPDATE_DELETE_NOT_ALLOWED_DURING_MAINTENANCE'
     * @return string 'INSERT_UPDATE_DELETE_NOT_ALLOWED_DURING_MAINTENANCE'
     */
    const VALUE_INSERT_UPDATE_DELETE_NOT_ALLOWED_DURING_MAINTENANCE = 'INSERT_UPDATE_DELETE_NOT_ALLOWED_DURING_MAINTENANCE';
    /**
     * Constant for value 'INSTALL_KEY_INVALID'
     * @return string 'INSTALL_KEY_INVALID'
     */
    const VALUE_INSTALL_KEY_INVALID = 'INSTALL_KEY_INVALID';
    /**
     * Constant for value 'INSTALL_KEY_REQUIRED'
     * @return string 'INSTALL_KEY_REQUIRED'
     */
    const VALUE_INSTALL_KEY_REQUIRED = 'INSTALL_KEY_REQUIRED';
    /**
     * Constant for value 'INSUFFICIENT_ACCESS'
     * @return string 'INSUFFICIENT_ACCESS'
     */
    const VALUE_INSUFFICIENT_ACCESS = 'INSUFFICIENT_ACCESS';
    /**
     * Constant for value 'INSUFFICIENT_ACCESS_APEX_METADATA_DEPLOY'
     * @return string 'INSUFFICIENT_ACCESS_APEX_METADATA_DEPLOY'
     */
    const VALUE_INSUFFICIENT_ACCESS_APEX_METADATA_DEPLOY = 'INSUFFICIENT_ACCESS_APEX_METADATA_DEPLOY';
    /**
     * Constant for value 'INTERNAL_CANVAS_ERROR'
     * @return string 'INTERNAL_CANVAS_ERROR'
     */
    const VALUE_INTERNAL_CANVAS_ERROR = 'INTERNAL_CANVAS_ERROR';
    /**
     * Constant for value 'INVALID_ASSIGNMENT_RULE'
     * @return string 'INVALID_ASSIGNMENT_RULE'
     */
    const VALUE_INVALID_ASSIGNMENT_RULE = 'INVALID_ASSIGNMENT_RULE';
    /**
     * Constant for value 'INVALID_AUTH_HEADER'
     * @return string 'INVALID_AUTH_HEADER'
     */
    const VALUE_INVALID_AUTH_HEADER = 'INVALID_AUTH_HEADER';
    /**
     * Constant for value 'INVALID_BATCH_REQUEST'
     * @return string 'INVALID_BATCH_REQUEST'
     */
    const VALUE_INVALID_BATCH_REQUEST = 'INVALID_BATCH_REQUEST';
    /**
     * Constant for value 'INVALID_BATCH_SIZE'
     * @return string 'INVALID_BATCH_SIZE'
     */
    const VALUE_INVALID_BATCH_SIZE = 'INVALID_BATCH_SIZE';
    /**
     * Constant for value 'INVALID_CLIENT'
     * @return string 'INVALID_CLIENT'
     */
    const VALUE_INVALID_CLIENT = 'INVALID_CLIENT';
    /**
     * Constant for value 'INVALID_CROSS_REFERENCE_KEY'
     * @return string 'INVALID_CROSS_REFERENCE_KEY'
     */
    const VALUE_INVALID_CROSS_REFERENCE_KEY = 'INVALID_CROSS_REFERENCE_KEY';
    /**
     * Constant for value 'INVALID_DATE_FORMAT'
     * @return string 'INVALID_DATE_FORMAT'
     */
    const VALUE_INVALID_DATE_FORMAT = 'INVALID_DATE_FORMAT';
    /**
     * Constant for value 'INVALID_FIELD'
     * @return string 'INVALID_FIELD'
     */
    const VALUE_INVALID_FIELD = 'INVALID_FIELD';
    /**
     * Constant for value 'INVALID_FILTER_LANGUAGE'
     * @return string 'INVALID_FILTER_LANGUAGE'
     */
    const VALUE_INVALID_FILTER_LANGUAGE = 'INVALID_FILTER_LANGUAGE';
    /**
     * Constant for value 'INVALID_FILTER_VALUE'
     * @return string 'INVALID_FILTER_VALUE'
     */
    const VALUE_INVALID_FILTER_VALUE = 'INVALID_FILTER_VALUE';
    /**
     * Constant for value 'INVALID_ID_FIELD'
     * @return string 'INVALID_ID_FIELD'
     */
    const VALUE_INVALID_ID_FIELD = 'INVALID_ID_FIELD';
    /**
     * Constant for value 'INVALID_INPUT_COMBINATION'
     * @return string 'INVALID_INPUT_COMBINATION'
     */
    const VALUE_INVALID_INPUT_COMBINATION = 'INVALID_INPUT_COMBINATION';
    /**
     * Constant for value 'INVALID_LOCALE_LANGUAGE'
     * @return string 'INVALID_LOCALE_LANGUAGE'
     */
    const VALUE_INVALID_LOCALE_LANGUAGE = 'INVALID_LOCALE_LANGUAGE';
    /**
     * Constant for value 'INVALID_LOCATOR'
     * @return string 'INVALID_LOCATOR'
     */
    const VALUE_INVALID_LOCATOR = 'INVALID_LOCATOR';
    /**
     * Constant for value 'INVALID_LOGIN'
     * @return string 'INVALID_LOGIN'
     */
    const VALUE_INVALID_LOGIN = 'INVALID_LOGIN';
    /**
     * Constant for value 'INVALID_MULTIPART_REQUEST'
     * @return string 'INVALID_MULTIPART_REQUEST'
     */
    const VALUE_INVALID_MULTIPART_REQUEST = 'INVALID_MULTIPART_REQUEST';
    /**
     * Constant for value 'INVALID_NEW_PASSWORD'
     * @return string 'INVALID_NEW_PASSWORD'
     */
    const VALUE_INVALID_NEW_PASSWORD = 'INVALID_NEW_PASSWORD';
    /**
     * Constant for value 'INVALID_OLD_PASSWORD'
     * @return string 'INVALID_OLD_PASSWORD'
     */
    const VALUE_INVALID_OLD_PASSWORD = 'INVALID_OLD_PASSWORD';
    /**
     * Constant for value 'INVALID_OPERATION'
     * @return string 'INVALID_OPERATION'
     */
    const VALUE_INVALID_OPERATION = 'INVALID_OPERATION';
    /**
     * Constant for value 'INVALID_OPERATION_WITH_EXPIRED_PASSWORD'
     * @return string 'INVALID_OPERATION_WITH_EXPIRED_PASSWORD'
     */
    const VALUE_INVALID_OPERATION_WITH_EXPIRED_PASSWORD = 'INVALID_OPERATION_WITH_EXPIRED_PASSWORD';
    /**
     * Constant for value 'INVALID_PACKAGE_VERSION'
     * @return string 'INVALID_PACKAGE_VERSION'
     */
    const VALUE_INVALID_PACKAGE_VERSION = 'INVALID_PACKAGE_VERSION';
    /**
     * Constant for value 'INVALID_PAGING_OPTION'
     * @return string 'INVALID_PAGING_OPTION'
     */
    const VALUE_INVALID_PAGING_OPTION = 'INVALID_PAGING_OPTION';
    /**
     * Constant for value 'INVALID_QUERY_FILTER_OPERATOR'
     * @return string 'INVALID_QUERY_FILTER_OPERATOR'
     */
    const VALUE_INVALID_QUERY_FILTER_OPERATOR = 'INVALID_QUERY_FILTER_OPERATOR';
    /**
     * Constant for value 'INVALID_QUERY_KEY'
     * @return string 'INVALID_QUERY_KEY'
     */
    const VALUE_INVALID_QUERY_KEY = 'INVALID_QUERY_KEY';
    /**
     * Constant for value 'INVALID_QUERY_LOCATOR'
     * @return string 'INVALID_QUERY_LOCATOR'
     */
    const VALUE_INVALID_QUERY_LOCATOR = 'INVALID_QUERY_LOCATOR';
    /**
     * Constant for value 'INVALID_QUERY_SCOPE'
     * @return string 'INVALID_QUERY_SCOPE'
     */
    const VALUE_INVALID_QUERY_SCOPE = 'INVALID_QUERY_SCOPE';
    /**
     * Constant for value 'INVALID_QUERY_VALUE'
     * @return string 'INVALID_QUERY_VALUE'
     */
    const VALUE_INVALID_QUERY_VALUE = 'INVALID_QUERY_VALUE';
    /**
     * Constant for value 'INVALID_REPLICATION_DATE'
     * @return string 'INVALID_REPLICATION_DATE'
     */
    const VALUE_INVALID_REPLICATION_DATE = 'INVALID_REPLICATION_DATE';
    /**
     * Constant for value 'INVALID_SEARCH'
     * @return string 'INVALID_SEARCH'
     */
    const VALUE_INVALID_SEARCH = 'INVALID_SEARCH';
    /**
     * Constant for value 'INVALID_SEARCH_SCOPE'
     * @return string 'INVALID_SEARCH_SCOPE'
     */
    const VALUE_INVALID_SEARCH_SCOPE = 'INVALID_SEARCH_SCOPE';
    /**
     * Constant for value 'INVALID_SESSION_ID'
     * @return string 'INVALID_SESSION_ID'
     */
    const VALUE_INVALID_SESSION_ID = 'INVALID_SESSION_ID';
    /**
     * Constant for value 'INVALID_SOAP_HEADER'
     * @return string 'INVALID_SOAP_HEADER'
     */
    const VALUE_INVALID_SOAP_HEADER = 'INVALID_SOAP_HEADER';
    /**
     * Constant for value 'INVALID_SORT_OPTION'
     * @return string 'INVALID_SORT_OPTION'
     */
    const VALUE_INVALID_SORT_OPTION = 'INVALID_SORT_OPTION';
    /**
     * Constant for value 'INVALID_SSO_GATEWAY_URL'
     * @return string 'INVALID_SSO_GATEWAY_URL'
     */
    const VALUE_INVALID_SSO_GATEWAY_URL = 'INVALID_SSO_GATEWAY_URL';
    /**
     * Constant for value 'INVALID_TYPE'
     * @return string 'INVALID_TYPE'
     */
    const VALUE_INVALID_TYPE = 'INVALID_TYPE';
    /**
     * Constant for value 'INVALID_TYPE_FOR_OPERATION'
     * @return string 'INVALID_TYPE_FOR_OPERATION'
     */
    const VALUE_INVALID_TYPE_FOR_OPERATION = 'INVALID_TYPE_FOR_OPERATION';
    /**
     * Constant for value 'JIGSAW_ACTION_DISABLED'
     * @return string 'JIGSAW_ACTION_DISABLED'
     */
    const VALUE_JIGSAW_ACTION_DISABLED = 'JIGSAW_ACTION_DISABLED';
    /**
     * Constant for value 'JIGSAW_IMPORT_LIMIT_EXCEEDED'
     * @return string 'JIGSAW_IMPORT_LIMIT_EXCEEDED'
     */
    const VALUE_JIGSAW_IMPORT_LIMIT_EXCEEDED = 'JIGSAW_IMPORT_LIMIT_EXCEEDED';
    /**
     * Constant for value 'JIGSAW_REQUEST_NOT_SUPPORTED'
     * @return string 'JIGSAW_REQUEST_NOT_SUPPORTED'
     */
    const VALUE_JIGSAW_REQUEST_NOT_SUPPORTED = 'JIGSAW_REQUEST_NOT_SUPPORTED';
    /**
     * Constant for value 'JSON_PARSER_ERROR'
     * @return string 'JSON_PARSER_ERROR'
     */
    const VALUE_JSON_PARSER_ERROR = 'JSON_PARSER_ERROR';
    /**
     * Constant for value 'KEY_HAS_BEEN_DESTROYED'
     * @return string 'KEY_HAS_BEEN_DESTROYED'
     */
    const VALUE_KEY_HAS_BEEN_DESTROYED = 'KEY_HAS_BEEN_DESTROYED';
    /**
     * Constant for value 'LICENSING_DATA_ERROR'
     * @return string 'LICENSING_DATA_ERROR'
     */
    const VALUE_LICENSING_DATA_ERROR = 'LICENSING_DATA_ERROR';
    /**
     * Constant for value 'LICENSING_UNKNOWN_ERROR'
     * @return string 'LICENSING_UNKNOWN_ERROR'
     */
    const VALUE_LICENSING_UNKNOWN_ERROR = 'LICENSING_UNKNOWN_ERROR';
    /**
     * Constant for value 'LIMIT_EXCEEDED'
     * @return string 'LIMIT_EXCEEDED'
     */
    const VALUE_LIMIT_EXCEEDED = 'LIMIT_EXCEEDED';
    /**
     * Constant for value 'LOGIN_CHALLENGE_ISSUED'
     * @return string 'LOGIN_CHALLENGE_ISSUED'
     */
    const VALUE_LOGIN_CHALLENGE_ISSUED = 'LOGIN_CHALLENGE_ISSUED';
    /**
     * Constant for value 'LOGIN_CHALLENGE_PENDING'
     * @return string 'LOGIN_CHALLENGE_PENDING'
     */
    const VALUE_LOGIN_CHALLENGE_PENDING = 'LOGIN_CHALLENGE_PENDING';
    /**
     * Constant for value 'LOGIN_DURING_RESTRICTED_DOMAIN'
     * @return string 'LOGIN_DURING_RESTRICTED_DOMAIN'
     */
    const VALUE_LOGIN_DURING_RESTRICTED_DOMAIN = 'LOGIN_DURING_RESTRICTED_DOMAIN';
    /**
     * Constant for value 'LOGIN_DURING_RESTRICTED_TIME'
     * @return string 'LOGIN_DURING_RESTRICTED_TIME'
     */
    const VALUE_LOGIN_DURING_RESTRICTED_TIME = 'LOGIN_DURING_RESTRICTED_TIME';
    /**
     * Constant for value 'LOGIN_MUST_USE_SECURITY_TOKEN'
     * @return string 'LOGIN_MUST_USE_SECURITY_TOKEN'
     */
    const VALUE_LOGIN_MUST_USE_SECURITY_TOKEN = 'LOGIN_MUST_USE_SECURITY_TOKEN';
    /**
     * Constant for value 'MALFORMED_ID'
     * @return string 'MALFORMED_ID'
     */
    const VALUE_MALFORMED_ID = 'MALFORMED_ID';
    /**
     * Constant for value 'MALFORMED_QUERY'
     * @return string 'MALFORMED_QUERY'
     */
    const VALUE_MALFORMED_QUERY = 'MALFORMED_QUERY';
    /**
     * Constant for value 'MALFORMED_SEARCH'
     * @return string 'MALFORMED_SEARCH'
     */
    const VALUE_MALFORMED_SEARCH = 'MALFORMED_SEARCH';
    /**
     * Constant for value 'MISMATCHING_VERSIONS'
     * @return string 'MISMATCHING_VERSIONS'
     */
    const VALUE_MISMATCHING_VERSIONS = 'MISMATCHING_VERSIONS';
    /**
     * Constant for value 'MISSING_ARGUMENT'
     * @return string 'MISSING_ARGUMENT'
     */
    const VALUE_MISSING_ARGUMENT = 'MISSING_ARGUMENT';
    /**
     * Constant for value 'MISSING_RECORD'
     * @return string 'MISSING_RECORD'
     */
    const VALUE_MISSING_RECORD = 'MISSING_RECORD';
    /**
     * Constant for value 'MODIFIED'
     * @return string 'MODIFIED'
     */
    const VALUE_MODIFIED = 'MODIFIED';
    /**
     * Constant for value 'MULTIPLE_RECORDS_FOUND'
     * @return string 'MULTIPLE_RECORDS_FOUND'
     */
    const VALUE_MULTIPLE_RECORDS_FOUND = 'MULTIPLE_RECORDS_FOUND';
    /**
     * Constant for value 'MUTUAL_AUTHENTICATION_FAILED'
     * @return string 'MUTUAL_AUTHENTICATION_FAILED'
     */
    const VALUE_MUTUAL_AUTHENTICATION_FAILED = 'MUTUAL_AUTHENTICATION_FAILED';
    /**
     * Constant for value 'NOT_ACCEPTABLE'
     * @return string 'NOT_ACCEPTABLE'
     */
    const VALUE_NOT_ACCEPTABLE = 'NOT_ACCEPTABLE';
    /**
     * Constant for value 'NOT_MODIFIED'
     * @return string 'NOT_MODIFIED'
     */
    const VALUE_NOT_MODIFIED = 'NOT_MODIFIED';
    /**
     * Constant for value 'NO_ACTIVE_DUPLICATE_RULE'
     * @return string 'NO_ACTIVE_DUPLICATE_RULE'
     */
    const VALUE_NO_ACTIVE_DUPLICATE_RULE = 'NO_ACTIVE_DUPLICATE_RULE';
    /**
     * Constant for value 'NO_RECIPIENTS'
     * @return string 'NO_RECIPIENTS'
     */
    const VALUE_NO_RECIPIENTS = 'NO_RECIPIENTS';
    /**
     * Constant for value 'NO_SOFTPHONE_LAYOUT'
     * @return string 'NO_SOFTPHONE_LAYOUT'
     */
    const VALUE_NO_SOFTPHONE_LAYOUT = 'NO_SOFTPHONE_LAYOUT';
    /**
     * Constant for value 'NUMBER_OUTSIDE_VALID_RANGE'
     * @return string 'NUMBER_OUTSIDE_VALID_RANGE'
     */
    const VALUE_NUMBER_OUTSIDE_VALID_RANGE = 'NUMBER_OUTSIDE_VALID_RANGE';
    /**
     * Constant for value 'OPERATION_TOO_LARGE'
     * @return string 'OPERATION_TOO_LARGE'
     */
    const VALUE_OPERATION_TOO_LARGE = 'OPERATION_TOO_LARGE';
    /**
     * Constant for value 'ORG_IN_MAINTENANCE'
     * @return string 'ORG_IN_MAINTENANCE'
     */
    const VALUE_ORG_IN_MAINTENANCE = 'ORG_IN_MAINTENANCE';
    /**
     * Constant for value 'ORG_IS_DOT_ORG'
     * @return string 'ORG_IS_DOT_ORG'
     */
    const VALUE_ORG_IS_DOT_ORG = 'ORG_IS_DOT_ORG';
    /**
     * Constant for value 'ORG_IS_SIGNING_UP'
     * @return string 'ORG_IS_SIGNING_UP'
     */
    const VALUE_ORG_IS_SIGNING_UP = 'ORG_IS_SIGNING_UP';
    /**
     * Constant for value 'ORG_LOCKED'
     * @return string 'ORG_LOCKED'
     */
    const VALUE_ORG_LOCKED = 'ORG_LOCKED';
    /**
     * Constant for value 'ORG_NOT_OWNED_BY_INSTANCE'
     * @return string 'ORG_NOT_OWNED_BY_INSTANCE'
     */
    const VALUE_ORG_NOT_OWNED_BY_INSTANCE = 'ORG_NOT_OWNED_BY_INSTANCE';
    /**
     * Constant for value 'PASSWORD_LOCKOUT'
     * @return string 'PASSWORD_LOCKOUT'
     */
    const VALUE_PASSWORD_LOCKOUT = 'PASSWORD_LOCKOUT';
    /**
     * Constant for value 'PORTAL_NO_ACCESS'
     * @return string 'PORTAL_NO_ACCESS'
     */
    const VALUE_PORTAL_NO_ACCESS = 'PORTAL_NO_ACCESS';
    /**
     * Constant for value 'POST_BODY_PARSE_ERROR'
     * @return string 'POST_BODY_PARSE_ERROR'
     */
    const VALUE_POST_BODY_PARSE_ERROR = 'POST_BODY_PARSE_ERROR';
    /**
     * Constant for value 'PRODUCT_NOT_FOUND'
     * @return string 'PRODUCT_NOT_FOUND'
     */
    const VALUE_PRODUCT_NOT_FOUND = 'PRODUCT_NOT_FOUND';
    /**
     * Constant for value 'QAT_HETEROGENOUS_CONTEXT_IDS'
     * @return string 'QAT_HETEROGENOUS_CONTEXT_IDS'
     */
    const VALUE_QAT_HETEROGENOUS_CONTEXT_IDS = 'QAT_HETEROGENOUS_CONTEXT_IDS';
    /**
     * Constant for value 'QAT_INVALID_CONTEXT_ID'
     * @return string 'QAT_INVALID_CONTEXT_ID'
     */
    const VALUE_QAT_INVALID_CONTEXT_ID = 'QAT_INVALID_CONTEXT_ID';
    /**
     * Constant for value 'QAT_INVALID_QUICK_ACTION'
     * @return string 'QAT_INVALID_QUICK_ACTION'
     */
    const VALUE_QAT_INVALID_QUICK_ACTION = 'QAT_INVALID_QUICK_ACTION';
    /**
     * Constant for value 'QUERY_TIMEOUT'
     * @return string 'QUERY_TIMEOUT'
     */
    const VALUE_QUERY_TIMEOUT = 'QUERY_TIMEOUT';
    /**
     * Constant for value 'QUERY_TOO_COMPLICATED'
     * @return string 'QUERY_TOO_COMPLICATED'
     */
    const VALUE_QUERY_TOO_COMPLICATED = 'QUERY_TOO_COMPLICATED';
    /**
     * Constant for value 'REALTIME_PROCESSING_TIME_EXCEEDED_LIMIT'
     * @return string 'REALTIME_PROCESSING_TIME_EXCEEDED_LIMIT'
     */
    const VALUE_REALTIME_PROCESSING_TIME_EXCEEDED_LIMIT = 'REALTIME_PROCESSING_TIME_EXCEEDED_LIMIT';
    /**
     * Constant for value 'RECORD_NOT_FOUND'
     * @return string 'RECORD_NOT_FOUND'
     */
    const VALUE_RECORD_NOT_FOUND = 'RECORD_NOT_FOUND';
    /**
     * Constant for value 'REQUEST_LIMIT_EXCEEDED'
     * @return string 'REQUEST_LIMIT_EXCEEDED'
     */
    const VALUE_REQUEST_LIMIT_EXCEEDED = 'REQUEST_LIMIT_EXCEEDED';
    /**
     * Constant for value 'REQUEST_RUNNING_TOO_LONG'
     * @return string 'REQUEST_RUNNING_TOO_LONG'
     */
    const VALUE_REQUEST_RUNNING_TOO_LONG = 'REQUEST_RUNNING_TOO_LONG';
    /**
     * Constant for value 'SERVER_UNAVAILABLE'
     * @return string 'SERVER_UNAVAILABLE'
     */
    const VALUE_SERVER_UNAVAILABLE = 'SERVER_UNAVAILABLE';
    /**
     * Constant for value 'SERVICE_DESK_NOT_ENABLED'
     * @return string 'SERVICE_DESK_NOT_ENABLED'
     */
    const VALUE_SERVICE_DESK_NOT_ENABLED = 'SERVICE_DESK_NOT_ENABLED';
    /**
     * Constant for value 'SOCIALCRM_FEEDSERVICE_API_CLIENT_EXCEPTION'
     * @return string 'SOCIALCRM_FEEDSERVICE_API_CLIENT_EXCEPTION'
     */
    const VALUE_SOCIALCRM_FEEDSERVICE_API_CLIENT_EXCEPTION = 'SOCIALCRM_FEEDSERVICE_API_CLIENT_EXCEPTION';
    /**
     * Constant for value 'SOCIALCRM_FEEDSERVICE_API_SERVER_EXCEPTION'
     * @return string 'SOCIALCRM_FEEDSERVICE_API_SERVER_EXCEPTION'
     */
    const VALUE_SOCIALCRM_FEEDSERVICE_API_SERVER_EXCEPTION = 'SOCIALCRM_FEEDSERVICE_API_SERVER_EXCEPTION';
    /**
     * Constant for value 'SOCIALCRM_FEEDSERVICE_API_UNAVAILABLE'
     * @return string 'SOCIALCRM_FEEDSERVICE_API_UNAVAILABLE'
     */
    const VALUE_SOCIALCRM_FEEDSERVICE_API_UNAVAILABLE = 'SOCIALCRM_FEEDSERVICE_API_UNAVAILABLE';
    /**
     * Constant for value 'SSO_SERVICE_DOWN'
     * @return string 'SSO_SERVICE_DOWN'
     */
    const VALUE_SSO_SERVICE_DOWN = 'SSO_SERVICE_DOWN';
    /**
     * Constant for value 'SST_ADMIN_FILE_DOWNLOAD_EXCEPTION'
     * @return string 'SST_ADMIN_FILE_DOWNLOAD_EXCEPTION'
     */
    const VALUE_SST_ADMIN_FILE_DOWNLOAD_EXCEPTION = 'SST_ADMIN_FILE_DOWNLOAD_EXCEPTION';
    /**
     * Constant for value 'STATE_TRANSITION_NOT_ALLOWED'
     * @return string 'STATE_TRANSITION_NOT_ALLOWED'
     */
    const VALUE_STATE_TRANSITION_NOT_ALLOWED = 'STATE_TRANSITION_NOT_ALLOWED';
    /**
     * Constant for value 'TOO_MANY_APEX_REQUESTS'
     * @return string 'TOO_MANY_APEX_REQUESTS'
     */
    const VALUE_TOO_MANY_APEX_REQUESTS = 'TOO_MANY_APEX_REQUESTS';
    /**
     * Constant for value 'TOO_MANY_JOBS'
     * @return string 'TOO_MANY_JOBS'
     */
    const VALUE_TOO_MANY_JOBS = 'TOO_MANY_JOBS';
    /**
     * Constant for value 'TOO_MANY_RECIPIENTS'
     * @return string 'TOO_MANY_RECIPIENTS'
     */
    const VALUE_TOO_MANY_RECIPIENTS = 'TOO_MANY_RECIPIENTS';
    /**
     * Constant for value 'TOO_MANY_RECORDS'
     * @return string 'TOO_MANY_RECORDS'
     */
    const VALUE_TOO_MANY_RECORDS = 'TOO_MANY_RECORDS';
    /**
     * Constant for value 'TRIAL_EXPIRED'
     * @return string 'TRIAL_EXPIRED'
     */
    const VALUE_TRIAL_EXPIRED = 'TRIAL_EXPIRED';
    /**
     * Constant for value 'TXN_SECURITY_APEX_ERROR'
     * @return string 'TXN_SECURITY_APEX_ERROR'
     */
    const VALUE_TXN_SECURITY_APEX_ERROR = 'TXN_SECURITY_APEX_ERROR';
    /**
     * Constant for value 'TXN_SECURITY_END_A_SESSION'
     * @return string 'TXN_SECURITY_END_A_SESSION'
     */
    const VALUE_TXN_SECURITY_END_A_SESSION = 'TXN_SECURITY_END_A_SESSION';
    /**
     * Constant for value 'TXN_SECURITY_FAIL_CLOSE'
     * @return string 'TXN_SECURITY_FAIL_CLOSE'
     */
    const VALUE_TXN_SECURITY_FAIL_CLOSE = 'TXN_SECURITY_FAIL_CLOSE';
    /**
     * Constant for value 'TXN_SECURITY_METERING_ERROR'
     * @return string 'TXN_SECURITY_METERING_ERROR'
     */
    const VALUE_TXN_SECURITY_METERING_ERROR = 'TXN_SECURITY_METERING_ERROR';
    /**
     * Constant for value 'TXN_SECURITY_NO_ACCESS'
     * @return string 'TXN_SECURITY_NO_ACCESS'
     */
    const VALUE_TXN_SECURITY_NO_ACCESS = 'TXN_SECURITY_NO_ACCESS';
    /**
     * Constant for value 'TXN_SECURITY_RUNTIME_ERROR'
     * @return string 'TXN_SECURITY_RUNTIME_ERROR'
     */
    const VALUE_TXN_SECURITY_RUNTIME_ERROR = 'TXN_SECURITY_RUNTIME_ERROR';
    /**
     * Constant for value 'TXN_SECURITY_TWO_FA_REQUIRED'
     * @return string 'TXN_SECURITY_TWO_FA_REQUIRED'
     */
    const VALUE_TXN_SECURITY_TWO_FA_REQUIRED = 'TXN_SECURITY_TWO_FA_REQUIRED';
    /**
     * Constant for value 'UNABLE_TO_LOCK_ROW'
     * @return string 'UNABLE_TO_LOCK_ROW'
     */
    const VALUE_UNABLE_TO_LOCK_ROW = 'UNABLE_TO_LOCK_ROW';
    /**
     * Constant for value 'UNKNOWN_ATTACHMENT_EXCEPTION'
     * @return string 'UNKNOWN_ATTACHMENT_EXCEPTION'
     */
    const VALUE_UNKNOWN_ATTACHMENT_EXCEPTION = 'UNKNOWN_ATTACHMENT_EXCEPTION';
    /**
     * Constant for value 'UNKNOWN_EXCEPTION'
     * @return string 'UNKNOWN_EXCEPTION'
     */
    const VALUE_UNKNOWN_EXCEPTION = 'UNKNOWN_EXCEPTION';
    /**
     * Constant for value 'UNKNOWN_ORG_SETTING'
     * @return string 'UNKNOWN_ORG_SETTING'
     */
    const VALUE_UNKNOWN_ORG_SETTING = 'UNKNOWN_ORG_SETTING';
    /**
     * Constant for value 'UNSUPPORTED_API_VERSION'
     * @return string 'UNSUPPORTED_API_VERSION'
     */
    const VALUE_UNSUPPORTED_API_VERSION = 'UNSUPPORTED_API_VERSION';
    /**
     * Constant for value 'UNSUPPORTED_ATTACHMENT_ENCODING'
     * @return string 'UNSUPPORTED_ATTACHMENT_ENCODING'
     */
    const VALUE_UNSUPPORTED_ATTACHMENT_ENCODING = 'UNSUPPORTED_ATTACHMENT_ENCODING';
    /**
     * Constant for value 'UNSUPPORTED_CLIENT'
     * @return string 'UNSUPPORTED_CLIENT'
     */
    const VALUE_UNSUPPORTED_CLIENT = 'UNSUPPORTED_CLIENT';
    /**
     * Constant for value 'UNSUPPORTED_MEDIA_TYPE'
     * @return string 'UNSUPPORTED_MEDIA_TYPE'
     */
    const VALUE_UNSUPPORTED_MEDIA_TYPE = 'UNSUPPORTED_MEDIA_TYPE';
    /**
     * Constant for value 'WEBSTORE_NOT_FOUND'
     * @return string 'WEBSTORE_NOT_FOUND'
     */
    const VALUE_WEBSTORE_NOT_FOUND = 'WEBSTORE_NOT_FOUND';
    /**
     * Constant for value 'XML_PARSER_ERROR'
     * @return string 'XML_PARSER_ERROR'
     */
    const VALUE_XML_PARSER_ERROR = 'XML_PARSER_ERROR';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_APEX_REST_SERVICES_DISABLED
     * @uses self::VALUE_APEX_TRIGGER_COUPLING_LIMIT
     * @uses self::VALUE_API_CURRENTLY_DISABLED
     * @uses self::VALUE_API_DISABLED_FOR_ORG
     * @uses self::VALUE_ARGUMENT_OBJECT_PARSE_ERROR
     * @uses self::VALUE_ASYNC_OPERATION_LOCATOR
     * @uses self::VALUE_ASYNC_QUERY_UNSUPPORTED_QUERY
     * @uses self::VALUE_BATCH_PROCESSING_HALTED
     * @uses self::VALUE_BIG_OBJECT_UNSUPPORTED_OPERATION
     * @uses self::VALUE_CANNOT_DELETE_ENTITY
     * @uses self::VALUE_CANNOT_DELETE_OWNER
     * @uses self::VALUE_CANT_ADD_STANDADRD_PORTAL_USER_TO_TERRITORY
     * @uses self::VALUE_CANT_ADD_STANDARD_PORTAL_USER_TO_TERRITORY
     * @uses self::VALUE_CATEGORY_NOT_FOUND
     * @uses self::VALUE_CIRCULAR_OBJECT_GRAPH
     * @uses self::VALUE_CLIENT_NOT_ACCESSIBLE_FOR_USER
     * @uses self::VALUE_CLIENT_REQUIRE_UPDATE_FOR_USER
     * @uses self::VALUE_CONTENT_ALREADY_AN_ASSET_EXCEPTION
     * @uses self::VALUE_CONTENT_CUSTOM_DOWNLOAD_EXCEPTION
     * @uses self::VALUE_CONTENT_HUB_AUTHENTICATION_EXCEPTION
     * @uses self::VALUE_CONTENT_HUB_FILE_DOWNLOAD_EXCEPTION
     * @uses self::VALUE_CONTENT_HUB_FILE_HAS_NO_URL_EXCEPTION
     * @uses self::VALUE_CONTENT_HUB_FILE_NOT_FOUND_EXCEPTION
     * @uses self::VALUE_CONTENT_HUB_INVALID_OBJECT_TYPE_EXCEPTION
     * @uses self::VALUE_CONTENT_HUB_INVALID_PAGE_NUMBER_EXCEPTION
     * @uses self::VALUE_CONTENT_HUB_INVALID_PAYLOAD
     * @uses self::VALUE_CONTENT_HUB_INVALID_RENDITION_PAGE_NUMBER_EXCEPTION
     * @uses self::VALUE_CONTENT_HUB_ITEM_TYPE_NOT_FOUND_EXCEPTION
     * @uses self::VALUE_CONTENT_HUB_OBJECT_NOT_FOUND_EXCEPTION
     * @uses self::VALUE_CONTENT_HUB_OPERATION_NOT_SUPPORTED_EXCEPTION
     * @uses self::VALUE_CONTENT_HUB_SECURITY_EXCEPTION
     * @uses self::VALUE_CONTENT_HUB_TIMEOUT_EXCEPTION
     * @uses self::VALUE_CONTENT_HUB_UNEXPECTED_EXCEPTION
     * @uses self::VALUE_CONTENT_IMAGE_SCALING_INVALID_ARGUMENTS_EXCEPTION
     * @uses self::VALUE_CONTENT_IMAGE_SCALING_INVALID_IMAGE_EXCEPTION
     * @uses self::VALUE_CONTENT_IMAGE_SCALING_MAX_RENDITIONS_EXCEPTION
     * @uses self::VALUE_CONTENT_IMAGE_SCALING_TIMEOUT_EXCEPTION
     * @uses self::VALUE_CONTENT_IMAGE_SCALING_UNKNOWN_EXCEPTION
     * @uses self::VALUE_CUSTOM_METADATA_LIMIT_EXCEEDED
     * @uses self::VALUE_CUSTOM_SETTINGS_LIMIT_EXCEEDED
     * @uses self::VALUE_DATACLOUD_API_CLIENT_EXCEPTION
     * @uses self::VALUE_DATACLOUD_API_DISABLED_EXCEPTION
     * @uses self::VALUE_DATACLOUD_API_INVALID_QUERY_EXCEPTION
     * @uses self::VALUE_DATACLOUD_API_SERVER_BUSY_EXCEPTION
     * @uses self::VALUE_DATACLOUD_API_SERVER_EXCEPTION
     * @uses self::VALUE_DATACLOUD_API_TIMEOUT_EXCEPTION
     * @uses self::VALUE_DATACLOUD_API_UNAVAILABLE
     * @uses self::VALUE_DATA_INTEGRATION_INPUT_ERROR
     * @uses self::VALUE_DATA_INTEGRATION_NOT_FOUND
     * @uses self::VALUE_DATA_INTEGRATION_NO_ACCESS
     * @uses self::VALUE_DATA_INTEGRATION_PACKAGE_ERROR
     * @uses self::VALUE_DATA_INTEGRATION_SERVER_ERROR
     * @uses self::VALUE_DATA_INTEGRATION_VENDOR_SETUP_ERROR
     * @uses self::VALUE_DUPLICATE_ARGUMENT_VALUE
     * @uses self::VALUE_DUPLICATE_VALUE
     * @uses self::VALUE_EMAIL_BATCH_SIZE_LIMIT_EXCEEDED
     * @uses self::VALUE_EMAIL_TO_CASE_INVALID_ROUTING
     * @uses self::VALUE_EMAIL_TO_CASE_LIMIT_EXCEEDED
     * @uses self::VALUE_EMAIL_TO_CASE_NOT_ENABLED
     * @uses self::VALUE_ENTITY_NOT_QUERYABLE
     * @uses self::VALUE_ENVIRONMENT_HUB_MEMBERSHIP_CONFLICT
     * @uses self::VALUE_EXCEEDED_ID_LIMIT
     * @uses self::VALUE_EXCEEDED_LEAD_CONVERT_LIMIT
     * @uses self::VALUE_EXCEEDED_MAX_FILTER_ENTITIES
     * @uses self::VALUE_EXCEEDED_MAX_SIZE_REQUEST
     * @uses self::VALUE_EXCEEDED_MAX_SOBJECTS
     * @uses self::VALUE_EXCEEDED_MAX_TYPES_LIMIT
     * @uses self::VALUE_EXCEEDED_QUOTA
     * @uses self::VALUE_EXTERNAL_OBJECT_AUTHENTICATION_EXCEPTION
     * @uses self::VALUE_EXTERNAL_OBJECT_CONNECTION_EXCEPTION
     * @uses self::VALUE_EXTERNAL_OBJECT_EXCEPTION
     * @uses self::VALUE_EXTERNAL_OBJECT_UNSUPPORTED_EXCEPTION
     * @uses self::VALUE_FEDERATED_SEARCH_ERROR
     * @uses self::VALUE_FEED_NOT_ENABLED_FOR_OBJECT
     * @uses self::VALUE_FUNCTIONALITY_NOT_ENABLED
     * @uses self::VALUE_FUNCTIONALITY_TEMPORARILY_UNAVAILABLE
     * @uses self::VALUE_ID_REQUIRED
     * @uses self::VALUE_ILLEGAL_QUERY_PARAMETER_VALUE
     * @uses self::VALUE_INACTIVE_OWNER_OR_USER
     * @uses self::VALUE_INACTIVE_PORTAL
     * @uses self::VALUE_INSERT_UPDATE_DELETE_NOT_ALLOWED_DURING_MAINTENANCE
     * @uses self::VALUE_INSTALL_KEY_INVALID
     * @uses self::VALUE_INSTALL_KEY_REQUIRED
     * @uses self::VALUE_INSUFFICIENT_ACCESS
     * @uses self::VALUE_INSUFFICIENT_ACCESS_APEX_METADATA_DEPLOY
     * @uses self::VALUE_INTERNAL_CANVAS_ERROR
     * @uses self::VALUE_INVALID_ASSIGNMENT_RULE
     * @uses self::VALUE_INVALID_AUTH_HEADER
     * @uses self::VALUE_INVALID_BATCH_REQUEST
     * @uses self::VALUE_INVALID_BATCH_SIZE
     * @uses self::VALUE_INVALID_CLIENT
     * @uses self::VALUE_INVALID_CROSS_REFERENCE_KEY
     * @uses self::VALUE_INVALID_DATE_FORMAT
     * @uses self::VALUE_INVALID_FIELD
     * @uses self::VALUE_INVALID_FILTER_LANGUAGE
     * @uses self::VALUE_INVALID_FILTER_VALUE
     * @uses self::VALUE_INVALID_ID_FIELD
     * @uses self::VALUE_INVALID_INPUT_COMBINATION
     * @uses self::VALUE_INVALID_LOCALE_LANGUAGE
     * @uses self::VALUE_INVALID_LOCATOR
     * @uses self::VALUE_INVALID_LOGIN
     * @uses self::VALUE_INVALID_MULTIPART_REQUEST
     * @uses self::VALUE_INVALID_NEW_PASSWORD
     * @uses self::VALUE_INVALID_OLD_PASSWORD
     * @uses self::VALUE_INVALID_OPERATION
     * @uses self::VALUE_INVALID_OPERATION_WITH_EXPIRED_PASSWORD
     * @uses self::VALUE_INVALID_PACKAGE_VERSION
     * @uses self::VALUE_INVALID_PAGING_OPTION
     * @uses self::VALUE_INVALID_QUERY_FILTER_OPERATOR
     * @uses self::VALUE_INVALID_QUERY_KEY
     * @uses self::VALUE_INVALID_QUERY_LOCATOR
     * @uses self::VALUE_INVALID_QUERY_SCOPE
     * @uses self::VALUE_INVALID_QUERY_VALUE
     * @uses self::VALUE_INVALID_REPLICATION_DATE
     * @uses self::VALUE_INVALID_SEARCH
     * @uses self::VALUE_INVALID_SEARCH_SCOPE
     * @uses self::VALUE_INVALID_SESSION_ID
     * @uses self::VALUE_INVALID_SOAP_HEADER
     * @uses self::VALUE_INVALID_SORT_OPTION
     * @uses self::VALUE_INVALID_SSO_GATEWAY_URL
     * @uses self::VALUE_INVALID_TYPE
     * @uses self::VALUE_INVALID_TYPE_FOR_OPERATION
     * @uses self::VALUE_JIGSAW_ACTION_DISABLED
     * @uses self::VALUE_JIGSAW_IMPORT_LIMIT_EXCEEDED
     * @uses self::VALUE_JIGSAW_REQUEST_NOT_SUPPORTED
     * @uses self::VALUE_JSON_PARSER_ERROR
     * @uses self::VALUE_KEY_HAS_BEEN_DESTROYED
     * @uses self::VALUE_LICENSING_DATA_ERROR
     * @uses self::VALUE_LICENSING_UNKNOWN_ERROR
     * @uses self::VALUE_LIMIT_EXCEEDED
     * @uses self::VALUE_LOGIN_CHALLENGE_ISSUED
     * @uses self::VALUE_LOGIN_CHALLENGE_PENDING
     * @uses self::VALUE_LOGIN_DURING_RESTRICTED_DOMAIN
     * @uses self::VALUE_LOGIN_DURING_RESTRICTED_TIME
     * @uses self::VALUE_LOGIN_MUST_USE_SECURITY_TOKEN
     * @uses self::VALUE_MALFORMED_ID
     * @uses self::VALUE_MALFORMED_QUERY
     * @uses self::VALUE_MALFORMED_SEARCH
     * @uses self::VALUE_MISMATCHING_VERSIONS
     * @uses self::VALUE_MISSING_ARGUMENT
     * @uses self::VALUE_MISSING_RECORD
     * @uses self::VALUE_MODIFIED
     * @uses self::VALUE_MULTIPLE_RECORDS_FOUND
     * @uses self::VALUE_MUTUAL_AUTHENTICATION_FAILED
     * @uses self::VALUE_NOT_ACCEPTABLE
     * @uses self::VALUE_NOT_MODIFIED
     * @uses self::VALUE_NO_ACTIVE_DUPLICATE_RULE
     * @uses self::VALUE_NO_RECIPIENTS
     * @uses self::VALUE_NO_SOFTPHONE_LAYOUT
     * @uses self::VALUE_NUMBER_OUTSIDE_VALID_RANGE
     * @uses self::VALUE_OPERATION_TOO_LARGE
     * @uses self::VALUE_ORG_IN_MAINTENANCE
     * @uses self::VALUE_ORG_IS_DOT_ORG
     * @uses self::VALUE_ORG_IS_SIGNING_UP
     * @uses self::VALUE_ORG_LOCKED
     * @uses self::VALUE_ORG_NOT_OWNED_BY_INSTANCE
     * @uses self::VALUE_PASSWORD_LOCKOUT
     * @uses self::VALUE_PORTAL_NO_ACCESS
     * @uses self::VALUE_POST_BODY_PARSE_ERROR
     * @uses self::VALUE_PRODUCT_NOT_FOUND
     * @uses self::VALUE_QAT_HETEROGENOUS_CONTEXT_IDS
     * @uses self::VALUE_QAT_INVALID_CONTEXT_ID
     * @uses self::VALUE_QAT_INVALID_QUICK_ACTION
     * @uses self::VALUE_QUERY_TIMEOUT
     * @uses self::VALUE_QUERY_TOO_COMPLICATED
     * @uses self::VALUE_REALTIME_PROCESSING_TIME_EXCEEDED_LIMIT
     * @uses self::VALUE_RECORD_NOT_FOUND
     * @uses self::VALUE_REQUEST_LIMIT_EXCEEDED
     * @uses self::VALUE_REQUEST_RUNNING_TOO_LONG
     * @uses self::VALUE_SERVER_UNAVAILABLE
     * @uses self::VALUE_SERVICE_DESK_NOT_ENABLED
     * @uses self::VALUE_SOCIALCRM_FEEDSERVICE_API_CLIENT_EXCEPTION
     * @uses self::VALUE_SOCIALCRM_FEEDSERVICE_API_SERVER_EXCEPTION
     * @uses self::VALUE_SOCIALCRM_FEEDSERVICE_API_UNAVAILABLE
     * @uses self::VALUE_SSO_SERVICE_DOWN
     * @uses self::VALUE_SST_ADMIN_FILE_DOWNLOAD_EXCEPTION
     * @uses self::VALUE_STATE_TRANSITION_NOT_ALLOWED
     * @uses self::VALUE_TOO_MANY_APEX_REQUESTS
     * @uses self::VALUE_TOO_MANY_JOBS
     * @uses self::VALUE_TOO_MANY_RECIPIENTS
     * @uses self::VALUE_TOO_MANY_RECORDS
     * @uses self::VALUE_TRIAL_EXPIRED
     * @uses self::VALUE_TXN_SECURITY_APEX_ERROR
     * @uses self::VALUE_TXN_SECURITY_END_A_SESSION
     * @uses self::VALUE_TXN_SECURITY_FAIL_CLOSE
     * @uses self::VALUE_TXN_SECURITY_METERING_ERROR
     * @uses self::VALUE_TXN_SECURITY_NO_ACCESS
     * @uses self::VALUE_TXN_SECURITY_RUNTIME_ERROR
     * @uses self::VALUE_TXN_SECURITY_TWO_FA_REQUIRED
     * @uses self::VALUE_UNABLE_TO_LOCK_ROW
     * @uses self::VALUE_UNKNOWN_ATTACHMENT_EXCEPTION
     * @uses self::VALUE_UNKNOWN_EXCEPTION
     * @uses self::VALUE_UNKNOWN_ORG_SETTING
     * @uses self::VALUE_UNSUPPORTED_API_VERSION
     * @uses self::VALUE_UNSUPPORTED_ATTACHMENT_ENCODING
     * @uses self::VALUE_UNSUPPORTED_CLIENT
     * @uses self::VALUE_UNSUPPORTED_MEDIA_TYPE
     * @uses self::VALUE_WEBSTORE_NOT_FOUND
     * @uses self::VALUE_XML_PARSER_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_APEX_REST_SERVICES_DISABLED,
            self::VALUE_APEX_TRIGGER_COUPLING_LIMIT,
            self::VALUE_API_CURRENTLY_DISABLED,
            self::VALUE_API_DISABLED_FOR_ORG,
            self::VALUE_ARGUMENT_OBJECT_PARSE_ERROR,
            self::VALUE_ASYNC_OPERATION_LOCATOR,
            self::VALUE_ASYNC_QUERY_UNSUPPORTED_QUERY,
            self::VALUE_BATCH_PROCESSING_HALTED,
            self::VALUE_BIG_OBJECT_UNSUPPORTED_OPERATION,
            self::VALUE_CANNOT_DELETE_ENTITY,
            self::VALUE_CANNOT_DELETE_OWNER,
            self::VALUE_CANT_ADD_STANDADRD_PORTAL_USER_TO_TERRITORY,
            self::VALUE_CANT_ADD_STANDARD_PORTAL_USER_TO_TERRITORY,
            self::VALUE_CATEGORY_NOT_FOUND,
            self::VALUE_CIRCULAR_OBJECT_GRAPH,
            self::VALUE_CLIENT_NOT_ACCESSIBLE_FOR_USER,
            self::VALUE_CLIENT_REQUIRE_UPDATE_FOR_USER,
            self::VALUE_CONTENT_ALREADY_AN_ASSET_EXCEPTION,
            self::VALUE_CONTENT_CUSTOM_DOWNLOAD_EXCEPTION,
            self::VALUE_CONTENT_HUB_AUTHENTICATION_EXCEPTION,
            self::VALUE_CONTENT_HUB_FILE_DOWNLOAD_EXCEPTION,
            self::VALUE_CONTENT_HUB_FILE_HAS_NO_URL_EXCEPTION,
            self::VALUE_CONTENT_HUB_FILE_NOT_FOUND_EXCEPTION,
            self::VALUE_CONTENT_HUB_INVALID_OBJECT_TYPE_EXCEPTION,
            self::VALUE_CONTENT_HUB_INVALID_PAGE_NUMBER_EXCEPTION,
            self::VALUE_CONTENT_HUB_INVALID_PAYLOAD,
            self::VALUE_CONTENT_HUB_INVALID_RENDITION_PAGE_NUMBER_EXCEPTION,
            self::VALUE_CONTENT_HUB_ITEM_TYPE_NOT_FOUND_EXCEPTION,
            self::VALUE_CONTENT_HUB_OBJECT_NOT_FOUND_EXCEPTION,
            self::VALUE_CONTENT_HUB_OPERATION_NOT_SUPPORTED_EXCEPTION,
            self::VALUE_CONTENT_HUB_SECURITY_EXCEPTION,
            self::VALUE_CONTENT_HUB_TIMEOUT_EXCEPTION,
            self::VALUE_CONTENT_HUB_UNEXPECTED_EXCEPTION,
            self::VALUE_CONTENT_IMAGE_SCALING_INVALID_ARGUMENTS_EXCEPTION,
            self::VALUE_CONTENT_IMAGE_SCALING_INVALID_IMAGE_EXCEPTION,
            self::VALUE_CONTENT_IMAGE_SCALING_MAX_RENDITIONS_EXCEPTION,
            self::VALUE_CONTENT_IMAGE_SCALING_TIMEOUT_EXCEPTION,
            self::VALUE_CONTENT_IMAGE_SCALING_UNKNOWN_EXCEPTION,
            self::VALUE_CUSTOM_METADATA_LIMIT_EXCEEDED,
            self::VALUE_CUSTOM_SETTINGS_LIMIT_EXCEEDED,
            self::VALUE_DATACLOUD_API_CLIENT_EXCEPTION,
            self::VALUE_DATACLOUD_API_DISABLED_EXCEPTION,
            self::VALUE_DATACLOUD_API_INVALID_QUERY_EXCEPTION,
            self::VALUE_DATACLOUD_API_SERVER_BUSY_EXCEPTION,
            self::VALUE_DATACLOUD_API_SERVER_EXCEPTION,
            self::VALUE_DATACLOUD_API_TIMEOUT_EXCEPTION,
            self::VALUE_DATACLOUD_API_UNAVAILABLE,
            self::VALUE_DATA_INTEGRATION_INPUT_ERROR,
            self::VALUE_DATA_INTEGRATION_NOT_FOUND,
            self::VALUE_DATA_INTEGRATION_NO_ACCESS,
            self::VALUE_DATA_INTEGRATION_PACKAGE_ERROR,
            self::VALUE_DATA_INTEGRATION_SERVER_ERROR,
            self::VALUE_DATA_INTEGRATION_VENDOR_SETUP_ERROR,
            self::VALUE_DUPLICATE_ARGUMENT_VALUE,
            self::VALUE_DUPLICATE_VALUE,
            self::VALUE_EMAIL_BATCH_SIZE_LIMIT_EXCEEDED,
            self::VALUE_EMAIL_TO_CASE_INVALID_ROUTING,
            self::VALUE_EMAIL_TO_CASE_LIMIT_EXCEEDED,
            self::VALUE_EMAIL_TO_CASE_NOT_ENABLED,
            self::VALUE_ENTITY_NOT_QUERYABLE,
            self::VALUE_ENVIRONMENT_HUB_MEMBERSHIP_CONFLICT,
            self::VALUE_EXCEEDED_ID_LIMIT,
            self::VALUE_EXCEEDED_LEAD_CONVERT_LIMIT,
            self::VALUE_EXCEEDED_MAX_FILTER_ENTITIES,
            self::VALUE_EXCEEDED_MAX_SIZE_REQUEST,
            self::VALUE_EXCEEDED_MAX_SOBJECTS,
            self::VALUE_EXCEEDED_MAX_TYPES_LIMIT,
            self::VALUE_EXCEEDED_QUOTA,
            self::VALUE_EXTERNAL_OBJECT_AUTHENTICATION_EXCEPTION,
            self::VALUE_EXTERNAL_OBJECT_CONNECTION_EXCEPTION,
            self::VALUE_EXTERNAL_OBJECT_EXCEPTION,
            self::VALUE_EXTERNAL_OBJECT_UNSUPPORTED_EXCEPTION,
            self::VALUE_FEDERATED_SEARCH_ERROR,
            self::VALUE_FEED_NOT_ENABLED_FOR_OBJECT,
            self::VALUE_FUNCTIONALITY_NOT_ENABLED,
            self::VALUE_FUNCTIONALITY_TEMPORARILY_UNAVAILABLE,
            self::VALUE_ID_REQUIRED,
            self::VALUE_ILLEGAL_QUERY_PARAMETER_VALUE,
            self::VALUE_INACTIVE_OWNER_OR_USER,
            self::VALUE_INACTIVE_PORTAL,
            self::VALUE_INSERT_UPDATE_DELETE_NOT_ALLOWED_DURING_MAINTENANCE,
            self::VALUE_INSTALL_KEY_INVALID,
            self::VALUE_INSTALL_KEY_REQUIRED,
            self::VALUE_INSUFFICIENT_ACCESS,
            self::VALUE_INSUFFICIENT_ACCESS_APEX_METADATA_DEPLOY,
            self::VALUE_INTERNAL_CANVAS_ERROR,
            self::VALUE_INVALID_ASSIGNMENT_RULE,
            self::VALUE_INVALID_AUTH_HEADER,
            self::VALUE_INVALID_BATCH_REQUEST,
            self::VALUE_INVALID_BATCH_SIZE,
            self::VALUE_INVALID_CLIENT,
            self::VALUE_INVALID_CROSS_REFERENCE_KEY,
            self::VALUE_INVALID_DATE_FORMAT,
            self::VALUE_INVALID_FIELD,
            self::VALUE_INVALID_FILTER_LANGUAGE,
            self::VALUE_INVALID_FILTER_VALUE,
            self::VALUE_INVALID_ID_FIELD,
            self::VALUE_INVALID_INPUT_COMBINATION,
            self::VALUE_INVALID_LOCALE_LANGUAGE,
            self::VALUE_INVALID_LOCATOR,
            self::VALUE_INVALID_LOGIN,
            self::VALUE_INVALID_MULTIPART_REQUEST,
            self::VALUE_INVALID_NEW_PASSWORD,
            self::VALUE_INVALID_OLD_PASSWORD,
            self::VALUE_INVALID_OPERATION,
            self::VALUE_INVALID_OPERATION_WITH_EXPIRED_PASSWORD,
            self::VALUE_INVALID_PACKAGE_VERSION,
            self::VALUE_INVALID_PAGING_OPTION,
            self::VALUE_INVALID_QUERY_FILTER_OPERATOR,
            self::VALUE_INVALID_QUERY_KEY,
            self::VALUE_INVALID_QUERY_LOCATOR,
            self::VALUE_INVALID_QUERY_SCOPE,
            self::VALUE_INVALID_QUERY_VALUE,
            self::VALUE_INVALID_REPLICATION_DATE,
            self::VALUE_INVALID_SEARCH,
            self::VALUE_INVALID_SEARCH_SCOPE,
            self::VALUE_INVALID_SESSION_ID,
            self::VALUE_INVALID_SOAP_HEADER,
            self::VALUE_INVALID_SORT_OPTION,
            self::VALUE_INVALID_SSO_GATEWAY_URL,
            self::VALUE_INVALID_TYPE,
            self::VALUE_INVALID_TYPE_FOR_OPERATION,
            self::VALUE_JIGSAW_ACTION_DISABLED,
            self::VALUE_JIGSAW_IMPORT_LIMIT_EXCEEDED,
            self::VALUE_JIGSAW_REQUEST_NOT_SUPPORTED,
            self::VALUE_JSON_PARSER_ERROR,
            self::VALUE_KEY_HAS_BEEN_DESTROYED,
            self::VALUE_LICENSING_DATA_ERROR,
            self::VALUE_LICENSING_UNKNOWN_ERROR,
            self::VALUE_LIMIT_EXCEEDED,
            self::VALUE_LOGIN_CHALLENGE_ISSUED,
            self::VALUE_LOGIN_CHALLENGE_PENDING,
            self::VALUE_LOGIN_DURING_RESTRICTED_DOMAIN,
            self::VALUE_LOGIN_DURING_RESTRICTED_TIME,
            self::VALUE_LOGIN_MUST_USE_SECURITY_TOKEN,
            self::VALUE_MALFORMED_ID,
            self::VALUE_MALFORMED_QUERY,
            self::VALUE_MALFORMED_SEARCH,
            self::VALUE_MISMATCHING_VERSIONS,
            self::VALUE_MISSING_ARGUMENT,
            self::VALUE_MISSING_RECORD,
            self::VALUE_MODIFIED,
            self::VALUE_MULTIPLE_RECORDS_FOUND,
            self::VALUE_MUTUAL_AUTHENTICATION_FAILED,
            self::VALUE_NOT_ACCEPTABLE,
            self::VALUE_NOT_MODIFIED,
            self::VALUE_NO_ACTIVE_DUPLICATE_RULE,
            self::VALUE_NO_RECIPIENTS,
            self::VALUE_NO_SOFTPHONE_LAYOUT,
            self::VALUE_NUMBER_OUTSIDE_VALID_RANGE,
            self::VALUE_OPERATION_TOO_LARGE,
            self::VALUE_ORG_IN_MAINTENANCE,
            self::VALUE_ORG_IS_DOT_ORG,
            self::VALUE_ORG_IS_SIGNING_UP,
            self::VALUE_ORG_LOCKED,
            self::VALUE_ORG_NOT_OWNED_BY_INSTANCE,
            self::VALUE_PASSWORD_LOCKOUT,
            self::VALUE_PORTAL_NO_ACCESS,
            self::VALUE_POST_BODY_PARSE_ERROR,
            self::VALUE_PRODUCT_NOT_FOUND,
            self::VALUE_QAT_HETEROGENOUS_CONTEXT_IDS,
            self::VALUE_QAT_INVALID_CONTEXT_ID,
            self::VALUE_QAT_INVALID_QUICK_ACTION,
            self::VALUE_QUERY_TIMEOUT,
            self::VALUE_QUERY_TOO_COMPLICATED,
            self::VALUE_REALTIME_PROCESSING_TIME_EXCEEDED_LIMIT,
            self::VALUE_RECORD_NOT_FOUND,
            self::VALUE_REQUEST_LIMIT_EXCEEDED,
            self::VALUE_REQUEST_RUNNING_TOO_LONG,
            self::VALUE_SERVER_UNAVAILABLE,
            self::VALUE_SERVICE_DESK_NOT_ENABLED,
            self::VALUE_SOCIALCRM_FEEDSERVICE_API_CLIENT_EXCEPTION,
            self::VALUE_SOCIALCRM_FEEDSERVICE_API_SERVER_EXCEPTION,
            self::VALUE_SOCIALCRM_FEEDSERVICE_API_UNAVAILABLE,
            self::VALUE_SSO_SERVICE_DOWN,
            self::VALUE_SST_ADMIN_FILE_DOWNLOAD_EXCEPTION,
            self::VALUE_STATE_TRANSITION_NOT_ALLOWED,
            self::VALUE_TOO_MANY_APEX_REQUESTS,
            self::VALUE_TOO_MANY_JOBS,
            self::VALUE_TOO_MANY_RECIPIENTS,
            self::VALUE_TOO_MANY_RECORDS,
            self::VALUE_TRIAL_EXPIRED,
            self::VALUE_TXN_SECURITY_APEX_ERROR,
            self::VALUE_TXN_SECURITY_END_A_SESSION,
            self::VALUE_TXN_SECURITY_FAIL_CLOSE,
            self::VALUE_TXN_SECURITY_METERING_ERROR,
            self::VALUE_TXN_SECURITY_NO_ACCESS,
            self::VALUE_TXN_SECURITY_RUNTIME_ERROR,
            self::VALUE_TXN_SECURITY_TWO_FA_REQUIRED,
            self::VALUE_UNABLE_TO_LOCK_ROW,
            self::VALUE_UNKNOWN_ATTACHMENT_EXCEPTION,
            self::VALUE_UNKNOWN_EXCEPTION,
            self::VALUE_UNKNOWN_ORG_SETTING,
            self::VALUE_UNSUPPORTED_API_VERSION,
            self::VALUE_UNSUPPORTED_ATTACHMENT_ENCODING,
            self::VALUE_UNSUPPORTED_CLIENT,
            self::VALUE_UNSUPPORTED_MEDIA_TYPE,
            self::VALUE_WEBSTORE_NOT_FOUND,
            self::VALUE_XML_PARSER_ERROR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
