<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstimatedDeliveryDate StructType
 * @subpackage Structs
 */
class EstimatedDeliveryDate extends AbstractStructBase
{
    /**
     * The EstimatedDeliveryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EstimatedDeliveryDate;
    /**
     * The EstimatedDeliveryType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EstimatedDeliveryType;
    /**
     * Constructor method for EstimatedDeliveryDate
     * @uses EstimatedDeliveryDate::setEstimatedDeliveryDate()
     * @uses EstimatedDeliveryDate::setEstimatedDeliveryType()
     * @param string $estimatedDeliveryDate
     * @param string $estimatedDeliveryType
     */
    public function __construct($estimatedDeliveryDate = null, $estimatedDeliveryType = null)
    {
        $this
            ->setEstimatedDeliveryDate($estimatedDeliveryDate)
            ->setEstimatedDeliveryType($estimatedDeliveryType);
    }
    /**
     * Get EstimatedDeliveryDate value
     * @return string|null
     */
    public function getEstimatedDeliveryDate()
    {
        return $this->EstimatedDeliveryDate;
    }
    /**
     * Set EstimatedDeliveryDate value
     * @param string $estimatedDeliveryDate
     * @return \DHLExpressGlobalWS\StructType\EstimatedDeliveryDate
     */
    public function setEstimatedDeliveryDate($estimatedDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedDeliveryDate) && !is_string($estimatedDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estimatedDeliveryDate, true), gettype($estimatedDeliveryDate)), __LINE__);
        }
        $this->EstimatedDeliveryDate = $estimatedDeliveryDate;
        return $this;
    }
    /**
     * Get EstimatedDeliveryType value
     * @return string|null
     */
    public function getEstimatedDeliveryType()
    {
        return $this->EstimatedDeliveryType;
    }
    /**
     * Set EstimatedDeliveryType value
     * @uses \DHLExpressGlobalWS\EnumType\EstimatedDeliveryType::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\EstimatedDeliveryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $estimatedDeliveryType
     * @return \DHLExpressGlobalWS\StructType\EstimatedDeliveryDate
     */
    public function setEstimatedDeliveryType($estimatedDeliveryType = null)
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\EstimatedDeliveryType::valueIsValid($estimatedDeliveryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\EstimatedDeliveryType', is_array($estimatedDeliveryType) ? implode(', ', $estimatedDeliveryType) : var_export($estimatedDeliveryType, true), implode(', ', \DHLExpressGlobalWS\EnumType\EstimatedDeliveryType::getValidValues())), __LINE__);
        }
        $this->EstimatedDeliveryType = $estimatedDeliveryType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\EstimatedDeliveryDate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
