<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceHandlingFeatureCodes StructType
 * Meta information extracted from the WSDL
 * - documentation: Service handling feature codes returned from Document Rendering service
 * - type: s3:ServiceHandlingFeatureCodes
 * @subpackage Structs
 */
class ServiceHandlingFeatureCodes extends AbstractStructBase
{
    /**
     * The ServiceHandlingFeatureCode
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * @var string
     */
    public $ServiceHandlingFeatureCode;
    /**
     * Constructor method for ServiceHandlingFeatureCodes
     * @uses ServiceHandlingFeatureCodes::setServiceHandlingFeatureCode()
     * @param string $serviceHandlingFeatureCode
     */
    public function __construct($serviceHandlingFeatureCode = null)
    {
        $this
            ->setServiceHandlingFeatureCode($serviceHandlingFeatureCode);
    }
    /**
     * Get ServiceHandlingFeatureCode value
     * @return string|null
     */
    public function getServiceHandlingFeatureCode()
    {
        return $this->ServiceHandlingFeatureCode;
    }
    /**
     * Set ServiceHandlingFeatureCode value
     * @param string $serviceHandlingFeatureCode
     * @return \DHLExpressGlobalWS\StructType\ServiceHandlingFeatureCodes
     */
    public function setServiceHandlingFeatureCode($serviceHandlingFeatureCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceHandlingFeatureCode) && !is_string($serviceHandlingFeatureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceHandlingFeatureCode, true), gettype($serviceHandlingFeatureCode)), __LINE__);
        }
        $this->ServiceHandlingFeatureCode = $serviceHandlingFeatureCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\ServiceHandlingFeatureCodes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
