<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_ServiceAreaType StructType
 * @subpackage Structs
 */
class DocTypeRef_ServiceAreaType extends AbstractStructBase
{
    /**
     * The FacilityCode
     * Meta information extracted from the WSDL
     * - documentation: The DHL Facility Code for the Origin/Destination
     * - minOccurs: 0
     * @var string
     */
    public $FacilityCode;
    /**
     * The ServiceAreaCode
     * Meta information extracted from the WSDL
     * - documentation: The DHL Service Area Code for the origin/destination of the Shipment
     * - minOccurs: 0
     * @var string
     */
    public $ServiceAreaCode;
    /**
     * Constructor method for docTypeRef_ServiceAreaType
     * @uses DocTypeRef_ServiceAreaType::setFacilityCode()
     * @uses DocTypeRef_ServiceAreaType::setServiceAreaCode()
     * @param string $facilityCode
     * @param string $serviceAreaCode
     */
    public function __construct($facilityCode = null, $serviceAreaCode = null)
    {
        $this
            ->setFacilityCode($facilityCode)
            ->setServiceAreaCode($serviceAreaCode);
    }
    /**
     * Get FacilityCode value
     * @return string|null
     */
    public function getFacilityCode()
    {
        return $this->FacilityCode;
    }
    /**
     * Set FacilityCode value
     * @param string $facilityCode
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ServiceAreaType
     */
    public function setFacilityCode($facilityCode = null)
    {
        // validation for constraint: string
        if (!is_null($facilityCode) && !is_string($facilityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($facilityCode, true), gettype($facilityCode)), __LINE__);
        }
        $this->FacilityCode = $facilityCode;
        return $this;
    }
    /**
     * Get ServiceAreaCode value
     * @return string|null
     */
    public function getServiceAreaCode()
    {
        return $this->ServiceAreaCode;
    }
    /**
     * Set ServiceAreaCode value
     * @param string $serviceAreaCode
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ServiceAreaType
     */
    public function setServiceAreaCode($serviceAreaCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceAreaCode) && !is_string($serviceAreaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceAreaCode, true), gettype($serviceAreaCode)), __LINE__);
        }
        $this->ServiceAreaCode = $serviceAreaCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ServiceAreaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
