<?php

namespace DHLExpressGlobalWS\EnumType;

/**
 * This class stands for ShipmentPurpose2 EnumType
 * @subpackage Enumerations
 */
class ShipmentPurpose2
{
    /**
     * Constant for value 'PERSONAL'
     * @return string 'PERSONAL'
     */
    const VALUE_PERSONAL = 'PERSONAL';
    /**
     * Constant for value 'COMMERCIAL'
     * @return string 'COMMERCIAL'
     */
    const VALUE_COMMERCIAL = 'COMMERCIAL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PERSONAL
     * @uses self::VALUE_COMMERCIAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PERSONAL,
            self::VALUE_COMMERCIAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
