<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceDeclarationText StructType
 * Meta information extracted from the WSDL
 * - documentation: Additional Declaration text in invoice
 * @subpackage Structs
 */
class InvoiceDeclarationText extends AbstractStructBase
{
    /**
     * The DeclarationText
     * Meta information extracted from the WSDL
     * - documentation: Declaration text
     * - base: xsd:string
     * - maxLength: 300
     * @var string
     */
    public $DeclarationText;
    /**
     * Constructor method for InvoiceDeclarationText
     * @uses InvoiceDeclarationText::setDeclarationText()
     * @param string $declarationText
     */
    public function __construct($declarationText = null)
    {
        $this
            ->setDeclarationText($declarationText);
    }
    /**
     * Get DeclarationText value
     * @return string|null
     */
    public function getDeclarationText()
    {
        return $this->DeclarationText;
    }
    /**
     * Set DeclarationText value
     * @param string $declarationText
     * @return \DHLExpressGlobalWS\StructType\InvoiceDeclarationText
     */
    public function setDeclarationText($declarationText = null)
    {
        // validation for constraint: string
        if (!is_null($declarationText) && !is_string($declarationText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($declarationText, true), gettype($declarationText)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($declarationText) && mb_strlen($declarationText) > 300) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen($declarationText)), __LINE__);
        }
        $this->DeclarationText = $declarationText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\InvoiceDeclarationText
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
