<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_WeightType StructType
 * @subpackage Structs
 */
class DocTypeRef_WeightType extends AbstractStructBase
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - documentation: Sum of the weight of the individual pieces/packages the rating request is for. Minimum allowed weight is 0.1kg – please see your DHL Account rate card for more information on minimum and maximum weights per piece.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - totalDigits: 12
     * @var float
     */
    public $Value;
    /**
     * Constructor method for docTypeRef_WeightType
     * @uses DocTypeRef_WeightType::setValue()
     * @param float $value
     */
    public function __construct($value = null)
    {
        $this
            ->setValue($value);
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_WeightType
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($value) && mb_strlen(mb_substr($value, mb_strpos($value, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($value, true), mb_strlen(mb_substr($value, mb_strpos($value, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($value) && mb_strlen(preg_replace('/(\D)/', '', $value)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($value, true), mb_strlen(preg_replace('/(\D)/', '', $value))), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_WeightType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
