<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_RequestedShipmentType2 StructType
 * @subpackage Structs
 */
class DocTypeRef_RequestedShipmentType2 extends AbstractStructBase
{
    /**
     * The GetRateEstimates
     * Meta information extracted from the WSDL
     * - documentation: This element is to provide customers with options to see DHL products and services without price. This improves response times for the requests. The default value is Y, where the response only show billing currency rates per product,
     * no breakdowns.
     * - minOccurs: 0
     * @var string
     */
    public $GetRateEstimates;
    /**
     * The GetDetailedRateBreakdown
     * Meta information extracted from the WSDL
     * - documentation: This option is to receive a breakdown of charges including taxes and discounts. The default value is N, a high level breakdown is provided then.
     * - minOccurs: 0
     * @var string
     */
    public $GetDetailedRateBreakdown;
    /**
     * The IncludeAdditionalCurrencies
     * Meta information extracted from the WSDL
     * - documentation: To show charges in other currencies. When the 'IncludeAdditionalCurrencies' value is “Y”, value of currencies will be returned based on below ; - ‘BILLC’, billing currency - ‘PULCL’, country public rates currency -
     * ‘BASEC’, base currency The default value is N, response to show TotalNet and all other rates in Billing currency only.
     * - minOccurs: 0
     * @var string
     */
    public $IncludeAdditionalCurrencies;
    /**
     * The DropOffType
     * Meta information extracted from the WSDL
     * - documentation: Requested value are REGULAR_PICKUP or REQUEST_COURIER, it identifies the method by which the package is to be tendered.
     * @var string
     */
    public $DropOffType;
    /**
     * The NextBusinessDay
     * Meta information extracted from the WSDL
     * - documentation: This indicator is a Y-N flag which indicates whether an error should be returned if no products are available that day (N) or if the next business day should be evaluated (Y). Default is N if not included.
     * - minOccurs: 0
     * @var string
     */
    public $NextBusinessDay;
    /**
     * The Ship
     * @var \DHLExpressGlobalWS\StructType\DocTypeRef_ShipType2
     */
    public $Ship;
    /**
     * The Packages
     * @var \DHLExpressGlobalWS\StructType\DocTypeRef_PackagesType2
     */
    public $Packages;
    /**
     * The ShipTimestamp
     * Meta information extracted from the WSDL
     * - documentation: Identifies the date and time the package is tendered. Both the date and time portions of the string are expected to be used. The date should not be a past date or a date more than 10 days in the future. The time is the local time of
     * the shipment based on the shipper's time zone. The date component must be in the format: YYYY-MM-DD; the time component must be in the format: HH:MM:SS using a 24 hour clock. The date and time parts are separated by the letter T (e.g.
     * 2006-06-26T17:00:00 GMT+01:00).
     * - base: xsd:token
     * - maxLength: 29
     * - whiteSpace: collapse
     * @var string
     */
    public $ShipTimestamp;
    /**
     * The PickupLocationCloseTime
     * Meta information extracted from the WSDL
     * - documentation: For future use
     * - base: xsd:token
     * - maxLength: 29
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $PickupLocationCloseTime;
    /**
     * The UnitOfMeasurement
     * Meta information extracted from the WSDL
     * - documentation: SI=the preferred system of weights and measures for Italian trade and commerce; SU=the preferred system of weights and measures for U.S. trade and commerce; Weight unit: if Type is SI it can be KG (kilograms), if Type is SU it can be
     * LB (pounds). Dimention unit: if Type is SI it can be CM, if Type is SU it can be IN (inch)
     * @var string
     */
    public $UnitOfMeasurement;
    /**
     * The Content
     * Meta information extracted from the WSDL
     * - documentation: Details whether a shipment is non-dutiable (value DOCUMENTS) or dutiable (NON_DOCUMENTS)
     * - minOccurs: 0
     * @var string
     */
    public $Content;
    /**
     * The DeclaredValue
     * Meta information extracted from the WSDL
     * - documentation: Declared value of the shipment
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $DeclaredValue;
    /**
     * The DeclaredValueCurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: 3 character currency code for the declared value
     * - base: xsd:string
     * - maxLength: 3
     * - minOccurs: 0
     * @var string
     */
    public $DeclaredValueCurrencyCode;
    /**
     * The PaymentInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaymentInfo;
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - documentation: The DHL account number that is used for the shipment. Internally attached to this account are the customer specific rates. Please note if you use the 'Account' tag then the Billing section below is not needed.
     * - base: xsd:string
     * - maxLength: 12
     * - minLength: 1
     * - minOccurs: 0
     * - whiteSpace: preserve
     * @var string
     */
    public $Account;
    /**
     * The PayerCountryCode
     * Meta information extracted from the WSDL
     * - documentation: The country code of the payer. This field is to allow rate requests with no account number provided. It is mandatory to provide this input field if DHL customers want to request for standard country rates but no account number is
     * provided. This function needs to be enabled for your username by your DHL Express IT Consultant.
     * - base: xsd:token
     * - maxLength: 2
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $PayerCountryCode;
    /**
     * The Billing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\Billing2
     */
    public $Billing;
    /**
     * The SpecialServices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\Services2
     */
    public $SpecialServices;
    /**
     * The RequestValueAddedServices
     * Meta information extracted from the WSDL
     * - documentation: If the value is "Y" all the additional services available for the product selected will be returned. The default value is "N"
     * - base: xsd:string
     * - default: N
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $RequestValueAddedServices;
    /**
     * The ServiceType
     * Meta information extracted from the WSDL
     * - documentation: Optional DHL service - global code
     * - base: xsd:string
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceType;
    /**
     * The NetworkTypeCode
     * Meta information extracted from the WSDL
     * - documentation: The NetworkTypeCode field is used to filter facility network type code. The default value is AL, return all products. DD is for Economy Select products and TD for Time Definite products
     * - minOccurs: 0
     * @var string
     */
    public $NetworkTypeCode;
    /**
     * The CustomerAgreementInd
     * Meta information extracted from the WSDL
     * - documentation: Customer agreement indicator for product and services. This field is for filtering agreement and non-agreement products. The default value is ‘Y’. All standard and non-agreement products will be returned. An example of a customer
     * agreement product is Medical Express
     * - minOccurs: 0
     * @var string
     */
    public $CustomerAgreementInd;
    /**
     * The ValidateReadyTime
     * Meta information extracted from the WSDL
     * - documentation: Validate ready time against pickup window start on Economy Select products
     * - minOccurs: 0
     * @var string
     */
    public $ValidateReadyTime;
    /**
     * The ProductsAndServices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\ProductsAndServices2
     */
    public $ProductsAndServices;
    /**
     * The LandedCost
     * Meta information extracted from the WSDL
     * - documentation: Landed Cost parameters
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\LandedCostType
     */
    public $LandedCost;
    /**
     * Constructor method for docTypeRef_RequestedShipmentType2
     * @uses DocTypeRef_RequestedShipmentType2::setGetRateEstimates()
     * @uses DocTypeRef_RequestedShipmentType2::setGetDetailedRateBreakdown()
     * @uses DocTypeRef_RequestedShipmentType2::setIncludeAdditionalCurrencies()
     * @uses DocTypeRef_RequestedShipmentType2::setDropOffType()
     * @uses DocTypeRef_RequestedShipmentType2::setNextBusinessDay()
     * @uses DocTypeRef_RequestedShipmentType2::setShip()
     * @uses DocTypeRef_RequestedShipmentType2::setPackages()
     * @uses DocTypeRef_RequestedShipmentType2::setShipTimestamp()
     * @uses DocTypeRef_RequestedShipmentType2::setPickupLocationCloseTime()
     * @uses DocTypeRef_RequestedShipmentType2::setUnitOfMeasurement()
     * @uses DocTypeRef_RequestedShipmentType2::setContent()
     * @uses DocTypeRef_RequestedShipmentType2::setDeclaredValue()
     * @uses DocTypeRef_RequestedShipmentType2::setDeclaredValueCurrencyCode()
     * @uses DocTypeRef_RequestedShipmentType2::setPaymentInfo()
     * @uses DocTypeRef_RequestedShipmentType2::setAccount()
     * @uses DocTypeRef_RequestedShipmentType2::setPayerCountryCode()
     * @uses DocTypeRef_RequestedShipmentType2::setBilling()
     * @uses DocTypeRef_RequestedShipmentType2::setSpecialServices()
     * @uses DocTypeRef_RequestedShipmentType2::setRequestValueAddedServices()
     * @uses DocTypeRef_RequestedShipmentType2::setServiceType()
     * @uses DocTypeRef_RequestedShipmentType2::setNetworkTypeCode()
     * @uses DocTypeRef_RequestedShipmentType2::setCustomerAgreementInd()
     * @uses DocTypeRef_RequestedShipmentType2::setValidateReadyTime()
     * @uses DocTypeRef_RequestedShipmentType2::setProductsAndServices()
     * @uses DocTypeRef_RequestedShipmentType2::setLandedCost()
     * @param string $getRateEstimates
     * @param string $getDetailedRateBreakdown
     * @param string $includeAdditionalCurrencies
     * @param string $dropOffType
     * @param string $nextBusinessDay
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_ShipType2 $ship
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_PackagesType2 $packages
     * @param string $shipTimestamp
     * @param string $pickupLocationCloseTime
     * @param string $unitOfMeasurement
     * @param string $content
     * @param float $declaredValue
     * @param string $declaredValueCurrencyCode
     * @param string $paymentInfo
     * @param string $account
     * @param string $payerCountryCode
     * @param \DHLExpressGlobalWS\StructType\Billing2 $billing
     * @param \DHLExpressGlobalWS\StructType\Services2 $specialServices
     * @param string $requestValueAddedServices
     * @param string $serviceType
     * @param string $networkTypeCode
     * @param string $customerAgreementInd
     * @param string $validateReadyTime
     * @param \DHLExpressGlobalWS\StructType\ProductsAndServices2 $productsAndServices
     * @param \DHLExpressGlobalWS\StructType\LandedCostType $landedCost
     */
    public function __construct($getRateEstimates = null, $getDetailedRateBreakdown = null, $includeAdditionalCurrencies = null, $dropOffType = null, $nextBusinessDay = null, \DHLExpressGlobalWS\StructType\DocTypeRef_ShipType2 $ship = null, \DHLExpressGlobalWS\StructType\DocTypeRef_PackagesType2 $packages = null, $shipTimestamp = null, $pickupLocationCloseTime = null, $unitOfMeasurement = null, $content = null, $declaredValue = null, $declaredValueCurrencyCode = null, $paymentInfo = null, $account = null, $payerCountryCode = null, \DHLExpressGlobalWS\StructType\Billing2 $billing = null, \DHLExpressGlobalWS\StructType\Services2 $specialServices = null, $requestValueAddedServices = 'N', $serviceType = null, $networkTypeCode = null, $customerAgreementInd = null, $validateReadyTime = null, \DHLExpressGlobalWS\StructType\ProductsAndServices2 $productsAndServices = null, \DHLExpressGlobalWS\StructType\LandedCostType $landedCost = null)
    {
        $this
            ->setGetRateEstimates($getRateEstimates)
            ->setGetDetailedRateBreakdown($getDetailedRateBreakdown)
            ->setIncludeAdditionalCurrencies($includeAdditionalCurrencies)
            ->setDropOffType($dropOffType)
            ->setNextBusinessDay($nextBusinessDay)
            ->setShip($ship)
            ->setPackages($packages)
            ->setShipTimestamp($shipTimestamp)
            ->setPickupLocationCloseTime($pickupLocationCloseTime)
            ->setUnitOfMeasurement($unitOfMeasurement)
            ->setContent($content)
            ->setDeclaredValue($declaredValue)
            ->setDeclaredValueCurrencyCode($declaredValueCurrencyCode)
            ->setPaymentInfo($paymentInfo)
            ->setAccount($account)
            ->setPayerCountryCode($payerCountryCode)
            ->setBilling($billing)
            ->setSpecialServices($specialServices)
            ->setRequestValueAddedServices($requestValueAddedServices)
            ->setServiceType($serviceType)
            ->setNetworkTypeCode($networkTypeCode)
            ->setCustomerAgreementInd($customerAgreementInd)
            ->setValidateReadyTime($validateReadyTime)
            ->setProductsAndServices($productsAndServices)
            ->setLandedCost($landedCost);
    }
    /**
     * Get GetRateEstimates value
     * @return string|null
     */
    public function getGetRateEstimates()
    {
        return $this->GetRateEstimates;
    }
    /**
     * Set GetRateEstimates value
     * @uses \DHLExpressGlobalWS\EnumType\GetRateEstimates2::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\GetRateEstimates2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $getRateEstimates
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setGetRateEstimates($getRateEstimates = null)
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\GetRateEstimates2::valueIsValid($getRateEstimates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\GetRateEstimates2', is_array($getRateEstimates) ? implode(', ', $getRateEstimates) : var_export($getRateEstimates, true), implode(', ', \DHLExpressGlobalWS\EnumType\GetRateEstimates2::getValidValues())), __LINE__);
        }
        $this->GetRateEstimates = $getRateEstimates;
        return $this;
    }
    /**
     * Get GetDetailedRateBreakdown value
     * @return string|null
     */
    public function getGetDetailedRateBreakdown()
    {
        return $this->GetDetailedRateBreakdown;
    }
    /**
     * Set GetDetailedRateBreakdown value
     * @uses \DHLExpressGlobalWS\EnumType\GetDetailedRateBreakdown2::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\GetDetailedRateBreakdown2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $getDetailedRateBreakdown
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setGetDetailedRateBreakdown($getDetailedRateBreakdown = null)
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\GetDetailedRateBreakdown2::valueIsValid($getDetailedRateBreakdown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\GetDetailedRateBreakdown2', is_array($getDetailedRateBreakdown) ? implode(', ', $getDetailedRateBreakdown) : var_export($getDetailedRateBreakdown, true), implode(', ', \DHLExpressGlobalWS\EnumType\GetDetailedRateBreakdown2::getValidValues())), __LINE__);
        }
        $this->GetDetailedRateBreakdown = $getDetailedRateBreakdown;
        return $this;
    }
    /**
     * Get IncludeAdditionalCurrencies value
     * @return string|null
     */
    public function getIncludeAdditionalCurrencies()
    {
        return $this->IncludeAdditionalCurrencies;
    }
    /**
     * Set IncludeAdditionalCurrencies value
     * @uses \DHLExpressGlobalWS\EnumType\IncludeAdditionalCurrencies2::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\IncludeAdditionalCurrencies2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeAdditionalCurrencies
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setIncludeAdditionalCurrencies($includeAdditionalCurrencies = null)
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\IncludeAdditionalCurrencies2::valueIsValid($includeAdditionalCurrencies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\IncludeAdditionalCurrencies2', is_array($includeAdditionalCurrencies) ? implode(', ', $includeAdditionalCurrencies) : var_export($includeAdditionalCurrencies, true), implode(', ', \DHLExpressGlobalWS\EnumType\IncludeAdditionalCurrencies2::getValidValues())), __LINE__);
        }
        $this->IncludeAdditionalCurrencies = $includeAdditionalCurrencies;
        return $this;
    }
    /**
     * Get DropOffType value
     * @return string|null
     */
    public function getDropOffType()
    {
        return $this->DropOffType;
    }
    /**
     * Set DropOffType value
     * @uses \DHLExpressGlobalWS\EnumType\DropOffType2::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\DropOffType2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dropOffType
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setDropOffType($dropOffType = null)
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\DropOffType2::valueIsValid($dropOffType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\DropOffType2', is_array($dropOffType) ? implode(', ', $dropOffType) : var_export($dropOffType, true), implode(', ', \DHLExpressGlobalWS\EnumType\DropOffType2::getValidValues())), __LINE__);
        }
        $this->DropOffType = $dropOffType;
        return $this;
    }
    /**
     * Get NextBusinessDay value
     * @return string|null
     */
    public function getNextBusinessDay()
    {
        return $this->NextBusinessDay;
    }
    /**
     * Set NextBusinessDay value
     * @uses \DHLExpressGlobalWS\EnumType\NextBusinessDay2::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\NextBusinessDay2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nextBusinessDay
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setNextBusinessDay($nextBusinessDay = null)
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\NextBusinessDay2::valueIsValid($nextBusinessDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\NextBusinessDay2', is_array($nextBusinessDay) ? implode(', ', $nextBusinessDay) : var_export($nextBusinessDay, true), implode(', ', \DHLExpressGlobalWS\EnumType\NextBusinessDay2::getValidValues())), __LINE__);
        }
        $this->NextBusinessDay = $nextBusinessDay;
        return $this;
    }
    /**
     * Get Ship value
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipType2|null
     */
    public function getShip()
    {
        return $this->Ship;
    }
    /**
     * Set Ship value
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_ShipType2 $ship
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setShip(\DHLExpressGlobalWS\StructType\DocTypeRef_ShipType2 $ship = null)
    {
        $this->Ship = $ship;
        return $this;
    }
    /**
     * Get Packages value
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_PackagesType2|null
     */
    public function getPackages()
    {
        return $this->Packages;
    }
    /**
     * Set Packages value
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_PackagesType2 $packages
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setPackages(\DHLExpressGlobalWS\StructType\DocTypeRef_PackagesType2 $packages = null)
    {
        $this->Packages = $packages;
        return $this;
    }
    /**
     * Get ShipTimestamp value
     * @return string|null
     */
    public function getShipTimestamp()
    {
        return $this->ShipTimestamp;
    }
    /**
     * Set ShipTimestamp value
     * @param string $shipTimestamp
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setShipTimestamp($shipTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($shipTimestamp) && !is_string($shipTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipTimestamp, true), gettype($shipTimestamp)), __LINE__);
        }
        // validation for constraint: maxLength(29)
        if (!is_null($shipTimestamp) && mb_strlen($shipTimestamp) > 29) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 29', mb_strlen($shipTimestamp)), __LINE__);
        }
        $this->ShipTimestamp = $shipTimestamp;
        return $this;
    }
    /**
     * Get PickupLocationCloseTime value
     * @return string|null
     */
    public function getPickupLocationCloseTime()
    {
        return $this->PickupLocationCloseTime;
    }
    /**
     * Set PickupLocationCloseTime value
     * @param string $pickupLocationCloseTime
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setPickupLocationCloseTime($pickupLocationCloseTime = null)
    {
        // validation for constraint: string
        if (!is_null($pickupLocationCloseTime) && !is_string($pickupLocationCloseTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupLocationCloseTime, true), gettype($pickupLocationCloseTime)), __LINE__);
        }
        // validation for constraint: maxLength(29)
        if (!is_null($pickupLocationCloseTime) && mb_strlen($pickupLocationCloseTime) > 29) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 29', mb_strlen($pickupLocationCloseTime)), __LINE__);
        }
        $this->PickupLocationCloseTime = $pickupLocationCloseTime;
        return $this;
    }
    /**
     * Get UnitOfMeasurement value
     * @return string|null
     */
    public function getUnitOfMeasurement()
    {
        return $this->UnitOfMeasurement;
    }
    /**
     * Set UnitOfMeasurement value
     * @uses \DHLExpressGlobalWS\EnumType\UnitOfMeasurement2::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\UnitOfMeasurement2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unitOfMeasurement
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setUnitOfMeasurement($unitOfMeasurement = null)
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\UnitOfMeasurement2::valueIsValid($unitOfMeasurement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\UnitOfMeasurement2', is_array($unitOfMeasurement) ? implode(', ', $unitOfMeasurement) : var_export($unitOfMeasurement, true), implode(', ', \DHLExpressGlobalWS\EnumType\UnitOfMeasurement2::getValidValues())), __LINE__);
        }
        $this->UnitOfMeasurement = $unitOfMeasurement;
        return $this;
    }
    /**
     * Get Content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->Content;
    }
    /**
     * Set Content value
     * @uses \DHLExpressGlobalWS\EnumType\Content2::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\Content2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $content
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setContent($content = null)
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\Content2::valueIsValid($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\Content2', is_array($content) ? implode(', ', $content) : var_export($content, true), implode(', ', \DHLExpressGlobalWS\EnumType\Content2::getValidValues())), __LINE__);
        }
        $this->Content = $content;
        return $this;
    }
    /**
     * Get DeclaredValue value
     * @return float|null
     */
    public function getDeclaredValue()
    {
        return $this->DeclaredValue;
    }
    /**
     * Set DeclaredValue value
     * @param float $declaredValue
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setDeclaredValue($declaredValue = null)
    {
        // validation for constraint: float
        if (!is_null($declaredValue) && !(is_float($declaredValue) || is_numeric($declaredValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($declaredValue, true), gettype($declaredValue)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($declaredValue) && mb_strlen(mb_substr($declaredValue, mb_strpos($declaredValue, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($declaredValue, true), mb_strlen(mb_substr($declaredValue, mb_strpos($declaredValue, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($declaredValue) && mb_strlen(preg_replace('/(\D)/', '', $declaredValue)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($declaredValue, true), mb_strlen(preg_replace('/(\D)/', '', $declaredValue))), __LINE__);
        }
        $this->DeclaredValue = $declaredValue;
        return $this;
    }
    /**
     * Get DeclaredValueCurrencyCode value
     * @return string|null
     */
    public function getDeclaredValueCurrencyCode()
    {
        return $this->DeclaredValueCurrencyCode;
    }
    /**
     * Set DeclaredValueCurrencyCode value
     * @param string $declaredValueCurrencyCode
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setDeclaredValueCurrencyCode($declaredValueCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($declaredValueCurrencyCode) && !is_string($declaredValueCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($declaredValueCurrencyCode, true), gettype($declaredValueCurrencyCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($declaredValueCurrencyCode) && mb_strlen($declaredValueCurrencyCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($declaredValueCurrencyCode)), __LINE__);
        }
        $this->DeclaredValueCurrencyCode = $declaredValueCurrencyCode;
        return $this;
    }
    /**
     * Get PaymentInfo value
     * @return string|null
     */
    public function getPaymentInfo()
    {
        return $this->PaymentInfo;
    }
    /**
     * Set PaymentInfo value
     * @uses \DHLExpressGlobalWS\EnumType\PaymentInfo2::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\PaymentInfo2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentInfo
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setPaymentInfo($paymentInfo = null)
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\PaymentInfo2::valueIsValid($paymentInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\PaymentInfo2', is_array($paymentInfo) ? implode(', ', $paymentInfo) : var_export($paymentInfo, true), implode(', ', \DHLExpressGlobalWS\EnumType\PaymentInfo2::getValidValues())), __LINE__);
        }
        $this->PaymentInfo = $paymentInfo;
        return $this;
    }
    /**
     * Get Account value
     * @return string|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param string $account
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setAccount($account = null)
    {
        // validation for constraint: string
        if (!is_null($account) && !is_string($account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($account, true), gettype($account)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($account) && mb_strlen($account) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($account)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($account) && mb_strlen($account) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($account)), __LINE__);
        }
        $this->Account = $account;
        return $this;
    }
    /**
     * Get PayerCountryCode value
     * @return string|null
     */
    public function getPayerCountryCode()
    {
        return $this->PayerCountryCode;
    }
    /**
     * Set PayerCountryCode value
     * @param string $payerCountryCode
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setPayerCountryCode($payerCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($payerCountryCode) && !is_string($payerCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerCountryCode, true), gettype($payerCountryCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($payerCountryCode) && mb_strlen($payerCountryCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($payerCountryCode)), __LINE__);
        }
        $this->PayerCountryCode = $payerCountryCode;
        return $this;
    }
    /**
     * Get Billing value
     * @return \DHLExpressGlobalWS\StructType\Billing2|null
     */
    public function getBilling()
    {
        return $this->Billing;
    }
    /**
     * Set Billing value
     * @param \DHLExpressGlobalWS\StructType\Billing2 $billing
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setBilling(\DHLExpressGlobalWS\StructType\Billing2 $billing = null)
    {
        $this->Billing = $billing;
        return $this;
    }
    /**
     * Get SpecialServices value
     * @return \DHLExpressGlobalWS\StructType\Services2|null
     */
    public function getSpecialServices()
    {
        return $this->SpecialServices;
    }
    /**
     * Set SpecialServices value
     * @param \DHLExpressGlobalWS\StructType\Services2 $specialServices
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setSpecialServices(\DHLExpressGlobalWS\StructType\Services2 $specialServices = null)
    {
        $this->SpecialServices = $specialServices;
        return $this;
    }
    /**
     * Get RequestValueAddedServices value
     * @return string|null
     */
    public function getRequestValueAddedServices()
    {
        return $this->RequestValueAddedServices;
    }
    /**
     * Set RequestValueAddedServices value
     * @param string $requestValueAddedServices
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setRequestValueAddedServices($requestValueAddedServices = 'N')
    {
        // validation for constraint: string
        if (!is_null($requestValueAddedServices) && !is_string($requestValueAddedServices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestValueAddedServices, true), gettype($requestValueAddedServices)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($requestValueAddedServices) && mb_strlen($requestValueAddedServices) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($requestValueAddedServices)), __LINE__);
        }
        $this->RequestValueAddedServices = $requestValueAddedServices;
        return $this;
    }
    /**
     * Get ServiceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->ServiceType;
    }
    /**
     * Set ServiceType value
     * @param string $serviceType
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: string
        if (!is_null($serviceType) && !is_string($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceType, true), gettype($serviceType)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($serviceType) && mb_strlen($serviceType) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($serviceType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($serviceType) && mb_strlen($serviceType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($serviceType)), __LINE__);
        }
        $this->ServiceType = $serviceType;
        return $this;
    }
    /**
     * Get NetworkTypeCode value
     * @return string|null
     */
    public function getNetworkTypeCode()
    {
        return $this->NetworkTypeCode;
    }
    /**
     * Set NetworkTypeCode value
     * @uses \DHLExpressGlobalWS\EnumType\NetworkTypeCode2::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\NetworkTypeCode2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkTypeCode
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setNetworkTypeCode($networkTypeCode = null)
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\NetworkTypeCode2::valueIsValid($networkTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\NetworkTypeCode2', is_array($networkTypeCode) ? implode(', ', $networkTypeCode) : var_export($networkTypeCode, true), implode(', ', \DHLExpressGlobalWS\EnumType\NetworkTypeCode2::getValidValues())), __LINE__);
        }
        $this->NetworkTypeCode = $networkTypeCode;
        return $this;
    }
    /**
     * Get CustomerAgreementInd value
     * @return string|null
     */
    public function getCustomerAgreementInd()
    {
        return $this->CustomerAgreementInd;
    }
    /**
     * Set CustomerAgreementInd value
     * @uses \DHLExpressGlobalWS\EnumType\CustomerAgreementInd2::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\CustomerAgreementInd2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $customerAgreementInd
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setCustomerAgreementInd($customerAgreementInd = null)
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\CustomerAgreementInd2::valueIsValid($customerAgreementInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\CustomerAgreementInd2', is_array($customerAgreementInd) ? implode(', ', $customerAgreementInd) : var_export($customerAgreementInd, true), implode(', ', \DHLExpressGlobalWS\EnumType\CustomerAgreementInd2::getValidValues())), __LINE__);
        }
        $this->CustomerAgreementInd = $customerAgreementInd;
        return $this;
    }
    /**
     * Get ValidateReadyTime value
     * @return string|null
     */
    public function getValidateReadyTime()
    {
        return $this->ValidateReadyTime;
    }
    /**
     * Set ValidateReadyTime value
     * @uses \DHLExpressGlobalWS\EnumType\ValidateReadyTime2::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\ValidateReadyTime2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $validateReadyTime
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setValidateReadyTime($validateReadyTime = null)
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\ValidateReadyTime2::valueIsValid($validateReadyTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\ValidateReadyTime2', is_array($validateReadyTime) ? implode(', ', $validateReadyTime) : var_export($validateReadyTime, true), implode(', ', \DHLExpressGlobalWS\EnumType\ValidateReadyTime2::getValidValues())), __LINE__);
        }
        $this->ValidateReadyTime = $validateReadyTime;
        return $this;
    }
    /**
     * Get ProductsAndServices value
     * @return \DHLExpressGlobalWS\StructType\ProductsAndServices2|null
     */
    public function getProductsAndServices()
    {
        return $this->ProductsAndServices;
    }
    /**
     * Set ProductsAndServices value
     * @param \DHLExpressGlobalWS\StructType\ProductsAndServices2 $productsAndServices
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setProductsAndServices(\DHLExpressGlobalWS\StructType\ProductsAndServices2 $productsAndServices = null)
    {
        $this->ProductsAndServices = $productsAndServices;
        return $this;
    }
    /**
     * Get LandedCost value
     * @return \DHLExpressGlobalWS\StructType\LandedCostType|null
     */
    public function getLandedCost()
    {
        return $this->LandedCost;
    }
    /**
     * Set LandedCost value
     * @param \DHLExpressGlobalWS\StructType\LandedCostType $landedCost
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public function setLandedCost(\DHLExpressGlobalWS\StructType\LandedCostType $landedCost = null)
    {
        $this->LandedCost = $landedCost;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedShipmentType2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
