<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerBarcode StructType
 * Meta information extracted from the WSDL
 * - documentation: Customer bar code that would like to be printed in supported transport label templates
 * @subpackage Structs
 */
class CustomerBarcode extends AbstractStructBase
{
    /**
     * The BarcodeType
     * Meta information extracted from the WSDL
     * - documentation: The customer barcode type. The first barcode code type valid value is 93, 39 or 128.
     * - minOccurs: 0
     * @var string
     */
    public $BarcodeType;
    /**
     * The BarcodeContent
     * Meta information extracted from the WSDL
     * - documentation: Customer barcode code content
     * - minOccurs: 0
     * @var string
     */
    public $BarcodeContent;
    /**
     * The TextBelowBarcode
     * Meta information extracted from the WSDL
     * - documentation: Text below customer barcode
     * - minOccurs: 0
     * @var string
     */
    public $TextBelowBarcode;
    /**
     * Constructor method for CustomerBarcode
     * @uses CustomerBarcode::setBarcodeType()
     * @uses CustomerBarcode::setBarcodeContent()
     * @uses CustomerBarcode::setTextBelowBarcode()
     * @param string $barcodeType
     * @param string $barcodeContent
     * @param string $textBelowBarcode
     */
    public function __construct($barcodeType = null, $barcodeContent = null, $textBelowBarcode = null)
    {
        $this
            ->setBarcodeType($barcodeType)
            ->setBarcodeContent($barcodeContent)
            ->setTextBelowBarcode($textBelowBarcode);
    }
    /**
     * Get BarcodeType value
     * @return string|null
     */
    public function getBarcodeType()
    {
        return $this->BarcodeType;
    }
    /**
     * Set BarcodeType value
     * @param string $barcodeType
     * @return \DHLExpressGlobalWS\StructType\CustomerBarcode
     */
    public function setBarcodeType($barcodeType = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeType) && !is_string($barcodeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeType, true), gettype($barcodeType)), __LINE__);
        }
        $this->BarcodeType = $barcodeType;
        return $this;
    }
    /**
     * Get BarcodeContent value
     * @return string|null
     */
    public function getBarcodeContent()
    {
        return $this->BarcodeContent;
    }
    /**
     * Set BarcodeContent value
     * @param string $barcodeContent
     * @return \DHLExpressGlobalWS\StructType\CustomerBarcode
     */
    public function setBarcodeContent($barcodeContent = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeContent) && !is_string($barcodeContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeContent, true), gettype($barcodeContent)), __LINE__);
        }
        $this->BarcodeContent = $barcodeContent;
        return $this;
    }
    /**
     * Get TextBelowBarcode value
     * @return string|null
     */
    public function getTextBelowBarcode()
    {
        return $this->TextBelowBarcode;
    }
    /**
     * Set TextBelowBarcode value
     * @param string $textBelowBarcode
     * @return \DHLExpressGlobalWS\StructType\CustomerBarcode
     */
    public function setTextBelowBarcode($textBelowBarcode = null)
    {
        // validation for constraint: string
        if (!is_null($textBelowBarcode) && !is_string($textBelowBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($textBelowBarcode, true), gettype($textBelowBarcode)), __LINE__);
        }
        $this->TextBelowBarcode = $textBelowBarcode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\CustomerBarcode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
