<?php

namespace DHLExpressGlobalWS\EnumType;

/**
 * This class stands for DHLCustomsInvoiceType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Use DHL generated custom invoice types Commercial Invoice (CMI), Proforma Invoice (PFI)
 * @subpackage Enumerations
 */
class DHLCustomsInvoiceType
{
    /**
     * Constant for value 'COMMERCIAL_INVOICE'
     * @return string 'COMMERCIAL_INVOICE'
     */
    const VALUE_COMMERCIAL_INVOICE = 'COMMERCIAL_INVOICE';
    /**
     * Constant for value 'PROFORMA_INVOICE'
     * @return string 'PROFORMA_INVOICE'
     */
    const VALUE_PROFORMA_INVOICE = 'PROFORMA_INVOICE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_COMMERCIAL_INVOICE
     * @uses self::VALUE_PROFORMA_INVOICE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_COMMERCIAL_INVOICE,
            self::VALUE_PROFORMA_INVOICE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
